/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.writer;

import com.aparapi.Config;
import com.aparapi.Kernel;
import com.aparapi.internal.exception.ClassParseException;
import com.aparapi.internal.exception.CodeGenException;
import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.instruction.InstructionSet;
import com.aparapi.internal.model.ClassModel;
import com.aparapi.internal.model.Entrypoint;
import com.aparapi.internal.model.MethodModel;
import com.aparapi.internal.writer.BlockWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class KernelWriter
extends BlockWriter {
    private final String cvtBooleanToChar = "char ";
    private final String cvtBooleanArrayToCharStar = "char* ";
    private final String cvtBooleanArrayToChar = "char ";
    private final String cvtByteToChar = "char ";
    private final String cvtByteArrayToCharStar = "char* ";
    private final String cvtByteArrayToChar = "char ";
    private final String cvtCharToShort = "unsigned short ";
    private final String cvtCharArrayToShortStar = "unsigned short* ";
    private final String cvtCharArrayToShort = "unsigned short ";
    private final String cvtIntArrayToIntStar = "int* ";
    private final String cvtIntArrayToInt = "int ";
    private final String cvtFloatArrayToFloatStar = "float* ";
    private final String cvtFloatArrayToFloat = "float ";
    private final String cvtDoubleArrayToDoubleStar = "double* ";
    private final String cvtDoubleArrayToDouble = "double ";
    private final String cvtLongArrayToLongStar = "long* ";
    private final String cvtLongArrayToLong = "long ";
    private final String cvtShortArrayToShortStar = "short* ";
    private final String cvtShortArrayToShort = "short ";
    private static final boolean IMPLICIT_PRIVATE_FIELDS = true;
    private Entrypoint entryPoint = null;
    public static final Map<String, String> javaToCLIdentifierMap = new HashMap<String, String>();
    public static final String __local = "__local";
    public static final String __global = "__global";
    public static final String __constant = "__constant";
    public static final String __private = "__private";
    public static final String LOCAL_ANNOTATION_NAME = "L" + Kernel.Local.class.getName().replace('.', '/') + ";";
    public static final String CONSTANT_ANNOTATION_NAME = "L" + Kernel.Constant.class.getName().replace('.', '/') + ";";

    public KernelWriter() {
        javaToCLIdentifierMap.put("getGlobalId()I", "get_global_id(0)");
        javaToCLIdentifierMap.put("getGlobalId(I)I", "get_global_id");
        javaToCLIdentifierMap.put("getGlobalX()I", "get_global_id(0)");
        javaToCLIdentifierMap.put("getGlobalY()I", "get_global_id(1)");
        javaToCLIdentifierMap.put("getGlobalZ()I", "get_global_id(2)");
        javaToCLIdentifierMap.put("getGlobalSize()I", "get_global_size(0)");
        javaToCLIdentifierMap.put("getGlobalSize(I)I", "get_global_size");
        javaToCLIdentifierMap.put("getGlobalWidth()I", "get_global_size(0)");
        javaToCLIdentifierMap.put("getGlobalHeight()I", "get_global_size(1)");
        javaToCLIdentifierMap.put("getGlobalDepth()I", "get_global_size(2)");
        javaToCLIdentifierMap.put("getLocalId()I", "get_local_id(0)");
        javaToCLIdentifierMap.put("getLocalId(I)I", "get_local_id");
        javaToCLIdentifierMap.put("getLocalX()I", "get_local_id(0)");
        javaToCLIdentifierMap.put("getLocalY()I", "get_local_id(1)");
        javaToCLIdentifierMap.put("getLocalZ()I", "get_local_id(2)");
        javaToCLIdentifierMap.put("getLocalSize()I", "get_local_size(0)");
        javaToCLIdentifierMap.put("getLocalSize(I)I", "get_local_size");
        javaToCLIdentifierMap.put("getLocalWidth()I", "get_local_size(0)");
        javaToCLIdentifierMap.put("getLocalHeight()I", "get_local_size(1)");
        javaToCLIdentifierMap.put("getLocalDepth()I", "get_local_size(2)");
        javaToCLIdentifierMap.put("getNumGroups()I", "get_num_groups(0)");
        javaToCLIdentifierMap.put("getNumGroups(I)I", "get_num_groups");
        javaToCLIdentifierMap.put("getNumGroupsX()I", "get_num_groups(0)");
        javaToCLIdentifierMap.put("getNumGroupsY()I", "get_num_groups(1)");
        javaToCLIdentifierMap.put("getNumGroupsZ()I", "get_num_groups(2)");
        javaToCLIdentifierMap.put("getGroupId()I", "get_group_id(0)");
        javaToCLIdentifierMap.put("getGroupId(I)I", "get_group_id");
        javaToCLIdentifierMap.put("getGroupX()I", "get_group_id(0)");
        javaToCLIdentifierMap.put("getGroupY()I", "get_group_id(1)");
        javaToCLIdentifierMap.put("getGroupZ()I", "get_group_id(2)");
        javaToCLIdentifierMap.put("getPassId()I", "get_pass_id(this)");
        javaToCLIdentifierMap.put("localBarrier()V", "barrier(CLK_LOCAL_MEM_FENCE)");
        javaToCLIdentifierMap.put("globalBarrier()V", "barrier(CLK_GLOBAL_MEM_FENCE)");
        javaToCLIdentifierMap.put("localGlobalBarrier()V", "barrier(CLK_LOCAL_MEM_FENCE | CLK_GLOBAL_MEM_FENCE)");
    }

    @Override
    public String convertType(String _typeDesc, boolean useClassModel, boolean isLocal) {
        if (_typeDesc.equals("Z") || _typeDesc.equals("boolean")) {
            return "char ";
        }
        if (_typeDesc.equals("[Z") || _typeDesc.equals("boolean[]")) {
            return isLocal ? "char " : "char* ";
        }
        if (_typeDesc.equals("B") || _typeDesc.equals("byte")) {
            return "char ";
        }
        if (_typeDesc.equals("[B") || _typeDesc.equals("byte[]")) {
            return isLocal ? "char " : "char* ";
        }
        if (_typeDesc.equals("C") || _typeDesc.equals("char")) {
            return "unsigned short ";
        }
        if (_typeDesc.equals("[C") || _typeDesc.equals("char[]")) {
            return isLocal ? "unsigned short " : "unsigned short* ";
        }
        if (_typeDesc.equals("[I") || _typeDesc.equals("int[]")) {
            return isLocal ? "int " : "int* ";
        }
        if (_typeDesc.equals("[F") || _typeDesc.equals("float[]")) {
            return isLocal ? "float " : "float* ";
        }
        if (_typeDesc.equals("[D") || _typeDesc.equals("double[]")) {
            return isLocal ? "double " : "double* ";
        }
        if (_typeDesc.equals("[J") || _typeDesc.equals("long[]")) {
            return isLocal ? "long " : "long* ";
        }
        if (_typeDesc.equals("[S") || _typeDesc.equals("short[]")) {
            return isLocal ? "short " : "short* ";
        }
        if ("[Ljava/util/concurrent/atomic/AtomicInteger;".equals(_typeDesc) || "[Ljava.util.concurrent.atomic.AtomicInteger;".equals(_typeDesc)) {
            return "int* ";
        }
        if (useClassModel) {
            return ClassModel.convert(_typeDesc, "", true);
        }
        return _typeDesc;
    }

    @Override
    public void writeMethod(InstructionSet.MethodCall _methodCall, ClassModel.ConstantPool.MethodEntry _methodEntry) throws CodeGenException {
        int argc = _methodEntry.getStackConsumeCount();
        String methodName = _methodEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
        String methodSignature = _methodEntry.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8();
        String barrierAndGetterMappings = javaToCLIdentifierMap.get(methodName + methodSignature);
        if (barrierAndGetterMappings != null) {
            if (argc > 0) {
                this.write(barrierAndGetterMappings);
                this.write("(");
                for (int arg = 0; arg < argc; ++arg) {
                    if (arg != 0) {
                        this.write(", ");
                    }
                    this.writeInstruction(_methodCall.getArg(arg));
                }
                this.write(")");
            } else {
                this.write(barrierAndGetterMappings);
            }
        } else {
            boolean isSpecial = _methodCall instanceof InstructionSet.I_INVOKESPECIAL;
            MethodModel m = this.entryPoint.getCallTarget(_methodEntry, isSpecial);
            ClassModel.ConstantPool.FieldEntry getterField = null;
            if (m != null && m.isGetter()) {
                getterField = m.getAccessorVariableFieldEntry();
            }
            if (getterField != null && this.isThis(_methodCall.getArg(0))) {
                String fieldName = getterField.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
                this.write("this->");
                this.write(fieldName);
                return;
            }
            boolean noCL = _methodEntry.getOwnerClassModel().getNoCLMethods().contains(_methodEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
            if (noCL) {
                return;
            }
            String intrinsicMapping = Kernel.getMappedMethodName(_methodEntry);
            boolean isIntrinsic = false;
            if (intrinsicMapping == null) {
                assert (this.entryPoint != null) : "entryPoint should not be null";
                boolean isMapped = Kernel.isMappedMethod(_methodEntry);
                if (m != null) {
                    this.write(m.getName());
                } else {
                    assert (isMapped) : _methodEntry + " should be mapped method!";
                    this.write(methodName);
                    isIntrinsic = true;
                }
            } else {
                this.write(intrinsicMapping);
            }
            this.write("(");
            if (intrinsicMapping == null && _methodCall instanceof InstructionSet.VirtualMethodCall && !isIntrinsic) {
                Instruction i = ((InstructionSet.VirtualMethodCall)_methodCall).getInstanceReference();
                if (i instanceof InstructionSet.I_ALOAD_0) {
                    this.write("this");
                } else if (i instanceof InstructionSet.AccessArrayElement) {
                    InstructionSet.AccessArrayElement arrayAccess = (InstructionSet.AccessArrayElement)((InstructionSet.VirtualMethodCall)_methodCall).getInstanceReference();
                    Instruction refAccess = arrayAccess.getArrayRef();
                    String fieldName = ((InstructionSet.AccessField)((Object)refAccess)).getConstantPoolFieldEntry().getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
                    this.write(" &(this->" + fieldName);
                    this.write("[");
                    this.writeInstruction(arrayAccess.getArrayIndex());
                    this.write("])");
                } else assert (false) : "unhandled call from: " + i;
            }
            for (int arg = 0; arg < argc; ++arg) {
                ClassModel.ConstantPool.MethodReferenceEntry.Arg methodArg;
                if (intrinsicMapping == null && _methodCall instanceof InstructionSet.VirtualMethodCall && !isIntrinsic || arg != 0) {
                    this.write(", ");
                }
                if (!(methodArg = _methodEntry.getArgs()[arg]).isArray() && "Ljava/util/concurrent/atomic/AtomicInteger;".equals(methodArg.getType())) {
                    this.write("&");
                }
                this.writeInstruction(_methodCall.getArg(arg));
            }
            this.write(")");
        }
    }

    private boolean isThis(Instruction instruction) {
        return instruction instanceof InstructionSet.I_ALOAD_0;
    }

    public void writePragma(String _name, boolean _enable) {
        this.write("#pragma OPENCL EXTENSION " + _name + " : " + (_enable ? "en" : "dis") + "able");
        this.newLine();
    }

    @Override
    public void write(Entrypoint _entryPoint) throws CodeGenException {
        boolean bl;
        ArrayList<String> thisStruct = new ArrayList<String>();
        ArrayList<String> argLines = new ArrayList<String>();
        ArrayList<String> assigns = new ArrayList<String>();
        this.entryPoint = _entryPoint;
        for (ClassModel.ClassModelField classModelField : _entryPoint.getReferencedClassModelFields()) {
            String argType;
            ClassModel.AttributePool.RuntimeAnnotationsEntry visibleAnnotations;
            StringBuilder thisStructLine = new StringBuilder();
            StringBuilder argLine = new StringBuilder();
            StringBuilder assignLine = new StringBuilder();
            String signature = classModelField.getDescriptor();
            boolean isPointer = false;
            int numDimensions = 0;
            String type = classModelField.getName().endsWith("_$local$") ? __local : (classModelField.getName().endsWith("_$constant$") ? __constant : __global);
            Integer privateMemorySize = null;
            try {
                privateMemorySize = _entryPoint.getClassModel().getPrivateMemorySize(classModelField.getName());
            }
            catch (ClassParseException e) {
                throw new CodeGenException(e);
            }
            if (privateMemorySize != null) {
                type = __private;
            }
            if ((visibleAnnotations = classModelField.getAttributePool().getRuntimeVisibleAnnotationsEntry()) != null) {
                for (ClassModel.AttributePool.RuntimeAnnotationsEntry.AnnotationInfo ai : visibleAnnotations) {
                    String typeDescriptor = ai.getTypeDescriptor();
                    if (typeDescriptor.equals(LOCAL_ANNOTATION_NAME)) {
                        type = __local;
                        continue;
                    }
                    if (!typeDescriptor.equals(CONSTANT_ANNOTATION_NAME)) continue;
                    type = __constant;
                }
            }
            String string = argType = __private.equals(type) ? __constant : type;
            while (signature.startsWith("[")) {
                if (!isPointer) {
                    argLine.append(argType + " ");
                    if (!type.equals(__private)) {
                        thisStructLine.append(type + " ");
                    }
                }
                isPointer = true;
                ++numDimensions;
                signature = signature.substring(1);
            }
            String className = null;
            if ("Ljava/util/concurrent/atomic/AtomicInteger;".equals(signature)) {
                argLine.append("int");
                thisStructLine.append("int");
            } else if (signature.startsWith("L")) {
                className = signature.substring(1, signature.length() - 1).replace('/', '_');
                argLine.append(className);
                thisStructLine.append(className);
            } else {
                argLine.append(this.convertType(ClassModel.typeName(signature.charAt(0)), false, false));
                thisStructLine.append(this.convertType(ClassModel.typeName(signature.charAt(0)), false, false));
            }
            argLine.append(" ");
            thisStructLine.append(" ");
            if (isPointer) {
                argLine.append("*");
                if (privateMemorySize == null) {
                    thisStructLine.append("*");
                }
            }
            if (privateMemorySize == null) {
                assignLine.append("this->");
                assignLine.append(classModelField.getName());
                assignLine.append(" = ");
                assignLine.append(classModelField.getName());
            }
            argLine.append(classModelField.getName());
            thisStructLine.append(classModelField.getName());
            if (privateMemorySize == null) {
                assigns.add(assignLine.toString());
            }
            argLines.add(argLine.toString());
            if (privateMemorySize != null) {
                thisStructLine.append("[").append(privateMemorySize).append("]");
            }
            thisStruct.add(thisStructLine.toString());
            if ((!isPointer || !_entryPoint.getArrayFieldArrayLengthUsed().contains(classModelField.getName())) && (!isPointer || numDimensions <= 1)) continue;
            for (int i = 0; i < numDimensions; ++i) {
                StringBuilder lenStructLine = new StringBuilder();
                StringBuilder lenArgLine = new StringBuilder();
                StringBuilder lenAssignLine = new StringBuilder();
                String suffix = numDimensions == 1 ? "" : Integer.toString(i);
                String lenName = classModelField.getName() + "__javaArrayLength" + suffix;
                lenStructLine.append("int " + lenName);
                lenAssignLine.append("this->");
                lenAssignLine.append(lenName);
                lenAssignLine.append(" = ");
                lenAssignLine.append(lenName);
                lenArgLine.append("int " + lenName);
                assigns.add(lenAssignLine.toString());
                argLines.add(lenArgLine.toString());
                thisStruct.add(lenStructLine.toString());
                if (numDimensions <= 1) continue;
                StringBuilder dimStructLine = new StringBuilder();
                StringBuilder dimArgLine = new StringBuilder();
                StringBuilder dimAssignLine = new StringBuilder();
                String dimName = classModelField.getName() + "__javaArrayDimension" + suffix;
                dimStructLine.append("int " + dimName);
                dimAssignLine.append("this->");
                dimAssignLine.append(dimName);
                dimAssignLine.append(" = ");
                dimAssignLine.append(dimName);
                dimArgLine.append("int " + dimName);
                assigns.add(dimAssignLine.toString());
                argLines.add(dimArgLine.toString());
                thisStruct.add(dimStructLine.toString());
            }
        }
        if (Config.enableByteWrites || _entryPoint.requiresByteAddressableStorePragma()) {
            // empty if block
        }
        boolean usesAtomics = false;
        if (Config.enableAtomic32 || _entryPoint.requiresAtomic32Pragma()) {
            usesAtomics = true;
            this.writePragma("cl_khr_global_int32_base_atomics", true);
            this.writePragma("cl_khr_global_int32_extended_atomics", true);
            this.writePragma("cl_khr_local_int32_base_atomics", true);
            this.writePragma("cl_khr_local_int32_extended_atomics", true);
        }
        if (Config.enableAtomic64 || _entryPoint.requiresAtomic64Pragma()) {
            usesAtomics = true;
            this.writePragma("cl_khr_int64_base_atomics", true);
            this.writePragma("cl_khr_int64_extended_atomics", true);
        }
        if (usesAtomics) {
            this.write("#define atomicGet(p) (*p)");
            this.newLine();
            this.write("#define atomicSet(p, val) (*p=val)");
            this.newLine();
            this.write("int atomicAdd(__global int *_arr, int _index, int _delta){");
            this.in();
            this.newLine();
            this.write("return atomic_add(&_arr[_index], _delta);");
            this.out();
            this.newLine();
            this.write("}");
            this.newLine();
        }
        if (Config.enableDoubles || _entryPoint.requiresDoublePragma()) {
            this.writePragma("cl_khr_fp64", true);
            this.newLine();
        }
        for (ClassModel cm : _entryPoint.getObjectArrayFieldsClasses().values()) {
            ArrayList<ClassModel.ConstantPool.FieldEntry> fieldSet = cm.getStructMembers();
            if (fieldSet.size() <= 0) continue;
            String mangledClassName = cm.getClassWeAreModelling().getName().replace('.', '_');
            this.newLine();
            this.write("typedef struct " + mangledClassName + "_s{");
            this.in();
            this.newLine();
            int totalSize = 0;
            int alignTo = 0;
            for (ClassModel.ConstantPool.FieldEntry field : fieldSet) {
                String fType = field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8();
                int fSize = InstructionSet.TypeSpec.valueOf(fType.equals("Z") ? "B" : fType).getSize();
                if (fSize > alignTo) {
                    alignTo = fSize;
                }
                totalSize += fSize;
                String cType = this.convertType(field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8(), true, false);
                assert (cType != null) : "could not find type for " + field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8();
                this.writeln(cType + " " + field.getNameAndTypeEntry().getNameUTF8Entry().getUTF8() + ";");
            }
            int totalStructSize = 0;
            totalStructSize = totalSize % alignTo == 0 ? totalSize : (totalSize / alignTo + 1) * alignTo;
            if (totalStructSize > alignTo) {
                while (totalSize < totalStructSize) {
                    this.writeln("char _pad_" + totalSize + ";");
                    ++totalSize;
                }
            }
            this.out();
            this.newLine();
            this.write("} " + mangledClassName + ";");
            this.newLine();
        }
        this.write("typedef struct This_s{");
        this.in();
        this.newLine();
        for (String line : thisStruct) {
            this.write(line);
            this.writeln(";");
        }
        this.write("int passid");
        this.out();
        this.writeln(";");
        this.write("}This;");
        this.newLine();
        this.write("int get_pass_id(This *this){");
        this.in();
        this.newLine();
        this.write("return this->passid;");
        this.out();
        this.newLine();
        this.write("}");
        this.newLine();
        for (MethodModel mm : _entryPoint.getCalledMethods()) {
            if (mm.isPrivateMemoryGetter()) continue;
            String returnType = mm.getReturnType();
            if (returnType.startsWith("[")) {
                this.write(" __global ");
            }
            this.write(this.convertType(returnType, true, false));
            this.write(mm.getName() + "(");
            if (!mm.getMethod().isStatic()) {
                if (mm.getMethod().getClassModel() == _entryPoint.getClassModel() || mm.getMethod().getClassModel().isSuperClass(_entryPoint.getClassModel().getClassWeAreModelling())) {
                    this.write("This *this");
                } else {
                    for (ClassModel c : _entryPoint.getObjectArrayFieldsClasses().values()) {
                        if (mm.getMethod().getClassModel() == c) {
                            this.write("__global " + mm.getMethod().getClassModel().getClassWeAreModelling().getName().replace('.', '_') + " *this");
                            break;
                        }
                        if (!mm.getMethod().getClassModel().isSuperClass(c.getClassWeAreModelling())) continue;
                        this.write("__global " + c.getClassWeAreModelling().getName().replace('.', '_') + " *this");
                        break;
                    }
                }
            }
            boolean alreadyHasFirstArg = !mm.getMethod().isStatic();
            ClassModel.AttributePool.RuntimeParameterAnnotationsEntry parameterAnnotations = mm.getMethod().getAttributePool().getRuntimeVisibleParameterAnnotationsEntry();
            ClassModel.LocalVariableTableEntry<ClassModel.LocalVariableInfo> lvte = mm.getLocalVariableTableEntry();
            int localVariableIndex = 0;
            for (ClassModel.LocalVariableInfo lvi : lvte) {
                if (lvi.getStart() != 0 || lvi.getVariableIndex() == 0 && !mm.getMethod().isStatic()) continue;
                String descriptor = lvi.getVariableDescriptor();
                if (alreadyHasFirstArg) {
                    this.write(", ");
                }
                if (descriptor.startsWith("[")) {
                    boolean isPrivate = false;
                    boolean isLocal = false;
                    if (lvi.getVariableName().endsWith("_$private$")) {
                        isPrivate = true;
                    } else if (lvi.getVariableName().endsWith("_$local$")) {
                        isLocal = true;
                    } else if (parameterAnnotations != null) {
                        ClassModel.AttributePool.RuntimeParameterAnnotationsEntry.ParameterInfo paramInfo = (ClassModel.AttributePool.RuntimeParameterAnnotationsEntry.ParameterInfo)parameterAnnotations.getPool().get(localVariableIndex);
                        List<ClassModel.AttributePool.RuntimeParameterAnnotationsEntry.ParameterInfo.AnnotationInfo> paramAnnotations = paramInfo.getAnnotations();
                        for (ClassModel.AttributePool.RuntimeParameterAnnotationsEntry.ParameterInfo.AnnotationInfo annotation : paramAnnotations) {
                            if (!annotation.getTypeDescriptor().equals(LOCAL_ANNOTATION_NAME)) continue;
                            isLocal = true;
                            break;
                        }
                    }
                    if (isLocal) {
                        this.write(" __local ");
                    } else if (!isPrivate) {
                        this.write(" __global ");
                    }
                }
                this.write(this.convertType(descriptor, true, false));
                this.write(lvi.getVariableName());
                alreadyHasFirstArg = true;
                ++localVariableIndex;
            }
            this.write(")");
            this.writeMethodBody(mm);
            this.newLine();
        }
        this.write("__kernel void " + _entryPoint.getMethodModel().getSimpleName() + "(");
        this.in();
        boolean bl2 = true;
        for (String line : argLines) {
            if (bl) {
                bl = false;
            } else {
                this.write(", ");
            }
            this.newLine();
            this.write(line);
        }
        if (bl) {
            boolean bl3 = false;
        } else {
            this.write(", ");
        }
        this.newLine();
        this.write("int passid");
        this.out();
        this.newLine();
        this.write("){");
        this.in();
        this.newLine();
        this.writeln("This thisStruct;");
        this.writeln("This* this=&thisStruct;");
        for (String line : assigns) {
            this.write(line);
            this.writeln(";");
        }
        this.write("this->passid = passid");
        this.writeln(";");
        this.writeMethodBody(_entryPoint.getMethodModel());
        this.out();
        this.newLine();
        this.writeln("}");
        this.out();
    }

    @Override
    public void writeThisRef() {
        this.write("this->");
    }

    @Override
    public void writeInstruction(Instruction _instruction) throws CodeGenException {
        if (_instruction instanceof InstructionSet.I_IUSHR || _instruction instanceof InstructionSet.I_LUSHR) {
            InstructionSet.BinaryOperator binaryInstruction = (InstructionSet.BinaryOperator)_instruction;
            Instruction parent = binaryInstruction.getParentExpr();
            boolean needsParenthesis = true;
            if (parent instanceof InstructionSet.AssignToLocalVariable) {
                needsParenthesis = false;
            } else if (parent instanceof InstructionSet.AssignToField) {
                needsParenthesis = false;
            } else if (parent instanceof InstructionSet.AssignToArrayElement) {
                needsParenthesis = false;
            }
            if (needsParenthesis) {
                this.write("(");
            }
            if (binaryInstruction instanceof InstructionSet.I_IUSHR) {
                this.write("((unsigned int)");
            } else {
                this.write("((unsigned long)");
            }
            this.writeInstruction(binaryInstruction.getLhs());
            this.write(")");
            this.write(" >> ");
            this.writeInstruction(binaryInstruction.getRhs());
            if (needsParenthesis) {
                this.write(")");
            }
        } else {
            super.writeInstruction(_instruction);
        }
    }

    public static String writeToString(Entrypoint _entrypoint) throws CodeGenException {
        final StringBuilder openCLStringBuilder = new StringBuilder();
        KernelWriter openCLWriter = new KernelWriter(){

            @Override
            public void write(String _string) {
                openCLStringBuilder.append(_string);
            }
        };
        openCLWriter.write(_entrypoint);
        return openCLStringBuilder.toString();
    }
}

