/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.writer;

import com.aparapi.Config;
import com.aparapi.internal.exception.CodeGenException;
import com.aparapi.internal.instruction.BranchSet;
import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.instruction.InstructionSet;
import com.aparapi.internal.model.ClassModel;
import com.aparapi.internal.model.Entrypoint;
import com.aparapi.internal.model.MethodModel;
import java.util.Stack;

public abstract class BlockWriter {
    public static final String arrayLengthMangleSuffix = "__javaArrayLength";
    public static final String arrayDimMangleSuffix = "__javaArrayDimension";
    public int indent = 0;

    public abstract void write(String var1);

    public void writeln(String _string) {
        this.write(_string);
        this.newLine();
    }

    public void in() {
        ++this.indent;
    }

    public void out() {
        --this.indent;
    }

    public void newLine() {
        this.write("\n");
        for (int i = 0; i < this.indent; ++i) {
            this.write("   ");
        }
    }

    public void writeConditionalBranch16(InstructionSet.ConditionalBranch16 _branch16, boolean _invert) throws CodeGenException {
        if (_branch16 instanceof InstructionSet.If) {
            InstructionSet.If iff = (InstructionSet.If)_branch16;
            this.writeInstruction(iff.getLhs());
            this.write(_branch16.getOperator().getText(_invert));
            this.writeInstruction(iff.getRhs());
        } else if (_branch16 instanceof InstructionSet.I_IFNULL) {
            InstructionSet.I_IFNULL iff = (InstructionSet.I_IFNULL)_branch16;
            this.writeInstruction(iff.getFirstChild());
            if (_invert) {
                this.write(" != NULL");
            } else {
                this.write(" == NULL");
            }
        } else if (_branch16 instanceof InstructionSet.I_IFNONNULL) {
            InstructionSet.I_IFNONNULL iff = (InstructionSet.I_IFNONNULL)_branch16;
            this.writeInstruction(iff.getFirstChild());
            if (_invert) {
                this.write(" == NULL");
            } else {
                this.write(" != NULL");
            }
        } else if (_branch16 instanceof InstructionSet.IfUnary) {
            InstructionSet.IfUnary branch16 = (InstructionSet.IfUnary)_branch16;
            Instruction comparison = branch16.getUnary();
            InstructionSet.ByteCode comparisonByteCode = comparison.getByteCode();
            String comparisonOperator = _branch16.getOperator().getText(_invert);
            switch (comparisonByteCode) {
                case FCMPG: 
                case DCMPG: 
                case FCMPL: 
                case DCMPL: {
                    if (Config.verboseComparitor) {
                        this.write("/* bytecode=" + comparisonByteCode.getName() + " invert=" + _invert + "*/");
                    }
                    this.writeInstruction(comparison.getFirstChild());
                    this.write(comparisonOperator);
                    this.writeInstruction(comparison.getLastChild());
                    break;
                }
                default: {
                    if (Config.verboseComparitor) {
                        this.write("/* default bytecode=" + comparisonByteCode.getName() + " invert=" + _invert + "*/");
                    }
                    this.writeInstruction(comparison);
                    this.write(comparisonOperator);
                    this.write("0");
                }
            }
        }
    }

    public void writeComposite(InstructionSet.CompositeInstruction instruction) throws CodeGenException {
        if (instruction instanceof InstructionSet.CompositeArbitraryScopeInstruction) {
            this.newLine();
            this.writeBlock(instruction.getFirstChild(), null);
        } else if (instruction instanceof InstructionSet.CompositeIfInstruction) {
            this.newLine();
            this.write("if (");
            Instruction blockStart = this.writeConditional(instruction.getBranchSet());
            this.write(")");
            this.writeBlock(blockStart, null);
        } else if (instruction instanceof InstructionSet.CompositeIfElseInstruction) {
            this.newLine();
            this.write("if (");
            Instruction blockStart = this.writeConditional(instruction.getBranchSet());
            this.write(")");
            Instruction elseGoto = blockStart;
            while (!elseGoto.isBranch() || !elseGoto.asBranch().isUnconditional()) {
                elseGoto = elseGoto.getNextExpr();
            }
            this.writeBlock(blockStart, elseGoto);
            this.write(" else ");
            this.writeBlock(elseGoto.getNextExpr(), null);
        } else if (instruction instanceof InstructionSet.CompositeForSunInstruction) {
            this.newLine();
            this.write("for (");
            Instruction topBranch = instruction.getFirstChild();
            if (topBranch instanceof InstructionSet.AssignToLocalVariable) {
                this.writeInstruction(topBranch);
                topBranch = topBranch.getNextExpr();
            }
            this.write("; ");
            BranchSet branchSet = instruction.getBranchSet();
            Instruction blockStart = this.writeConditional(branchSet);
            Instruction lastGoto = instruction.getLastChild();
            if (branchSet.getFallThrough() == lastGoto) {
                this.write(";){}");
            } else {
                Instruction delta = lastGoto.getPrevExpr();
                this.write("; ");
                if (!(delta instanceof InstructionSet.CompositeInstruction)) {
                    this.writeInstruction(delta);
                    this.write(")");
                    this.writeBlock(blockStart, delta);
                } else {
                    this.write("){");
                    this.in();
                    this.writeSequence(blockStart, delta);
                    this.newLine();
                    this.writeSequence(delta, delta.getNextExpr());
                    this.out();
                    this.newLine();
                    this.write("}");
                }
            }
        } else if (instruction instanceof InstructionSet.CompositeWhileInstruction) {
            this.newLine();
            this.write("while (");
            BranchSet branchSet = instruction.getBranchSet();
            Instruction blockStart = this.writeConditional(branchSet);
            this.write(")");
            Instruction lastGoto = instruction.getLastChild();
            this.writeBlock(blockStart, lastGoto);
        } else if (instruction instanceof InstructionSet.CompositeEmptyLoopInstruction) {
            this.newLine();
            this.write("for (");
            Instruction topBranch = instruction.getFirstChild();
            if (topBranch instanceof InstructionSet.AssignToLocalVariable) {
                this.writeInstruction(topBranch);
                topBranch = topBranch.getNextExpr();
            }
            this.write("; ");
            this.writeConditional(instruction.getBranchSet());
            this.write(";){}");
        } else if (instruction instanceof InstructionSet.CompositeForEclipseInstruction) {
            this.newLine();
            this.write("for (");
            Instruction topGoto = instruction.getFirstChild();
            if (topGoto instanceof InstructionSet.AssignToLocalVariable) {
                this.writeInstruction(topGoto);
                topGoto = topGoto.getNextExpr();
            }
            this.write("; ");
            Instruction last = instruction.getLastChild();
            while (last.getPrevExpr().isBranch()) {
                last = last.getPrevExpr();
            }
            this.writeConditional(instruction.getBranchSet(), true);
            this.write("; ");
            Instruction delta = last.getPrevExpr();
            if (!(delta instanceof InstructionSet.CompositeInstruction)) {
                this.writeInstruction(delta);
                this.write(")");
                this.writeBlock(topGoto.getNextExpr(), delta);
            } else {
                this.write("){");
                this.in();
                this.writeSequence(topGoto.getNextExpr(), delta);
                this.newLine();
                this.writeSequence(delta, delta.getNextExpr());
                this.out();
                this.newLine();
                this.write("}");
            }
        } else if (instruction instanceof InstructionSet.CompositeDoWhileInstruction) {
            this.newLine();
            this.write("do");
            Instruction blockStart = instruction.getFirstChild();
            Instruction blockEnd = instruction.getLastChild();
            this.writeBlock(blockStart, blockEnd);
            this.write("while(");
            this.writeConditional(instruction.getBranchSet(), true);
            this.write(");");
            this.newLine();
        }
    }

    public void writeSequence(Instruction _first, Instruction _last) throws CodeGenException {
        for (Instruction instruction = _first; instruction != _last; instruction = instruction.getNextExpr()) {
            if (instruction instanceof InstructionSet.CompositeInstruction) {
                this.writeComposite((InstructionSet.CompositeInstruction)instruction);
                continue;
            }
            if (instruction.getByteCode().equals((Object)InstructionSet.ByteCode.NONE)) continue;
            this.newLine();
            this.writeInstruction(instruction);
            this.write(";");
        }
    }

    protected void writeGetterBlock(ClassModel.ConstantPool.FieldEntry accessorVariableFieldEntry) {
        this.write("{");
        this.in();
        this.newLine();
        this.write("return this->");
        this.write(accessorVariableFieldEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
        this.write(";");
        this.out();
        this.newLine();
        this.write("}");
    }

    public void writeBlock(Instruction _first, Instruction _last) throws CodeGenException {
        this.write("{");
        this.in();
        this.writeSequence(_first, _last);
        this.out();
        this.newLine();
        this.write("}");
    }

    public Instruction writeConditional(BranchSet _branchSet) throws CodeGenException {
        return this.writeConditional(_branchSet, false);
    }

    public Instruction writeConditional(BranchSet _branchSet, boolean _invert) throws CodeGenException {
        BranchSet.LogicalExpressionNode logicalExpression = _branchSet.getLogicalExpression();
        this.write(_invert ? logicalExpression : logicalExpression.cloneInverted());
        return _branchSet.getLast().getNextExpr();
    }

    public void write(BranchSet.LogicalExpressionNode _node) throws CodeGenException {
        if (_node instanceof BranchSet.SimpleLogicalExpressionNode) {
            BranchSet.SimpleLogicalExpressionNode sn = (BranchSet.SimpleLogicalExpressionNode)_node;
            this.writeConditionalBranch16((InstructionSet.ConditionalBranch16)sn.getBranch(), sn.isInvert());
        } else {
            BranchSet.CompoundLogicalExpressionNode ln = (BranchSet.CompoundLogicalExpressionNode)_node;
            boolean needParenthesis = false;
            BranchSet.CompoundLogicalExpressionNode parent = (BranchSet.CompoundLogicalExpressionNode)ln.getParent();
            if (parent != null && !ln.isAnd() && parent.isAnd()) {
                needParenthesis = true;
            }
            if (needParenthesis) {
                this.write("(");
            }
            this.write(ln.getLhs());
            this.write(ln.isAnd() ? " && " : " || ");
            this.write(ln.getRhs());
            if (needParenthesis) {
                this.write(")");
            }
        }
    }

    public String convertType(String _typeDesc, boolean useClassModel, boolean isLocal) {
        return _typeDesc;
    }

    public String convertCast(String _cast) {
        String raw = this.convertType(_cast.substring(1, _cast.length() - 1), false, false);
        return "(" + raw + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeInstruction(Instruction _instruction) throws CodeGenException {
        if (_instruction instanceof InstructionSet.CompositeIfElseInstruction) {
            boolean needParenthesis = this.isNeedParenthesis(_instruction);
            if (needParenthesis) {
                this.write("(");
            }
            this.write("(");
            Instruction lhs = this.writeConditional(((InstructionSet.CompositeInstruction)_instruction).getBranchSet());
            this.write(")?");
            this.writeInstruction(lhs);
            this.write(":");
            this.writeInstruction(lhs.getNextExpr().getNextExpr());
            if (!needParenthesis) return;
            this.write(")");
            return;
        } else if (_instruction instanceof InstructionSet.CompositeInstruction) {
            this.writeComposite((InstructionSet.CompositeInstruction)_instruction);
            return;
        } else if (_instruction instanceof InstructionSet.I_NEWARRAY) {
            if (_instruction.getParentExpr() instanceof InstructionSet.Return) {
                throw new CodeGenException("'newarray' is not allowed after 'return'");
            }
            for (Instruction operand = _instruction.getFirstChild(); operand != null; operand = operand.getNextExpr()) {
                this.write("[");
                this.writeInstruction(operand);
                this.write("]");
            }
            return;
        } else if (_instruction instanceof InstructionSet.AssignToLocalVariable) {
            String descriptor;
            InstructionSet.AssignToLocalVariable assignToLocalVariable = (InstructionSet.AssignToLocalVariable)((Object)_instruction);
            ClassModel.LocalVariableInfo localVariableInfo = assignToLocalVariable.getLocalVariableInfo();
            if (_instruction.getFirstChild() instanceof InstructionSet.I_NEWARRAY) {
                if (localVariableInfo == null) {
                    throw new CodeGenException("outOfScope" + _instruction.getThisPC() + " = ");
                }
                descriptor = localVariableInfo.getVariableDescriptor();
                this.write(this.convertType(descriptor, true, true));
                this.write(localVariableInfo.getVariableName());
            } else {
                if (assignToLocalVariable.isDeclaration()) {
                    descriptor = localVariableInfo.getVariableDescriptor();
                    if (descriptor.startsWith("[")) {
                        this.write(" __global ");
                    }
                    this.write(this.convertType(descriptor, true, false));
                }
                if (localVariableInfo == null) {
                    throw new CodeGenException("outOfScope" + _instruction.getThisPC() + " = ");
                }
                this.write(localVariableInfo.getVariableName() + " = ");
            }
            for (Instruction operand = _instruction.getFirstChild(); operand != null; operand = operand.getNextExpr()) {
                this.writeInstruction(operand);
            }
            return;
        } else if (_instruction instanceof InstructionSet.AssignToArrayElement) {
            InstructionSet.AssignToArrayElement arrayAssignmentInstruction = (InstructionSet.AssignToArrayElement)_instruction;
            this.writeInstruction(arrayAssignmentInstruction.getArrayRef());
            this.write("[");
            this.writeInstruction(arrayAssignmentInstruction.getArrayIndex());
            this.write("]");
            this.write(" ");
            this.write(" = ");
            this.writeInstruction(arrayAssignmentInstruction.getValue());
            return;
        } else if (_instruction instanceof InstructionSet.AccessArrayElement) {
            boolean isMultiDimensional;
            InstructionSet.AccessArrayElement arrayLoadInstruction = (InstructionSet.AccessArrayElement)_instruction;
            boolean bl = isMultiDimensional = arrayLoadInstruction instanceof InstructionSet.I_AALOAD && this.isMultiDimensionalArray(arrayLoadInstruction);
            if (isMultiDimensional) {
                this.write("(&");
            }
            this.writeInstruction(arrayLoadInstruction.getArrayRef());
            this.write("[");
            this.writeInstruction(arrayLoadInstruction.getArrayIndex());
            if (isMultiDimensional) {
                int dim = 0;
                Instruction load = arrayLoadInstruction.getArrayRef();
                while (load instanceof InstructionSet.I_AALOAD) {
                    load = load.getFirstChild();
                    ++dim;
                }
                ClassModel.ConstantPool.NameAndTypeEntry nameAndTypeEntry = ((InstructionSet.AccessField)((Object)load)).getConstantPoolFieldEntry().getNameAndTypeEntry();
                if (this.isMultiDimensionalArray(nameAndTypeEntry)) {
                    String arrayName = nameAndTypeEntry.getNameUTF8Entry().getUTF8();
                    this.write(" * this->" + arrayName + arrayDimMangleSuffix + dim);
                }
            }
            this.write("]");
            if (!isMultiDimensional) return;
            this.write(")");
            return;
        } else if (_instruction instanceof InstructionSet.AccessField) {
            InstructionSet.AccessField accessField = (InstructionSet.AccessField)((Object)_instruction);
            if (accessField instanceof InstructionSet.AccessInstanceField) {
                Instruction accessInstanceField = ((InstructionSet.AccessInstanceField)accessField).getInstance();
                if (accessInstanceField instanceof InstructionSet.CloneInstruction) {
                    accessInstanceField = ((InstructionSet.CloneInstruction)accessInstanceField).getReal();
                }
                if (!(accessInstanceField instanceof InstructionSet.I_ALOAD_0)) {
                    this.writeInstruction(accessInstanceField);
                    this.write(".");
                } else {
                    this.writeThisRef();
                }
            }
            this.write(accessField.getConstantPoolFieldEntry().getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
            return;
        } else if (_instruction instanceof InstructionSet.I_ARRAYLENGTH) {
            int dim = 0;
            Instruction load = _instruction.getFirstChild();
            while (load instanceof InstructionSet.I_AALOAD) {
                load = load.getFirstChild();
                ++dim;
            }
            ClassModel.ConstantPool.NameAndTypeEntry nameAndTypeEntry = ((InstructionSet.AccessInstanceField)((Object)load)).getConstantPoolFieldEntry().getNameAndTypeEntry();
            String arrayName = nameAndTypeEntry.getNameUTF8Entry().getUTF8();
            String dimSuffix = this.isMultiDimensionalArray(nameAndTypeEntry) ? Integer.toString(dim) : "";
            this.write("this->" + arrayName + arrayLengthMangleSuffix + dimSuffix);
            return;
        } else if (_instruction instanceof InstructionSet.AssignToField) {
            InstructionSet.AssignToField assignedField = (InstructionSet.AssignToField)((Object)_instruction);
            if (assignedField instanceof InstructionSet.AssignToInstanceField) {
                Instruction accessInstanceField = ((InstructionSet.AssignToInstanceField)assignedField).getInstance().getReal();
                if (!(accessInstanceField instanceof InstructionSet.I_ALOAD_0)) {
                    this.writeInstruction(accessInstanceField);
                    this.write(".");
                } else {
                    this.writeThisRef();
                }
            }
            this.write(assignedField.getConstantPoolFieldEntry().getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
            this.write("=");
            this.writeInstruction(assignedField.getValueToAssign());
            return;
        } else if (_instruction instanceof InstructionSet.Constant) {
            InstructionSet.Constant constantInstruction = (InstructionSet.Constant)((Object)_instruction);
            Object value = constantInstruction.getValue();
            if (value instanceof Float) {
                Float f = (Float)value;
                if (f.isNaN()) {
                    this.write("NAN");
                    return;
                } else if (f.isInfinite()) {
                    if (f.floatValue() < 0.0f) {
                        this.write("-");
                    }
                    this.write("INFINITY");
                    return;
                } else {
                    this.write(value.toString());
                    this.write("f");
                }
                return;
            } else if (value instanceof Double) {
                Double d = (Double)value;
                if (d.isNaN()) {
                    this.write("NAN");
                    return;
                } else if (d.isInfinite()) {
                    if (d < 0.0) {
                        this.write("-");
                    }
                    this.write("INFINITY");
                    return;
                } else {
                    this.write(value.toString());
                }
                return;
            } else {
                this.write(value.toString());
                if (!(value instanceof Long)) return;
                this.write("L");
            }
            return;
        } else if (_instruction instanceof InstructionSet.AccessLocalVariable) {
            InstructionSet.AccessLocalVariable localVariableLoadInstruction = (InstructionSet.AccessLocalVariable)((Object)_instruction);
            ClassModel.LocalVariableInfo localVariable = localVariableLoadInstruction.getLocalVariableInfo();
            this.write(localVariable.getVariableName());
            return;
        } else if (_instruction instanceof InstructionSet.I_IINC) {
            InstructionSet.I_IINC location = (InstructionSet.I_IINC)_instruction;
            ClassModel.LocalVariableInfo localVariable = location.getLocalVariableInfo();
            int adjust = location.getAdjust();
            this.write(localVariable.getVariableName());
            if (adjust == 1) {
                this.write("++");
                return;
            } else if (adjust == -1) {
                this.write("--");
                return;
            } else if (adjust > 1) {
                this.write("+=" + adjust);
                return;
            } else {
                if (adjust >= -1) return;
                this.write("-=" + -adjust);
            }
            return;
        } else if (_instruction instanceof InstructionSet.BinaryOperator) {
            InstructionSet.BinaryOperator binaryInstruction = (InstructionSet.BinaryOperator)_instruction;
            Instruction parent = binaryInstruction.getParentExpr();
            boolean needsParenthesis = this.isNeedParenthesis(binaryInstruction);
            if (needsParenthesis) {
                this.write("(");
            }
            this.writeInstruction(binaryInstruction.getLhs());
            this.write(" " + binaryInstruction.getOperator().getText() + " ");
            this.writeInstruction(binaryInstruction.getRhs());
            if (!needsParenthesis) return;
            this.write(")");
            return;
        } else if (_instruction instanceof InstructionSet.CastOperator) {
            InstructionSet.CastOperator castInstruction = (InstructionSet.CastOperator)_instruction;
            this.write(this.convertCast(castInstruction.getOperator().getText()));
            this.writeInstruction(castInstruction.getUnary());
            return;
        } else if (_instruction instanceof InstructionSet.UnaryOperator) {
            InstructionSet.UnaryOperator unaryInstruction = (InstructionSet.UnaryOperator)_instruction;
            this.write(unaryInstruction.getOperator().getText());
            this.writeInstruction(unaryInstruction.getUnary());
            return;
        } else if (_instruction instanceof InstructionSet.Return) {
            InstructionSet.Return ret = (InstructionSet.Return)_instruction;
            this.write("return");
            if (ret.getStackConsumeCount() <= 0) return;
            this.write("(");
            this.writeInstruction(ret.getFirstChild());
            this.write(")");
            return;
        } else if (_instruction instanceof InstructionSet.MethodCall) {
            InstructionSet.MethodCall methodCall = (InstructionSet.MethodCall)((Object)_instruction);
            ClassModel.ConstantPool.MethodEntry methodEntry = methodCall.getConstantPoolMethodEntry();
            this.writeMethod(methodCall, methodEntry);
            return;
        } else if (_instruction.getByteCode().equals((Object)InstructionSet.ByteCode.CLONE)) {
            InstructionSet.CloneInstruction cloneInstruction = (InstructionSet.CloneInstruction)_instruction;
            this.writeInstruction(cloneInstruction.getReal());
            return;
        } else if (_instruction.getByteCode().equals((Object)InstructionSet.ByteCode.INCREMENT)) {
            InstructionSet.IncrementInstruction incrementInstruction = (InstructionSet.IncrementInstruction)_instruction;
            if (incrementInstruction.isPre()) {
                if (incrementInstruction.isInc()) {
                    this.write("++");
                } else {
                    this.write("--");
                }
            }
            this.writeInstruction(incrementInstruction.getFieldOrVariableReference());
            if (incrementInstruction.isPre()) return;
            if (incrementInstruction.isInc()) {
                this.write("++");
                return;
            } else {
                this.write("--");
            }
            return;
        } else if (_instruction.getByteCode().equals((Object)InstructionSet.ByteCode.MULTI_ASSIGN)) {
            InstructionSet.MultiAssignInstruction multiAssignInstruction = (InstructionSet.MultiAssignInstruction)_instruction;
            InstructionSet.AssignToLocalVariable from = (InstructionSet.AssignToLocalVariable)((Object)multiAssignInstruction.getFrom());
            InstructionSet.AssignToLocalVariable last = (InstructionSet.AssignToLocalVariable)((Object)multiAssignInstruction.getTo());
            Instruction common = multiAssignInstruction.getCommon();
            Stack<InstructionSet.AssignToLocalVariable> stack = new Stack<InstructionSet.AssignToLocalVariable>();
            while (from != last) {
                stack.push(from);
                from = (InstructionSet.AssignToLocalVariable)((Object)((Instruction)((Object)from)).getNextExpr());
            }
            InstructionSet.AssignToLocalVariable alv = (InstructionSet.AssignToLocalVariable)stack.pop();
            while (alv != null) {
                ClassModel.LocalVariableInfo localVariableInfo = alv.getLocalVariableInfo();
                if (alv.isDeclaration()) {
                    this.write(this.convertType(localVariableInfo.getVariableDescriptor(), true, false));
                }
                if (localVariableInfo == null) {
                    throw new CodeGenException("outOfScope" + _instruction.getThisPC() + " = ");
                }
                this.write(localVariableInfo.getVariableName() + " = ");
                alv = stack.size() > 0 ? (InstructionSet.AssignToLocalVariable)stack.pop() : null;
            }
            this.writeInstruction(common);
            return;
        } else if (_instruction.getByteCode().equals((Object)InstructionSet.ByteCode.INLINE_ASSIGN)) {
            InstructionSet.InlineAssignInstruction inlineAssignInstruction = (InstructionSet.InlineAssignInstruction)_instruction;
            InstructionSet.AssignToLocalVariable assignToLocalVariable = inlineAssignInstruction.getAssignToLocalVariable();
            ClassModel.LocalVariableInfo localVariableInfo = assignToLocalVariable.getLocalVariableInfo();
            if (assignToLocalVariable.isDeclaration()) {
                throw new CodeGenException("/* we can't declare this " + this.convertType(localVariableInfo.getVariableDescriptor(), true, false) + " here */");
            }
            this.write(localVariableInfo.getVariableName());
            this.write("=");
            this.writeInstruction(inlineAssignInstruction.getRhs());
            return;
        } else if (_instruction.getByteCode().equals((Object)InstructionSet.ByteCode.FIELD_ARRAY_ELEMENT_ASSIGN)) {
            InstructionSet.FieldArrayElementAssign inlineAssignInstruction = (InstructionSet.FieldArrayElementAssign)_instruction;
            InstructionSet.AssignToArrayElement arrayAssignmentInstruction = inlineAssignInstruction.getAssignToArrayElement();
            this.writeInstruction(arrayAssignmentInstruction.getArrayRef());
            this.write("[");
            this.writeInstruction(arrayAssignmentInstruction.getArrayIndex());
            this.write("]");
            this.write(" ");
            this.write(" = ");
            this.writeInstruction(inlineAssignInstruction.getRhs());
            return;
        } else if (_instruction.getByteCode().equals((Object)InstructionSet.ByteCode.FIELD_ARRAY_ELEMENT_INCREMENT)) {
            InstructionSet.FieldArrayElementIncrement fieldArrayElementIncrement = (InstructionSet.FieldArrayElementIncrement)_instruction;
            InstructionSet.AssignToArrayElement arrayAssignmentInstruction = fieldArrayElementIncrement.getAssignToArrayElement();
            if (fieldArrayElementIncrement.isPre()) {
                if (fieldArrayElementIncrement.isInc()) {
                    this.write("++");
                } else {
                    this.write("--");
                }
            }
            this.writeInstruction(arrayAssignmentInstruction.getArrayRef());
            this.write("[");
            this.writeInstruction(arrayAssignmentInstruction.getArrayIndex());
            this.write("]");
            if (fieldArrayElementIncrement.isPre()) return;
            if (fieldArrayElementIncrement.isInc()) {
                this.write("++");
                return;
            } else {
                this.write("--");
            }
            return;
        } else {
            if (_instruction.getByteCode().equals((Object)InstructionSet.ByteCode.NONE)) return;
            if (_instruction instanceof InstructionSet.Branch) {
                if (!(_instruction instanceof InstructionSet.ConditionalBranch16)) throw new CodeGenException(String.format("%s -> %04d", _instruction.getByteCode().toString().toLowerCase(), ((InstructionSet.Branch)_instruction).getTarget().getThisPC()));
                this.writeConditionalBranch16((InstructionSet.ConditionalBranch16)_instruction, true);
                return;
            } else {
                if (!(_instruction instanceof InstructionSet.I_POP)) throw new CodeGenException(String.format("%s", _instruction.getByteCode().toString().toLowerCase()));
                this.writeInstruction(_instruction.getFirstChild());
            }
        }
    }

    private boolean isNeedParenthesis(Instruction instruction) {
        Instruction parent = instruction.getParentExpr();
        boolean needsParenthesis = true;
        if (parent instanceof InstructionSet.AssignToLocalVariable) {
            needsParenthesis = false;
        } else if (parent instanceof InstructionSet.AssignToField) {
            needsParenthesis = false;
        } else if (parent instanceof InstructionSet.AssignToArrayElement) {
            needsParenthesis = false;
        }
        return needsParenthesis;
    }

    private boolean isMultiDimensionalArray(ClassModel.ConstantPool.NameAndTypeEntry nameAndTypeEntry) {
        return nameAndTypeEntry.getDescriptorUTF8Entry().getUTF8().startsWith("[[");
    }

    private boolean isObjectArray(ClassModel.ConstantPool.NameAndTypeEntry nameAndTypeEntry) {
        return nameAndTypeEntry.getDescriptorUTF8Entry().getUTF8().startsWith("[L");
    }

    private boolean isMultiDimensionalArray(InstructionSet.AccessArrayElement arrayLoadInstruction) {
        InstructionSet.AccessField accessInstanceField = this.getUltimateInstanceFieldAccess(arrayLoadInstruction);
        if (accessInstanceField != null) {
            return this.isMultiDimensionalArray(accessInstanceField.getConstantPoolFieldEntry().getNameAndTypeEntry());
        }
        InstructionSet.AccessLocalVariable accessLocalVariable = this.getUltimateInstanceLocalVarAccess(arrayLoadInstruction);
        return accessLocalVariable.getLocalVariableInfo().getVariableDescriptor().startsWith("[[");
    }

    private boolean isObjectArray(InstructionSet.AccessArrayElement arrayLoadInstruction) {
        InstructionSet.AccessField accessInstanceField = this.getUltimateInstanceFieldAccess(arrayLoadInstruction);
        return this.isObjectArray(accessInstanceField.getConstantPoolFieldEntry().getNameAndTypeEntry());
    }

    private InstructionSet.AccessField getUltimateInstanceFieldAccess(InstructionSet.AccessArrayElement arrayLoadInstruction) {
        Instruction load = arrayLoadInstruction.getArrayRef();
        while (load instanceof InstructionSet.I_AALOAD) {
            load = load.getFirstChild();
        }
        if (load instanceof InstructionSet.I_ALOAD || load instanceof InstructionSet.I_ALOAD_0 || load instanceof InstructionSet.I_ALOAD_1 || load instanceof InstructionSet.I_ALOAD_2 || load instanceof InstructionSet.I_ALOAD_3) {
            return null;
        }
        return (InstructionSet.AccessField)((Object)load);
    }

    private InstructionSet.AccessLocalVariable getUltimateInstanceLocalVarAccess(InstructionSet.AccessArrayElement arrayLoadInstruction) {
        Instruction load = arrayLoadInstruction.getArrayRef();
        while (load instanceof InstructionSet.I_AALOAD) {
            load = load.getFirstChild();
        }
        return (InstructionSet.AccessLocalVariable)((Object)load);
    }

    public void writeMethod(InstructionSet.MethodCall _methodCall, ClassModel.ConstantPool.MethodEntry _methodEntry) throws CodeGenException {
        boolean noCL = _methodEntry.getOwnerClassModel().getNoCLMethods().contains(_methodEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
        if (noCL) {
            return;
        }
        if (_methodCall instanceof InstructionSet.VirtualMethodCall) {
            Instruction instanceInstruction = ((InstructionSet.VirtualMethodCall)_methodCall).getInstanceReference();
            if (!(instanceInstruction instanceof InstructionSet.I_ALOAD_0)) {
                this.writeInstruction(instanceInstruction);
                this.write(".");
            } else {
                this.writeThisRef();
            }
        }
        int argc = _methodEntry.getStackConsumeCount();
        this.write(_methodEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
        this.write("(");
        for (int arg = 0; arg < argc; ++arg) {
            if (arg != 0) {
                this.write(", ");
            }
            this.writeInstruction(_methodCall.getArg(arg));
        }
        this.write(")");
    }

    public void writeThisRef() {
        this.write("this.");
    }

    public void writeMethodBody(MethodModel _methodModel) throws CodeGenException {
        if (_methodModel.isGetter() && !_methodModel.isNoCL()) {
            ClassModel.ConstantPool.FieldEntry accessorVariableFieldEntry = _methodModel.getAccessorVariableFieldEntry();
            this.writeGetterBlock(accessorVariableFieldEntry);
        } else {
            this.writeBlock(_methodModel.getExprHead(), null);
        }
    }

    public abstract void write(Entrypoint var1) throws CodeGenException;
}

