/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.tool;

import com.aparapi.internal.exception.CodeGenException;
import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.instruction.InstructionSet;
import com.aparapi.internal.model.ClassModel;
import com.aparapi.internal.model.Entrypoint;
import com.aparapi.internal.model.MethodModel;
import com.aparapi.internal.writer.BlockWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class InstructionHelper {
    private static Comparator<BranchVector> branchInfoComparator = new Comparator<BranchVector>(){

        @Override
        public int compare(BranchVector left, BranchVector right) {
            int value = left.getFrom().compareTo(right.getFrom());
            return value;
        }
    };

    public static String getLabel(Instruction instruction, boolean showNumber, boolean showExpressions, boolean verboseBytecodeLabels) {
        InstructionSet.ByteCode byteCode = instruction.getByteCode();
        StringBuilder label = new StringBuilder();
        if (showNumber) {
            label.append(String.format("%3d: ", instruction.getThisPC()));
        }
        if (!showExpressions) {
            String byteCodeName = byteCode.getName();
            if (!verboseBytecodeLabels) {
                label.append(byteCodeName);
            } else if (instruction instanceof InstructionSet.ConditionalBranch16) {
                InstructionSet.ConditionalBranch16 conditionalBranch16 = (InstructionSet.ConditionalBranch16)instruction;
                label.append(conditionalBranch16.getOperator().getText());
                label.append(" -> ");
                label.append(conditionalBranch16.getTarget().getThisPC());
            } else if (instruction instanceof InstructionSet.Branch) {
                InstructionSet.Branch branch = (InstructionSet.Branch)instruction;
                label.append(" -> ");
                label.append(branch.getTarget().getThisPC());
            } else if (instruction instanceof InstructionSet.MethodCall) {
                InstructionSet.MethodCall methodCall = (InstructionSet.MethodCall)((Object)instruction);
                label.append(methodCall.getConstantPoolMethodEntry().getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
                label.append(" ");
                label.append(methodCall.getConstantPoolMethodEntry().getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8());
            } else if (instruction instanceof InstructionSet.OperatorInstruction) {
                InstructionSet.OperatorInstruction operatorInstruction = (InstructionSet.OperatorInstruction)instruction;
                label.append(operatorInstruction.getOperator().getText() + "(" + byteCodeName + ")");
            } else if (instruction instanceof InstructionSet.FieldReference) {
                InstructionSet.FieldReference field = (InstructionSet.FieldReference)((Object)instruction);
                label.append(field.getConstantPoolFieldEntry().getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
                label.append(field.getConstantPoolFieldEntry().getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8());
            } else if (instruction instanceof InstructionSet.Constant) {
                InstructionSet.Constant constant = (InstructionSet.Constant)((Object)instruction);
                Object value = constant.getValue();
                if (value != null) {
                    label.append(value);
                } else if (instruction instanceof InstructionSet.I_ACONST_NULL) {
                    label.append("null");
                } else {
                    label.append(byteCodeName);
                }
            } else if (instruction instanceof InstructionSet.AssignToLocalVariable) {
                InstructionSet.AssignToLocalVariable assignToLocalVariable = (InstructionSet.AssignToLocalVariable)((Object)instruction);
                ClassModel.LocalVariableInfo info = assignToLocalVariable.getLocalVariableInfo();
                if (assignToLocalVariable.isDeclaration()) {
                    label.append(ClassModel.convert(info.getVariableDescriptor()));
                }
                label.append(info == null ? "?" : info.getVariableName());
                label.append("=");
            } else if (instruction instanceof InstructionSet.LocalVariableTableIndexAccessor) {
                InstructionSet.LocalVariableTableIndexAccessor localVariableAccessor = (InstructionSet.LocalVariableTableIndexAccessor)((Object)instruction);
                ClassModel.LocalVariableInfo info = localVariableAccessor.getLocalVariableInfo();
                label.append(info.getVariableName());
            } else if (instruction instanceof InstructionSet.I_IINC) {
                label.append((Object)instruction.getByteCode());
                label.append(" " + ((InstructionSet.I_IINC)instruction).getDelta());
                label.append(" " + ((InstructionSet.I_IINC)instruction).getLocalVariableInfo().getVariableName());
            } else if (instruction instanceof InstructionSet.CompositeInstruction) {
                label.append("composite ");
                label.append((Object)instruction.getByteCode());
            } else {
                label.append(byteCodeName);
            }
        } else {
            StringWriter writer = new StringWriter(label);
            try {
                writer.writeInstruction(instruction);
            }
            catch (CodeGenException e) {
                e.printStackTrace();
                writer.write("// exception " + e.getMessage());
            }
        }
        return label.toString();
    }

    private static void appendFoldedInstruction(Table _sl, String _prefix, Instruction _instruction) {
        _sl.data(_instruction.getThisPC());
        _sl.data(_prefix + InstructionHelper.getLabel(_instruction, false, false, true));
        int startPc = _instruction.getStartPC();
        int thisPc = _instruction.getThisPC();
        StringBuilder sb = new StringBuilder();
        for (BranchVector branchInfo : InstructionHelper.getBranches(_instruction.getMethod())) {
            sb.append(branchInfo.render(startPc, thisPc));
        }
        _sl.data(sb.toString());
        for (Instruction child = _instruction.getFirstChild(); child != null; child = child.getNextExpr()) {
            InstructionHelper.appendFoldedInstruction(_sl, _prefix + "   ", child);
        }
    }

    static void writeExpression(String _prefix, Instruction _instruction) {
        System.out.println(_prefix + InstructionHelper.getLabel(_instruction, true, true, false));
    }

    static String getFoldedView(MethodModel _methodModel) {
        Table sl = new Table("%4d", " %s", " %s");
        sl.header("  pc", " expression", " branches");
        for (Instruction root = _methodModel.getExprHead(); root != null; root = root.getNextExpr()) {
            InstructionHelper.appendFoldedInstruction(sl, "", root);
        }
        return sl.toString();
    }

    static String createView(MethodModel _methodModel, String _msg, Instruction _head) {
        Table table = new Table("[%2d-%2d] ", "%-60s", "%s");
        for (Instruction root = _head; root != null; root = root.getNextExpr()) {
            String label = InstructionHelper.getLabel(root, false, true, false);
            StringBuilder sb = new StringBuilder();
            for (BranchVector branchInfo : InstructionHelper.getBranches(_methodModel)) {
                sb.append(branchInfo.render(root.getThisPC(), root.getStartPC()));
            }
            table.data(root.getStartPC(), root.getThisPC());
            table.data(label);
            table.data(sb);
        }
        return _msg + "{\n" + table.toString() + "}\n";
    }

    static String createView(MethodModel _methodModel, String _msg, Instruction _head, Instruction _tail, int[] _pcForwardBranchTargetCounts) {
        Table table = new Table("[%2d-%2d] ", "%-40s", "%s", "%3d");
        for (Instruction root = _head; root != null; root = root.getNextExpr()) {
            String label = InstructionHelper.getLabel(root, false, false, false);
            StringBuilder sb = new StringBuilder();
            for (BranchVector branchInfo : InstructionHelper.getBranches(_methodModel)) {
                sb.append(branchInfo.render(root.getThisPC(), root.getStartPC()));
            }
            table.data(root.getStartPC(), root.getThisPC());
            table.data(" " + label);
            table.data(sb);
            table.data(_pcForwardBranchTargetCounts[root.getStartPC()]);
        }
        String label = InstructionHelper.getLabel(_tail, false, false, false);
        StringBuilder sb = new StringBuilder();
        for (BranchVector branchInfo : InstructionHelper.getBranches(_methodModel)) {
            sb.append(branchInfo.render(_tail.getThisPC(), _tail.getStartPC()));
        }
        table.data(_tail.getStartPC(), _tail.getThisPC());
        table.data("[" + label + "]");
        table.data(sb);
        table.data(_pcForwardBranchTargetCounts[_tail.getStartPC()]);
        return _msg + "{\n" + table.toString() + "}\n";
    }

    static String getJavapView(MethodModel _methodModel) {
        Table table = new Table("%4d", "%4d", " %s", " %s");
        table.header("stack ", "pc ", " mnemonic", " branches");
        int stack = 0;
        for (Instruction i = _methodModel.getPCHead(); i != null; i = i.getNextPC()) {
            int pc = i.getThisPC();
            table.data(stack += i.getStackDelta());
            table.data(pc);
            table.data(InstructionHelper.getLabel(i, false, false, false));
            StringBuilder sb = new StringBuilder();
            for (BranchVector branchInfo : InstructionHelper.getBranches(_methodModel)) {
                sb.append(branchInfo.render(pc));
            }
            table.data(sb);
        }
        return table.toString();
    }

    static List<BranchVector> getBranches(MethodModel _methodModel) {
        ArrayList<BranchVector> branchVectors = new ArrayList<BranchVector>();
        for (Instruction instruction = _methodModel.getPCHead(); instruction != null; instruction = instruction.getNextPC()) {
            if (!instruction.isBranch()) continue;
            InstructionSet.Branch branch = (InstructionSet.Branch)instruction;
            Instruction branchTarget = branch.getTarget();
            branchVectors.add(new BranchVector(branch, branchTarget));
        }
        Collections.sort(branchVectors, branchInfoComparator);
        return branchVectors;
    }

    void edump(StringBuilder _sb, Instruction i, boolean clone) {
        String label = InstructionHelper.getLabel(i, false, true, true);
        if (i instanceof InstructionSet.CloneInstruction) {
            this.edump(_sb, ((InstructionSet.CloneInstruction)i).getReal(), true);
        } else {
            if (i.producesStack()) {
                _sb.append("  ");
            } else {
                _sb.append("! ");
            }
            if (clone) {
                _sb.append("*");
            } else {
                _sb.append(" ");
            }
            _sb.append(i.getThisPC() + ":" + label);
        }
    }

    void fdump(int _depth, Instruction i, boolean clone) {
        String label = i.getByteCode().getName();
        if (i instanceof InstructionSet.CloneInstruction) {
            this.fdump(_depth, ((InstructionSet.CloneInstruction)i).getReal(), true);
        } else {
            if (_depth == 0) {
                if (i.producesStack()) {
                    System.out.print("  ");
                } else {
                    System.out.print("! ");
                }
            }
            if (clone) {
                System.out.print("*");
            } else if (_depth == 0) {
                System.out.print(" ");
            }
            System.out.print(i.getThisPC() + ":" + label);
        }
        if (i.getFirstChild() != null) {
            System.out.print("{");
            boolean comma = false;
            for (Instruction ii = i.getFirstChild(); ii != null; ii = ii.getNextExpr()) {
                if (comma) {
                    System.out.print(" ,");
                }
                this.fdump(_depth + 1, ii, false);
                comma = true;
            }
            System.out.print("}");
        }
    }

    void dump(String _indent, Instruction i, boolean clone) {
        String label = InstructionHelper.getLabel(i, true, false, false);
        if (i instanceof InstructionSet.CloneInstruction) {
            this.dump(_indent, ((InstructionSet.CloneInstruction)i).getReal(), true);
        } else {
            System.out.println(_indent + (clone ? "*" : " ") + label);
        }
        for (Instruction ii = i.getFirstChild(); ii != null; ii = ii.getNextExpr()) {
            this.dump(_indent + "  ", ii, false);
        }
    }

    public static class BranchVector {
        protected Instruction from;
        protected Instruction to;
        protected Instruction start;
        protected Instruction end;
        private boolean forward = false;
        public static final String NONE = " ";
        public static final String THROUGH = "|";
        public static final String CONDITIONAL_START = "?";
        public static final String UNCONDITIONAL_START = "-";
        public static final String TOP_ARROW = "^";
        public static final String BOTTOM_ARROW = "v";

        public BranchVector(Instruction _from, Instruction _to) {
            this.from = _from;
            this.to = _to;
            if (this.from.getThisPC() > this.to.getThisPC()) {
                this.start = _to;
                this.end = _from;
                this.forward = false;
            } else {
                this.start = _from;
                this.end = _to;
                this.forward = true;
            }
        }

        public boolean overlaps(BranchVector _other) {
            boolean overlap = this.start.getThisPC() < _other.start.getThisPC() && this.end.getThisPC() > _other.start.getThisPC() && this.end.getThisPC() <= _other.end.getThisPC() || _other.start.getThisPC() < this.start.getThisPC() && _other.start.getThisPC() > this.start.getThisPC() && _other.end.getThisPC() <= this.end.getThisPC();
            return overlap;
        }

        public Instruction getTo() {
            return this.to;
        }

        public Instruction getFrom() {
            return this.from;
        }

        public int getStartPC() {
            return this.start.getThisPC();
        }

        public int getEndPC() {
            return this.end.getThisPC();
        }

        public Instruction getStart() {
            return this.start;
        }

        public Instruction getEnd() {
            return this.end;
        }

        public boolean equals(Object other) {
            return other instanceof BranchVector && (other == this || ((BranchVector)other).from.equals(((BranchVector)other).to));
        }

        public int hashCode() {
            return this.from.hashCode() * 31 + this.to.hashCode();
        }

        public boolean isForward() {
            return this.forward;
        }

        public String toString() {
            if (this.isForward()) {
                return "forward from " + this.getStart() + " to " + this.getEnd();
            }
            return "backward from " + this.getEnd() + " to " + this.getStart();
        }

        public boolean isConditionalBranch() {
            return this.getFrom().isBranch() && this.getFrom().asBranch().isConditional();
        }

        public boolean isBackward() {
            return !this.isForward();
        }

        public String render(int _pc) {
            String returnString = NONE;
            if (this.isForward()) {
                if (_pc == this.getStartPC()) {
                    returnString = this.isConditionalBranch() ? CONDITIONAL_START : UNCONDITIONAL_START;
                } else if (_pc > this.getStartPC() && _pc < this.getEndPC()) {
                    returnString = THROUGH;
                } else if (_pc == this.getEndPC()) {
                    returnString = BOTTOM_ARROW;
                }
            } else if (_pc == this.getStartPC()) {
                returnString = TOP_ARROW;
            } else if (_pc > this.getStartPC() && _pc < this.getEndPC()) {
                returnString = THROUGH;
            } else if (_pc == this.getEndPC()) {
                returnString = this.isConditionalBranch() ? CONDITIONAL_START : UNCONDITIONAL_START;
            }
            return returnString;
        }

        public String render(int _startPC, int _thisPC) {
            String returnString = NONE;
            if (this.isForward()) {
                if (_startPC == this.getStartPC()) {
                    returnString = this.isConditionalBranch() ? CONDITIONAL_START : UNCONDITIONAL_START;
                } else if (_thisPC > this.getStartPC() && _startPC < this.getEndPC()) {
                    returnString = THROUGH;
                } else if (_thisPC == this.getEndPC()) {
                    returnString = BOTTOM_ARROW;
                }
            } else if (_startPC == this.getStartPC()) {
                returnString = TOP_ARROW;
            } else if (_thisPC > this.getStartPC() && _startPC < this.getEndPC()) {
                returnString = THROUGH;
            } else if (_thisPC == this.getEndPC()) {
                returnString = this.isConditionalBranch() ? CONDITIONAL_START : UNCONDITIONAL_START;
            }
            return returnString;
        }
    }

    public static class StringWriter
    extends BlockWriter {
        private StringBuilder sb = null;

        public StringWriter(StringBuilder _sb) {
            this.sb = _sb;
        }

        public StringWriter() {
            this.sb = new StringBuilder();
        }

        @Override
        public void write(String _string) {
            this.sb.append(_string);
        }

        public String toString() {
            return this.sb.toString().trim();
        }

        public void clear() {
            this.sb = new StringBuilder();
        }

        public static String write(MethodModel _methodModel) throws CodeGenException {
            StringWriter sw = new StringWriter();
            sw.writeMethodBody(_methodModel);
            return sw.toString();
        }

        @Override
        public void write(Entrypoint entryPoint) {
        }

        @Override
        public void writeMethodBody(MethodModel _methodModel) throws CodeGenException {
            super.writeMethodBody(_methodModel);
        }
    }

    public static class Table {
        static final String spaces = "                                                                                                                        ";
        private final List<Col> cols = new ArrayList<Col>();
        private int size = 0;
        private int col = 0;

        public Table(String ... _formats) {
            for (String format : _formats) {
                this.cols.add(new Col(format));
            }
        }

        public void data(Object ... args) {
            this.cols.get(this.col++).format(args);
            if (this.col == this.cols.size()) {
                this.col = 0;
                ++this.size;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                for (Col col : this.cols) {
                    sb.append(col.get(i));
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        public void header(String ... _headers) {
            for (int i = 0; i < _headers.length; ++i) {
                this.cols.get(i).header(_headers[i]);
            }
            ++this.size;
        }

        public static class Col {
            private final List<String> text = new ArrayList<String>();
            private int width;
            private String format = "%s";

            public Col(String _format) {
                this.format = _format;
            }

            public Col() {
                this("%s");
            }

            public void format(Object ... args) {
                String s = String.format(this.format, args);
                this.width = Math.max(s.length(), this.width);
                this.text.add(s);
            }

            public int size() {
                return this.text.size();
            }

            public String pad(String _s, int _width) {
                int length = _s.length();
                int padWidth = _width - length;
                String padded = _s + Table.spaces.substring(0, padWidth);
                return padded;
            }

            public String get(int _i) {
                return this.pad(this.text.get(_i), this.width);
            }

            public void header(String _header) {
                this.text.add(_header);
                this.width = _header.length();
            }
        }
    }
}

