/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.reader;

import com.aparapi.internal.reader.ByteBuffer;
import java.io.InputStream;

public class ByteReader {
    private final ByteBuffer byteBuffer;
    private int offset;

    public ByteReader(ByteBuffer _byteBuffer) {
        this.byteBuffer = _byteBuffer;
    }

    public ByteReader(byte[] _bytes) {
        this(new ByteBuffer(_bytes));
    }

    public ByteReader(InputStream _inputStream) {
        this(new ByteBuffer(_inputStream));
    }

    public int u1() {
        int value = this.byteBuffer.u1(this.offset);
        ++this.offset;
        return value;
    }

    public int u2() {
        int value = this.byteBuffer.u2(this.offset);
        this.offset += 2;
        return value;
    }

    public int s2() {
        int value = this.byteBuffer.s2(this.offset);
        this.offset += 2;
        return value;
    }

    public int peekU2() {
        return this.byteBuffer.u2(this.offset);
    }

    public int u4() {
        int value = this.byteBuffer.u4(this.offset);
        this.offset += 4;
        return value;
    }

    public int s4() {
        int value = this.byteBuffer.s4(this.offset);
        this.offset += 4;
        return value;
    }

    public long u8() {
        long value = this.byteBuffer.u8(this.offset);
        this.offset += 8;
        return value;
    }

    public float f4() {
        float value = this.byteBuffer.f4(this.offset);
        this.offset += 4;
        return value;
    }

    public double d8() {
        double value = this.byteBuffer.d8(this.offset);
        this.offset += 8;
        return value;
    }

    public String utf8() {
        String utf8 = this.byteBuffer.utf8(this.offset);
        this.offset += this.byteBuffer.utf8bytes(this.offset);
        return utf8;
    }

    public byte[] bytes(int _length) {
        byte[] bytes = this.byteBuffer.bytes(this.offset, _length);
        this.offset += _length;
        return bytes;
    }

    public void skip(int _length) {
        this.offset += _length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int _offset) {
        this.offset = _offset;
    }

    public boolean hasMore() {
        return this.getOffset() < this.byteBuffer.size();
    }
}

