/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.reader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteBuffer {
    private byte[] bytes;

    ByteBuffer(InputStream _inputStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.bytes = new byte[4096];
        int bytesRead = 0;
        try {
            while ((bytesRead = _inputStream.read(this.bytes)) > 0) {
                baos.write(this.bytes, 0, bytesRead);
            }
            this.bytes = baos.toByteArray();
        }
        catch (IOException e) {
            this.bytes = new byte[0];
            e.printStackTrace();
        }
    }

    int u2(int _offset) {
        return this.u1(_offset) << 8 | this.u1(_offset + 1);
    }

    int s2(int _offset) {
        int s2 = this.u2(_offset);
        if (s2 > Short.MAX_VALUE) {
            s2 = -(65536 - s2);
        }
        return s2;
    }

    int u4(int _offset) {
        return (this.u2(_offset) & 0xFFFF) << 16 | this.u2(_offset + 2);
    }

    int s4(int _offset) {
        int s4 = this.u4(_offset);
        return s4;
    }

    ByteBuffer(byte[] _bytes) {
        this.bytes = _bytes;
    }

    int u1(int _offset) {
        return this.bytes[_offset] & 0xFF;
    }

    int size() {
        return this.bytes.length;
    }

    double d8(int _offset) {
        return Double.longBitsToDouble(this.u8(_offset));
    }

    float f4(int _offset) {
        return Float.intBitsToFloat(this.u4(_offset));
    }

    long u8(int _offset) {
        return ((long)this.u4(_offset) & 0xFFFFFFFFL) << 32 | (long)this.u4(_offset + 4) & 0xFFFFFFFFL;
    }

    int utf8bytes(int _offset) {
        return 2 + this.u2(_offset);
    }

    byte[] bytes(int _offset, int _length) {
        byte[] returnBytes = new byte[_length];
        System.arraycopy(this.bytes, _offset, returnBytes, 0, _length);
        return returnBytes;
    }

    String utf8(int _offset) {
        int c;
        int utflen = this.u2(_offset);
        _offset += 2;
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int count = 0;
        int chararr_count = 0;
        for (int i = 0; i < utflen; ++i) {
            bytearr[i] = this.b(_offset + i);
        }
        _offset += utflen;
        while (count < utflen && (c = bytearr[count] & 0xFF) <= 127) {
            ++count;
            chararr[chararr_count++] = (char)c;
        }
        block7: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block7;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        System.out.println("malformed input: partial character at end");
                        return null;
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        System.out.println("malformed input around byte " + count);
                        return null;
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block7;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        System.out.println("malformed input: partial character at end");
                        return null;
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        System.out.println("malformed input around byte " + (count - 1));
                        return null;
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block7;
                }
            }
            System.out.println("malformed input around byte " + count);
            return null;
        }
        String returnString = new String(chararr, 0, chararr_count);
        return returnString;
    }

    byte b(int _offset) {
        return this.bytes[_offset];
    }
}

