/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.opencl;

import com.aparapi.ProfileInfo;
import com.aparapi.device.OpenCLDevice;
import com.aparapi.internal.jni.OpenCLJNI;
import com.aparapi.internal.opencl.OpenCLMem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenCLProgram
extends OpenCLJNI {
    private final long programId;
    private final long queueId;
    private final long contextId;
    private final long profileInfo = 0L;
    private final OpenCLDevice device;
    private final String source;
    private final Map<Object, OpenCLMem> instanceToMem = new HashMap<Object, OpenCLMem>();
    private final Map<Long, OpenCLMem> addressToMem = new HashMap<Long, OpenCLMem>();

    public OpenCLProgram(OpenCLDevice _device, String _source) {
        this.programId = 0L;
        this.queueId = 0L;
        this.contextId = 0L;
        this.device = _device;
        this.source = _source;
    }

    public OpenCLProgram(long _programId, long _queueId, long _contextId, OpenCLDevice _device, String _source) {
        this.programId = _programId;
        this.queueId = _queueId;
        this.contextId = _contextId;
        this.device = _device;
        this.source = _source;
    }

    public OpenCLProgram createProgram(OpenCLDevice context) {
        return this.createProgram(context, this.source);
    }

    public OpenCLDevice getDevice() {
        return this.device;
    }

    public synchronized OpenCLMem getMem(Object _instance, long _address) {
        OpenCLMem mem = this.instanceToMem.get(_instance);
        if (mem == null && (mem = this.addressToMem.get(_instance)) != null) {
            System.out.println("object has been moved, we need to remap the buffer");
            this.remap(this, mem, _address);
        }
        return mem;
    }

    public synchronized void add(Object _instance, long _address, OpenCLMem _mem) {
        this.instanceToMem.put(_instance, _mem);
        this.addressToMem.put(_address, _mem);
    }

    public synchronized void remapped(Object _instance, long _address, OpenCLMem _mem, long _oldAddress) {
        this.addressToMem.remove(_oldAddress);
        this.addressToMem.put(_address, _mem);
    }

    public void dispose() {
        this.disposeProgram(this);
    }

    public List<ProfileInfo> getProfileInfo() {
        return this.getProfileInfo(this);
    }
}

