/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.model;

import java.util.NoSuchElementException;

interface Optional<E> {
    public E get();

    public boolean isPresent();

    public static final class None<E>
    implements Optional<E> {
        private static final None none = new None();

        static <E> Optional<E> none() {
            return none;
        }

        private None() {
        }

        @Override
        public E get() {
            throw new NoSuchElementException("No value present");
        }

        @Override
        public boolean isPresent() {
            return false;
        }
    }

    public static final class Some<E>
    implements Optional<E> {
        private final E value;

        static final <E> Optional<E> of(E value) {
            return new Some<E>(value);
        }

        private Some(E value) {
            this.value = value;
        }

        @Override
        public E get() {
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }
    }
}

