/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.model;

import com.aparapi.Config;
import com.aparapi.Kernel;
import com.aparapi.internal.exception.AparapiException;
import com.aparapi.internal.exception.ClassParseException;
import com.aparapi.internal.instruction.ExpressionList;
import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.instruction.InstructionPattern;
import com.aparapi.internal.instruction.InstructionSet;
import com.aparapi.internal.instruction.InstructionTransformer;
import com.aparapi.internal.model.ClassModel;
import com.aparapi.internal.model.Entrypoint;
import com.aparapi.internal.reader.ByteReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MethodModel {
    private static Logger logger = Logger.getLogger(Config.getLoggerName());
    private ExpressionList expressionList;
    private ClassModel.ClassModelMethod method;
    private boolean usesDoubles;
    private boolean usesByteWrites;
    private boolean methodIsGetter;
    private boolean methodIsSetter;
    private boolean methodIsPrivateMemoryGetter = false;
    private boolean usesPutfield;
    private ClassModel.ConstantPool.FieldEntry accessorVariableFieldEntry;
    private boolean noCL = false;
    private final Set<MethodModel> calledMethods = new HashSet<MethodModel>();
    private Instruction pcTail = null;
    private Instruction pcHead = null;
    InstructionTransformer[] transformers = new InstructionTransformer[]{new InstructionTransformer("long hand post increment of field"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            if (Config.enablePUTFIELD) {
                result = InstructionPattern.accessInstanceField.matches(i, InstructionPattern.assignToInstanceField);
                if (result.ok) {
                    Instruction accessRaw = i;
                    Instruction assignRaw = i.getNextExpr();
                    InstructionSet.AccessInstanceField access = (InstructionSet.AccessInstanceField)((Object)i.getReal());
                    InstructionSet.AssignToInstanceField assign = (InstructionSet.AssignToInstanceField)((Object)i.getNextExpr().getReal());
                    if (access.getConstantPoolFieldIndex() == assign.getConstantPoolFieldIndex()) {
                        Instruction child = ((Instruction)((Object)assign)).getFirstChild().getNextExpr();
                        if (child instanceof InstructionSet.CastOperator) {
                            child = child.getFirstChild();
                        }
                        if (child instanceof InstructionSet.I_IADD) {
                            InstructionSet.I_IADD add = (InstructionSet.I_IADD)child;
                            Instruction lhs = add.getLhs();
                            Instruction rhs = add.getRhs();
                            if (lhs instanceof InstructionSet.AccessInstanceField && rhs instanceof InstructionSet.I_ICONST_1) {
                                InstructionSet.IncrementInstruction inc = new InstructionSet.IncrementInstruction(MethodModel.this, (Instruction)((Object)access), true, false);
                                _expressionList.replaceInclusive(accessRaw, assignRaw, inc);
                                return inc;
                            }
                        }
                    }
                }
            }
            return null;
        }
    }, new InstructionTransformer("long hand pre increment of field"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            if (Config.enablePUTFIELD) {
                result = InstructionPattern.fieldPlusOne.matches(i, InstructionPattern.assignToInstanceField);
                if (result.ok) {
                    Instruction topAddRaw = i;
                    Instruction assignRaw = i.getNextExpr();
                    InstructionSet.I_IADD topAdd = (InstructionSet.I_IADD)i.getReal();
                    InstructionSet.AssignToInstanceField assign = (InstructionSet.AssignToInstanceField)((Object)i.getNextExpr().getReal());
                    Instruction topLhs = topAdd.getLhs().getReal();
                    Instruction topRhs = topAdd.getRhs().getReal();
                    if (topLhs instanceof InstructionSet.AccessInstanceField) {
                        InstructionSet.AccessInstanceField topLhsAccess = (InstructionSet.AccessInstanceField)((Object)topLhs);
                        if (topRhs instanceof InstructionSet.I_ICONST_1 && topLhsAccess.getConstantPoolFieldIndex() == assign.getConstantPoolFieldIndex()) {
                            Instruction child = ((Instruction)((Object)assign)).getFirstChild().getNextExpr();
                            Instruction valueToAssign = assign.getValueToAssign();
                            if (valueToAssign instanceof InstructionSet.I_IADD) {
                                InstructionSet.I_IADD add = (InstructionSet.I_IADD)child;
                                Instruction lhs = add.getLhs();
                                Instruction rhs = add.getRhs();
                                if (lhs instanceof InstructionSet.AccessInstanceField && rhs instanceof InstructionSet.I_ICONST_1) {
                                    InstructionSet.IncrementInstruction inc = new InstructionSet.IncrementInstruction(MethodModel.this, (Instruction)((Object)topLhsAccess), true, true);
                                    _expressionList.replaceInclusive(topAddRaw, assignRaw, inc);
                                    return inc;
                                }
                            }
                        }
                    }
                }
            }
            return null;
        }
    }, new InstructionTransformer("long hand post increment of local variable"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.accessLocalVariable.matches(i, InstructionPattern.longHandIncLocalVariable);
            if (result.ok) {
                InstructionSet.AccessLocalVariable access = (InstructionSet.AccessLocalVariable)((Object)i);
                InstructionSet.AssignToLocalVariable assign = (InstructionSet.AssignToLocalVariable)((Object)i.getNextExpr());
                if (access.getLocalVariableTableIndex() == assign.getLocalVariableTableIndex()) {
                    InstructionSet.IncrementInstruction inc = new InstructionSet.IncrementInstruction(MethodModel.this, (Instruction)((Object)access), true, false);
                    _expressionList.replaceInclusive((Instruction)((Object)access), (Instruction)((Object)assign), inc);
                    return inc;
                }
            }
            return null;
        }
    }, new InstructionTransformer("long hand post decrement of local variable"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.accessLocalVariable.matches(i, InstructionPattern.longHandDecLocalVariable);
            if (result.ok) {
                InstructionSet.AccessLocalVariable access = (InstructionSet.AccessLocalVariable)((Object)i);
                InstructionSet.AssignToLocalVariable assign = (InstructionSet.AssignToLocalVariable)((Object)i.getNextExpr());
                if (access.getLocalVariableTableIndex() == assign.getLocalVariableTableIndex()) {
                    InstructionSet.IncrementInstruction inc = new InstructionSet.IncrementInstruction(MethodModel.this, (Instruction)((Object)access), false, false);
                    _expressionList.replaceInclusive((Instruction)((Object)access), (Instruction)((Object)assign), inc);
                    return inc;
                }
            }
            return null;
        }
    }, new InstructionTransformer("long hand pre increment of local variable"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.longHandIncLocalVariable.matches(i, InstructionPattern.accessLocalVariable);
            if (result.ok) {
                InstructionSet.AssignToLocalVariable assign = (InstructionSet.AssignToLocalVariable)((Object)i);
                InstructionSet.AccessLocalVariable access = (InstructionSet.AccessLocalVariable)((Object)i.getNextExpr());
                if (access.getLocalVariableTableIndex() == assign.getLocalVariableTableIndex()) {
                    InstructionSet.IncrementInstruction inc = new InstructionSet.IncrementInstruction(MethodModel.this, (Instruction)((Object)access), true, true);
                    _expressionList.replaceInclusive((Instruction)((Object)assign), (Instruction)((Object)access), inc);
                    return inc;
                }
            }
            return null;
        }
    }, new InstructionTransformer("inline assign - say for methiod call or logical expression - "){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionSet.AccessLocalVariable access;
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.accessLocalVariable.matches(i, InstructionPattern.assignToLocalVariable);
            if (result.ok && (access = (InstructionSet.AccessLocalVariable)((Object)i)).getLocalVariableTableIndex() != 0) {
                InstructionSet.AssignToLocalVariable assign = (InstructionSet.AssignToLocalVariable)((Object)i.getNextExpr());
                if (access.getLocalVariableTableIndex() != assign.getLocalVariableTableIndex()) {
                    InstructionSet.InlineAssignInstruction inlineAssign = new InstructionSet.InlineAssignInstruction(MethodModel.this, assign, (Instruction)((Object)access));
                    _expressionList.replaceInclusive((Instruction)((Object)access), (Instruction)((Object)assign), inlineAssign);
                    return inlineAssign;
                }
            }
            return null;
        }
    }, new InstructionTransformer("pre increment of local variable"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.inc.matches(i, InstructionPattern.accessLocalVariable);
            if (result.ok) {
                InstructionSet.I_IINC iinc = (InstructionSet.I_IINC)i;
                InstructionSet.AccessLocalVariable access = (InstructionSet.AccessLocalVariable)((Object)i.getNextExpr());
                if (iinc.getLocalVariableTableIndex() == access.getLocalVariableTableIndex()) {
                    InstructionSet.IncrementInstruction inc = new InstructionSet.IncrementInstruction(MethodModel.this, (Instruction)((Object)access), iinc.isInc(), true);
                    _expressionList.replaceInclusive(iinc, (Instruction)((Object)access), inc);
                    return inc;
                }
            }
            return null;
        }
    }, new InstructionTransformer("post increment of local variable"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.accessLocalVariable.matches(i, InstructionPattern.inc);
            if (result.ok) {
                InstructionSet.AccessLocalVariable access = (InstructionSet.AccessLocalVariable)((Object)i);
                InstructionSet.I_IINC iinc = (InstructionSet.I_IINC)i.getNextExpr();
                if (iinc.getLocalVariableTableIndex() == access.getLocalVariableTableIndex()) {
                    InstructionSet.IncrementInstruction inc = new InstructionSet.IncrementInstruction(MethodModel.this, (Instruction)((Object)access), iinc.isInc(), false);
                    _expressionList.replaceInclusive((Instruction)((Object)access), iinc, inc);
                    return inc;
                }
            }
            return null;
        }
    }, new InstructionTransformer("inline assign of local variable (with cast)"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.cast.matches(i, InstructionPattern.assignToLocalVariable);
            if (result.ok) {
                InstructionSet.CastOperator cast = (InstructionSet.CastOperator)i;
                InstructionSet.AssignToLocalVariable assign = (InstructionSet.AssignToLocalVariable)((Object)i.getNextExpr());
                InstructionSet.InlineAssignInstruction inlineAssign = new InstructionSet.InlineAssignInstruction(MethodModel.this, assign, cast);
                _expressionList.replaceInclusive(cast, (Instruction)((Object)assign), inlineAssign);
                return inlineAssign;
            }
            return null;
        }
    }, new InstructionTransformer("field array element pre increment with nested index (local variable) pre increment"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.fieldArrayElementPlusOne.matches(i, InstructionPattern.longHandFieldArrayElementIncrement);
            if (result.ok) {
                Instruction addRaw = i;
                Instruction assignArrayRaw = i.getNextExpr();
                InstructionSet.AssignToArrayElement assignArray = (InstructionSet.AssignToArrayElement)assignArrayRaw.getReal();
                InstructionSet.FieldArrayElementIncrement inlineAssign = new InstructionSet.FieldArrayElementIncrement(MethodModel.this, assignArray, true, true);
                _expressionList.replaceInclusive(addRaw, assignArrayRaw, inlineAssign);
                return inlineAssign;
            }
            return null;
        }
    }, new InstructionTransformer("field array element pre decrement with nested index (local variable) pre decrement"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.fieldArrayElementMinusOne.matches(i, InstructionPattern.longHandFieldArrayElementDecrement);
            if (result.ok) {
                Instruction subRaw = i;
                Instruction assignArrayRaw = i.getNextExpr();
                InstructionSet.AssignToArrayElement assignArray = (InstructionSet.AssignToArrayElement)assignArrayRaw.getReal();
                InstructionSet.FieldArrayElementIncrement inlineAssign = new InstructionSet.FieldArrayElementIncrement(MethodModel.this, assignArray, false, true);
                _expressionList.replaceInclusive(subRaw, assignArrayRaw, inlineAssign);
                return inlineAssign;
            }
            return null;
        }
    }, new InstructionTransformer("field array element post inccrement with nested index (local variable) "){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.fieldArrayElementAccess.matches(i, InstructionPattern.longHandFieldArrayElementIncrement);
            if (result.ok) {
                Instruction accessArrayRaw = i;
                Instruction assignArrayRaw = i.getNextExpr();
                InstructionSet.AccessArrayElement accessArray = (InstructionSet.AccessArrayElement)accessArrayRaw.getReal();
                InstructionSet.AssignToArrayElement assignArray = (InstructionSet.AssignToArrayElement)assignArrayRaw.getReal();
                InstructionSet.AccessField accessField1 = (InstructionSet.AccessField)((Object)accessArray.getArrayRef().getReal());
                InstructionSet.AccessField accessField2 = (InstructionSet.AccessField)((Object)assignArray.getArrayRef().getReal());
                if (accessField1.getConstantPoolFieldIndex() == accessField2.getConstantPoolFieldIndex()) {
                    InstructionSet.FieldArrayElementIncrement inlineAssign = new InstructionSet.FieldArrayElementIncrement(MethodModel.this, assignArray, true, false);
                    _expressionList.replaceInclusive(accessArrayRaw, assignArrayRaw, inlineAssign);
                    return inlineAssign;
                }
            }
            return null;
        }
    }, new InstructionTransformer("field array element post decrement with nested index (local variable) "){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.fieldArrayElementAccess.matches(i, InstructionPattern.longHandFieldArrayElementDecrement);
            if (result.ok) {
                Instruction accessArrayRaw = i;
                Instruction assignArrayRaw = i.getNextExpr();
                InstructionSet.AccessArrayElement accessArray = (InstructionSet.AccessArrayElement)accessArrayRaw.getReal();
                InstructionSet.AssignToArrayElement assignArray = (InstructionSet.AssignToArrayElement)assignArrayRaw.getReal();
                InstructionSet.AccessField accessField1 = (InstructionSet.AccessField)((Object)accessArray.getArrayRef().getReal());
                InstructionSet.AccessField accessField2 = (InstructionSet.AccessField)((Object)assignArray.getArrayRef().getReal());
                if (accessField1.getConstantPoolFieldIndex() == accessField2.getConstantPoolFieldIndex()) {
                    InstructionSet.AccessLocalVariable accessLocalVariable1 = (InstructionSet.AccessLocalVariable)((Object)accessArray.getArrayIndex().getReal());
                    InstructionSet.AccessLocalVariable accessLocalVariable2 = (InstructionSet.AccessLocalVariable)((Object)assignArray.getArrayIndex().getReal());
                    if (accessLocalVariable1.getLocalVariableTableIndex() == accessLocalVariable2.getLocalVariableTableIndex()) {
                        InstructionSet.FieldArrayElementIncrement inlineAssign = new InstructionSet.FieldArrayElementIncrement(MethodModel.this, assignArray, false, false);
                        _expressionList.replaceInclusive(accessArrayRaw, assignArrayRaw, inlineAssign);
                        return inlineAssign;
                    }
                }
            }
            return null;
        }
    }, new InstructionTransformer("inline assign (for method call or logical expression)"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.methodCall.matches(i, InstructionPattern.assignToLocalVariable);
            if (result.ok) {
                Instruction invoke = i;
                InstructionSet.AssignToLocalVariable assign = (InstructionSet.AssignToLocalVariable)((Object)i.getNextExpr());
                InstructionSet.InlineAssignInstruction inlineAssign = new InstructionSet.InlineAssignInstruction(MethodModel.this, assign, invoke);
                _expressionList.replaceInclusive(invoke, (Instruction)((Object)assign), inlineAssign);
                return inlineAssign;
            }
            return null;
        }
    }, new InstructionTransformer("incline assign from constant (method call or logical expression)"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.constant.matches(i, InstructionPattern.assignToLocalVariable);
            if (result.ok) {
                Instruction constant = i;
                InstructionSet.AssignToLocalVariable assign = (InstructionSet.AssignToLocalVariable)((Object)i.getNextExpr());
                InstructionSet.InlineAssignInstruction inlineAssign = new InstructionSet.InlineAssignInstruction(MethodModel.this, assign, constant);
                _expressionList.replaceInclusive(constant, (Instruction)((Object)assign), inlineAssign);
                return inlineAssign;
            }
            return null;
        }
    }, new InstructionTransformer("inline array assignment as part of a method call"){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.methodCall.matches(i, InstructionPattern.assignToArrayElement);
            if (result.ok) {
                Instruction invoke = i;
                InstructionSet.AssignToArrayElement assign = (InstructionSet.AssignToArrayElement)i.getNextExpr();
                InstructionSet.FieldArrayElementAssign inlineAssign = new InstructionSet.FieldArrayElementAssign(MethodModel.this, assign, invoke);
                _expressionList.replaceInclusive(invoke, assign, inlineAssign);
                return inlineAssign;
            }
            return null;
        }
    }, new InstructionTransformer("inline array element increment as as part of a method call "){

        @Override
        public Instruction transform(ExpressionList _expressionList, Instruction i) {
            InstructionPattern.InstructionMatch result = null;
            result = InstructionPattern.assignToArrayElement.matches(i, InstructionPattern.longHandFieldArrayElementIncrement);
            if (result.ok) {
                Instruction invoke = i;
                InstructionSet.AssignToArrayElement assign = (InstructionSet.AssignToArrayElement)i.getNextExpr();
                InstructionSet.FieldArrayElementAssign inlineAssign = new InstructionSet.FieldArrayElementAssign(MethodModel.this, assign, invoke);
                _expressionList.replaceInclusive(invoke, assign, inlineAssign);
                return inlineAssign;
            }
            return null;
        }
    }};
    Entrypoint entrypoint = null;

    public boolean isGetter() {
        return this.methodIsGetter;
    }

    public boolean isSetter() {
        return this.methodIsSetter;
    }

    public boolean methodUsesPutfield() {
        return this.usesPutfield;
    }

    public boolean isNoCL() {
        return this.noCL;
    }

    public boolean isPrivateMemoryGetter() {
        return this.methodIsPrivateMemoryGetter;
    }

    public ClassModel.ClassModelMethod getMethod() {
        return this.method;
    }

    public ClassModel.ConstantPool.FieldEntry getAccessorVariableFieldEntry() {
        return this.accessorVariableFieldEntry;
    }

    public Set<MethodModel> getCalledMethods() {
        return this.calledMethods;
    }

    public void checkForRecursion(Set<MethodModel> transitiveCalledMethods) throws AparapiException {
        if (transitiveCalledMethods.contains(this)) {
            throw new ClassParseException(ClassParseException.TYPE.RECURSION, this.getName());
        }
        transitiveCalledMethods.add(this);
        for (MethodModel next : this.getCalledMethods()) {
            next.checkForRecursion(transitiveCalledMethods);
        }
        transitiveCalledMethods.remove(this);
    }

    public void setRequiredPragmas(Instruction instruction) {
        boolean setDouble = instruction.getByteCode().usesDouble();
        if (setDouble) {
            this.usesDoubles = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found D on =" + instruction + " in " + this.getName());
            }
        }
        if (instruction instanceof InstructionSet.I_BASTORE || instruction instanceof InstructionSet.I_CASTORE) {
            this.usesByteWrites = true;
            if (this.usesByteWrites && logger.isLoggable(Level.FINE)) {
                logger.fine("Found Byte Addressable Store on =" + instruction + " in " + this.getName());
            }
        }
    }

    public boolean requiresDoublePragma() {
        return this.usesDoubles;
    }

    public boolean requiresByteAddressableStorePragma() {
        return this.usesByteWrites;
    }

    public Map<Integer, Instruction> createListOfInstructions() throws ClassParseException {
        LinkedHashMap<Integer, Instruction> pcMap = new LinkedHashMap<Integer, Instruction>();
        byte[] code = this.method.getCode();
        ByteReader codeReader = new ByteReader(code);
        while (codeReader.hasMore()) {
            InstructionSet.MethodCall methodCall;
            ClassModel.ConstantPool.MethodEntry methodReferenceEntry;
            int pc = codeReader.getOffset();
            Instruction instruction = InstructionSet.ByteCode.create(this, codeReader);
            if (!Config.enablePUTFIELD && instruction instanceof InstructionSet.I_PUTFIELD) {
                this.usesPutfield = true;
            }
            if (!Config.enableARETURN && instruction instanceof InstructionSet.I_ARETURN) {
                throw new ClassParseException(instruction, ClassParseException.TYPE.ARRAY_RETURN);
            }
            if (!Config.enablePUTSTATIC && instruction instanceof InstructionSet.I_PUTSTATIC) {
                throw new ClassParseException(instruction, ClassParseException.TYPE.PUTFIELD);
            }
            if (!Config.enableINVOKEINTERFACE && instruction instanceof InstructionSet.I_INVOKEINTERFACE) {
                throw new ClassParseException(instruction, ClassParseException.TYPE.INVOKEINTERFACE);
            }
            if (!Config.enableATHROW && instruction instanceof InstructionSet.I_ATHROW) {
                throw new ClassParseException(instruction, ClassParseException.TYPE.ATHROW);
            }
            if (!Config.enableMONITOR && (instruction instanceof InstructionSet.I_MONITORENTER || instruction instanceof InstructionSet.I_MONITOREXIT)) {
                throw new ClassParseException(instruction, ClassParseException.TYPE.SYNCHRONIZE);
            }
            if (instruction instanceof InstructionSet.New) {
                if (instruction instanceof InstructionSet.I_NEWARRAY) {
                    if (!Config.enableARRAY) {
                        throw new ClassParseException(instruction, ClassParseException.TYPE.NEWARRAY);
                    }
                } else {
                    if (instruction instanceof InstructionSet.I_MULTIANEWARRAY) {
                        throw new ClassParseException(instruction, ClassParseException.TYPE.NEWMULTIARRAY);
                    }
                    if (!Config.enableNEW) {
                        throw new ClassParseException(instruction, ClassParseException.TYPE.NEW);
                    }
                }
            }
            if (!Config.enableSWITCH && (instruction instanceof InstructionSet.I_LOOKUPSWITCH || instruction instanceof InstructionSet.I_TABLESWITCH)) {
                throw new ClassParseException(instruction, ClassParseException.TYPE.SWITCH);
            }
            if (!Config.enableMETHODARRAYPASSING && instruction instanceof InstructionSet.MethodCall && !Kernel.isMappedMethod(methodReferenceEntry = (methodCall = (InstructionSet.MethodCall)((Object)instruction)).getConstantPoolMethodEntry())) {
                for (ClassModel.ConstantPool.MethodReferenceEntry.Arg arg : methodReferenceEntry.getArgs()) {
                    if (!arg.isArray()) continue;
                    throw new ClassParseException(instruction, ClassParseException.TYPE.METHODARRAYARG);
                }
            }
            this.setRequiredPragmas(instruction);
            pcMap.put(pc, instruction);
            if (this.pcHead == null) {
                this.pcHead = instruction;
            }
            instruction.setPrevPC(this.pcTail);
            if (this.pcTail != null) {
                this.pcTail.setNextPC(instruction);
            }
            this.pcTail = instruction;
        }
        return pcMap;
    }

    public void buildBranchGraphs(Map<Integer, Instruction> pcMap) {
        for (Instruction instruction = this.pcHead; instruction != null; instruction = instruction.getNextPC()) {
            if (!instruction.isBranch()) continue;
            InstructionSet.Branch branch = instruction.asBranch();
            Instruction targetInstruction = pcMap.get(branch.getAbsolute());
            branch.setTarget(targetInstruction);
        }
    }

    public void deoptimizeReverseBranches() {
        for (Instruction instruction = this.pcHead; instruction != null; instruction = instruction.getNextPC()) {
            Instruction target;
            LinkedList<InstructionSet.Branch> list;
            InstructionSet.Branch branch;
            if (!instruction.isBranch() || !(branch = instruction.asBranch()).isReverse() || (list = (target = branch.getTarget()).getReverseUnconditionalBranches()) == null || list.size() <= 0 || list.get(list.size() - 1) == branch) continue;
            InstructionSet.Branch unconditional = list.get(list.size() - 1).asBranch();
            branch.retarget(unconditional);
        }
    }

    public void txFormDups(ExpressionList _expressionList, Instruction _instruction) throws ClassParseException {
        if (_instruction instanceof InstructionSet.I_DUP) {
            Instruction e = _expressionList.getTail();
            while (!e.producesStack()) {
                e = e.getPrevExpr();
            }
            _expressionList.add(new InstructionSet.CloneInstruction(this, e));
        } else if (_instruction instanceof InstructionSet.I_DUP2) {
            Instruction e = _expressionList.getTail();
            while (!e.producesStack()) {
                e = e.getPrevPC();
            }
            Instruction clone = e;
            e = e.getPrevExpr();
            while (!e.producesStack()) {
                e = e.getPrevExpr();
            }
            _expressionList.add(new InstructionSet.CloneInstruction(this, e));
            _expressionList.add(new InstructionSet.CloneInstruction(this, clone));
        } else if (_instruction instanceof InstructionSet.I_DUP_X1) {
            Instruction e = _expressionList.getTail();
            while (!e.producesStack()) {
                e = e.getPrevExpr();
            }
            InstructionSet.CloneInstruction clone1 = new InstructionSet.CloneInstruction(this, e);
            e = e.getPrevExpr();
            while (!e.producesStack()) {
                e = e.getPrevExpr();
            }
            _expressionList.insertBetween(e.getPrevExpr(), e, clone1);
        } else if (_instruction instanceof InstructionSet.I_DUP_X2) {
            Instruction e = _expressionList.getTail();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found DUP_X2 prev=" + e.getPrevExpr() + " e=" + e + " curr=" + _instruction);
            }
            while (!e.producesStack()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("DUP_X2 skipping to find write: e=" + e);
                }
                e = e.getPrevExpr();
            }
            InstructionSet.CloneInstruction clone1 = new InstructionSet.CloneInstruction(this, e);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("DUP_X2 cloning: clone1=" + clone1);
            }
            e = e.getPrevExpr();
            int i = 0;
            while (i < 2) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("DUP_X2 skipping to find insert: e=" + e);
                }
                if (e.producesStack()) {
                    ++i;
                }
                if (i >= 2) continue;
                e = e.getPrevExpr();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("DUP_X2 insert: prev=" + e.getPrevExpr() + " e=" + e + " clone=" + clone1);
            }
            _expressionList.insertBetween(e.getPrevExpr(), e, clone1);
        } else if (_instruction instanceof InstructionSet.DUP) {
            throw new ClassParseException(_instruction, ClassParseException.TYPE.UNSUPPORTEDBYTECODE);
        }
    }

    void foldExpressions() throws ClassParseException {
        for (Instruction instruction = this.pcHead; instruction != null; instruction = instruction.getNextPC()) {
            this.expressionList.foldComposite(instruction);
            if (instruction instanceof InstructionSet.DUP) {
                this.txFormDups(this.expressionList, instruction);
                continue;
            }
            if (instruction.consumesStack()) {
                Instruction cursor = this.expressionList.getTail();
                boolean foundNonStackProducer = false;
                Instruction operandStart = null;
                int i = 0;
                while (i < instruction.getStackConsumeCount()) {
                    if (!cursor.producesStack()) {
                        foundNonStackProducer = true;
                    } else {
                        ++i;
                    }
                    operandStart = cursor;
                    cursor = cursor.getPrevExpr();
                }
                if (foundNonStackProducer) {
                    this.applyTransformations(this.expressionList, instruction, operandStart);
                }
                Instruction childTail = this.expressionList.getTail();
                Instruction childHead = this.expressionList.createList(cursor);
                instruction.setChildren(childHead, childTail);
            }
            this.expressionList.add(instruction);
        }
    }

    void applyTransformations(ExpressionList _expressionList, Instruction _instruction, Instruction _operandStart) throws ClassParseException {
        if (logger.isLoggable(Level.FINE)) {
            System.out.println("We are looking at " + _instruction + " which wants to consume " + _instruction.getStackConsumeCount() + " operands");
        }
        boolean txformed = false;
        if (_instruction instanceof InstructionSet.AssignToLocalVariable && _operandStart.producesStack() && _operandStart.getNextExpr() instanceof InstructionSet.AssignToLocalVariable) {
            Instruction assignFirst;
            Instruction assign = assignFirst = _operandStart.getNextExpr();
            int count = 0;
            while (assign != null && assign instanceof InstructionSet.AssignToLocalVariable) {
                assign = assign.getNextExpr();
                ++count;
            }
            if (assign == null) {
                InstructionSet.MultiAssignInstruction newOne = new InstructionSet.MultiAssignInstruction(this, _operandStart, assignFirst, assign);
                _expressionList.replaceInclusive(_operandStart, assign, newOne);
                txformed = true;
            }
        }
        if (!txformed) {
            boolean again = false;
            Instruction i = _operandStart;
            while (i != null) {
                again = false;
                for (InstructionTransformer txformer : this.transformers) {
                    Instruction newI = txformer.transform(_expressionList, i);
                    if (newI == null) continue;
                    i = newI;
                    again = true;
                    txformed = true;
                    break;
                }
                i = again ? i : i.getNextExpr();
            }
        }
        if (txformed) {
            if (logger.isLoggable(Level.FINE)) {
                System.out.println("We are looking at " + _instruction + " which wants to consume " + _instruction.getStackConsumeCount() + " operands");
            }
        } else {
            throw new ClassParseException(_instruction, ClassParseException.TYPE.OPERANDCONSUMERPRODUCERMISSMATCH);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void checkForGetter(Map<Integer, Instruction> pcMap) throws ClassParseException {
        String methodName = this.getMethod().getName();
        String rawVarNameCandidate = null;
        boolean mightBeGetter = true;
        if (methodName.startsWith("get")) {
            rawVarNameCandidate = methodName.substring(3);
        } else {
            if (!methodName.startsWith("is")) return;
            rawVarNameCandidate = methodName.substring(2);
        }
        if (!mightBeGetter) return;
        boolean possiblySimpleGetImplementation = pcMap.size() == 3;
        if (rawVarNameCandidate == null) throw new ClassParseException(ClassParseException.TYPE.BADGETTERNAMENOTFOUND, methodName);
        if (!this.isNoCL()) {
            if (!possiblySimpleGetImplementation) throw new ClassParseException(ClassParseException.TYPE.BADGETTERNAMENOTFOUND, methodName);
        }
        String firstLetter = rawVarNameCandidate.substring(0, 1).toLowerCase();
        String varNameCandidateCamelCased = rawVarNameCandidate.replaceFirst(rawVarNameCandidate.substring(0, 1), firstLetter);
        if (!this.isNoCL()) {
            Instruction instruction = this.expressionList.getHead();
            if (!(instruction instanceof InstructionSet.Return)) throw new ClassParseException(ClassParseException.TYPE.BADGETTERNAMENOTFOUND, methodName);
            if (this.expressionList.getHead() != this.expressionList.getTail()) throw new ClassParseException(ClassParseException.TYPE.BADGETTERNAMENOTFOUND, methodName);
            if (!((instruction = instruction.getPrevPC()) instanceof InstructionSet.AccessInstanceField)) return;
            ClassModel.ConstantPool.FieldEntry field = ((InstructionSet.AccessInstanceField)((Object)instruction)).getConstantPoolFieldEntry();
            String accessedFieldName = field.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
            if (!accessedFieldName.equals(varNameCandidateCamelCased)) throw new ClassParseException(ClassParseException.TYPE.BADGETTERNAMEMISMATCH, methodName);
            String fieldType = field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8();
            String returnType = this.getMethod().getDescriptor().substring(2);
            if (!$assertionsDisabled) {
                if (fieldType.length() != 1) throw new AssertionError((Object)" can only use basic type getters");
                if (returnType.length() != 1) {
                    throw new AssertionError((Object)" can only use basic type getters");
                }
            }
            if (!methodName.startsWith("is") || !fieldType.equals("Z")) {
                if (!methodName.startsWith("get")) return;
            }
            if (!fieldType.equals(returnType)) throw new ClassParseException(ClassParseException.TYPE.BADGETTERTYPEMISMATCH, methodName);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found " + methodName + " as a getter for " + varNameCandidateCamelCased.toLowerCase());
            }
            this.methodIsGetter = true;
            this.setAccessorVariableFieldEntry(field);
            if ($assertionsDisabled) return;
            if (!this.methodIsSetter) return;
            throw new AssertionError((Object)" cannot be both");
        }
        ClassModel.ConstantPool.FieldEntry fieldEntry = this.getMethod().getOwnerClassModel().getConstantPool().getFieldEntry(varNameCandidateCamelCased);
        this.setAccessorVariableFieldEntry(fieldEntry);
        if (this.getAccessorVariableFieldEntry() == null) {
            throw new ClassParseException(ClassParseException.TYPE.BADGETTERNAMEMISMATCH, methodName);
        }
        this.methodIsGetter = true;
        if (this.method.getClassModel().getPrivateMemorySize(fieldEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8()) == null) return;
        this.methodIsPrivateMemoryGetter = true;
    }

    private void setAccessorVariableFieldEntry(ClassModel.ConstantPool.FieldEntry field) {
        this.accessorVariableFieldEntry = field;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void checkForSetter(Map<Integer, Instruction> pcMap) throws ClassParseException {
        Instruction prev;
        String methodName = this.getMethod().getName();
        if (!methodName.startsWith("set")) return;
        String rawVarNameCandidate = methodName.substring(3);
        String firstLetter = rawVarNameCandidate.substring(0, 1).toLowerCase();
        String varNameCandidateCamelCased = rawVarNameCandidate.replaceFirst(rawVarNameCandidate.substring(0, 1), firstLetter);
        String accessedFieldName = null;
        Instruction instruction = this.expressionList.getHead();
        if (!(instruction instanceof InstructionSet.AssignToInstanceField)) return;
        if (!(this.expressionList.getTail() instanceof InstructionSet.Return) || pcMap.size() != 4 || !((prev = instruction.getPrevPC()) instanceof InstructionSet.AccessLocalVariable)) return;
        ClassModel.ConstantPool.FieldEntry field = ((InstructionSet.AssignToInstanceField)((Object)instruction)).getConstantPoolFieldEntry();
        accessedFieldName = field.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
        if (!accessedFieldName.equals(varNameCandidateCamelCased)) throw new ClassParseException(ClassParseException.TYPE.BADSETTERTYPEMISMATCH, methodName);
        String fieldType = field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8();
        String setterArgType = this.getMethod().getDescriptor().substring(1, 2);
        assert (fieldType.length() == 1) : " can only use basic type getters";
        if (!fieldType.equals(setterArgType)) throw new ClassParseException(ClassParseException.TYPE.BADSETTERTYPEMISMATCH, methodName);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Found " + methodName + " as a setter for " + varNameCandidateCamelCased.toLowerCase() + " of type " + fieldType);
        }
        this.methodIsSetter = true;
        this.setAccessorVariableFieldEntry(field);
        if (fieldType.equals("B") || fieldType.equals("Z")) {
            this.usesByteWrites = true;
        }
        assert (!this.methodIsGetter) : " cannot be both";
        return;
    }

    MethodModel(ClassModel.ClassModelMethod _method, Entrypoint _entrypoint) throws AparapiException {
        this.entrypoint = _entrypoint;
        this.init(_method);
    }

    MethodModel(ClassModel.ClassModelMethod _method) throws AparapiException {
        this.init(_method);
    }

    private void init(ClassModel.ClassModelMethod _method) throws AparapiException {
        int exceptionsSize;
        this.method = _method;
        this.expressionList = new ExpressionList(this);
        ClassModel owner = _method.getOwnerClassModel();
        if (owner.getNoCLMethods().contains(this.method.getName())) {
            this.noCL = true;
        }
        if ((exceptionsSize = this.method.getCodeEntry().getExceptionPoolEntries().size()) > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("exception size for " + this.method + " = " + exceptionsSize);
            }
            throw new ClassParseException(ClassParseException.TYPE.EXCEPTION);
        }
        Map<Integer, Instruction> pcMap = this.createListOfInstructions();
        ClassModel.LocalVariableTableEntry localVariableTableEntry = this.method.getLocalVariableTableEntry();
        if (localVariableTableEntry == null) {
            localVariableTableEntry = new FakeLocalVariableTableEntry(pcMap, this.method);
            this.method.setLocalVariableTableEntry(localVariableTableEntry);
            logger.warning("Method " + this.method.getName() + this.method.getDescriptor() + " does not contain a LocalVariableTable entry (source not compiled with -g) codegen will attempt to create a synthetic table based on bytecode. This is experimental!!");
        }
        this.buildBranchGraphs(pcMap);
        this.deoptimizeReverseBranches();
        this.foldExpressions();
        if (this.isNoCL() || this.entrypoint != null && _method.getClassModel() != this.entrypoint.getClassModel()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Considering accessor call: " + this.getName());
            }
            this.checkForGetter(pcMap);
            this.checkForSetter(pcMap);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("end \n" + this.expressionList.dumpDiagram(null));
        }
        if (Config.instructionListener != null) {
            Config.instructionListener.showAndTell("end", this.expressionList.getHead(), null);
        }
    }

    public ClassModel.LocalVariableTableEntry<ClassModel.LocalVariableInfo> getLocalVariableTableEntry() {
        return this.method.getLocalVariableTableEntry();
    }

    public ClassModel.ConstantPool getConstantPool() {
        return this.method.getConstantPool();
    }

    public ClassModel.LocalVariableInfo getLocalVariable(int _pc, int _index) {
        return this.method.getLocalVariable(_pc, _index);
    }

    public String getSimpleName() {
        return this.method.getName();
    }

    public String getName() {
        return this.method.getClassModel().getMethod(this.method.getName(), this.method.getDescriptor()).getClassModel().getClassWeAreModelling().getName().replace('.', '_') + "__" + this.method.getName();
    }

    public String getReturnType() {
        String returnType = this.method.getDescriptorUTF8Entry().getUTF8();
        int index = returnType.indexOf(")");
        return returnType.substring(index + 1);
    }

    public List<InstructionSet.MethodCall> getMethodCalls() {
        ArrayList<InstructionSet.MethodCall> methodCalls = new ArrayList<InstructionSet.MethodCall>();
        for (Instruction i = this.getPCHead(); i != null; i = i.getNextPC()) {
            if (!(i instanceof InstructionSet.MethodCall)) continue;
            InstructionSet.MethodCall methodCall = (InstructionSet.MethodCall)((Object)i);
            methodCalls.add(methodCall);
        }
        return methodCalls;
    }

    public Instruction getPCHead() {
        return this.pcHead;
    }

    public Instruction getExprHead() {
        return this.expressionList.getHead();
    }

    public String toString() {
        return "MethodModel of " + this.method;
    }

    public static class FakeLocalVariableTableEntry
    implements ClassModel.LocalVariableTableEntry<ClassModel.LocalVariableInfo> {
        List<ClassModel.LocalVariableInfo> list = new ArrayList<ClassModel.LocalVariableInfo>();

        public FakeLocalVariableTableEntry(Map<Integer, Instruction> _pcMap, ClassModel.ClassModelMethod _method) {
            int i;
            int numberOfSlots = _method.getCodeEntry().getMaxLocals();
            ClassModel.MethodDescription description = ClassModel.getMethodDescription(_method.getDescriptor());
            String[] args = description.getArgs();
            int thisOffset = _method.isStatic() ? 0 : 1;
            Var[] vars = new Var[numberOfSlots + thisOffset];
            InstructionSet.StoreSpec[] argsAsStoreSpecs = new InstructionSet.StoreSpec[args.length + thisOffset];
            if (thisOffset == 1) {
                argsAsStoreSpecs[0] = InstructionSet.StoreSpec.O;
                vars[0] = new Var(argsAsStoreSpecs[0], 0, 0, true);
                this.list.add(vars[0]);
            }
            for (i = 0; i < args.length; ++i) {
                argsAsStoreSpecs[i + thisOffset] = args[i].startsWith("[") ? InstructionSet.StoreSpec.A : InstructionSet.StoreSpec.valueOf(args[i].substring(0, 1));
                vars[i + thisOffset] = new Var(argsAsStoreSpecs[i + thisOffset], i + thisOffset, 0, true);
                this.list.add(vars[i + thisOffset]);
            }
            for (i = args.length + thisOffset; i < numberOfSlots + thisOffset; ++i) {
                vars[i] = new Var();
            }
            int pc = 0;
            Instruction instruction = null;
            for (Map.Entry<Integer, Instruction> entry : _pcMap.entrySet()) {
                Var var;
                int slotIndex;
                Var prevVar;
                pc = entry.getKey();
                instruction = entry.getValue();
                InstructionSet.StoreSpec storeSpec = instruction.getByteCode().getStore();
                if (storeSpec == InstructionSet.StoreSpec.NONE || (prevVar = vars[slotIndex = ((InstructionSet.LocalVariableTableIndexAccessor)((Object)instruction)).getLocalVariableTableIndex()]).equals(var = new Var(storeSpec, slotIndex, pc + instruction.getLength(), false))) continue;
                prevVar.endPc = pc;
                vars[slotIndex] = var;
                this.list.add(vars[slotIndex]);
            }
            for (int i2 = 0; i2 < numberOfSlots + thisOffset; ++i2) {
                vars[i2].endPc = pc + instruction.getLength();
            }
            Collections.sort(this.list, new Comparator<ClassModel.LocalVariableInfo>(){

                @Override
                public int compare(ClassModel.LocalVariableInfo o1, ClassModel.LocalVariableInfo o2) {
                    return o1.getStart() - o2.getStart();
                }
            });
            if (Config.enableShowFakeLocalVariableTable) {
                System.out.println("FakeLocalVariableTable:");
                System.out.println(" Start  Length  Slot    Name   Signature");
                for (ClassModel.LocalVariableInfo lvi : this.list) {
                    Var var = (Var)lvi;
                    System.out.println(String.format(" %5d   %5d  %4d  %8s     %s", var.startPc, var.getLength(), var.slotIndex, var.name, var.descriptor));
                }
            }
        }

        @Override
        public ClassModel.LocalVariableInfo getVariable(int _pc, int _index) {
            ClassModel.LocalVariableInfo returnValue = null;
            for (ClassModel.LocalVariableInfo localVariableInfo : this.list) {
                if (_pc < localVariableInfo.getStart() - 1 || _pc > localVariableInfo.getStart() + localVariableInfo.getLength() || _index != localVariableInfo.getVariableIndex()) continue;
                returnValue = localVariableInfo;
                break;
            }
            return returnValue;
        }

        @Override
        public Iterator<ClassModel.LocalVariableInfo> iterator() {
            return this.list.iterator();
        }

        class Var
        implements ClassModel.LocalVariableInfo {
            int startPc = 0;
            int endPc = 0;
            String name = null;
            boolean arg;
            String descriptor = "";
            int slotIndex;

            Var(InstructionSet.StoreSpec _storeSpec, int _slotIndex, int _startPc, boolean _arg) {
                this.slotIndex = _slotIndex;
                this.arg = _arg;
                this.startPc = _startPc;
                if (_storeSpec.equals((Object)InstructionSet.StoreSpec.A)) {
                    this.name = "arr_" + _slotIndex;
                    this.descriptor = "/* arg */";
                } else {
                    this.name = _storeSpec.toString().toLowerCase() + "_" + _slotIndex;
                    this.descriptor = _storeSpec.toString();
                }
            }

            Var() {
                this.name = "NONE";
            }

            public boolean equals(Object object) {
                return object instanceof Var && (object == this || ((Var)object).name.equals(this.name));
            }

            public String toString() {
                return this.name + "[" + this.startPc + "-" + this.endPc + "]";
            }

            @Override
            public boolean isArray() {
                return this.name.startsWith("arr");
            }

            @Override
            public int getStart() {
                return this.startPc;
            }

            @Override
            public int getEnd() {
                return this.endPc;
            }

            @Override
            public int getLength() {
                return this.endPc - this.startPc;
            }

            @Override
            public String getVariableName() {
                return this.name;
            }

            @Override
            public String getVariableDescriptor() {
                return this.descriptor;
            }

            @Override
            public int getVariableIndex() {
                return this.slotIndex;
            }
        }
    }
}

