/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.kernel;

import com.aparapi.Config;
import com.aparapi.Kernel;
import com.aparapi.ProfileInfo;
import com.aparapi.Range;
import com.aparapi.device.Device;
import com.aparapi.device.JavaDevice;
import com.aparapi.device.OpenCLDevice;
import com.aparapi.exception.AparapiBrokenBarrierException;
import com.aparapi.exception.AparapiKernelFailedException;
import com.aparapi.exception.CompileFailedException;
import com.aparapi.exception.QueryFailedException;
import com.aparapi.internal.annotation.UsedByJNICode;
import com.aparapi.internal.exception.AparapiException;
import com.aparapi.internal.exception.CodeGenException;
import com.aparapi.internal.instruction.InstructionSet;
import com.aparapi.internal.jni.KernelRunnerJNI;
import com.aparapi.internal.kernel.IKernelBarrier;
import com.aparapi.internal.kernel.KernelArg;
import com.aparapi.internal.kernel.KernelDeviceProfile;
import com.aparapi.internal.kernel.KernelManager;
import com.aparapi.internal.kernel.KernelPreferences;
import com.aparapi.internal.kernel.KernelProfile;
import com.aparapi.internal.kernel.ProfilingEvent;
import com.aparapi.internal.model.ClassModel;
import com.aparapi.internal.model.Entrypoint;
import com.aparapi.internal.util.UnsafeWrapper;
import com.aparapi.internal.writer.KernelWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KernelRunner
extends KernelRunnerJNI {
    public static boolean BINARY_CACHING_DISABLED = false;
    private static final int MINIMUM_ARRAY_SIZE = 1;
    @UsedByJNICode
    public static final int PASS_ID_PREPARING_EXECUTION = -2;
    @UsedByJNICode
    public static final int PASS_ID_COMPLETED_EXECUTION = -1;
    @UsedByJNICode
    public static final int CANCEL_STATUS_FALSE = 0;
    @UsedByJNICode
    public static final int CANCEL_STATUS_TRUE = 1;
    private static final String CODE_GEN_ERROR_MARKER = CodeGenException.class.getName();
    private static Logger logger = Logger.getLogger(Config.getLoggerName());
    private long jniContextHandle = 0L;
    private final Kernel kernel;
    private Entrypoint entryPoint;
    private int argc;
    private volatile boolean executing;
    private volatile int passId = -2;
    private final ByteBuffer inBufferRemote;
    private final IntBuffer inBufferRemoteInt;
    private final ByteBuffer outBufferRemote;
    private final IntBuffer outBufferRemoteInt;
    private boolean isFallBack = false;
    private static final ForkJoinPool.ForkJoinWorkerThreadFactory lowPriorityThreadFactory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            ForkJoinWorkerThread newThread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            newThread.setPriority(1);
            return newThread;
        }
    };
    private final ThreadDiedHandler handler = new ThreadDiedHandler();
    private final ForkJoinPool threadPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), lowPriorityThreadFactory, this.handler, false);
    private static HashMap<Class<? extends Kernel>, String> openCLCache = new HashMap();
    private static LinkedHashSet<String> seenBinaryKeys = new LinkedHashSet();
    private final Hashtable<Device, Boolean> kernelIsCompiledForDeviceHash = new Hashtable();
    private final Hashtable<Device, Boolean> kernelNeverExecutedForDeviceHash = new Hashtable();
    private Set<String> capabilitiesSet;
    private KernelArg[] args = null;
    private boolean usesOopConversion = false;
    private final Set<Object> puts = new HashSet<Object>();
    private boolean explicit = false;

    public KernelRunner(Kernel _kernel) {
        this.kernel = _kernel;
        this.inBufferRemote = ByteBuffer.allocateDirect(4);
        this.outBufferRemote = ByteBuffer.allocateDirect(4);
        this.inBufferRemote.order(ByteOrder.nativeOrder());
        this.outBufferRemote.order(ByteOrder.nativeOrder());
        this.inBufferRemoteInt = this.inBufferRemote.asIntBuffer();
        this.outBufferRemoteInt = this.outBufferRemote.asIntBuffer();
        KernelManager.instance();
    }

    public void cleanUpArrays() {
        if (this.args != null && this.kernel.isRunningCL()) {
            for (KernelArg arg : this.args) {
                Field field;
                if ((arg.getType() & 0x80) == 0 || (field = arg.getField()) == null || !field.getType().isArray() || Modifier.isFinal(field.getModifiers())) continue;
                field.setAccessible(true);
                Class<?> componentType = field.getType().getComponentType();
                Object newValue = Array.newInstance(componentType, 1);
                try {
                    field.set(this.kernel, newValue);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            this.kernel.execute(0);
        } else if (this.kernel.isRunningCL()) {
            logger.log(Level.SEVERE, "KernelRunner#cleanUpArrays() could not execute as no args available (Kernel has not been executed?)");
        }
    }

    public synchronized void dispose() {
        if (this.kernel.isRunningCL()) {
            this.disposeJNI(this.jniContextHandle);
            seenBinaryKeys.clear();
        }
    }

    public long getKernelMinimumPrivateMemSizeInUsePerWorkItem(Device device) throws QueryFailedException {
        if (device != null && !(device instanceof OpenCLDevice)) {
            return 0L;
        }
        try {
            this.compile("run", device);
            return this.getKernelMinimumPrivateMemSizeInUsePerWorkItemJNI(this.jniContextHandle);
        }
        catch (CompileFailedException ex) {
            throw new QueryFailedException("Failed to query kernel MinimumPrivateMemSizeInUsePerWorkItem", ex);
        }
    }

    public long getKernelLocalMemSizeInUse(Device device) throws QueryFailedException {
        if (device != null && !(device instanceof OpenCLDevice)) {
            return 0L;
        }
        try {
            this.compile("run", device);
            return this.getKernelLocalMemSizeInUseJNI(this.jniContextHandle);
        }
        catch (CompileFailedException ex) {
            throw new QueryFailedException("Failed to query kernel LocalMemSizeInUse", ex);
        }
    }

    public int getKernelPreferredWorkGroupSizeMultiple(Device device) throws QueryFailedException {
        if (device != null && !(device instanceof OpenCLDevice)) {
            return 1;
        }
        try {
            this.compile("run", device);
            return this.getKernelPreferredWorkGroupSizeMultipleJNI(this.jniContextHandle);
        }
        catch (CompileFailedException ex) {
            throw new QueryFailedException("Failed to query kernel PreferredWorkGroupSizeMultiple", ex);
        }
    }

    public int getKernelMaxWorkGroupSize(Device device) throws QueryFailedException {
        if (device != null && !(device instanceof OpenCLDevice)) {
            return device.getMaxWorkGroupSize();
        }
        try {
            this.compile("run", device);
            return this.getKernelMaxWorkGroupSizeJNI(this.jniContextHandle);
        }
        catch (CompileFailedException ex) {
            throw new QueryFailedException("Failed to query kernel MaxWorkGroupSize", ex);
        }
    }

    public int[] getKernelCompileWorkGroupSize(Device device) throws QueryFailedException {
        int[] unknownCompileWorkGroupSize = new int[]{0, 0, 0};
        if (device != null && !(device instanceof OpenCLDevice)) {
            return unknownCompileWorkGroupSize;
        }
        try {
            this.compile("run", device);
            return this.getKernelCompileWorkGroupSizeJNI(this.jniContextHandle);
        }
        catch (CompileFailedException ex) {
            throw new QueryFailedException("Failed to query kernel CompileWorkGroupSize", ex);
        }
    }

    boolean hasFP64Support() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_fp64");
    }

    boolean hasSelectFPRoundingModeSupport() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_select_fprounding_mode");
    }

    boolean hasGlobalInt32BaseAtomicsSupport() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_global_int32_base_atomics");
    }

    boolean hasGlobalInt32ExtendedAtomicsSupport() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_global_int32_extended_atomics");
    }

    boolean hasLocalInt32BaseAtomicsSupport() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_local_int32_base_atomics");
    }

    boolean hasLocalInt32ExtendedAtomicsSupport() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_local_int32_extended_atomics");
    }

    boolean hasInt64BaseAtomicsSupport() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_int64_base_atomics");
    }

    boolean hasInt64ExtendedAtomicsSupport() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_int64_extended_atomics");
    }

    boolean has3DImageWritesSupport() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_3d_image_writes");
    }

    boolean hasByteAddressableStoreSupport() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_byte_addressable_store");
    }

    boolean hasFP16Support() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_fp16");
    }

    boolean hasGLSharingSupport() {
        if (this.capabilitiesSet == null) {
            throw new IllegalStateException("Capabilities queried before they were initialized");
        }
        return this.capabilitiesSet.contains("cl_khr_gl_sharing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeJava(ExecutionSettings _settings, Device device) {
        block35: {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("executeJava: range = " + _settings.range + ", device = " + device);
            }
            boolean legacySequentialMode = this.kernel.getExecutionMode().equals((Object)Kernel.EXECUTION_MODE.SEQ);
            this.passId = -2;
            _settings.profile.onEvent(device, ProfilingEvent.PREPARE_EXECUTE);
            try {
                ThreadIdSetter threadIdSetter;
                if (device == JavaDevice.ALTERNATIVE_ALGORITHM) {
                    if (this.kernel.hasFallbackAlgorithm()) {
                        this.passId = 0;
                        while (this.passId < _settings.passes) {
                            this.kernel.executeFallbackAlgorithm(_settings.range, this.passId);
                            ++this.passId;
                        }
                    } else {
                        boolean silently = true;
                        this.fallBackToNextDevice(device, _settings, null, silently);
                    }
                    break block35;
                }
                final int localSize0 = _settings.range.getLocalSize(0);
                final int localSize1 = _settings.range.getLocalSize(1);
                final int localSize2 = _settings.range.getLocalSize(2);
                final int globalSize1 = _settings.range.getGlobalSize(1);
                if (legacySequentialMode || device == JavaDevice.SEQUENTIAL) {
                    if (localSize0 * localSize1 * localSize2 > 1) {
                        throw new IllegalStateException("Can't run range with group size >1 sequentially. Barriers would deadlock!");
                    }
                    Kernel kernelClone = this.kernel.clone();
                    Kernel.KernelState kernelState = kernelClone.getKernelState();
                    kernelState.setRange(_settings.range);
                    kernelState.setGroupId(0, 0);
                    kernelState.setGroupId(1, 0);
                    kernelState.setGroupId(2, 0);
                    kernelState.setLocalId(0, 0);
                    kernelState.setLocalId(1, 0);
                    kernelState.setLocalId(2, 0);
                    kernelState.setLocalBarrier(new FJSafeBarrier(1));
                    this.passId = 0;
                    while (this.passId < _settings.passes && this.getCancelState() != 1) {
                        int y;
                        int x;
                        kernelState.setPassId(this.passId);
                        if (_settings.range.getDims() == 1) {
                            for (int id = 0; id < _settings.range.getGlobalSize(0); ++id) {
                                kernelState.setGlobalId(0, id);
                                kernelClone.run();
                            }
                        } else if (_settings.range.getDims() == 2) {
                            for (x = 0; x < _settings.range.getGlobalSize(0); ++x) {
                                kernelState.setGlobalId(0, x);
                                for (y = 0; y < globalSize1; ++y) {
                                    kernelState.setGlobalId(1, y);
                                    kernelClone.run();
                                }
                            }
                        } else if (_settings.range.getDims() == 3) {
                            for (x = 0; x < _settings.range.getGlobalSize(0); ++x) {
                                kernelState.setGlobalId(0, x);
                                for (y = 0; y < globalSize1; ++y) {
                                    kernelState.setGlobalId(1, y);
                                    for (int z = 0; z < _settings.range.getGlobalSize(2); ++z) {
                                        kernelState.setGlobalId(2, z);
                                        kernelClone.run();
                                    }
                                    kernelClone.run();
                                }
                            }
                        }
                        ++this.passId;
                    }
                    this.passId = -1;
                    break block35;
                }
                if (device != JavaDevice.THREAD_POOL && this.kernel.getExecutionMode() != Kernel.EXECUTION_MODE.JTP) {
                    throw new AssertionError((Object)"unexpected JavaDevice or EXECUTION_MODE");
                }
                final int threads = localSize0 * localSize1 * localSize2;
                final int numGroups0 = _settings.range.getNumGroups(0);
                final int numGroups1 = _settings.range.getNumGroups(1);
                final int globalGroups = numGroups0 * numGroups1 * _settings.range.getNumGroups(2);
                final FJSafeBarrier localBarrier = new FJSafeBarrier(threads);
                if (_settings.range.getDims() == 1) {
                    threadIdSetter = new ThreadIdSetter(){

                        @Override
                        public void set(Kernel.KernelState kernelState, int globalGroupId, int threadId) {
                            kernelState.setLocalId(0, threadId % localSize0);
                            kernelState.setGlobalId(0, threadId + globalGroupId * threads);
                            kernelState.setGroupId(0, globalGroupId);
                        }
                    };
                } else if (_settings.range.getDims() == 2) {
                    threadIdSetter = new ThreadIdSetter(){

                        @Override
                        public void set(Kernel.KernelState kernelState, int globalGroupId, int threadId) {
                            int localId0 = threadId % localSize0;
                            int localId1 = threadId / localSize0;
                            kernelState.setLocalId(0, localId0);
                            kernelState.setLocalId(1, localId1);
                            int globalThreadIdOffsetX = globalGroupId % numGroups0 * localSize0;
                            kernelState.setGlobalId(0, globalThreadIdOffsetX + localId0);
                            int globalThreadIdOffsetY = globalGroupId / numGroups0 * localSize1;
                            kernelState.setGlobalId(1, globalThreadIdOffsetY + localId1);
                            kernelState.setGroupId(0, globalGroupId % numGroups0);
                            kernelState.setGroupId(1, globalGroupId / numGroups0);
                        }
                    };
                } else if (_settings.range.getDims() == 3) {
                    threadIdSetter = new ThreadIdSetter(){

                        @Override
                        public void set(Kernel.KernelState kernelState, int globalGroupId, int threadId) {
                            kernelState.setLocalId(0, threadId % localSize0);
                            kernelState.setLocalId(1, threadId / localSize0 % localSize1);
                            kernelState.setLocalId(2, threadId / (localSize0 * localSize1));
                            kernelState.setGlobalId(0, globalGroupId % numGroups0 * localSize0 + kernelState.getLocalIds()[0]);
                            kernelState.setGlobalId(1, globalGroupId / numGroups0 * localSize1 % globalSize1 + kernelState.getLocalIds()[1]);
                            kernelState.setGlobalId(2, globalGroupId / (numGroups0 * numGroups1) * localSize2 + kernelState.getLocalIds()[2]);
                            kernelState.setGroupId(0, globalGroupId % numGroups0);
                            kernelState.setGroupId(1, globalGroupId / numGroups0 % numGroups1);
                            kernelState.setGroupId(2, globalGroupId / (numGroups0 * numGroups1));
                        }
                    };
                } else {
                    throw new IllegalArgumentException("Expected 1,2 or 3 dimensions, found " + _settings.range.getDims());
                }
                ForkJoinTask[] tasks = new ForkJoinTask[threads];
                this.passId = 0;
                while (this.passId < _settings.passes && this.getCancelState() != 1) {
                    long deadThreadCount = this.handler.threadsDiedCounter.get();
                    for (int id = 0; id < threads; ++id) {
                        final int threadId = id;
                        final Kernel kernelClone = this.kernel.clone();
                        final Kernel.KernelState kernelState = kernelClone.getKernelState();
                        kernelState.setRange(_settings.range);
                        kernelState.setPassId(this.passId);
                        if (threads == 1) {
                            kernelState.disableLocalBarrier();
                        } else {
                            kernelState.setLocalBarrier(localBarrier);
                        }
                        Future fjt = this.threadPool.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    for (int globalGroupId = 0; globalGroupId < globalGroups; ++globalGroupId) {
                                        threadIdSetter.set(kernelState, globalGroupId, threadId);
                                        kernelClone.run();
                                    }
                                }
                                catch (AparapiBrokenBarrierException globalGroupId) {
                                }
                                catch (Error | RuntimeException e) {
                                    localBarrier.breakBarrier(e);
                                    throw new AparapiKernelFailedException(kernelState.describe(), e);
                                }
                            }
                        });
                        tasks[id] = fjt;
                    }
                    for (ForkJoinTask task : tasks) {
                        task.join();
                    }
                    long deathCount = this.handler.threadsDiedCounter.get() - deadThreadCount;
                    if (deathCount > 0L) {
                        logger.log(Level.SEVERE, "(" + deathCount + ") Pool threads died during execution of kernel: " + this.kernel.getClass().getName() + " at pass: " + this.passId);
                    }
                    ++this.passId;
                }
                this.passId = -1;
            }
            finally {
                this.passId = -1;
            }
        }
    }

    private ClassModel getClassModelFromArg(KernelArg arg, Class<?> arrayClass) {
        ClassModel c = null;
        if (arg.getObjArrayElementModel() == null) {
            String tmp = arrayClass.getName().substring(2).replace('/', '.');
            String arrayClassInDotForm = tmp.substring(0, tmp.length() - 1);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("looking for type = " + arrayClassInDotForm);
            }
            c = this.entryPoint.getObjectArrayFieldsClasses().get(arrayClassInDotForm);
            arg.setObjArrayElementModel(c);
        } else {
            c = arg.getObjArrayElementModel();
        }
        assert (c != null) : "should find class for elements " + arrayClass.getName();
        return c;
    }

    public boolean allocateArrayBufferIfFirstTimeOrArrayChanged(KernelArg arg, Object newRef, int objArraySize, int totalStructSize, int totalBufferSize) {
        boolean didReallocate = false;
        if (arg.getObjArrayBuffer() == null || newRef != arg.getArray()) {
            ByteBuffer structBuffer = ByteBuffer.allocate(totalBufferSize);
            arg.setObjArrayByteBuffer(structBuffer.order(ByteOrder.LITTLE_ENDIAN));
            arg.setObjArrayBuffer(arg.getObjArrayByteBuffer().array());
            didReallocate = true;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("objArraySize = " + objArraySize + " totalStructSize= " + totalStructSize + " totalBufferSize=" + totalBufferSize);
            }
        } else {
            arg.getObjArrayByteBuffer().clear();
        }
        return didReallocate;
    }

    /*
     * Could not resolve type clashes
     */
    private boolean prepareOopConversionBuffer(KernelArg arg) throws AparapiException {
        this.usesOopConversion = true;
        Class<?> arrayClass = arg.getField().getType();
        ClassModel c = this.getClassModelFromArg(arg, arrayClass);
        int arrayBaseOffset = UnsafeWrapper.arrayBaseOffset(arrayClass);
        int arrayScale = UnsafeWrapper.arrayIndexScale(arrayClass);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Syncing obj array type = " + arrayClass + " cvtd= " + c.getClassWeAreModelling().getName() + "arrayBaseOffset=" + arrayBaseOffset + " arrayScale=" + arrayScale);
        }
        int objArraySize = 0;
        Object newRef = null;
        try {
            newRef = arg.getField().get(this.kernel);
            objArraySize = Array.getLength(newRef);
        }
        catch (IllegalAccessException e) {
            throw new AparapiException(e);
        }
        assert (newRef != null && objArraySize != 0) : "no data";
        int totalStructSize = c.getTotalStructSize();
        int totalBufferSize = objArraySize * totalStructSize;
        boolean didReallocate = this.allocateArrayBufferIfFirstTimeOrArrayChanged(arg, newRef, objArraySize, totalStructSize, totalBufferSize);
        arg.setJavaArray(arg.getObjArrayBuffer());
        arg.setNumElements(objArraySize);
        arg.setSizeInBytes(totalBufferSize);
        for (int j = 0; j < objArraySize; ++j) {
            int sizeWritten = 0;
            Object object = UnsafeWrapper.getObject(newRef, arrayBaseOffset + arrayScale * j);
            block11: for (int i = 0; i < c.getStructMemberTypes().size(); ++i) {
                InstructionSet.TypeSpec t = c.getStructMemberTypes().get(i);
                long offset = c.getStructMemberOffsets().get(i);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("name = " + c.getStructMembers().get(i).getNameAndTypeEntry().getNameUTF8Entry().getUTF8() + " t= " + (Object)((Object)t));
                }
                switch (t) {
                    case I: {
                        byte x = UnsafeWrapper.getInt(object, offset);
                        arg.getObjArrayByteBuffer().putInt(x);
                        sizeWritten += t.getSize();
                        continue block11;
                    }
                    case F: {
                        float x = UnsafeWrapper.getFloat(object, offset);
                        arg.getObjArrayByteBuffer().putFloat(x);
                        sizeWritten += t.getSize();
                        continue block11;
                    }
                    case J: {
                        long x = UnsafeWrapper.getLong(object, offset);
                        arg.getObjArrayByteBuffer().putLong(x);
                        sizeWritten += t.getSize();
                        continue block11;
                    }
                    case Z: {
                        byte x = (byte)(UnsafeWrapper.getBoolean(object, offset) ? 1 : 0);
                        arg.getObjArrayByteBuffer().put(x == 1 ? (byte)1 : 0);
                        sizeWritten += InstructionSet.TypeSpec.B.getSize();
                        continue block11;
                    }
                    case B: {
                        byte x = UnsafeWrapper.getByte(object, offset);
                        arg.getObjArrayByteBuffer().put(x);
                        sizeWritten += t.getSize();
                        continue block11;
                    }
                    case D: {
                        throw new AparapiException("Double not implemented yet");
                    }
                    default: {
                        assert (false) : "typespec did not match anything";
                        throw new AparapiException("Unhandled type in buffer conversion");
                    }
                }
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("sizeWritten = " + sizeWritten + " totalStructSize= " + totalStructSize);
            }
            assert (sizeWritten <= totalStructSize) : "wrote too much into buffer";
            while (sizeWritten < totalStructSize) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(arg.getName() + " struct pad byte = " + sizeWritten + " totalStructSize= " + totalStructSize);
                }
                arg.getObjArrayByteBuffer().put((byte)-1);
                ++sizeWritten;
            }
        }
        assert (arg.getObjArrayByteBuffer().arrayOffset() == 0) : "should be zero";
        return didReallocate;
    }

    /*
     * Could not resolve type clashes
     */
    private void extractOopConversionBuffer(KernelArg arg) throws AparapiException {
        Class<?> arrayClass = arg.getField().getType();
        ClassModel c = arg.getObjArrayElementModel();
        assert (c != null) : "should find class for elements: " + arrayClass.getName();
        assert (arg.getArray() != null) : "array is null";
        int arrayBaseOffset = UnsafeWrapper.arrayBaseOffset(arrayClass);
        int arrayScale = UnsafeWrapper.arrayIndexScale(arrayClass);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Syncing field:" + arg.getName() + ", bb=" + arg.getObjArrayByteBuffer() + ", type = " + arrayClass);
        }
        int objArraySize = 0;
        try {
            objArraySize = Array.getLength(arg.getField().get(this.kernel));
        }
        catch (IllegalAccessException e) {
            throw new AparapiException(e);
        }
        assert (objArraySize > 0) : "should be > 0";
        int totalStructSize = c.getTotalStructSize();
        arg.getObjArrayByteBuffer().rewind();
        for (int j = 0; j < objArraySize; ++j) {
            int sizeWritten = 0;
            Object object = UnsafeWrapper.getObject(arg.getArray(), arrayBaseOffset + arrayScale * j);
            block11: for (int i = 0; i < c.getStructMemberTypes().size(); ++i) {
                InstructionSet.TypeSpec t = c.getStructMemberTypes().get(i);
                long offset = c.getStructMemberOffsets().get(i);
                switch (t) {
                    case I: {
                        byte x = arg.getObjArrayByteBuffer().getInt();
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("fType = " + t.getShortName() + " x= " + x);
                        }
                        UnsafeWrapper.putInt(object, offset, x);
                        sizeWritten += t.getSize();
                        continue block11;
                    }
                    case F: {
                        float x = arg.getObjArrayByteBuffer().getFloat();
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("fType = " + t.getShortName() + " x= " + x);
                        }
                        UnsafeWrapper.putFloat(object, offset, x);
                        sizeWritten += t.getSize();
                        continue block11;
                    }
                    case J: {
                        long x = arg.getObjArrayByteBuffer().getLong();
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("fType = " + t.getShortName() + " x= " + x);
                        }
                        UnsafeWrapper.putLong(object, offset, x);
                        sizeWritten += t.getSize();
                        continue block11;
                    }
                    case Z: {
                        byte x = arg.getObjArrayByteBuffer().get();
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("fType = " + t.getShortName() + " x= " + x);
                        }
                        UnsafeWrapper.putBoolean(object, offset, x == 1);
                        sizeWritten += InstructionSet.TypeSpec.B.getSize();
                        continue block11;
                    }
                    case B: {
                        byte x = arg.getObjArrayByteBuffer().get();
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("fType = " + t.getShortName() + " x= " + x);
                        }
                        UnsafeWrapper.putByte(object, offset, x);
                        sizeWritten += t.getSize();
                        continue block11;
                    }
                    case D: {
                        throw new AparapiException("Double not implemented yet");
                    }
                    default: {
                        assert (false) : "typespec did not match anything";
                        throw new AparapiException("Unhandled type in buffer conversion");
                    }
                }
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("sizeWritten = " + sizeWritten + " totalStructSize= " + totalStructSize);
            }
            assert (sizeWritten <= totalStructSize) : "wrote too much into buffer";
            while (sizeWritten < totalStructSize) {
                arg.getObjArrayByteBuffer().get();
                ++sizeWritten;
            }
        }
    }

    private void restoreObjects() throws AparapiException {
        for (int i = 0; i < this.argc; ++i) {
            KernelArg arg = this.args[i];
            if (arg.getField().getType() == AtomicInteger[].class) {
                this.extractAtomicIntegerConversionBuffer(arg);
                continue;
            }
            if ((arg.getType() & 0x40000) == 0) continue;
            this.extractOopConversionBuffer(arg);
        }
    }

    private boolean prepareAtomicIntegerConversionBuffer(KernelArg arg) throws AparapiException {
        this.usesOopConversion = true;
        Class<?> arrayClass = arg.getField().getType();
        ClassModel c = this.getClassModelFromArg(arg, arrayClass);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Syncing obj array type = " + arrayClass + " cvtd= " + c.getClassWeAreModelling().getName());
        }
        int objArraySize = 0;
        Object newRef = null;
        try {
            newRef = arg.getField().get(this.kernel);
            objArraySize = Array.getLength(newRef);
        }
        catch (IllegalAccessException e) {
            throw new AparapiException(e);
        }
        assert (newRef != null && objArraySize != 0) : "no data";
        int totalStructSize = 4;
        int totalBufferSize = objArraySize * 4;
        boolean didReallocate = this.allocateArrayBufferIfFirstTimeOrArrayChanged(arg, newRef, objArraySize, 4, totalBufferSize);
        AtomicInteger[] atomic = (AtomicInteger[])newRef;
        arg.setJavaArray(arg.getObjArrayBuffer());
        arg.setNumElements(objArraySize);
        arg.setSizeInBytes(totalBufferSize);
        int sizeWritten = 0;
        for (int j = 0; j < objArraySize; ++j) {
            arg.getObjArrayByteBuffer().putInt(atomic[j].get());
            sizeWritten += 4;
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest("sizeWritten = " + sizeWritten + " totalStructSize= " + 4);
        }
        assert (sizeWritten <= totalBufferSize) : "wrote too much into buffer";
        while (sizeWritten < totalBufferSize) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(arg.getName() + " struct pad byte = " + sizeWritten + " totalStructSize= " + 4);
            }
            arg.getObjArrayByteBuffer().put((byte)-1);
            ++sizeWritten;
        }
        assert (arg.getObjArrayByteBuffer().arrayOffset() == 0) : "should be zero";
        return didReallocate;
    }

    private void extractAtomicIntegerConversionBuffer(KernelArg arg) throws AparapiException {
        Class<?> arrayClass = arg.getField().getType();
        ClassModel c = arg.getObjArrayElementModel();
        assert (c != null) : "should find class for elements: " + arrayClass.getName();
        assert (arg.getArray() != null) : "array is null";
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Syncing field:" + arg.getName() + ", bb=" + arg.getObjArrayByteBuffer() + ", type = " + arrayClass);
        }
        int objArraySize = 0;
        try {
            objArraySize = Array.getLength(arg.getField().get(this.kernel));
        }
        catch (IllegalAccessException e) {
            throw new AparapiException(e);
        }
        assert (objArraySize > 0) : "should be > 0";
        int totalStructSize = 4;
        int totalBufferSize = objArraySize * 4;
        arg.getObjArrayByteBuffer().rewind();
        AtomicInteger[] atomics = (AtomicInteger[])arg.getArray();
        int sizeWritten = 0;
        for (int j = 0; j < objArraySize; ++j) {
            int x = arg.getObjArrayByteBuffer().getInt();
            atomics[j].set(x);
            sizeWritten += 4;
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest("sizeWritten = " + sizeWritten + " totalStructSize= " + 4);
        }
        assert (sizeWritten <= totalBufferSize) : "wrote too much into buffer";
        while (sizeWritten < totalBufferSize) {
            arg.getObjArrayByteBuffer().get();
            ++sizeWritten;
        }
    }

    private boolean updateKernelArrayRefs() throws AparapiException {
        boolean needsSync = false;
        for (int i = 0; i < this.argc; ++i) {
            KernelArg arg = this.args[i];
            try {
                if ((arg.getType() & 0x80) != 0) {
                    Object newArrayRef = arg.getField().get(this.kernel);
                    if (newArrayRef == null) {
                        throw new IllegalStateException("Cannot send null refs to kernel, reverting to java");
                    }
                    String fieldName = arg.getField().getName();
                    int arrayLength = Array.getLength(newArrayRef);
                    Integer privateMemorySize = ClassModel.getPrivateMemorySizeFromField(arg.getField());
                    if (privateMemorySize == null) {
                        privateMemorySize = ClassModel.getPrivateMemorySizeFromFieldName(fieldName);
                    }
                    if (privateMemorySize != null && arrayLength > privateMemorySize) {
                        throw new IllegalStateException("__private array field " + fieldName + " has illegal length " + arrayLength + " > " + privateMemorySize);
                    }
                    if (arg.getField().getType() == AtomicInteger[].class) {
                        this.prepareAtomicIntegerConversionBuffer(arg);
                    } else if ((arg.getType() & 0x40000) != 0) {
                        this.prepareOopConversionBuffer(arg);
                    } else {
                        arg.setJavaArray(newArrayRef);
                        arg.setNumElements(arrayLength);
                        arg.setSizeInBytes(arg.getNumElements() * arg.getPrimitiveSize());
                        if ((this.args[i].getType() & 0x10000) != 0 && this.puts.contains(newArrayRef)) {
                            this.args[i].setType(this.args[i].getType() | 0x20000);
                            this.puts.remove(newArrayRef);
                        }
                    }
                    if (newArrayRef != arg.getArray()) {
                        needsSync = true;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("saw newArrayRef for " + arg.getName() + " = " + newArrayRef + ", newArrayLen = " + Array.getLength(newArrayRef));
                        }
                    }
                    arg.setArray(newArrayRef);
                    assert (arg.getArray() != null) : "null array ref";
                    continue;
                }
                if ((arg.getType() & 0x8000) == 0) continue;
                needsSync = true;
                Object buffer = new Object();
                try {
                    buffer = arg.getField().get(this.kernel);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                int numDims = arg.getNumDims();
                Object subBuffer = buffer;
                int[] dims = new int[numDims];
                for (int d = 0; d < numDims - 1; ++d) {
                    dims[d] = Array.getLength(subBuffer);
                    subBuffer = Array.get(subBuffer, 0);
                }
                dims[numDims - 1] = Array.getLength(subBuffer);
                arg.setDims(dims);
                int primitiveSize = this.getPrimitiveSize(arg.getType());
                int totalElements = 1;
                for (int d = 0; d < numDims; ++d) {
                    totalElements *= dims[d];
                }
                arg.setJavaBuffer(buffer);
                arg.setSizeInBytes(totalElements * primitiveSize);
                arg.setArray(buffer);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return needsSync;
    }

    private Kernel executeOpenCL(Device device, ExecutionSettings _settings) throws AparapiException {
        int returnValue;
        assert (this.args != null) : "args should not be null";
        boolean needSync = this.updateKernelArrayRefs();
        if (needSync && logger.isLoggable(Level.FINE)) {
            logger.fine("Need to resync arrays on " + this.kernel);
        }
        if ((returnValue = this.runKernelJNI(this.jniContextHandle, _settings.range, needSync, _settings.passes, this.inBufferRemote, this.outBufferRemote)) != 0) {
            String reason = "OpenCL execution seems to have failed (runKernelJNI returned " + returnValue + ")";
            return this.fallBackToNextDevice(device, _settings, new AparapiException(reason));
        }
        if (this.usesOopConversion) {
            this.restoreObjects();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("executeOpenCL completed. " + _settings.range);
        }
        return this.kernel;
    }

    private synchronized Kernel fallBackByExecutionMode(ExecutionSettings _settings) {
        this.isFallBack = true;
        if (this.kernel.hasNextExecutionMode()) {
            this.kernel.tryNextExecutionMode();
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Trying next execution mode " + (Object)((Object)this.kernel.getExecutionMode()));
            }
        } else {
            this.kernel.setFallbackExecutionMode();
        }
        this.recreateRange(_settings);
        try {
            return this.executeInternalInner(_settings, null, false);
        }
        catch (CompileFailedException e) {
            logger.log(Level.SEVERE, "KernelRunner#fallBackByExecutionMode() this should never happen...", e);
            throw new IllegalStateException("This should never happen, since compileOnly is set to false", e);
        }
    }

    private void recreateRange(ExecutionSettings _settings) {
        if (_settings.range.isLocalIsDerived() && !_settings.legacyExecutionMode) {
            Range result;
            Device device = this.kernel.getTargetDevice();
            switch (_settings.range.getDims()) {
                case 1: {
                    result = Range.create(device, _settings.range.getGlobalSize_0());
                    break;
                }
                case 2: {
                    result = Range.create2D(device, _settings.range.getGlobalSize_0(), _settings.range.getGlobalSize_1());
                    break;
                }
                case 3: {
                    result = Range.create3D(device, _settings.range.getGlobalSize_0(), _settings.range.getGlobalSize_1(), _settings.range.getGlobalSize_2());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Range.getDims() = " + _settings.range.getDims()));
                }
            }
            _settings.range = result;
        }
    }

    private Kernel fallBackToNextDevice(Device device, ExecutionSettings _settings, String _reason) {
        return this.fallBackToNextDevice(device, _settings, new AparapiException(_reason));
    }

    private synchronized Kernel fallBackToNextDevice(Device device, ExecutionSettings _settings, Exception _exception) {
        return this.fallBackToNextDevice(device, _settings, _exception, false);
    }

    private synchronized Kernel fallBackToNextDevice(Device device, ExecutionSettings _settings, Exception _exception, boolean _silently) {
        this.isFallBack = true;
        _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
        if (_settings.legacyExecutionMode) {
            if (!_silently && logger.isLoggable(Level.WARNING)) {
                logger.warning("Execution mode " + (Object)((Object)this.kernel.getExecutionMode()) + " failed for " + this.kernel + ": " + _exception.getMessage());
                _exception.printStackTrace();
            }
            return this.fallBackByExecutionMode(_settings);
        }
        KernelPreferences preferences = KernelManager.instance().getPreferences(this.kernel);
        if (!_silently && logger.isLoggable(Level.WARNING)) {
            logger.warning("Device failed for " + this.kernel + ": " + _exception.getMessage());
        }
        preferences.markDeviceFailed(device);
        if (!_silently && logger.isLoggable(Level.WARNING)) {
            _exception.printStackTrace();
            logger.warning("Trying next device: " + this.describeDevice());
        }
        this.recreateRange(_settings);
        try {
            return this.executeInternalInner(_settings, null, false);
        }
        catch (CompileFailedException e) {
            logger.log(Level.SEVERE, "KernelRunner#fallBackToNextDevice() this should never happen, since compileOnly is set to false...", e);
            throw new IllegalStateException("This should never happen, since compileOnly is set to false", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Kernel execute(String _entrypoint, Range _range, int _passes) {
        this.executing = true;
        try {
            this.clearCancelMultiPass();
            KernelProfile profile = KernelManager.instance().getProfile(this.kernel.getClass());
            KernelPreferences preferences = KernelManager.instance().getPreferences(this.kernel);
            boolean legacyExecutionMode = this.kernel.getExecutionMode() != Kernel.EXECUTION_MODE.AUTO;
            ExecutionSettings settings = new ExecutionSettings(preferences, profile, _entrypoint, _range, _passes, legacyExecutionMode);
            Kernel kernel = this.executeInternalOuter(settings);
            return kernel;
        }
        finally {
            this.executing = false;
            this.clearCancelMultiPass();
        }
    }

    public synchronized Kernel compile(String _entrypoint, Device device) throws CompileFailedException {
        KernelProfile profile = KernelManager.instance().getProfile(this.kernel.getClass());
        KernelPreferences preferences = KernelManager.instance().getPreferences(this.kernel);
        Range range = new Range(device, 1);
        ExecutionSettings settings = new ExecutionSettings(preferences, profile, _entrypoint, range, 1, false);
        return this.executeInternalInner(settings, device, true);
    }

    private synchronized Kernel executeInternalOuter(ExecutionSettings _settings) {
        try {
            Kernel kernel = this.executeInternalInner(_settings, null, false);
            return kernel;
        }
        catch (CompileFailedException e) {
            logger.log(Level.SEVERE, "KernelRunner#executeInternalOuter() this should never happen, since compileOnly is set to false...", e);
            throw new IllegalStateException("This should never happen, since compileOnly is set to false", e);
        }
        finally {
            if (this.kernel.isAutoCleanUpArrays() && _settings.range.getGlobalSize_0() != 0) {
                this.cleanUpArrays();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized Kernel executeInternalInner(ExecutionSettings _settings, Device aparapiDevice, boolean compileOnly) throws CompileFailedException {
        block108: {
            block109: {
                block107: {
                    block106: {
                        block105: {
                            block104: {
                                block103: {
                                    block102: {
                                        block115: {
                                            block114: {
                                                block112: {
                                                    block113: {
                                                        if (_settings.range == null) {
                                                            throw new IllegalStateException("range can't be null");
                                                        }
                                                        requestedExecutionMode = this.kernel.getExecutionMode();
                                                        if (!compileOnly && requestedExecutionMode.isOpenCL() && _settings.range.getDevice() != null && !(_settings.range.getDevice() instanceof OpenCLDevice)) {
                                                            this.fallBackToNextDevice(_settings.range.getDevice(), _settings, "OpenCL EXECUTION_MODE was requested but Device supplied was not an OpenCLDevice");
                                                        }
                                                        if (compileOnly) {
                                                            if (aparapiDevice == null) {
                                                                throw new CompileFailedException("A kernel can only be compiled for a specific device, but no concrete device was specified");
                                                            }
                                                            if (this.kernelIsCompiledForDeviceHash.getOrDefault(aparapiDevice, false).booleanValue()) {
                                                                return this.kernel;
                                                            }
                                                            if (!(aparapiDevice instanceof OpenCLDevice)) {
                                                                this.kernelIsCompiledForDeviceHash.putIfAbsent(aparapiDevice, true);
                                                                return this.kernel;
                                                            }
                                                        }
                                                        device = _settings.range.getDevice();
                                                        userSpecifiedDevice = true;
                                                        if (device != null) break block112;
                                                        userSpecifiedDevice = false;
                                                        if (_settings.legacyExecutionMode) break block113;
                                                        device = _settings.preferences.getPreferredDevice(this.kernel);
                                                        if (device == null) {
                                                            device = JavaDevice.THREAD_POOL;
                                                        }
                                                        break block114;
                                                    }
                                                    if (requestedExecutionMode == Kernel.EXECUTION_MODE.JTP) {
                                                        device = JavaDevice.THREAD_POOL;
                                                        break block114;
                                                    } else if (requestedExecutionMode == Kernel.EXECUTION_MODE.SEQ) {
                                                        device = JavaDevice.SEQUENTIAL;
                                                    }
                                                    break block114;
                                                }
                                                compatible = this.isDeviceCompatible(device);
                                                if (!compatible) {
                                                    throw new AssertionError((Object)("user supplied Device incompatible with current EXECUTION_MODE or getTargetDevice(); device = " + device.getShortDescription() + "; kernel = " + this.kernel));
                                                }
                                            }
                                            openCLDevice = device instanceof OpenCLDevice != false ? (OpenCLDevice)device : null;
                                            jniFlags = 0;
                                            if (compileOnly || !_settings.legacyExecutionMode || userSpecifiedDevice || !requestedExecutionMode.isOpenCL()) break block102;
                                            if (!requestedExecutionMode.equals((Object)Kernel.EXECUTION_MODE.GPU)) break block115;
                                            openCLDevice = (OpenCLDevice)KernelManager.DeprecatedMethods.bestGPU();
                                            jniFlags |= 4;
                                            if (openCLDevice == null) {
                                                var9_10 = this.fallBackToNextDevice(null, _settings, "GPU request can't be honored, no GPU device");
                                                _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
                                                this.maybeReportProfile(_settings);
                                                return var9_10;
                                            }
                                            ** GOTO lbl74
                                        }
                                        if (requestedExecutionMode.equals((Object)Kernel.EXECUTION_MODE.ACC)) {
                                            openCLDevice = (OpenCLDevice)KernelManager.DeprecatedMethods.bestACC();
                                            jniFlags |= 32;
                                            if (openCLDevice == null) {
                                                var9_11 = this.fallBackToNextDevice(null, _settings, "ACC request can't be honored, no ACC device");
                                                _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
                                                this.maybeReportProfile(_settings);
                                                return var9_11;
                                            }
                                        } else {
                                            openCLDevice = (OpenCLDevice)KernelManager.DeprecatedMethods.firstDevice(Device.TYPE.CPU);
                                            if (openCLDevice == null) {
                                                var9_12 = this.fallBackToNextDevice(null, _settings, "CPU request can't be honored, no CPU device");
                                                _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
                                                this.maybeReportProfile(_settings);
                                                return var9_12;
                                            }
                                        }
                                        ** GOTO lbl74
                                    }
                                    if (device.getType() == Device.TYPE.GPU) {
                                        jniFlags |= 4;
                                    } else if (device.getType() == Device.TYPE.ACC) {
                                        jniFlags |= 32;
                                    }
lbl74:
                                    // 7 sources

                                    if (device == null && openCLDevice != null) {
                                        device = openCLDevice;
                                    }
                                    if (!KernelRunner.$assertionsDisabled && device == null) {
                                        throw new AssertionError((Object)"No device available");
                                    }
                                    _settings.profile.onStart(device);
                                    v0 = isOpenCl = requestedExecutionMode.isOpenCL() != false || device instanceof OpenCLDevice != false;
                                    if (!isOpenCl) ** GOTO lbl231
                                    if (!this.kernelNeverExecutedForDeviceHash.getOrDefault(device, true).booleanValue() && this.entryPoint != null && !this.isFallBack) ** GOTO lbl222
                                    if (this.entryPoint != null) break block103;
                                    try {
                                        classModel = ClassModel.createClassModel(this.kernel.getClass());
                                        this.entryPoint = classModel.getEntrypoint(_settings.entrypoint, this.kernel);
                                        _settings.profile.onEvent(device, ProfilingEvent.CLASS_MODEL_BUILT);
                                    }
                                    catch (Exception exception) {
                                        _settings.profile.onEvent(device, ProfilingEvent.CLASS_MODEL_BUILT);
                                        if (compileOnly) {
                                            throw new CompileFailedException(exception);
                                        }
                                        var11_19 = this.fallBackToNextDevice(device, _settings, exception);
                                        _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
                                        this.maybeReportProfile(_settings);
                                        return var11_19;
                                    }
                                }
                                if (this.kernelIsCompiledForDeviceHash.getOrDefault(device, false).booleanValue() || this.entryPoint == null) ** GOTO lbl216
                                exception = Kernel.class;
                                // MONITORENTER : com.aparapi.Kernel.class
                                this.jniContextHandle = this.initJNI(this.kernel, openCLDevice, jniFlags);
                                _settings.profile.onEvent(device, ProfilingEvent.INIT_JNI);
                                // MONITOREXIT : exception
                                if (this.jniContextHandle != 0L) break block104;
                                if (compileOnly) {
                                    throw new CompileFailedException("initJNI failed to return a valid handle");
                                }
                                exception = this.fallBackToNextDevice(device, _settings, "initJNI failed to return a valid handle");
                                _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
                                this.maybeReportProfile(_settings);
                                return exception;
                            }
                            extensions = this.getExtensionsJNI(this.jniContextHandle);
                            this.capabilitiesSet = new HashSet<String>();
                            strTok = new StringTokenizer(extensions);
                            while (strTok.hasMoreTokens()) {
                                this.capabilitiesSet.add(strTok.nextToken());
                            }
                            if (KernelRunner.logger.isLoggable(Level.FINE)) {
                                KernelRunner.logger.fine("Capabilities initialized to :" + this.capabilitiesSet.toString());
                            }
                            if (!this.entryPoint.requiresDoublePragma() || this.hasFP64Support()) break block105;
                            if (compileOnly) {
                                throw new CompileFailedException("FP64 required but not supported");
                            }
                            var12_22 = this.fallBackToNextDevice(device, _settings, "FP64 required but not supported");
                            _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
                            this.maybeReportProfile(_settings);
                            return var12_22;
                        }
                        if (!this.entryPoint.requiresByteAddressableStorePragma() || this.hasByteAddressableStoreSupport()) break block106;
                        if (compileOnly) {
                            throw new CompileFailedException("Byte addressable stores required but not supported");
                        }
                        var12_23 = this.fallBackToNextDevice(device, _settings, "Byte addressable stores required but not supported");
                        _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
                        this.maybeReportProfile(_settings);
                        return var12_23;
                    }
                    v1 = all32AtomicsAvailable = this.hasGlobalInt32BaseAtomicsSupport() != false && this.hasGlobalInt32ExtendedAtomicsSupport() != false && this.hasLocalInt32BaseAtomicsSupport() != false && this.hasLocalInt32ExtendedAtomicsSupport() != false;
                    if (!this.entryPoint.requiresAtomic32Pragma() || all32AtomicsAvailable) break block107;
                    if (compileOnly) {
                        throw new CompileFailedException("32 bit Atomics required but not supported");
                    }
                    var13_26 = this.fallBackToNextDevice(device, _settings, "32 bit Atomics required but not supported");
                    _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
                    this.maybeReportProfile(_settings);
                    return var13_26;
                }
                var14_29 = KernelRunner.openCLCache;
                // MONITORENTER : var14_29
                openCL = KernelRunner.openCLCache.get(this.kernel.getClass());
                if (openCL == null) {
                    try {
                        openCL = KernelWriter.writeToString(this.entryPoint);
                        if (KernelRunner.logger.isLoggable(Level.INFO)) {
                            KernelRunner.logger.info(openCL);
                        } else if (Config.enableShowGeneratedOpenCL) {
                            System.out.println(openCL);
                        }
                        _settings.profile.onEvent(device, ProfilingEvent.OPENCL_GENERATED);
                        KernelRunner.openCLCache.put(this.kernel.getClass(), openCL);
                        break block108;
                    }
                    catch (CodeGenException codeGenException) {
                        KernelRunner.openCLCache.put(this.kernel.getClass(), KernelRunner.CODE_GEN_ERROR_MARKER);
                        _settings.profile.onEvent(device, ProfilingEvent.OPENCL_GENERATED);
                        if (compileOnly) {
                            throw new CompileFailedException(codeGenException);
                        }
                        var16_35 = this.fallBackToNextDevice(device, _settings, codeGenException);
                        // MONITOREXIT : var14_29
                        _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
                        this.maybeReportProfile(_settings);
                        return var16_35;
                    }
                }
                if (!openCL.equals(KernelRunner.CODE_GEN_ERROR_MARKER)) break block108;
                _settings.profile.onEvent(device, ProfilingEvent.OPENCL_GENERATED);
                silently = true;
                if (!compileOnly) break block109;
                throw new CompileFailedException("Code Gen Error Marker present");
            }
            var16_36 = this.fallBackToNextDevice(device, _settings, null, silently);
            // MONITOREXIT : var14_29
            _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
            this.maybeReportProfile(_settings);
            return var16_36;
        }
        try {
            block116: {
                block117: {
                    // MONITOREXIT : var14_29
                    if (KernelRunner.BINARY_CACHING_DISABLED) {
                        handle = this.buildProgramJNI(this.jniContextHandle, openCL, "");
                    } else {
                        var16_37 /* !! */  = KernelRunner.seenBinaryKeys;
                        // MONITORENTER : var16_37 /* !! */ 
                        binaryKey = this.kernel.getClass().getName() + ":" + device.getDeviceId();
                        if (KernelRunner.seenBinaryKeys.contains(binaryKey)) {
                            KernelRunner.logger.log(Level.INFO, "reusing cached binary for " + binaryKey);
                            handle = this.buildProgramJNI(this.jniContextHandle, "", binaryKey);
                        } else {
                            KernelRunner.logger.log(Level.INFO, "compiling new binary for " + binaryKey);
                            handle = this.buildProgramJNI(this.jniContextHandle, openCL, binaryKey);
                            KernelRunner.seenBinaryKeys.add(binaryKey);
                        }
                        // MONITOREXIT : var16_37 /* !! */ 
                    }
                    _settings.profile.onEvent(device, ProfilingEvent.OPENCL_COMPILED);
                    if (handle == 0L) {
                        if (compileOnly) {
                            throw new CompileFailedException("OpenCL compile failed");
                        }
                        var16_37 /* !! */  = this.fallBackToNextDevice(device, _settings, "OpenCL compile failed");
                        return var16_37 /* !! */ ;
                    }
                    this.kernelIsCompiledForDeviceHash.putIfAbsent(device, true);
                    if (compileOnly) {
                        var16_37 /* !! */  = this.kernel;
                        return var16_37 /* !! */ ;
                    }
lbl216:
                    // 3 sources

                    if (this.entryPoint != null) break block116;
                    if (compileOnly) {
                        throw new CompileFailedException("failed to locate entrypoint");
                    }
                    this.fallBackToNextDevice(device, _settings, "failed to locate entrypoint");
                    break block117;
lbl222:
                    // 1 sources

                    try {
                        this.executeOpenCL(device, _settings);
                        this.isFallBack = false;
                    }
                    catch (AparapiException e) {
                        this.fallBackToNextDevice(device, _settings, e);
                    }
                    break block117;
lbl231:
                    // 1 sources

                    if (!(device instanceof JavaDevice)) {
                        this.fallBackToNextDevice(device, _settings, "Non-OpenCL Kernel.EXECUTION_MODE requested but device is not a JavaDevice ");
                    }
                    this.executeJava(_settings, (JavaDevice)device);
                }
lbl236:
                // 3 sources

                while (true) {
                    if (Config.enableExecutionModeReporting) {
                        System.out.println("execution complete: " + this.kernel);
                    }
                    var10_18 = this.kernel;
                    return var10_18;
                }
            }
            this.args = new KernelArg[this.entryPoint.getReferencedFields().size()];
            i = 0;
            strTok = this.entryPoint.getReferencedFields().iterator();
        }
        catch (Throwable var19_39) {
            throw var19_39;
        }
        finally {
            _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
            this.maybeReportProfile(_settings);
        }
        while (strTok.hasNext()) {
            block111: {
                field = strTok.next();
                try {
                    field.setAccessible(true);
                    this.args[i] = new KernelArg();
                    this.args[i].setName(field.getName());
                    this.args[i].setField(field);
                    if ((field.getModifiers() & 8) == 8) {
                        this.args[i].setType(this.args[i].getType() | 0x400000);
                    }
                    if ((type = field.getType()).isArray()) {
                        if (field.getAnnotation(Kernel.Local.class) != null || this.args[i].getName().endsWith("_$local$")) {
                            this.args[i].setType(this.args[i].getType() | 2048);
                        } else if (field.getAnnotation(Kernel.Constant.class) != null || this.args[i].getName().endsWith("_$constant$")) {
                            this.args[i].setType(this.args[i].getType() | 8192);
                        } else {
                            this.args[i].setType(this.args[i].getType() | 4096);
                        }
                        if (this.isExplicit()) {
                            this.args[i].setType(this.args[i].getType() | 65536);
                        }
                        this.args[i].setType(this.args[i].getType() | (this.entryPoint.getArrayFieldAssignments().contains(field.getName()) != false ? 1536 : 0));
                        this.args[i].setType(this.args[i].getType() | (this.entryPoint.getArrayFieldAccesses().contains(field.getName()) != false ? 512 : 0));
                        if (type.getName().startsWith("[L")) {
                            this.args[i].setArray(null);
                            this.args[i].setType(this.args[i].getType() | 263808);
                            if (KernelRunner.logger.isLoggable(Level.FINE)) {
                                KernelRunner.logger.fine("tagging " + this.args[i].getName() + " as (ARG_ARRAY | ARG_OBJ_ARRAY_STRUCT | ARG_WRITE | ARG_READ)");
                            }
                            break block111;
                        }
                        if (type.getName().startsWith("[[")) {
                            try {
                                this.setMultiArrayType(this.args[i], type);
                                break block111;
                            }
                            catch (AparapiException e) {
                                var15_34 = this.fallBackToNextDevice(device, _settings, "failed to set kernel arguement " + this.args[i].getName() + ".  Aparapi only supports 2D and 3D arrays.");
                                _settings.profile.onEvent(device, ProfilingEvent.EXECUTED);
                                this.maybeReportProfile(_settings);
                                return var15_34;
                            }
                        }
                        this.args[i].setArray(null);
                        this.args[i].setType(this.args[i].getType() | 128);
                        this.args[i].setType(this.args[i].getType() | (type.isAssignableFrom(float[].class) != false ? 4 : 0));
                        this.args[i].setType(this.args[i].getType() | (type.isAssignableFrom(int[].class) != false ? 8 : 0));
                        this.args[i].setType(this.args[i].getType() | (type.isAssignableFrom(boolean[].class) != false ? 1 : 0));
                        this.args[i].setType(this.args[i].getType() | (type.isAssignableFrom(byte[].class) != false ? 2 : 0));
                        this.args[i].setType(this.args[i].getType() | (type.isAssignableFrom(char[].class) != false ? 0x200000 : 0));
                        this.args[i].setType(this.args[i].getType() | (type.isAssignableFrom(double[].class) != false ? 16 : 0));
                        this.args[i].setType(this.args[i].getType() | (type.isAssignableFrom(long[].class) != false ? 32 : 0));
                        this.args[i].setType(this.args[i].getType() | (type.isAssignableFrom(short[].class) != false ? 64 : 0));
                        if (this.entryPoint.getArrayFieldArrayLengthUsed().contains(this.args[i].getName())) {
                            this.args[i].setType(this.args[i].getType() | 16384);
                        }
                        if (!type.getName().startsWith("[L")) break block111;
                        this.args[i].setType(this.args[i].getType() | 263680);
                        if (KernelRunner.logger.isLoggable(Level.FINE)) {
                            KernelRunner.logger.fine("tagging " + this.args[i].getName() + " as (ARG_OBJ_ARRAY_STRUCT | ARG_WRITE | ARG_READ)");
                        }
                        break block111;
                    }
                    if (type.isAssignableFrom(Float.TYPE)) {
                        this.args[i].setType(this.args[i].getType() | 256);
                        this.args[i].setType(this.args[i].getType() | 4);
                        break block111;
                    }
                    if (type.isAssignableFrom(Integer.TYPE)) {
                        this.args[i].setType(this.args[i].getType() | 256);
                        this.args[i].setType(this.args[i].getType() | 8);
                        break block111;
                    }
                    if (type.isAssignableFrom(Double.TYPE)) {
                        this.args[i].setType(this.args[i].getType() | 256);
                        this.args[i].setType(this.args[i].getType() | 16);
                        break block111;
                    }
                    if (type.isAssignableFrom(Long.TYPE)) {
                        this.args[i].setType(this.args[i].getType() | 256);
                        this.args[i].setType(this.args[i].getType() | 32);
                        break block111;
                    }
                    if (type.isAssignableFrom(Boolean.TYPE)) {
                        this.args[i].setType(this.args[i].getType() | 256);
                        this.args[i].setType(this.args[i].getType() | 1);
                        break block111;
                    }
                    if (type.isAssignableFrom(Byte.TYPE)) {
                        this.args[i].setType(this.args[i].getType() | 256);
                        this.args[i].setType(this.args[i].getType() | 2);
                        break block111;
                    }
                    if (type.isAssignableFrom(Character.TYPE)) {
                        this.args[i].setType(this.args[i].getType() | 256);
                        this.args[i].setType(this.args[i].getType() | 0x200000);
                        break block111;
                    }
                    if (type.isAssignableFrom(Short.TYPE)) {
                        this.args[i].setType(this.args[i].getType() | 256);
                        this.args[i].setType(this.args[i].getType() | 64);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            this.args[i].setPrimitiveSize(this.getPrimitiveSize(this.args[i].getType()));
            if (KernelRunner.logger.isLoggable(Level.FINE)) {
                KernelRunner.logger.fine("arg " + i + ", " + this.args[i].getName() + ", type=" + Integer.toHexString(this.args[i].getType()) + ", primitiveSize=" + this.args[i].getPrimitiveSize());
            }
            ++i;
        }
        this.argc = i;
        this.setArgsJNI(this.jniContextHandle, this.args, this.argc);
        _settings.profile.onEvent(device, ProfilingEvent.PREPARE_EXECUTE);
        this.kernelNeverExecutedForDeviceHash.putIfAbsent(device, false);
        try {
            this.executeOpenCL(device, _settings);
            this.isFallBack = false;
        }
        catch (AparapiException e) {
            this.fallBackToNextDevice(device, _settings, e);
            ** continue;
        }
    }

    public String toString() {
        return "KernelRunner{" + this.kernel + "}";
    }

    private String describeDevice() {
        Device device = KernelManager.instance().getPreferences(this.kernel).getPreferredDevice(this.kernel);
        return device == null ? "<default fallback>" : device.getShortDescription();
    }

    private void maybeReportProfile(ExecutionSettings _settings) {
        if (Config.dumpProfileOnExecution) {
            StringBuilder report = new StringBuilder();
            report.append(KernelDeviceProfile.getTableHeader()).append('\n');
            report.append(_settings.profile.getLastDeviceProfile().getLastAsTableRow());
            System.out.println(report);
        }
    }

    private boolean isDeviceCompatible(Device device) {
        Kernel.EXECUTION_MODE mode = this.kernel.getExecutionMode();
        if (mode != Kernel.EXECUTION_MODE.AUTO) {
            switch (device.getType()) {
                case GPU: {
                    return mode == Kernel.EXECUTION_MODE.GPU;
                }
                case CPU: {
                    return mode == Kernel.EXECUTION_MODE.CPU;
                }
                case JTP: {
                    return mode == Kernel.EXECUTION_MODE.JTP;
                }
                case SEQ: {
                    return mode == Kernel.EXECUTION_MODE.SEQ;
                }
                case ACC: {
                    return mode == Kernel.EXECUTION_MODE.ACC;
                }
            }
            return false;
        }
        return KernelManager.instance().getPreferences(this.kernel).isDeviceAmongPreferredDevices(device);
    }

    public int getCancelState() {
        return this.inBufferRemoteInt.get(0);
    }

    public void cancelMultiPass() {
        this.inBufferRemoteInt.put(0, 1);
    }

    private void clearCancelMultiPass() {
        this.inBufferRemoteInt.put(0, 0);
    }

    public int getCurrentPass() {
        if (!this.executing) {
            return -1;
        }
        if (this.kernel.isRunningCL()) {
            return this.getCurrentPassRemote();
        }
        return this.getCurrentPassLocal();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    protected int getCurrentPassRemote() {
        return this.outBufferRemoteInt.get(0);
    }

    private int getCurrentPassLocal() {
        return this.passId;
    }

    private int getPrimitiveSize(int type) {
        if ((type & 4) != 0) {
            return 4;
        }
        if ((type & 8) != 0) {
            return 4;
        }
        if ((type & 2) != 0) {
            return 1;
        }
        if ((type & 0x200000) != 0) {
            return 2;
        }
        if ((type & 1) != 0) {
            return 1;
        }
        if ((type & 0x40) != 0) {
            return 2;
        }
        if ((type & 0x20) != 0) {
            return 8;
        }
        if ((type & 0x10) != 0) {
            return 8;
        }
        return 0;
    }

    private void setMultiArrayType(KernelArg arg, Class<?> type) throws AparapiException {
        arg.setType(arg.getType() | 0x8600);
        int numDims = 0;
        if (type.getName().startsWith("[[[[")) {
            throw new AparapiException("Aparapi only supports 2D and 3D arrays.");
        }
        arg.setType(arg.getType() | 0x4000);
        while (type.getName().charAt(numDims) == '[') {
            ++numDims;
        }
        arg.setNumDims(numDims);
        arg.setJavaBuffer(null);
        arg.setArray(null);
        Class<Serializable> elementType = arg.getField().getType();
        while (elementType.isArray()) {
            elementType = elementType.getComponentType();
        }
        if (elementType.isAssignableFrom(Float.TYPE)) {
            arg.setType(arg.getType() | 4);
        } else if (elementType.isAssignableFrom(Integer.TYPE)) {
            arg.setType(arg.getType() | 8);
        } else if (elementType.isAssignableFrom(Boolean.TYPE)) {
            arg.setType(arg.getType() | 1);
        } else if (elementType.isAssignableFrom(Byte.TYPE)) {
            arg.setType(arg.getType() | 2);
        } else if (elementType.isAssignableFrom(Character.TYPE)) {
            arg.setType(arg.getType() | 0x200000);
        } else if (elementType.isAssignableFrom(Double.TYPE)) {
            arg.setType(arg.getType() | 0x10);
        } else if (elementType.isAssignableFrom(Long.TYPE)) {
            arg.setType(arg.getType() | 0x20);
        } else if (elementType.isAssignableFrom(Short.TYPE)) {
            arg.setType(arg.getType() | 0x40);
        }
    }

    public void get(Object array) {
        if (this.explicit && this.kernel.isRunningCL()) {
            this.getJNI(this.jniContextHandle, array);
        }
    }

    public List<ProfileInfo> getProfileInfo() {
        if (this.explicit && this.kernel.isRunningCL()) {
            return this.getProfileInfoJNI(this.jniContextHandle);
        }
        return null;
    }

    public void put(Object array) {
        if (this.explicit && this.kernel.isRunningCL()) {
            this.puts.add(array);
        }
    }

    public void setExplicit(boolean _explicit) {
        this.explicit = _explicit;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    private static class ExecutionSettings {
        final KernelPreferences preferences;
        final KernelProfile profile;
        final String entrypoint;
        Range range;
        final int passes;
        final boolean legacyExecutionMode;

        private ExecutionSettings(KernelPreferences preferences, KernelProfile profile, String entrypoint, Range range, int passes, boolean legacyExecutionMode) {
            this.preferences = preferences;
            this.profile = profile;
            this.entrypoint = entrypoint;
            this.range = range;
            this.passes = passes;
            this.legacyExecutionMode = legacyExecutionMode;
        }

        public String toString() {
            return "ExecutionSettings{preferences=" + this.preferences + ", profile=" + this.profile + ", entrypoint='" + this.entrypoint + '\'' + ", range=" + this.range + ", passes=" + this.passes + ", legacyExecutionMode=" + this.legacyExecutionMode + '}';
        }
    }

    private static interface ThreadIdSetter {
        public void set(Kernel.KernelState var1, int var2, int var3);
    }

    private static final class FJSafeBarrier
    implements IKernelBarrier {
        final int threads;
        final AtomicBoolean brokenBarrier = new AtomicBoolean(false);
        final AtomicBoolean canceled = new AtomicBoolean(false);
        final Object lock = new Object();
        int remainingThreads;

        FJSafeBarrier(int threads) {
            this.remainingThreads = threads;
            this.threads = threads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void breakBarrier(Throwable e) {
            Object object = this.lock;
            synchronized (object) {
                this.brokenBarrier.set(true);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelBarrier() {
            Object object = this.lock;
            synchronized (object) {
                this.remainingThreads = this.threads;
                this.canceled.set(true);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public boolean block() throws InterruptedException {
            if (this.canceled.get()) {
                return true;
            }
            var1_1 = this.lock;
            synchronized (var1_1) {
                --this.remainingThreads;
                if (this.remainingThreads < 0) {
                    throw new Error("Thread count cannot be less than 0");
                }
                if (!this.brokenBarrier.get() && this.remainingThreads > 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        if (this.remainingThreads == this.threads) ** GOTO lbl22
                        ++this.remainingThreads;
                        throw e;
                    }
                } else {
                    this.remainingThreads = this.threads;
                    this.lock.notifyAll();
                }
            }
lbl22:
            // 3 sources

            if (this.brokenBarrier.get()) {
                throw new AparapiBrokenBarrierException("Barrier was broken");
            }
            return true;
        }

        @Override
        public boolean isReleasable() {
            return false;
        }
    }

    private class ThreadDiedHandler
    implements Thread.UncaughtExceptionHandler {
        private AtomicLong threadsDiedCounter = new AtomicLong(0L);

        private ThreadDiedHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            logger.log(Level.SEVERE, "Thread died in thread pool of kernel runner for kernel: " + KernelRunner.this.kernel.getClass(), e);
            this.threadsDiedCounter.incrementAndGet();
        }
    }
}

