/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.kernel;

import com.aparapi.Config;
import com.aparapi.IProfileReportObserver;
import com.aparapi.Kernel;
import com.aparapi.device.Device;
import com.aparapi.internal.kernel.KernelDeviceProfile;
import com.aparapi.internal.kernel.ProfilingEvent;
import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KernelProfile {
    public static final double MILLION = 1000000.0;
    private static Logger logger = Logger.getLogger(Config.getLoggerName());
    private final Class<? extends Kernel> kernelClass;
    private ConcurrentSkipListMap<Device, KernelDeviceProfile> deviceProfiles = new ConcurrentSkipListMap();
    private final AtomicReference<Device> currentDevice = new AtomicReference<Object>(null);
    private IProfileReportObserver observer;

    public KernelProfile(Class<? extends Kernel> _kernelClass) {
        this.kernelClass = _kernelClass;
    }

    public double getLastExecutionTime() {
        KernelDeviceProfile lastDeviceProfile = this.getLastDeviceProfile();
        return lastDeviceProfile == null ? Double.NaN : lastDeviceProfile.getElapsedTimeLastThread(ProfilingEvent.START.ordinal(), ProfilingEvent.EXECUTED.ordinal());
    }

    public double getLastConversionTime() {
        KernelDeviceProfile lastDeviceProfile = this.getLastDeviceProfile();
        return lastDeviceProfile == null ? Double.NaN : lastDeviceProfile.getElapsedTimeLastThread(ProfilingEvent.START.ordinal(), ProfilingEvent.PREPARE_EXECUTE.ordinal());
    }

    public double getAccumulatedTotalTime() {
        KernelDeviceProfile lastDeviceProfile = this.getLastDeviceProfile();
        if (lastDeviceProfile == null) {
            return Double.NaN;
        }
        return lastDeviceProfile.getCumulativeElapsedTimeAllGlobal() / 1000000.0;
    }

    public KernelDeviceProfile getLastDeviceProfile() {
        return this.deviceProfiles.get(this.currentDevice.get());
    }

    void onStart(Device device) {
        KernelDeviceProfile existingProfile;
        KernelDeviceProfile currentDeviceProfile = this.deviceProfiles.get(device);
        if (currentDeviceProfile == null && (existingProfile = this.deviceProfiles.putIfAbsent(device, currentDeviceProfile = new KernelDeviceProfile(this, this.kernelClass, device))) != null) {
            currentDeviceProfile = existingProfile;
        }
        currentDeviceProfile.onEvent(ProfilingEvent.START);
        this.currentDevice.set(device);
    }

    void onEvent(Device device, ProfilingEvent event) {
        if (event == null) {
            logger.log(Level.WARNING, "Discarding profiling event " + (Object)((Object)event) + " for null device, for Kernel class: " + this.kernelClass.getName());
            return;
        }
        KernelDeviceProfile deviceProfile = this.deviceProfiles.get(device);
        switch (event) {
            case CLASS_MODEL_BUILT: 
            case OPENCL_GENERATED: 
            case INIT_JNI: 
            case OPENCL_COMPILED: 
            case PREPARE_EXECUTE: 
            case EXECUTED: {
                if (deviceProfile == null) {
                    logger.log(Level.SEVERE, "Error in KernelProfile, no currentDevice (synchronization error?");
                }
                deviceProfile.onEvent(event);
                break;
            }
            case START: {
                throw new IllegalArgumentException("must use onStart(Device) to start profiling");
            }
            default: {
                throw new IllegalArgumentException("Unhandled event " + (Object)((Object)event));
            }
        }
    }

    public Collection<Device> getDevices() {
        return this.deviceProfiles.keySet();
    }

    public Collection<KernelDeviceProfile> getDeviceProfiles() {
        return this.deviceProfiles.values();
    }

    public KernelDeviceProfile getDeviceProfile(Device device) {
        return this.deviceProfiles.get(device);
    }

    public void setReportObserver(IProfileReportObserver _observer) {
        this.observer = _observer;
    }

    public IProfileReportObserver getReportObserver() {
        return this.observer;
    }
}

