/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.kernel;

import com.aparapi.Kernel;
import com.aparapi.device.Device;
import com.aparapi.internal.kernel.KernelManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class KernelPreferences {
    private final Class<? extends Kernel> kernelClass;
    private final KernelManager manager;
    private final AtomicReference<LinkedHashSet<Device>> preferredDevices = new AtomicReference<Object>(null);
    private final LinkedHashSet<Device> failedDevices = new LinkedHashSet();

    public KernelPreferences(KernelManager manager, Class<? extends Kernel> kernelClass) {
        this.kernelClass = kernelClass;
        this.manager = manager;
    }

    public Class<? extends Kernel> getKernelClass() {
        return this.kernelClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Device> getPreferredDevices(Kernel kernel) {
        ArrayList copy;
        this.maybeSetUpDefaultPreferredDevices();
        KernelPreferences kernelPreferences = this;
        synchronized (kernelPreferences) {
            copy = new ArrayList(this.preferredDevices.get());
        }
        if (kernel == null) {
            return Collections.unmodifiableList(copy);
        }
        ArrayList<Device> localPreferredDevices = new ArrayList<Device>();
        for (Device device : copy) {
            if (!kernel.isAllowDevice(device)) continue;
            localPreferredDevices.add(device);
        }
        return Collections.unmodifiableList(localPreferredDevices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeviceAmongPreferredDevices(Device device) {
        this.maybeSetUpDefaultPreferredDevices();
        boolean result = false;
        KernelPreferences kernelPreferences = this;
        synchronized (kernelPreferences) {
            result = this.preferredDevices.get().contains(device);
        }
        return result;
    }

    synchronized void setPreferredDevices(LinkedHashSet<Device> _preferredDevices) {
        if (this.preferredDevices.get() != null) {
            this.preferredDevices.get().clear();
            this.preferredDevices.get().addAll(_preferredDevices);
        } else {
            this.preferredDevices.set(new LinkedHashSet<Device>(_preferredDevices));
        }
        this.failedDevices.clear();
    }

    public Device getPreferredDevice(Kernel kernel) {
        List<Device> localPreferredDevices = this.getPreferredDevices(kernel);
        return localPreferredDevices.isEmpty() ? null : localPreferredDevices.get(0);
    }

    synchronized void markPreferredDeviceFailed() {
        LinkedHashSet<Device> devices = this.preferredDevices.get();
        if (devices.size() > 0) {
            Device device = (Device)devices.iterator().next();
            this.preferredDevices.get().remove(device);
            this.failedDevices.add(device);
        }
    }

    synchronized void markDeviceFailed(Device device) {
        this.preferredDevices.get().remove(device);
        this.failedDevices.add(device);
    }

    private void maybeSetUpDefaultPreferredDevices() {
        if (this.preferredDevices.get() == null) {
            this.preferredDevices.compareAndSet(null, new LinkedHashSet<Device>(this.manager.getDefaultPreferences().getPreferredDevices(null)));
        }
    }

    public synchronized List<Device> getFailedDevices() {
        return new ArrayList<Device>(this.failedDevices);
    }
}

