/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.kernel;

import com.aparapi.Config;
import com.aparapi.IProfileReportObserver;
import com.aparapi.Kernel;
import com.aparapi.ProfileReport;
import com.aparapi.device.Device;
import com.aparapi.internal.kernel.KernelProfile;
import com.aparapi.internal.kernel.ProfilingEvent;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KernelDeviceProfile {
    private static Logger logger = Logger.getLogger(Config.getLoggerName());
    private static final int NUM_EVENTS = ProfilingEvent.values().length;
    private static final double MILLION = 1000000.0;
    private static final int TABLE_COLUMN_HEADER_WIDTH = 21;
    private static final int TABLE_COLUMN_COUNT_WIDTH = 8;
    private static final int TABLE_COLUMN_WIDTH;
    private static String tableHeader;
    private final KernelProfile parentKernelProfile;
    private final Class<? extends Kernel> kernel;
    private final Device device;
    private final DecimalFormat format;
    private final AtomicLong invocationCountGlobal = new AtomicLong(0L);
    private final AtomicReference<Accumulator> lastAccumulator = new AtomicReference<Object>(null);
    private final GlobalAccumulator globalAcc = new GlobalAccumulator();
    private final Map<Thread, Accumulator> accs = Collections.synchronizedMap(new WeakHashMap(Runtime.getRuntime().availableProcessors() * 2, 0.95f));

    private Accumulator getAccForThreadPutIfAbsent() {
        Thread t = Thread.currentThread();
        Accumulator a = this.accs.get(t);
        if (a == null) {
            a = new Accumulator(t.getId());
            this.accs.put(t, a);
        }
        return a;
    }

    private Accumulator getAccForThread() {
        Thread t = Thread.currentThread();
        return this.accs.get(t);
    }

    public KernelDeviceProfile(KernelProfile parentProfile, Class<? extends Kernel> kernel, Device device) {
        this.parentKernelProfile = parentProfile;
        this.kernel = kernel;
        this.device = device;
        this.format = (DecimalFormat)DecimalFormat.getNumberInstance();
        this.format.setMinimumFractionDigits(3);
        this.format.setMaximumFractionDigits(3);
    }

    public void onEvent(ProfilingEvent event) {
        this.getAccForThreadPutIfAbsent().onEvent(event);
    }

    private ProfileReport updateProfileReport(ProfileReport report, long invocationCount, long[] currentTimes) {
        report.setProfileReport(invocationCount, currentTimes);
        return report;
    }

    public double getElapsedTimeCurrentThread(int stage) {
        if (stage == ProfilingEvent.START.ordinal()) {
            return 0.0;
        }
        Accumulator acc = this.getAccForThread();
        return acc == null ? Double.NaN : (double)(acc.currentTimes[stage] - acc.currentTimes[stage - 1]) / 1000000.0;
    }

    public double getElapsedTimeCurrentThread(int from, int to) {
        Accumulator acc = this.getAccForThread();
        return acc == null ? Double.NaN : (double)(acc.currentTimes[to] - acc.currentTimes[from]) / 1000000.0;
    }

    public WeakReference<ProfileReport> getReportCurrentThread() {
        Accumulator acc = this.getAccForThread();
        return acc == null ? null : acc.reportRef;
    }

    public WeakReference<ProfileReport> getReportLastThread() {
        Accumulator acc = this.lastAccumulator.get();
        return acc == null ? null : acc.reportRef;
    }

    public double getCumulativeElapsedTimeCurrrentThread(ProfilingEvent stage) {
        Accumulator acc = this.getAccForThread();
        return acc == null ? Double.NaN : (double)acc.accumulatedTimes[stage.ordinal()] / 1000000.0;
    }

    public double getCumulativeElapsedTimeAllCurrentThread() {
        double sum = 0.0;
        Accumulator acc = this.getAccForThread();
        if (acc == null) {
            return sum;
        }
        for (int i = 1; i <= ProfilingEvent.EXECUTED.ordinal(); ++i) {
            sum += (double)acc.accumulatedTimes[i];
        }
        return sum;
    }

    public double getElapsedTimeLastThread(int stage) {
        if (stage == ProfilingEvent.START.ordinal()) {
            return 0.0;
        }
        Accumulator acc = this.lastAccumulator.get();
        return acc == null ? Double.NaN : (double)(acc.currentTimes[stage] - acc.currentTimes[stage - 1]) / 1000000.0;
    }

    public double getElapsedTimeLastThread(int from, int to) {
        Accumulator acc = this.lastAccumulator.get();
        return acc == null ? Double.NaN : (double)(acc.currentTimes[to] - acc.currentTimes[from]) / 1000000.0;
    }

    public double getCumulativeElapsedTimeGlobal(ProfilingEvent stage) {
        long[] accumulatedTimesHolder = new long[NUM_EVENTS];
        this.globalAcc.consultAccumulatedTimes(accumulatedTimesHolder);
        return (double)accumulatedTimesHolder[stage.ordinal()] / 1000000.0;
    }

    public double getCumulativeElapsedTimeAllGlobal() {
        long[] accumulatedTimesHolder = new long[NUM_EVENTS];
        this.globalAcc.consultAccumulatedTimes(accumulatedTimesHolder);
        double sum = 0.0;
        for (int i = 1; i <= ProfilingEvent.EXECUTED.ordinal(); ++i) {
            sum += (double)accumulatedTimesHolder[i];
        }
        return sum;
    }

    public static synchronized String getTableHeader() {
        if (tableHeader == null) {
            int length = ProfilingEvent.values().length;
            StringBuilder builder = new StringBuilder(150);
            KernelDeviceProfile.appendRowHeaders(builder, "Device", "Count");
            for (int i = 1; i < length; ++i) {
                ProfilingEvent stage = ProfilingEvent.values()[i];
                String heading = stage.name();
                KernelDeviceProfile.appendCell(builder, heading);
            }
            builder.append("  ").append("Total");
            tableHeader = builder.toString();
        }
        return tableHeader;
    }

    public String getLastAsTableRow() {
        StringBuilder builder = new StringBuilder(150);
        Accumulator acc = this.lastAccumulator.get();
        if (acc == null) {
            KernelDeviceProfile.appendRowHeaders(builder, this.device.getShortDescription(), String.valueOf(this.invocationCountGlobal.get()));
            builder.append("No thread available");
            return builder.toString();
        }
        double total = 0.0;
        KernelDeviceProfile.appendRowHeaders(builder, this.device.getShortDescription(), String.valueOf(this.invocationCountGlobal.get()));
        for (int i = 1; i < NUM_EVENTS; ++i) {
            ProfilingEvent stage = ProfilingEvent.values()[i];
            double time = this.getElapsedTimeLastThread(stage.ordinal());
            total += time;
            String formatted = this.format.format(time);
            KernelDeviceProfile.appendCell(builder, formatted);
        }
        builder.append("  ").append(this.format.format(total));
        return builder.toString();
    }

    public String getCumulativeAsTableRow() {
        return this.internalCumulativeAsTableRow(false);
    }

    public String getAverageAsTableRow() {
        return this.internalCumulativeAsTableRow(true);
    }

    private String internalCumulativeAsTableRow(boolean mean) {
        double total = 0.0;
        double count = mean ? (double)this.invocationCountGlobal.get() : 1.0;
        StringBuilder builder = new StringBuilder(150);
        KernelDeviceProfile.appendRowHeaders(builder, this.device.getShortDescription(), String.valueOf(this.invocationCountGlobal.get()));
        for (int i = 1; i < NUM_EVENTS; ++i) {
            ProfilingEvent stage = ProfilingEvent.values()[i];
            double time = this.getCumulativeElapsedTimeGlobal(stage);
            if (mean) {
                time /= count;
            }
            total += time;
            String formatted = this.format.format(time);
            KernelDeviceProfile.appendCell(builder, formatted);
        }
        builder.append("  ").append(this.format.format(total));
        return builder.toString();
    }

    private static void appendRowHeaders(StringBuilder builder, String device, String count) {
        int i;
        if (device.length() > 20) {
            device = device.substring(0, 20);
        }
        builder.append(device);
        int padding = 21 - device.length();
        for (i = 0; i < padding; ++i) {
            builder.append(' ');
        }
        builder.append(count);
        padding = 8 - count.length();
        for (i = 0; i < padding; ++i) {
            builder.append(' ');
        }
    }

    private static void appendCell(StringBuilder builder, String cell) {
        int padding = TABLE_COLUMN_WIDTH - cell.length();
        for (int paddingIndex = 0; paddingIndex < padding; ++paddingIndex) {
            builder.append(' ');
        }
        builder.append(cell);
    }

    public String toString() {
        return "KernelDeviceProfile{" + this.kernel.toString() + ", " + this.device.getShortDescription() + "}";
    }

    static {
        tableHeader = null;
        assert (ProfilingEvent.START.ordinal() == 0) : "ProfilingEvent.START.ordinal() != 0";
        int max = 0;
        for (ProfilingEvent event : ProfilingEvent.values()) {
            max = Math.max(max, event.name().length());
        }
        TABLE_COLUMN_WIDTH = max + 1;
    }

    private class Accumulator {
        private final long threadId;
        private final long[] currentTimes = new long[KernelDeviceProfile.access$100()];
        private final long[] accumulatedTimes = new long[KernelDeviceProfile.access$100()];
        private final ProfileReport report;
        private final WeakReference<ProfileReport> reportRef;
        private ProfilingEvent lastEvent = null;
        private int invocationCount = 0;

        private Accumulator(long _threadId) {
            this.threadId = _threadId;
            this.report = new ProfileReport(this.threadId, KernelDeviceProfile.this.kernel, KernelDeviceProfile.this.device);
            this.reportRef = new WeakReference<ProfileReport>(this.report);
        }

        private void parseStartEventHelper(ProfilingEvent event) {
            int i;
            if (event == ProfilingEvent.START) {
                if (this.lastEvent != null) {
                    logger.log(Level.SEVERE, "ProfilingEvent.START encountered without ProfilingEvent.EXECUTED");
                } else if (this.lastEvent == ProfilingEvent.START) {
                    logger.log(Level.SEVERE, "Duplicate event ProfilingEvent.START");
                }
                Arrays.fill(this.currentTimes, 0L);
                ++this.invocationCount;
                KernelDeviceProfile.this.invocationCountGlobal.incrementAndGet();
            } else if (this.lastEvent == null) {
                if (event != ProfilingEvent.EXECUTED) {
                    logger.log(Level.SEVERE, "ProfilingEvent.START was not invoked prior to ProfilingEvent." + (Object)((Object)event));
                }
            } else {
                for (i = this.lastEvent.ordinal() + 1; i < event.ordinal(); ++i) {
                    this.currentTimes[i] = this.currentTimes[i - 1];
                }
            }
            this.currentTimes[event.ordinal()] = System.nanoTime();
            if (event == ProfilingEvent.EXECUTED) {
                i = 1;
                while (i < this.currentTimes.length) {
                    long elapsed = this.currentTimes[i] - this.currentTimes[i - 1];
                    if (elapsed < 0L) {
                        logger.log(Level.SEVERE, "negative elapsed time for event " + (Object)((Object)event));
                        break;
                    }
                    int n = i++;
                    this.accumulatedTimes[n] = this.accumulatedTimes[n] + elapsed;
                }
                KernelDeviceProfile.this.globalAcc.accumulateTimes(this.currentTimes);
                KernelDeviceProfile.this.lastAccumulator.set(this);
            }
        }

        private void onEvent(ProfilingEvent event) {
            this.parseStartEventHelper(event);
            this.lastEvent = event;
            if (event == ProfilingEvent.EXECUTED) {
                KernelDeviceProfile.this.updateProfileReport(this.report, this.invocationCount, this.currentTimes);
                IProfileReportObserver observer = KernelDeviceProfile.this.parentKernelProfile.getReportObserver();
                this.lastEvent = null;
                if (observer != null) {
                    observer.receiveReport(KernelDeviceProfile.this.kernel, KernelDeviceProfile.this.device, this.reportRef);
                }
            }
        }
    }

    private class GlobalAccumulator {
        private final AtomicLongArray accumulatedTimes = new AtomicLongArray(KernelDeviceProfile.access$100());
        private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        private GlobalAccumulator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void accumulateTimes(long[] currentTimes) {
            this.lock.readLock().lock();
            try {
                for (int i = 1; i < currentTimes.length; ++i) {
                    long elapsed = currentTimes[i] - currentTimes[i - 1];
                    this.accumulatedTimes.addAndGet(i, elapsed);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void consultAccumulatedTimes(long[] accumulatedTimesHolder) {
            this.lock.writeLock().lock();
            try {
                for (int i = 0; i < NUM_EVENTS; ++i) {
                    accumulatedTimesHolder[i] = this.accumulatedTimes.get(i);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

