/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.instruction;

import com.aparapi.Config;
import com.aparapi.internal.exception.ClassParseException;
import com.aparapi.internal.instruction.BranchSet;
import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.instruction.InstructionSet;
import com.aparapi.internal.model.ClassModel;
import com.aparapi.internal.model.MethodModel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExpressionList {
    private static Logger logger = Logger.getLogger(Config.getLoggerName());
    private final MethodModel methodModel;
    private final ExpressionList parent;
    private Instruction head;
    private Instruction tail;
    private final Instruction instruction;

    private ExpressionList(MethodModel _methodModel, ExpressionList _parent, Instruction _instruction) {
        this.methodModel = _methodModel;
        this.parent = _parent;
        this.instruction = _instruction;
        if (this.parent != null) {
            this.head = this.parent.head;
            this.tail = this.parent.tail;
        }
        if (this.instruction != null) {
            this.tail = _instruction.getPrevExpr();
            this.tail.setNextExpr(null);
            _instruction.setPrevExpr(null);
        }
    }

    public ExpressionList(MethodModel _methodModel) {
        this(_methodModel, null, null);
    }

    public boolean doesNotContainContinueOrBreak(Instruction _start, Instruction _extent) {
        Instruction i;
        boolean ok = true;
        boolean breakOrContinue = false;
        for (i = _start; i != null; i = i.getNextExpr()) {
            if (!i.isBranch()) continue;
            if (i.asBranch().isForwardUnconditional() && i.asBranch().getTarget().isAfter(_extent)) {
                breakOrContinue = true;
                continue;
            }
            ok = false;
            break;
        }
        if (ok && breakOrContinue) {
            for (i = _start; i != null; i = i.getNextExpr()) {
                if (!i.isBranch() || !i.asBranch().isForwardUnconditional() || !i.asBranch().getTarget().isAfter(_extent)) continue;
                i.asBranch().setBreakOrContinue(true);
            }
        }
        return ok;
    }

    public boolean doesNotContainCompositeOrBranch(Instruction _start, Instruction _exclusiveEnd) {
        boolean ok = true;
        for (Instruction i = _start; i != null && i != _exclusiveEnd; i = i.getNextExpr()) {
            if (i instanceof InstructionSet.CompositeInstruction || !i.isBranch()) continue;
            ok = false;
            break;
        }
        return ok;
    }

    public void unwind() {
        if (this.parent != null) {
            if (this.instruction != null) {
                this.tail.setNextExpr(this.instruction);
                this.instruction.setPrevExpr(this.tail);
                this.parent.head = this.head;
            } else {
                this.parent.head = this.head;
                this.parent.tail = this.tail;
            }
        }
    }

    public Instruction createList(Instruction _newTail) {
        Instruction childExprHead = null;
        if (_newTail == null) {
            childExprHead = this.head;
            this.head = null;
            this.tail = null;
        } else {
            childExprHead = _newTail.getNextExpr();
            this.tail = _newTail;
            _newTail.setNextExpr(null);
            if (childExprHead != null) {
                childExprHead.setPrevExpr(null);
            }
        }
        return childExprHead;
    }

    public Instruction add(Instruction _instruction) {
        if (this.head == null) {
            this.head = _instruction;
        } else {
            _instruction.setPrevExpr(this.tail);
            this.tail.setNextExpr(_instruction);
        }
        this.tail = _instruction;
        logger.log(Level.FINE, "After PUSH of " + _instruction + " tail=" + this.tail);
        return this.tail;
    }

    public void insertBetween(Instruction _prev, Instruction _next, Instruction _newOne) {
        _newOne.setNextExpr(null);
        _newOne.setPrevExpr(null);
        if (_prev == null) {
            if (_next == null) {
                this.head = this.tail = _newOne;
            } else {
                _newOne.setNextExpr(this.head);
                this.head.setPrevExpr(_newOne);
                this.head = _newOne;
            }
        } else if (_next == null) {
            _newOne.setPrevExpr(this.tail);
            this.tail.setNextExpr(_newOne);
            this.tail = _newOne;
        } else {
            _newOne.setNextExpr(_prev.getNextExpr());
            _newOne.setPrevExpr(_next.getPrevExpr());
            _prev.setNextExpr(_newOne);
            _next.setPrevExpr(_newOne);
        }
    }

    public void replaceInclusive(Instruction _head, Instruction _tail, Instruction _newOne) {
        _newOne.setNextExpr(null);
        _newOne.setPrevExpr(null);
        Instruction prevHead = _head.getPrevExpr();
        if (_tail == null) {
            _newOne.setPrevExpr(prevHead);
            prevHead.setNextExpr(_newOne);
            this.tail = _newOne;
        } else {
            Instruction tailNext = _tail.getNextExpr();
            if (prevHead == null) {
                if (tailNext == null) {
                    this.head = this.tail = _newOne;
                } else {
                    _newOne.setNextExpr(this.head);
                    this.head.setPrevExpr(_newOne);
                    this.head = _newOne;
                }
            } else if (tailNext == null) {
                _newOne.setPrevExpr(prevHead);
                prevHead.setNextExpr(_newOne);
                this.tail = _newOne;
                _head.setPrevExpr(null);
            } else {
                _newOne.setNextExpr(tailNext);
                _newOne.setPrevExpr(prevHead);
                prevHead.setNextExpr(_newOne);
                tailNext.setPrevExpr(_newOne);
            }
            _tail.setNextExpr(null);
            _head.setPrevExpr(null);
        }
    }

    public boolean foldComposite(Instruction _instruction) throws ClassParseException {
        boolean handled;
        block40: {
            block41: {
                handled = false;
                if (logger.isLoggable(Level.FINE)) {
                    System.out.println("foldComposite: curr = " + _instruction);
                    System.out.println(this.dumpDiagram(_instruction));
                }
                if (!_instruction.isForwardBranchTarget() && (this.tail == null || !this.tail.isBranch() || !this.tail.asBranch().isReverseConditional())) break block41;
                while (_instruction.isForwardBranchTarget() || this.tail != null && this.tail.isBranch() && this.tail.asBranch().isReverseConditional()) {
                    block42: {
                        LinkedList<InstructionSet.Branch> forwardUnconditionalBranches;
                        InstructionSet.Branch lastForwardUnconditional;
                        block43: {
                            Instruction afterGoto;
                            BranchSet branchSet;
                            InstructionSet.ConditionalBranch lastForwardConditional;
                            if (logger.isLoggable(Level.FINE)) {
                                System.out.println(this.dumpDiagram(_instruction));
                            }
                            handled = false;
                            if (this.tail != null && this.tail.isBranch() && this.tail.asBranch().isReverseConditional()) {
                                ClassModel.LocalVariableInfo localVariableInfo;
                                BranchSet branchSet2 = ((InstructionSet.ConditionalBranch)this.tail.asBranch()).getOrCreateBranchSet();
                                Instruction loopTop = branchSet2.getTarget().getRootExpr();
                                InstructionSet.Branch beginingOfBranch = branchSet2.getFirst();
                                Instruction startOfBeginningOfBranch = beginingOfBranch.getStartInstruction();
                                if (startOfBeginningOfBranch == loopTop) {
                                    if ((loopTop = loopTop.getPrevExpr()) instanceof InstructionSet.AssignToLocalVariable && (localVariableInfo = ((InstructionSet.AssignToLocalVariable)((Object)loopTop)).getLocalVariableInfo()).getStart() == loopTop.getNextExpr().getStartPC() && localVariableInfo.getEnd() == _instruction.getThisPC()) {
                                        loopTop = loopTop.getPrevExpr();
                                    }
                                    this.addAsComposites(InstructionSet.ByteCode.COMPOSITE_EMPTY_LOOP, loopTop, branchSet2);
                                    handled = true;
                                } else {
                                    if (loopTop.getPrevExpr() != null && loopTop.getPrevExpr().isBranch() && loopTop.getPrevExpr().asBranch().isForwardUnconditional() && this.doesNotContainCompositeOrBranch(branchSet2.getTarget().getRootExpr(), branchSet2.getFirst().getPrevExpr())) {
                                        branchSet2.unhook();
                                        loopTop.getPrevExpr().asBranch().unhook();
                                        loopTop = loopTop.getPrevExpr();
                                        loopTop = loopTop.getPrevExpr();
                                        if (loopTop instanceof InstructionSet.AssignToLocalVariable && (localVariableInfo = ((InstructionSet.AssignToLocalVariable)((Object)loopTop)).getLocalVariableInfo()).getStart() == loopTop.getNextExpr().getStartPC() && localVariableInfo.getEnd() == _instruction.getThisPC()) {
                                            loopTop = loopTop.getPrevExpr();
                                        }
                                        this.addAsComposites(InstructionSet.ByteCode.COMPOSITE_FOR_ECLIPSE, loopTop, branchSet2);
                                        handled = true;
                                    }
                                    if (!handled) {
                                        if (loopTop.getPrevExpr() == null) {
                                            throw new IllegalStateException("might be a dowhile with no provious expression");
                                        }
                                        if (!loopTop.getPrevExpr().isBranch() || !loopTop.getPrevExpr().asBranch().isForwardUnconditional()) {
                                            if (this.doesNotContainCompositeOrBranch(branchSet2.getTarget().getRootExpr(), branchSet2.getFirst().getPrevExpr())) {
                                                loopTop = loopTop.getPrevExpr();
                                                branchSet2.unhook();
                                                this.addAsComposites(InstructionSet.ByteCode.COMPOSITE_DO_WHILE, loopTop, branchSet2);
                                                handled = true;
                                            }
                                        } else {
                                            throw new IllegalStateException("might be mistaken for a do while!");
                                        }
                                    }
                                }
                            }
                            if (!handled && _instruction.isForwardConditionalBranchTarget() && this.tail.isBranch() && this.tail.asBranch().isReverseUnconditional()) {
                                InstructionSet.Branch lastForwardUnconditional2;
                                lastForwardConditional = _instruction.getForwardConditionalBranches().getLast();
                                branchSet = lastForwardConditional.getOrCreateBranchSet();
                                InstructionSet.Branch reverseGoto = this.tail.asBranch();
                                Instruction loopBackTarget = reverseGoto.getTarget();
                                if (loopBackTarget.getReverseUnconditionalBranches().size() > 1) {
                                    throw new ClassParseException(ClassParseException.TYPE.CONFUSINGBRANCHESPOSSIBLYCONTINUE);
                                }
                                if (_instruction.isForwardUnconditionalBranchTarget() && (lastForwardUnconditional2 = _instruction.getForwardUnconditionalBranches().getLast()) != null && lastForwardUnconditional2.isAfter(lastForwardConditional)) {
                                    throw new ClassParseException(ClassParseException.TYPE.CONFUSINGBRANCHESPOSSIBLYBREAK);
                                }
                                if (loopBackTarget != branchSet.getFirst().getStartInstruction()) {
                                    Instruction loopbackTargetRoot = loopBackTarget.getRootExpr();
                                    if (loopbackTargetRoot.isBranch() && loopbackTargetRoot.asBranch().isConditional()) {
                                        InstructionSet.ConditionalBranch topOfRealLoop = (InstructionSet.ConditionalBranch)loopbackTargetRoot.asBranch();
                                        BranchSet extentBranchSet = topOfRealLoop.getBranchSet();
                                        if (topOfRealLoop.getBranchSet() == null) {
                                            extentBranchSet = topOfRealLoop.findEndOfConditionalBranchSet(_instruction.getNextPC()).getOrCreateBranchSet();
                                        }
                                        if (this.doesNotContainCompositeOrBranch(extentBranchSet.getLast().getNextExpr(), reverseGoto)) {
                                            ClassModel.LocalVariableInfo localVariableInfo;
                                            Instruction loopTop = topOfRealLoop.getPrevExpr();
                                            if (loopTop instanceof InstructionSet.AssignToLocalVariable && (localVariableInfo = ((InstructionSet.AssignToLocalVariable)((Object)loopTop)).getLocalVariableInfo()).getStart() == loopTop.getNextExpr().getStartPC() && localVariableInfo.getEnd() == _instruction.getThisPC()) {
                                                loopTop = loopTop.getPrevExpr();
                                            }
                                            extentBranchSet.unhook();
                                            this.addAsComposites(InstructionSet.ByteCode.COMPOSITE_FOR_SUN, loopTop, extentBranchSet);
                                            InstructionSet.FakeGoto fakeGoto = new InstructionSet.FakeGoto(this.methodModel, extentBranchSet.getLast().getTarget());
                                            this.add(fakeGoto);
                                            extentBranchSet.getLast().getTarget().addBranchTarget(fakeGoto);
                                            handled = true;
                                        }
                                    }
                                } else if (this.doesNotContainCompositeOrBranch(branchSet.getLast().getNextExpr(), reverseGoto)) {
                                    ClassModel.LocalVariableInfo localVariableInfo;
                                    Instruction loopTop = reverseGoto.getTarget().getRootExpr().getPrevExpr();
                                    if (logger.isLoggable(Level.FINEST)) {
                                        System.out.println("### for/while candidate exprs: " + branchSet.getFirst());
                                        for (Instruction next = branchSet.getFirst().getNextExpr(); next != null; next = next.getNextExpr()) {
                                            System.out.println("### expr = " + next);
                                        }
                                    }
                                    if (loopTop instanceof InstructionSet.AssignToLocalVariable && (localVariableInfo = ((InstructionSet.AssignToLocalVariable)((Object)loopTop)).getLocalVariableInfo()) != null && localVariableInfo.getStart() == loopTop.getNextExpr().getStartPC() && localVariableInfo.getEnd() == _instruction.getThisPC()) {
                                        loopTop = loopTop.getPrevExpr();
                                    }
                                    branchSet.unhook();
                                    if (reverseGoto.getPrevExpr() instanceof InstructionSet.CompositeArbitraryScopeInstruction) {
                                        this.addAsComposites(InstructionSet.ByteCode.COMPOSITE_WHILE, loopTop, branchSet);
                                    } else {
                                        this.addAsComposites(InstructionSet.ByteCode.COMPOSITE_FOR_SUN, loopTop, branchSet);
                                    }
                                    handled = true;
                                }
                            }
                            if (!handled && !this.tail.isForwardBranch() && _instruction.isForwardConditionalBranchTarget() && this.doesNotContainContinueOrBreak((branchSet = (lastForwardConditional = _instruction.getForwardConditionalBranches().getLast()).getOrCreateBranchSet()).getLast().getNextExpr(), _instruction)) {
                                branchSet.unhook();
                                this.addAsComposites(InstructionSet.ByteCode.COMPOSITE_IF, branchSet.getFirst().getPrevExpr(), branchSet);
                                handled = true;
                            }
                            if (handled || this.tail.isForwardBranch() || !_instruction.isForwardUnconditionalBranchTarget() || !(afterGoto = (lastForwardUnconditional = (forwardUnconditionalBranches = _instruction.getForwardUnconditionalBranches()).getLast()).getNextExpr()).getStartInstruction().isForwardConditionalBranchTarget()) break block42;
                            LinkedList<InstructionSet.ConditionalBranch> forwardConditionalBranches = afterGoto.getStartInstruction().getForwardConditionalBranches();
                            InstructionSet.ConditionalBranch lastForwardConditional2 = forwardConditionalBranches.getLast();
                            BranchSet branchSet3 = lastForwardConditional2.getOrCreateBranchSet();
                            if (!this.doesNotContainCompositeOrBranch(branchSet3.getLast().getNextExpr(), lastForwardUnconditional)) break block43;
                            if (!this.doesNotContainContinueOrBreak(afterGoto.getNextExpr(), _instruction)) break block42;
                            branchSet3.unhook();
                            lastForwardUnconditional.unhook();
                            this.addAsComposites(InstructionSet.ByteCode.COMPOSITE_IF_ELSE, branchSet3.getFirst().getPrevExpr(), branchSet3);
                            handled = true;
                            break block42;
                        }
                        ExpressionList newHeadTail = new ExpressionList(this.methodModel, this, lastForwardUnconditional);
                        handled = newHeadTail.foldComposite(lastForwardUnconditional.getStartInstruction());
                        newHeadTail.unwind();
                        if (!handled && forwardUnconditionalBranches.size() > 1) {
                            for (int i = forwardUnconditionalBranches.size(); i > 1; --i) {
                                BranchSet elseBranchSet;
                                InstructionSet.Branch thisGoto = forwardUnconditionalBranches.get(i - 1);
                                InstructionSet.Branch elseGoto = forwardUnconditionalBranches.get(i - 2);
                                Instruction afterElseGoto = elseGoto.getNextExpr();
                                if (!afterElseGoto.getStartInstruction().isConditionalBranchTarget() || !this.doesNotContainCompositeOrBranch((elseBranchSet = afterElseGoto.getStartInstruction().getForwardConditionalBranches().getLast().getOrCreateBranchSet()).getLast().getNextExpr(), elseGoto) || !this.doesNotContainCompositeOrBranch(afterElseGoto.getNextExpr(), thisGoto)) continue;
                                if (logger.isLoggable(Level.FINE)) {
                                    System.out.println(this.dumpDiagram(_instruction));
                                }
                                elseBranchSet.unhook();
                                elseGoto.unhook();
                                if (logger.isLoggable(Level.FINE)) {
                                    System.out.println(this.dumpDiagram(_instruction));
                                }
                                InstructionSet.CompositeInstruction composite = InstructionSet.CompositeInstruction.create(InstructionSet.ByteCode.COMPOSITE_IF_ELSE, this.methodModel, elseBranchSet.getFirst(), thisGoto, elseBranchSet);
                                this.replaceInclusive(elseBranchSet.getFirst(), thisGoto.getPrevExpr(), composite);
                                handled = true;
                                break;
                            }
                        }
                    }
                    if (!handled && !this.tail.isForwardBranch() && _instruction.isForwardConditionalBranchTarget() && _instruction.isForwardUnconditionalBranchTarget()) {
                        InstructionSet.Branch lastForwardUnconditional = _instruction.getForwardUnconditionalBranches().getLast();
                        InstructionSet.ConditionalBranch lastForwardConditional = _instruction.getStartInstruction().getForwardConditionalBranches().getLast();
                        if (lastForwardConditional.getTarget().isAfter(lastForwardUnconditional)) {
                            lastForwardConditional.retarget(lastForwardUnconditional);
                            ExpressionList newHeadTail = new ExpressionList(this.methodModel, this, lastForwardUnconditional);
                            handled = newHeadTail.foldComposite(lastForwardUnconditional.getStartInstruction());
                            newHeadTail.unwind();
                        }
                    }
                    if (handled) continue;
                    break block40;
                }
                break block40;
            }
            ClassModel.LocalVariableTableEntry localVariableTable = this.methodModel.getMethod().getLocalVariableTableEntry();
            int startPc = Short.MAX_VALUE;
            for (ClassModel.LocalVariableInfo localVariableInfo : localVariableTable) {
                if (localVariableInfo.getEnd() != _instruction.getThisPC()) continue;
                logger.fine(localVariableInfo.getVariableName() + "  scope  " + localVariableInfo.getStart() + " ," + localVariableInfo.getEnd());
                if (localVariableInfo.getStart() >= startPc) continue;
                startPc = localVariableInfo.getStart();
            }
            if (startPc < Short.MAX_VALUE) {
                logger.fine("Scope block from " + startPc + " to  " + (this.tail.getThisPC() + this.tail.getLength()));
                for (Instruction i = this.head; i != null; i = i.getNextPC()) {
                    if (i.getThisPC() != startPc) continue;
                    Instruction j = i.getRootExpr().getPrevExpr();
                    Instruction startInstruction = j == null ? i : j;
                    logger.fine("Start = " + startInstruction);
                    this.addAsComposites(InstructionSet.ByteCode.COMPOSITE_ARBITRARY_SCOPE, startInstruction.getPrevExpr(), null);
                    handled = true;
                    break;
                }
            }
        }
        if (Config.instructionListener != null) {
            Config.instructionListener.showAndTell("after folding", this.head, _instruction);
        }
        return handled;
    }

    private void addAsComposites(InstructionSet.ByteCode _byteCode, Instruction _start, BranchSet _branchSet) {
        Instruction childTail = this.tail;
        Instruction childHead = this.createList(_start);
        InstructionSet.CompositeInstruction composite = InstructionSet.CompositeInstruction.create(_byteCode, this.methodModel, childHead, childTail, _branchSet);
        this.add(composite);
    }

    public String dumpDiagram(Instruction _instruction) {
        Instruction i;
        StringBuilder sb = new StringBuilder();
        ArrayList<Instruction> list = new ArrayList<Instruction>();
        for (i = this.head; i != null; i = i.getNextExpr()) {
            list.add(i);
        }
        for (i = _instruction; i != null; i = i.getNextPC()) {
            list.add(i);
        }
        Instruction[] array = list.toArray(new Instruction[0]);
        boolean lastWasCursor = false;
        ArrayList<InstructionSet.Branch> branches = new ArrayList<InstructionSet.Branch>();
        for (Instruction i2 : list) {
            sb.append(String.format(" %3d", i2.getStartPC()));
        }
        sb.append("\n");
        for (Instruction i2 : list) {
            sb.append(String.format(" %3d", i2.getThisPC()));
        }
        sb.append("\n");
        for (Instruction i2 : list) {
            if (i2 == _instruction) {
                sb.append(" [");
                lastWasCursor = true;
            } else if (lastWasCursor) {
                sb.append("] ");
                lastWasCursor = false;
            } else {
                sb.append("  ");
            }
            if (i2.isBranch() && i2.asBranch().isConditional()) {
                branches.add(i2.asBranch());
                if (i2.asBranch().isForward()) {
                    sb.append("?>");
                    continue;
                }
                sb.append("?<");
                continue;
            }
            if (i2.isBranch() && i2.asBranch().isUnconditional()) {
                branches.add(i2.asBranch());
                if (i2.asBranch().isForward()) {
                    sb.append(">>");
                    continue;
                }
                sb.append("<<");
                continue;
            }
            if (i2 instanceof InstructionSet.CompositeInstruction) {
                sb.append(" C");
                continue;
            }
            if (i2 instanceof InstructionSet.Return) {
                sb.append(" R");
                continue;
            }
            sb.append("..");
        }
        if (lastWasCursor) {
            sb.append("] ");
        } else {
            sb.append("  ");
        }
        for (InstructionSet.Branch b : branches) {
            int i3;
            sb.append("\n   ");
            if (b.isForward()) {
                for (i3 = 0; i3 < array.length; ++i3) {
                    if (array[i3].getStartPC() < b.getStartPC() || array[i3].getThisPC() > b.getTarget().getThisPC()) {
                        sb.append("    ");
                        continue;
                    }
                    if (b.isConditional()) {
                        sb.append("?-");
                    } else {
                        sb.append("+-");
                    }
                    ++i3;
                    while (i3 < array.length && array[i3].getStartPC() < b.getTarget().getThisPC()) {
                        sb.append("----");
                        ++i3;
                    }
                    sb.append("->");
                    sb.append(b.getTarget().getThisPC());
                }
                continue;
            }
            for (i3 = 0; i3 < array.length; ++i3) {
                if (array[i3].getStartPC() < b.getTarget().getThisPC() || array[i3].getThisPC() > b.getThisPC()) {
                    sb.append("    ");
                    continue;
                }
                sb.append("<-");
                ++i3;
                while (i3 < array.length && array[i3].getStartPC() < b.getThisPC()) {
                    sb.append("----");
                    ++i3;
                }
                if (b.isConditional()) {
                    sb.append("-?");
                    continue;
                }
                sb.append("-+");
            }
        }
        return sb.toString();
    }

    public Instruction getTail() {
        return this.tail;
    }

    public Instruction getHead() {
        return this.head;
    }
}

