/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.instruction;

import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.instruction.InstructionSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class BranchSet {
    private final List<InstructionSet.ConditionalBranch> set = new ArrayList<InstructionSet.ConditionalBranch>();
    private final Instruction fallThrough;
    private final Instruction target;
    private final InstructionSet.Branch last;
    private InstructionSet.Branch first;
    private LogicalExpressionNode logicalExpressionNode = null;

    public BranchSet(InstructionSet.Branch _branch) {
        this.target = _branch.getTarget();
        this.last = _branch;
        LinkedHashSet<InstructionSet.Branch> expandedSet = new LinkedHashSet<InstructionSet.Branch>();
        Instruction fallThroughRoot = this.last.getNextExpr();
        this.fallThrough = fallThroughRoot == null ? this.last.getNextPC() : fallThroughRoot.getStartInstruction();
        this.first = this.last;
        while (this.first.getPrevExpr() != null && this.first.getPrevExpr().isBranch() && this.first.getPrevExpr().asBranch().isConditional()) {
            Instruction prevBranchTarget = this.first.getPrevExpr().asBranch().getTarget();
            Instruction prevBranchTargetRoot = prevBranchTarget.getRootExpr();
            if (prevBranchTarget != this.target && prevBranchTarget != this.fallThrough && !expandedSet.contains(prevBranchTargetRoot)) break;
            expandedSet.add(this.first);
            this.first = this.first.getPrevExpr().asBranch();
        }
        for (Instruction i = this.first; i != fallThroughRoot; i = i.getNextExpr()) {
            this.set.add((InstructionSet.ConditionalBranch)i.asBranch());
            ((InstructionSet.ConditionalBranch)i.asBranch()).setBranchSet(this);
        }
        LogicalExpressionNode end = null;
        for (InstructionSet.ConditionalBranch cb : this.set) {
            SimpleLogicalExpressionNode sn = new SimpleLogicalExpressionNode(cb);
            if (this.logicalExpressionNode == null) {
                this.logicalExpressionNode = sn;
            } else {
                end.setNext(sn);
            }
            end = sn;
        }
        int count = 0;
        block3: while (this.logicalExpressionNode.next != null) {
            if (++count > 20) {
                throw new IllegalStateException("Sanity check, we seem to have >20 iterations collapsing logical expression");
            }
            LogicalExpressionNode n = this.logicalExpressionNode;
            LogicalExpressionNode prev = null;
            int i = 0;
            while (n != null && n.getNext() != null) {
                if (n.getTarget() == n.getNext().getTarget() || n.getTarget() == n.getNext().getFallThrough()) {
                    CompoundLogicalExpressionNode newNode = null;
                    if (n.getTarget() == n.getNext().getTarget()) {
                        newNode = new CompoundLogicalExpressionNode(false, n, n.getNext());
                    } else if (n.getTarget() == n.getNext().getFallThrough()) {
                        newNode = new CompoundLogicalExpressionNode(true, n, n.getNext());
                    }
                    if (n == this.logicalExpressionNode) {
                        this.logicalExpressionNode = newNode;
                    }
                    if (prev == null) continue block3;
                    prev.setNext(newNode);
                    continue block3;
                }
                prev = n;
                n = n.getNext();
                ++i;
            }
        }
    }

    public List<InstructionSet.ConditionalBranch> getBranches() {
        return this.set;
    }

    public InstructionSet.Branch getFirst() {
        return this.first;
    }

    public InstructionSet.Branch getLast() {
        return this.last;
    }

    public void unhook() {
        for (InstructionSet.Branch branch : this.set) {
            branch.unhook();
        }
    }

    public Instruction getTarget() {
        return this.target;
    }

    public Instruction getFallThrough() {
        return this.fallThrough;
    }

    public LogicalExpressionNode getLogicalExpression() {
        return this.logicalExpressionNode;
    }

    public static class CompoundLogicalExpressionNode
    extends LogicalExpressionNode {
        private final LogicalExpressionNode lhs;
        private final LogicalExpressionNode rhs;
        private boolean and;

        private CompoundLogicalExpressionNode(boolean _and, LogicalExpressionNode _lhs, LogicalExpressionNode _rhs, boolean applyInverts) {
            this.lhs = _lhs;
            this.and = _and;
            this.rhs = _rhs;
            this.setNext(_rhs.getNext());
            if (applyInverts && this.and) {
                this.lhs.invert();
            }
            this.rhs.setParent(this);
            this.lhs.setParent(this);
        }

        public CompoundLogicalExpressionNode(boolean _and, LogicalExpressionNode _lhs, LogicalExpressionNode _rhs) {
            this(_and, _lhs, _rhs, true);
        }

        @Override
        public int getTarget() {
            return this.rhs.getTarget();
        }

        @Override
        public void invert() {
            this.and = !this.and;
            this.lhs.invert();
            this.rhs.invert();
        }

        @Override
        public LogicalExpressionNode cloneInverted() {
            return new CompoundLogicalExpressionNode(!this.and, this.lhs.cloneInverted(), this.rhs.cloneInverted(), false);
        }

        public boolean isAnd() {
            return this.and;
        }

        @Override
        public int getFallThrough() {
            return this.rhs.getFallThrough();
        }

        public LogicalExpressionNode getLhs() {
            return this.lhs;
        }

        public LogicalExpressionNode getRhs() {
            return this.rhs;
        }

        public String toString() {
            return this.getLhs().toString() + " " + (this.isAnd() ? "&&" : "||") + " " + this.getRhs().toString();
        }
    }

    public static class SimpleLogicalExpressionNode
    extends LogicalExpressionNode {
        private final InstructionSet.ConditionalBranch branch;
        private boolean invert;

        public SimpleLogicalExpressionNode(InstructionSet.ConditionalBranch _branch) {
            this(_branch, false);
        }

        private SimpleLogicalExpressionNode(InstructionSet.ConditionalBranch _branch, boolean _invert) {
            this.branch = _branch;
            this.invert = _invert;
        }

        @Override
        public int getTarget() {
            return this.getBranch().getTarget().getThisPC();
        }

        @Override
        public void invert() {
            this.invert = !this.invert;
        }

        @Override
        public LogicalExpressionNode cloneInverted() {
            return new SimpleLogicalExpressionNode(this.branch, !this.invert);
        }

        @Override
        public int getFallThrough() {
            return this.getBranch().getNextPC().getThisPC();
        }

        public boolean isInvert() {
            return this.invert;
        }

        public InstructionSet.ConditionalBranch getBranch() {
            return this.branch;
        }

        public String toString() {
            return this.invert ? "!(" + this.getBranch() + ")" : this.getBranch().toString();
        }
    }

    public static abstract class LogicalExpressionNode {
        private LogicalExpressionNode next = null;
        private LogicalExpressionNode parent = null;

        public void setParent(LogicalExpressionNode _parent) {
            this.parent = _parent;
        }

        public abstract int getTarget();

        public abstract int getFallThrough();

        public abstract void invert();

        public abstract LogicalExpressionNode cloneInverted();

        public LogicalExpressionNode getRoot() {
            if (this.parent != null) {
                return this.parent;
            }
            return this;
        }

        public LogicalExpressionNode getNext() {
            return this.next == null ? this.next : this.next.getRoot();
        }

        public void setNext(LogicalExpressionNode _next) {
            this.next = _next == null ? _next : _next.getRoot();
        }

        public LogicalExpressionNode getParent() {
            return this.parent;
        }
    }
}

