/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.exception;

import com.aparapi.internal.exception.AparapiException;
import com.aparapi.internal.instruction.Instruction;

public class ClassParseException
extends AparapiException {
    private Instruction instruction;
    private TYPE type;

    public ClassParseException(TYPE _type) {
        super(_type.getDescription());
        this.type = _type;
        this.instruction = null;
    }

    public ClassParseException(Instruction _instruction, TYPE _type) {
        super("@" + _instruction.getThisPC() + " " + (Object)((Object)_instruction.getByteCode()) + " " + _type.getDescription());
        this.type = _type;
        this.instruction = _instruction;
    }

    public ClassParseException(TYPE _type, String _methodName) {
        super("@" + _methodName + " " + _type.getDescription());
        this.type = _type;
        this.instruction = null;
    }

    public ClassParseException(Throwable _t) {
        super(_t);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public TYPE getType() {
        return this.type;
    }

    public static enum TYPE {
        NONE("none"),
        ARRAY_RETURN("We don't support areturn instructions"),
        PUTFIELD("We don't support putstatic instructions"),
        INVOKEINTERFACE("We don't support invokeinterface instructions"),
        GETSTATIC("We don't support getstatic instructions"),
        ATHROW("We don't support athrow instructions"),
        SYNCHRONIZE("We don't support monitorenter or monitorexit instructions"),
        NEW("We don't support new instructions"),
        NEWARRAY("We don't support new array instructions"),
        NEWMULTIARRAY("We don't support new multi array instructions"),
        ARRAYALIAS("We don't support copying refs in kernels"),
        SWITCH("We don't support lookupswitch or tableswitch instructions"),
        METHODARRAYARG("We don't support passing arrays as method args"),
        RECURSION("We don't support recursion"),
        UNSUPPORTEDBYTECODE("This bytecode is not supported"),
        OPERANDCONSUMERPRODUCERMISSMATCH("Detected an non-reducable operand consumer/producer mismatch"),
        BADGETTERTYPEMISMATCH("Getter return type does not match field var type"),
        BADGETTERNAMEMISMATCH("Getter name does not match fiels name"),
        BADGETTERNAMENOTFOUND("Getter not found"),
        BADSETTERTYPEMISMATCH("Setter arg type does not match field var type"),
        EXCEPTION("We don't support catch blocks"),
        ARRAYLOCALVARIABLE("Found an array local variable which assumes that we will alias a field array"),
        CONFUSINGBRANCHESPOSSIBLYCONTINUE("we don't support continue"),
        CONFUSINGBRANCHESPOSSIBLYBREAK("we don't support break"),
        OBJECTFIELDREFERENCE("Using java objects inside kernels is not supported"),
        OBJECTARRAYFIELDREFERENCE("Object array elements cannot contain"),
        OVERRIDENFIELD("Found overidden field"),
        LOCALARRAYLENGTHACCESS("Found array length access on local array. Might be a result of using ForEach()"),
        ACCESSEDOBJECTNONFINAL("Kernel array object member class must be final."),
        ACCESSEDOBJECTFIELDNAMECONFLICT("Conflicting fields found in class hierarchy"),
        ACCESSEDOBJECTONLYSUPPORTSSIMPLEPUTFIELD("We don't support putfield instructions beyond simple setters"),
        ACCESSEDOBJECTSETTERARRAY("Passing array arguments to Intrinsics in expression form is not supported"),
        MULTIDIMENSIONARRAYASSIGN("Can't assign to two dimension array"),
        MULTIDIMENSIONARRAYACCESS("Can't access through a two dimensional array"),
        MISSINGLOCALVARIABLETABLE("Method does not contain a local variable table (recompile with -g?)"),
        IMPROPERPRIVATENAMEMANGLING("Could not parse private array size from field name");

        private String description;

        private TYPE(String _description) {
            this.description = _description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

