/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi;

import com.aparapi.Kernel;
import com.aparapi.device.Device;
import com.aparapi.internal.kernel.ProfilingEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ProfileReport {
    private static final int NUM_EVENTS = ProfilingEvent.values().length;
    private static final double MILLION = 1000000.0;
    private long id;
    private final Class<? extends Kernel> kernelClass;
    private final long threadId;
    private final Device device;
    private final long[] currentTimes = new long[NUM_EVENTS];
    private final String[] stagesNames;

    public ProfileReport(long _threadId, Class<? extends Kernel> clazz, Device _device) {
        this.threadId = _threadId;
        this.kernelClass = clazz;
        this.device = _device;
        this.stagesNames = ProfilingEvent.getStagesNames();
    }

    public void setProfileReport(long reportId, long[] _currentTimes) {
        this.id = reportId;
        System.arraycopy(_currentTimes, 0, this.currentTimes, 0, NUM_EVENTS);
    }

    public long getReportId() {
        return this.id;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public Class<? extends Kernel> getKernelClass() {
        return this.kernelClass;
    }

    public Device getDevice() {
        return this.device;
    }

    public List<String> getStageNames() {
        return Collections.unmodifiableList(Arrays.asList(this.stagesNames));
    }

    public int getNumberOfStages() {
        return this.stagesNames.length;
    }

    public String getStageName(int stage) {
        return this.stagesNames[stage];
    }

    public double getElapsedTime(int stage) {
        if (stage == ProfilingEvent.START.ordinal()) {
            return 0.0;
        }
        return (double)(this.currentTimes[stage] - this.currentTimes[stage - 1]) / 1000000.0;
    }

    public double getElapsedTime(int from, int to) {
        return (double)(this.currentTimes[to] - this.currentTimes[from]) / 1000000.0;
    }

    public double getExecutionTime() {
        return this.getElapsedTime(ProfilingEvent.START.ordinal(), ProfilingEvent.EXECUTED.ordinal());
    }

    public double getConversionTime() {
        return this.getElapsedTime(ProfilingEvent.START.ordinal(), ProfilingEvent.PREPARE_EXECUTE.ordinal());
    }

    public ProfileReport clone() {
        ProfileReport r = new ProfileReport(this.threadId, this.kernelClass, this.device);
        r.setProfileReport(this.id, this.currentTimes);
        return r;
    }
}

