/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import systems.uom.common.CGS;
import systems.uom.common.Imperial;
import systems.uom.common.USCustomary;
import tec.uom.lib.common.function.IntPrioritySupplier;

public class CommonSystemService
implements SystemOfUnitsService,
IntPrioritySupplier {
    static final int PRIO = 100;
    private static final String DEFAULT_SYSTEM_NAME = "USCustomary";
    private final Map<String, SystemOfUnits> souMap = new HashMap<String, SystemOfUnits>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public CommonSystemService() {
        this.souMap.put("Imperial", Imperial.getInstance());
        this.souMap.put(DEFAULT_SYSTEM_NAME, USCustomary.getInstance());
        this.souMap.put("CGS", (SystemOfUnits)CGS.getInstance());
        this.aliases.put("US", DEFAULT_SYSTEM_NAME);
        this.aliases.put("Centimetre\u2013gram\u2013second", "CGS");
    }

    public Collection<SystemOfUnits> getAvailableSystemsOfUnits() {
        return this.souMap.values();
    }

    public SystemOfUnits getSystemOfUnits() {
        return this.getSystemOfUnits(DEFAULT_SYSTEM_NAME);
    }

    public SystemOfUnits getSystemOfUnits(String name) {
        String alias = this.aliases.get(name);
        if (alias != null && alias.length() > 0) {
            return this.souMap.get(alias);
        }
        return this.souMap.get(name);
    }

    public int getPriority() {
        return 100;
    }
}

