/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.util;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.raster.PixelWithID;
import fr.inrae.act.bagap.apiland.raster.RefPoint;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.apiland.util.Tool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.csv.CsvWriter;

public class SpatialCsvManager {
    public static void merge(String outputCsv, String[] inputCsv) {
        try {
            LinkedHashMap values = new LinkedHashMap();
            LinkedHashMap<String, Integer> index = null;
            for (String icsv : inputCsv) {
                CsvReader reader = new CsvReader(icsv);
                reader.setDelimiter(';');
                reader.readHeaders();
                index = new LinkedHashMap<String, Integer>();
                for (int c = 0; c < reader.getHeaderCount(); ++c) {
                    String header = reader.getHeader(c);
                    if (header.equalsIgnoreCase("raster")) continue;
                    index.put(header, c);
                }
                while (reader.readRecord()) {
                    String name = reader.get("raster");
                    if (!values.containsKey(name)) {
                        values.put(name, new LinkedHashMap());
                    }
                    for (Map.Entry ind : index.entrySet()) {
                        ((Map)values.get(name)).put((String)ind.getKey(), reader.get(((Integer)ind.getValue()).intValue()));
                    }
                }
                reader.close();
            }
            CsvWriter cw = new CsvWriter(outputCsv);
            cw.setDelimiter(';');
            cw.write("raster");
            for (Map.Entry ind : ((Map)values.entrySet().iterator().next().getValue()).entrySet()) {
                cw.write((String)ind.getKey());
            }
            cw.endRecord();
            for (Map.Entry e1 : values.entrySet()) {
                cw.write((String)e1.getKey());
                for (Map.Entry e2 : ((Map)e1.getValue()).entrySet()) {
                    cw.write((String)e2.getValue());
                }
                cw.endRecord();
            }
            cw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void mergeById(String outputCsv, String[] inputCsv) {
        try {
            LinkedHashMap values = new LinkedHashMap();
            LinkedHashMap<String, Integer> index = null;
            for (String icsv : inputCsv) {
                CsvReader reader = new CsvReader(icsv);
                reader.setDelimiter(';');
                reader.readHeaders();
                index = new LinkedHashMap<String, Integer>();
                for (int c = 0; c < reader.getHeaderCount(); ++c) {
                    String header = reader.getHeader(c);
                    if (header.equalsIgnoreCase("id")) continue;
                    index.put(header, c);
                }
                while (reader.readRecord()) {
                    String name = reader.get("id");
                    if (!values.containsKey(name)) {
                        values.put(name, new LinkedHashMap());
                    }
                    for (Map.Entry ind : index.entrySet()) {
                        ((Map)values.get(name)).put((String)ind.getKey(), reader.get(((Integer)ind.getValue()).intValue()));
                    }
                }
                reader.close();
            }
            CsvWriter cw = new CsvWriter(outputCsv);
            cw.setDelimiter(';');
            cw.write("id");
            for (Map.Entry ind : ((Map)values.entrySet().iterator().next().getValue()).entrySet()) {
                cw.write((String)ind.getKey());
            }
            cw.endRecord();
            for (Map.Entry e1 : values.entrySet()) {
                cw.write((String)e1.getKey());
                for (Map.Entry e2 : ((Map)e1.getValue()).entrySet()) {
                    cw.write((String)e2.getValue());
                }
                cw.endRecord();
            }
            cw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void mergeSortXY(String totalCsv, String[] localCsv) {
        try {
            CsvReader cr;
            LinkedHashMap readers = new LinkedHashMap();
            for (String csv : localCsv) {
                cr = new CsvReader(csv);
                cr.setDelimiter(';');
                readers.put(cr, new LinkedHashMap());
                cr.readHeaders();
                for (int h = 0; h < cr.getHeaderCount(); ++h) {
                    String header = cr.getHeader(h);
                    if (header.equalsIgnoreCase("X") || header.equalsIgnoreCase("Y")) continue;
                    ((Map)readers.get(cr)).put(header, h);
                }
            }
            CsvWriter cw = new CsvWriter(totalCsv);
            cw.setDelimiter(';');
            cw.write("X");
            cw.write("Y");
            for (String header : ((Map)readers.entrySet().iterator().next().getValue()).keySet()) {
                cw.write(header);
            }
            cw.endRecord();
            TreeMap<RefPoint, CsvReader> next = new TreeMap<RefPoint, CsvReader>();
            for (CsvReader cr2 : readers.keySet()) {
                cr2.readRecord();
                RefPoint p = new RefPoint(Double.parseDouble(cr2.get("X")), Double.parseDouble(cr2.get("Y")));
                next.put(p, cr2);
            }
            while (next.size() > 0) {
                Map.Entry entry = next.entrySet().iterator().next();
                RefPoint rp = (RefPoint)entry.getKey();
                next.remove(rp);
                cr = (CsvReader)entry.getValue();
                cw.write(rp.getX() + "");
                cw.write(rp.getY() + "");
                Iterator h = ((Map)readers.get(cr)).values().iterator();
                while (h.hasNext()) {
                    int ind = (Integer)h.next();
                    cw.write(cr.get(ind));
                }
                cw.endRecord();
                if (cr.readRecord()) {
                    RefPoint p = new RefPoint(Double.parseDouble(cr.get("X")), Double.parseDouble(cr.get("Y")));
                    next.put(p, cr);
                    continue;
                }
                cr.close();
            }
            cw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void mergeXY(String outputCsv, String[] inputCsv, String[] suffixCsv, String idX, String idY, EnteteRaster entete) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputCsv));
            bw.write("X;Y");
            LinkedHashMap readers = new LinkedHashMap();
            for (String icsv : inputCsv) {
                CsvReader reader = new CsvReader(icsv);
                reader.setDelimiter(';');
                reader.readHeaders();
                HashSet<Integer> index = new HashSet<Integer>();
                for (int c = 0; c < reader.getHeaderCount(); ++c) {
                    if (idX.equalsIgnoreCase(reader.getHeader(c)) || idY.equalsIgnoreCase(reader.getHeader(c))) continue;
                    index.add(c);
                }
                readers.put(reader, index);
            }
            int is = 0;
            for (Map.Entry r : readers.entrySet()) {
                String suffix = suffixCsv[is++];
                Iterator c = ((Set)r.getValue()).iterator();
                while (c.hasNext()) {
                    int ind = (Integer)c.next();
                    bw.write(";" + ((CsvReader)r.getKey()).getHeader(ind) + suffix);
                }
            }
            bw.newLine();
            HashMap waits = new HashMap();
            StringBuilder local = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < entete.height(); ++j) {
                for (int i = 0; i < entete.width(); ++i) {
                    boolean export = false;
                    RefPoint lp = new RefPoint(CoordinateManager.getProjectedX(entete, i), CoordinateManager.getProjectedY(entete, j));
                    local.setLength(0);
                    for (Map.Entry r : readers.entrySet()) {
                        int ind;
                        if (waits.containsKey(r.getKey()) && ((Map)waits.get(r.getKey())).containsKey(lp)) {
                            local.append((String)((Map)waits.get(r.getKey())).remove(lp));
                            export = true;
                            continue;
                        }
                        if (((CsvReader)r.getKey()).readRecord()) {
                            sb.setLength(0);
                            Iterator iterator = ((Set)r.getValue()).iterator();
                            while (iterator.hasNext()) {
                                ind = (Integer)iterator.next();
                                sb.append(";" + ((CsvReader)r.getKey()).get(ind));
                            }
                            double xx = Double.parseDouble(((CsvReader)r.getKey()).get(idX));
                            double yy = Double.parseDouble(((CsvReader)r.getKey()).get(idY));
                            if (lp.getX() == xx && lp.getY() == yy) {
                                local.append(sb.toString());
                                export = true;
                                continue;
                            }
                            if (!waits.containsKey(r.getKey())) {
                                waits.put((CsvReader)r.getKey(), new HashMap());
                            }
                            ((Map)waits.get(r.getKey())).put(new RefPoint(xx, yy), sb.toString());
                            Iterator iterator2 = ((Set)r.getValue()).iterator();
                            while (iterator2.hasNext()) {
                                int ind2 = (Integer)iterator2.next();
                                local.append(";" + entete.noDataValue());
                            }
                            continue;
                        }
                        Iterator iterator = ((Set)r.getValue()).iterator();
                        while (iterator.hasNext()) {
                            ind = (Integer)iterator.next();
                            local.append(";" + entete.noDataValue());
                        }
                    }
                    if (!export) continue;
                    bw.write(lp.getX() + ";");
                    bw.write(lp.getY() + "");
                    bw.write(local.toString());
                    bw.newLine();
                }
            }
            bw.close();
            for (CsvReader r : readers.keySet()) {
                r.close();
            }
            readers.clear();
            readers = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void mergeXYOld(String outputCsv, String[] inputCsv, String[] suffixCsv, String idX, String idY, EnteteRaster entete) {
        try {
            CsvWriter cw = new CsvWriter(outputCsv);
            cw.setDelimiter(';');
            cw.write(idX);
            cw.write(idY);
            LinkedHashMap readers = new LinkedHashMap();
            for (String icsv : inputCsv) {
                CsvReader reader = new CsvReader(icsv);
                reader.setDelimiter(';');
                reader.readHeaders();
                HashSet<Integer> index = new HashSet<Integer>();
                for (int c = 0; c < reader.getHeaderCount(); ++c) {
                    if (idX.equalsIgnoreCase(reader.getHeader(c)) || idY.equalsIgnoreCase(reader.getHeader(c))) continue;
                    index.add(c);
                }
                readers.put(reader, index);
            }
            int is = 0;
            for (Map.Entry r : readers.entrySet()) {
                String suffix = suffixCsv[is++];
                Iterator c = ((Set)r.getValue()).iterator();
                while (c.hasNext()) {
                    int ind = (Integer)c.next();
                    cw.write(((CsvReader)r.getKey()).getHeader(ind) + suffix);
                }
            }
            cw.endRecord();
            HashMap waits = new HashMap();
            for (int j = 0; j < entete.height(); ++j) {
                for (int i = 0; i < entete.width(); ++i) {
                    boolean export = false;
                    RefPoint lp = new RefPoint(CoordinateManager.getProjectedX(entete, i), CoordinateManager.getProjectedY(entete, j));
                    LinkedHashMap<CsvReader, List> local = new LinkedHashMap<CsvReader, List>();
                    for (Map.Entry r : readers.entrySet()) {
                        int ind;
                        Iterator iterator;
                        ArrayList<String> values;
                        if (waits.containsKey(r.getKey())) {
                            if (((Map)waits.get(r.getKey())).containsKey(lp)) {
                                local.put((CsvReader)r.getKey(), (List)((Map)waits.get(r.getKey())).get(lp));
                                waits.remove(r.getKey());
                                export = true;
                                continue;
                            }
                            values = new ArrayList();
                            iterator = ((Set)r.getValue()).iterator();
                            while (iterator.hasNext()) {
                                ind = (Integer)iterator.next();
                                values.add(entete.noDataValue() + "");
                            }
                            local.put((CsvReader)r.getKey(), values);
                            continue;
                        }
                        if (((CsvReader)r.getKey()).readRecord()) {
                            RefPoint rp = new RefPoint(Double.parseDouble(((CsvReader)r.getKey()).get(idX)), Double.parseDouble(((CsvReader)r.getKey()).get(idY)));
                            values = new ArrayList();
                            iterator = ((Set)r.getValue()).iterator();
                            while (iterator.hasNext()) {
                                ind = (Integer)iterator.next();
                                values.add(((CsvReader)r.getKey()).get(ind));
                            }
                            if (rp.equals(lp)) {
                                local.put((CsvReader)r.getKey(), values);
                                export = true;
                                continue;
                            }
                            if (!waits.containsKey(r.getKey())) {
                                waits.put((CsvReader)r.getKey(), new HashMap());
                            }
                            ((Map)waits.get(r.getKey())).put(rp, values);
                            values = new ArrayList();
                            iterator = ((Set)r.getValue()).iterator();
                            while (iterator.hasNext()) {
                                ind = (Integer)iterator.next();
                                values.add(entete.noDataValue() + "");
                            }
                            local.put((CsvReader)r.getKey(), values);
                            continue;
                        }
                        values = new ArrayList<String>();
                        iterator = ((Set)r.getValue()).iterator();
                        while (iterator.hasNext()) {
                            ind = (Integer)iterator.next();
                            values.add(entete.noDataValue() + "");
                        }
                        local.put((CsvReader)r.getKey(), values);
                    }
                    if (!export) continue;
                    cw.write(CoordinateManager.getProjectedX(entete, i) + "");
                    cw.write(CoordinateManager.getProjectedY(entete, j) + "");
                    for (Map.Entry r : local.entrySet()) {
                        for (String v : (List)r.getValue()) {
                            cw.write(v);
                        }
                    }
                    cw.endRecord();
                }
            }
            cw.close();
            for (CsvReader r : readers.keySet()) {
                r.close();
            }
            readers.clear();
            readers = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeFromPixels(String outputCsv, String[] inputCsv, String[] suffixCsv, EnteteRaster entete, Set<Pixel> pixels) {
        try {
            void var15_15;
            boolean isPixelWithID = pixels.iterator().next() instanceof PixelWithID;
            LinkedHashMap values = new LinkedHashMap();
            for (Pixel p : pixels) {
                values.put(p, new LinkedHashMap());
            }
            int is = 0;
            String[] stringArray = inputCsv;
            int n = stringArray.length;
            boolean bl = false;
            while (var15_15 < n) {
                String icsv = stringArray[var15_15];
                String suffix = suffixCsv[is++];
                CsvReader reader = new CsvReader(icsv);
                reader.setDelimiter(';');
                reader.readHeaders();
                LinkedHashMap<String, Integer> index = new LinkedHashMap<String, Integer>();
                for (int c = 0; c < reader.getHeaderCount(); ++c) {
                    String header = reader.getHeader(c);
                    if (header.equalsIgnoreCase("ID") || header.equalsIgnoreCase("X") || header.equalsIgnoreCase("Y")) continue;
                    index.put(header, c);
                    for (Pixel p : pixels) {
                        if (((Map)values.get(p)).containsKey(header + suffix)) continue;
                        ((Map)values.get(p)).put(header + suffix, entete.noDataValue() + "");
                    }
                }
                String id = null;
                while (reader.readRecord()) {
                    double X = Double.parseDouble(reader.get("X"));
                    double Y = Double.parseDouble(reader.get("Y"));
                    if (isPixelWithID) {
                        id = reader.get("id");
                    }
                    Pixel p = null;
                    for (Pixel pixel : pixels) {
                        if (isPixelWithID) {
                            if (X != ((PixelWithID)pixel).getX() || Y != ((PixelWithID)pixel).getY() || !id.equalsIgnoreCase(((PixelWithID)pixel).getId())) continue;
                            p = pixel;
                            break;
                        }
                        if (X != CoordinateManager.getProjectedX(entete, pixel.x()) || Y != CoordinateManager.getProjectedY(entete, pixel.y())) continue;
                        p = pixel;
                        break;
                    }
                    for (Map.Entry entry : index.entrySet()) {
                        ((Map)values.get(p)).put((String)entry.getKey() + suffix, reader.get(((Integer)entry.getValue()).intValue()));
                    }
                }
                reader.close();
                ++var15_15;
            }
            CsvWriter cw = new CsvWriter(outputCsv);
            cw.setDelimiter(';');
            if (isPixelWithID) {
                cw.write("ID");
            }
            cw.write("X");
            cw.write("Y");
            for (String string : ((Map)values.get(pixels.iterator().next())).keySet()) {
                cw.write(string);
            }
            cw.endRecord();
            for (Map.Entry entry : values.entrySet()) {
                Pixel p = (Pixel)entry.getKey();
                if (isPixelWithID) {
                    cw.write(((PixelWithID)p).getId());
                    cw.write(((PixelWithID)p).getX() + "");
                    cw.write(((PixelWithID)p).getY() + "");
                } else {
                    cw.write(CoordinateManager.getProjectedX(entete, p.x()) + "");
                    cw.write(CoordinateManager.getProjectedY(entete, p.y()) + "");
                }
                for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                    cw.write((String)e2.getValue());
                }
                cw.endRecord();
            }
            cw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void mergeMapPixels(String outputCsv, Map<String, String> localCsv, int noDataValue, Set<Pixel> pixels) {
        try {
            HashMap<String, CsvReader> readers = new HashMap<String, CsvReader>();
            ArrayList<String> headers = new ArrayList<String>();
            for (String string : localCsv.keySet()) {
                CsvReader cr = new CsvReader(string);
                cr.setDelimiter(';');
                readers.put(string, cr);
                cr.readHeaders();
                if (headers.size() != 0) continue;
                for (int h = 0; h < cr.getHeaderCount(); ++h) {
                    String header = cr.getHeader(h);
                    if (header.equalsIgnoreCase("ID") || header.equalsIgnoreCase("X") || header.equalsIgnoreCase("Y")) continue;
                    headers.add(header);
                }
            }
            CsvWriter cw = new CsvWriter(outputCsv);
            cw.setDelimiter(';');
            cw.write("ID");
            cw.write("X");
            cw.write("Y");
            cw.write("RASTER");
            for (String header : headers) {
                cw.write(header);
            }
            cw.endRecord();
            String tmpID = null;
            String tmpX = null;
            String tmpY = null;
            for (Pixel pixel : pixels) {
                boolean writeOk = false;
                for (String csv : localCsv.keySet()) {
                    boolean bl;
                    boolean bl2 = false;
                    CsvReader cr = (CsvReader)readers.get(csv);
                    cr.readRecord();
                    tmpID = cr.get("ID");
                    tmpX = cr.get("X");
                    tmpY = cr.get("Y");
                    for (String header : headers) {
                        double v = Double.parseDouble(cr.get(header));
                        if (v == (double)noDataValue) continue;
                        bl = true;
                        writeOk = true;
                        break;
                    }
                    if (!bl) continue;
                    cw.write(cr.get("ID"));
                    cw.write(cr.get("X"));
                    cw.write(cr.get("Y"));
                    cw.write(localCsv.get(csv));
                    for (String header : headers) {
                        cw.write(cr.get(header));
                    }
                    cw.endRecord();
                }
                if (writeOk) continue;
                cw.write(tmpID);
                cw.write(tmpX);
                cw.write(tmpY);
                cw.write("");
                for (String header : headers) {
                    cw.write(noDataValue + "");
                }
                cw.endRecord();
            }
            cw.close();
            for (CsvReader cr : readers.values()) {
                cr.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportTab(float[] data, String csv, String variable, EnteteRaster entete) {
        double minX = entete.minx();
        double minY = entete.miny();
        int width = entete.width();
        int height = entete.height();
        float cellSize = entete.cellsize();
        int noDataValue = entete.noDataValue();
        try {
            CsvReader cr = new CsvReader(csv);
            cr.setDelimiter(';');
            cr.readHeaders();
            cr.readRecord();
            double x = Double.parseDouble(cr.get("X"));
            double y = Double.parseDouble(cr.get("Y"));
            int i = 0;
            int j = 0;
            boolean ok = true;
            double nextY = minY + (double)((float)(height - 1) * cellSize) + (double)(cellSize / 2.0f);
            while (nextY >= minY) {
                i = 0;
                double nextX = minX + (double)cellSize - (double)(cellSize / 2.0f);
                while (nextX < minX + (double)((float)width * cellSize)) {
                    if (ok && Math.abs(y - nextY) < (double)cellSize / 2.0 && Math.abs(x - nextX) < (double)cellSize / 2.0) {
                        data[j * width + i] = Float.parseFloat(cr.get(variable));
                        if (cr.readRecord()) {
                            x = Double.parseDouble(cr.get("X"));
                            y = Double.parseDouble(cr.get("Y"));
                        } else {
                            ok = false;
                        }
                    } else {
                        data[j * width + i] = noDataValue;
                    }
                    nextX += (double)cellSize;
                    ++i;
                }
                nextY -= (double)cellSize;
                ++j;
            }
            cr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportTabs(float[][] datas, String csv, String[] variables, EnteteRaster entete) {
        double minX = entete.minx();
        double minY = entete.miny();
        int width = entete.width();
        int height = entete.height();
        float cellSize = entete.cellsize();
        int noDataValue = entete.noDataValue();
        try {
            CsvReader cr = new CsvReader(csv);
            cr.setDelimiter(';');
            cr.readHeaders();
            cr.readRecord();
            double x = Double.parseDouble(cr.get("X"));
            double y = Double.parseDouble(cr.get("Y"));
            int i = 0;
            int j = 0;
            double nextY = minY + (double)((float)(height - 1) * cellSize) + (double)(cellSize / 2.0f);
            while (nextY >= minY) {
                i = 0;
                double nextX = minX + (double)cellSize - (double)(cellSize / 2.0f);
                while (nextX < minX + (double)((float)width * cellSize)) {
                    int var;
                    if (Math.abs(y - nextY) < (double)cellSize / 2.0 && Math.abs(x - nextX) < (double)cellSize / 2.0) {
                        for (var = 0; var < variables.length; ++var) {
                            datas[var][j * width + i] = Float.parseFloat(cr.get(variables[var]));
                        }
                        if (cr.readRecord()) {
                            x = Double.parseDouble(cr.get("X"));
                            y = Double.parseDouble(cr.get("Y"));
                        }
                    } else {
                        for (var = 0; var < variables.length; ++var) {
                            datas[var][j * width + i] = noDataValue;
                        }
                    }
                    nextX += (double)cellSize;
                    ++i;
                }
                nextY -= (double)cellSize;
                ++j;
            }
            cr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportGeoTiff(String csv, String output, String variable, EnteteRaster entete) {
        double minX = entete.minx();
        double minY = entete.miny();
        int width = entete.width();
        int height = entete.height();
        float cellSize = entete.cellsize();
        int noDataValue = entete.noDataValue();
        float[] data = new float[width * height];
        try {
            CsvReader cr = new CsvReader(csv);
            cr.setDelimiter(';');
            cr.readHeaders();
            cr.readRecord();
            double x = Double.parseDouble(cr.get("X"));
            double y = Double.parseDouble(cr.get("Y"));
            int i = 0;
            int j = 0;
            double nextY = minY + (double)((float)(height - 1) * cellSize) + (double)(cellSize / 2.0f);
            while (nextY >= minY) {
                i = 0;
                double nextX = minX + (double)cellSize - (double)(cellSize / 2.0f);
                while (nextX < minX + (double)((float)width * cellSize)) {
                    if (Math.abs(y - nextY) < (double)cellSize / 2.0 && Math.abs(x - nextX) < (double)cellSize / 2.0) {
                        data[j * width + i] = Float.parseFloat(cr.get(variable));
                        if (cr.readRecord()) {
                            x = Double.parseDouble(cr.get("X"));
                            y = Double.parseDouble(cr.get("Y"));
                        }
                    } else {
                        data[j * width + i] = noDataValue;
                    }
                    nextX += (double)cellSize;
                    ++i;
                }
                nextY -= (double)cellSize;
                ++j;
            }
            CoverageManager.writeGeotiff(output, data, entete);
            cr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportRaster(String csv, String outputRaster, String variable, EnteteRaster entete) {
        double minX = entete.minx();
        double minY = entete.miny();
        int width = entete.width();
        int height = entete.height();
        float cellSize = entete.cellsize();
        int noDataValue = entete.noDataValue();
        float[] data = new float[width * height];
        try {
            CsvReader cr = new CsvReader(csv);
            cr.setDelimiter(';');
            cr.readHeaders();
            cr.readRecord();
            double x = Double.parseDouble(cr.get("X"));
            double y = Double.parseDouble(cr.get("Y"));
            int i = 0;
            int j = 0;
            double nextY = minY + (double)((float)(height - 1) * cellSize) + (double)(cellSize / 2.0f);
            while (nextY >= minY) {
                i = 0;
                double nextX = minX + (double)cellSize - (double)(cellSize / 2.0f);
                while (nextX < minX + (double)((float)width * cellSize)) {
                    if (Math.abs(y - nextY) < (double)cellSize / 2.0 && Math.abs(x - nextX) < (double)cellSize / 2.0) {
                        data[j * width + i] = Float.parseFloat(cr.get(variable));
                        if (cr.readRecord()) {
                            x = Double.parseDouble(cr.get("X"));
                            y = Double.parseDouble(cr.get("Y"));
                        }
                    } else {
                        data[j * width + i] = noDataValue;
                    }
                    nextX += (double)cellSize;
                    ++i;
                }
                nextY -= (double)cellSize;
                ++j;
            }
            CoverageManager.write(outputRaster, data, entete);
            cr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportAsciiGrid2(String csv, String folder, String outputName, Set<String> metrics, int width, int height, double minX, double minY, int delta, double cellSize, int noDataValue) {
        try {
            HashMap<Object, BufferedWriter> writers = new HashMap<Object, BufferedWriter>();
            CsvReader cr = new CsvReader(csv);
            cr.setDelimiter(';');
            cr.readHeaders();
            if (metrics != null && metrics.size() != 0) {
                for (String metric : metrics) {
                    for (String header : cr.getHeaders()) {
                        if (!header.contains(metric)) continue;
                        writers.put(header, new BufferedWriter(new FileWriter(folder + header + ".asc")));
                    }
                }
            } else {
                for (String header : cr.getHeaders()) {
                    if (header.equalsIgnoreCase("X") || header.equalsIgnoreCase("Y")) continue;
                    writers.put(header, new BufferedWriter(new FileWriter(folder + (String)header + ".asc")));
                }
            }
            for (BufferedWriter w : writers.values()) {
                int nc = new Double(width / delta).intValue();
                if (width % delta != 0) {
                    ++nc;
                }
                w.write("ncols " + nc + "\n");
                int nr = new Double(height / delta).intValue();
                if (height % delta != 0) {
                    ++nr;
                }
                w.write("nrows " + nr + "\n");
                w.write("xllcorner " + minX + "\n");
                w.write("yllcorner " + minY + "\n");
                w.write("cellsize " + (double)delta * cellSize + "\n");
                w.write("NODATA_value " + noDataValue + "\n");
            }
            double y = -1.0;
            while (cr.readRecord()) {
                double ytemp = Double.parseDouble(cr.get("Y"));
                if (y == -1.0) {
                    for (Map.Entry e : writers.entrySet()) {
                        ((BufferedWriter)e.getValue()).write(cr.get((String)e.getKey()) + "");
                    }
                    y = ytemp;
                    continue;
                }
                if (ytemp != y) {
                    for (Map.Entry e : writers.entrySet()) {
                        ((BufferedWriter)e.getValue()).write("\n" + cr.get((String)e.getKey()));
                    }
                    y = ytemp;
                    continue;
                }
                for (Map.Entry e : writers.entrySet()) {
                    ((BufferedWriter)e.getValue()).write(" " + cr.get((String)e.getKey()));
                }
            }
            for (Map.Entry e : writers.entrySet()) {
                ((BufferedWriter)e.getValue()).write(10);
                ((BufferedWriter)e.getValue()).close();
            }
            cr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportAsciiGrid(String csv, String folder, String outputAsc, Set<String> metrics, int width, int height, double minX, double minY, int delta, double cellSize, int noDataValue) {
        try {
            HashMap<Object, BufferedWriter> writers = new HashMap<Object, BufferedWriter>();
            String name = new File(csv).getName().replace(".csv", "");
            CsvReader cr = new CsvReader(csv);
            cr.setDelimiter(';');
            cr.readHeaders();
            if (metrics.size() == 1 && outputAsc != null) {
                for (String header : cr.getHeaders()) {
                    if (!header.equalsIgnoreCase(metrics.iterator().next())) continue;
                    writers.put(header, new BufferedWriter(new FileWriter(outputAsc)));
                }
            } else if (metrics != null && metrics.size() != 0) {
                for (String metric : metrics) {
                    for (String header : cr.getHeaders()) {
                        if (!header.equalsIgnoreCase(metric)) continue;
                        writers.put(header, new BufferedWriter(new FileWriter(folder + name + "_" + header + ".asc")));
                    }
                }
            } else {
                for (String header : cr.getHeaders()) {
                    if (header.equalsIgnoreCase("X") || header.equalsIgnoreCase("Y")) continue;
                    writers.put(header, new BufferedWriter(new FileWriter(folder + name + "_" + (String)header + ".asc")));
                }
            }
            for (BufferedWriter w : writers.values()) {
                int nc = new Double(width / delta).intValue();
                if (width % delta != 0) {
                    ++nc;
                }
                w.write("ncols " + nc);
                w.newLine();
                int nr = new Double(height / delta).intValue();
                if (height % delta != 0) {
                    ++nr;
                }
                w.write("nrows " + nr);
                w.newLine();
                w.write("xllcorner " + minX);
                w.newLine();
                w.write("yllcorner " + minY);
                w.newLine();
                w.write("cellsize " + (double)delta * cellSize);
                w.newLine();
                w.write("NODATA_value " + noDataValue);
                w.newLine();
            }
            cr.readRecord();
            double x = Double.parseDouble(cr.get("X"));
            double y = Double.parseDouble(cr.get("Y"));
            boolean ok = true;
            for (double nextY = minY + (double)(height - 1) * cellSize + cellSize / 2.0; nextY >= minY; nextY -= cellSize) {
                for (double nextX = minX + cellSize - cellSize / 2.0; nextX < minX + (double)width * cellSize; nextX += cellSize) {
                    if (Math.abs(y - nextY) < cellSize / 2.0 && Math.abs(x - nextX) < cellSize / 2.0) {
                        for (Map.Entry e : writers.entrySet()) {
                            ((BufferedWriter)e.getValue()).write(cr.get((String)e.getKey()) + " ");
                        }
                        if (!cr.readRecord()) continue;
                        x = Double.parseDouble(cr.get("X"));
                        y = Double.parseDouble(cr.get("Y"));
                        continue;
                    }
                    for (Map.Entry e : writers.entrySet()) {
                        ((BufferedWriter)e.getValue()).write(noDataValue + " ");
                    }
                }
                for (Map.Entry e : writers.entrySet()) {
                    ((BufferedWriter)e.getValue()).newLine();
                }
            }
            for (Map.Entry e : writers.entrySet()) {
                ((BufferedWriter)e.getValue()).close();
                try {
                    Tool.copy(CoverageManager.class.getResourceAsStream(CoverageManager.epsg()), folder + name + "_" + (String)e.getKey() + ".prj");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            cr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void exportFromAsciiGrid(String ascii, String csv) {
        String name = new File(ascii).getName().replace(".asc", "");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(ascii));
            String line = br.readLine();
            String sep = String.valueOf(line.charAt(5));
            String[] s = line.split(sep);
            int width = Integer.parseInt(s[s.length - 1]);
            s = br.readLine().split(sep);
            int height = Integer.parseInt(s[s.length - 1]);
            s = br.readLine().split(sep);
            double minx = Double.parseDouble(s[s.length - 1]);
            s = br.readLine().split(sep);
            double miny = Double.parseDouble(s[s.length - 1]);
            s = br.readLine().split(sep);
            double cellsize = Double.parseDouble(s[s.length - 1]);
            double maxx = minx + (double)width * cellsize;
            double maxy = miny + (double)height * cellsize;
            s = br.readLine().split(sep);
            int noDataValue = Integer.parseInt(s[s.length - 1]);
            CsvWriter cw = new CsvWriter(csv);
            cw.setDelimiter(';');
            cw.write("X");
            cw.write("Y");
            cw.write(name);
            cw.endRecord();
            double y = maxy;
            while (br.ready()) {
                double x = minx;
                for (String v : s = br.readLine().split(" ")) {
                    if (Double.parseDouble(v) != (double)noDataValue) {
                        cw.write(x + "");
                        cw.write(y + "");
                        cw.write(v);
                        cw.endRecord();
                    }
                    x += cellsize;
                }
                y -= cellsize;
            }
            cw.close();
            br.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void exportFromAsciiGrid(Set<String> asciis, String csv) {
        try {
            TreeMap<String, BufferedReader> readers = new TreeMap<String, BufferedReader>();
            for (String a : asciis) {
                readers.put(new File(a).getName().replace(".asc", ""), new BufferedReader(new FileReader(a)));
            }
            int width = 0;
            int noDataValue = -1;
            double minx = 0.0;
            double maxy = 0.0;
            double cellsize = 0.0;
            for (Object br : readers.values()) {
                String line = ((BufferedReader)br).readLine();
                String sep = String.valueOf(line.charAt(5));
                String[] s = line.split(sep);
                width = Integer.parseInt(s[s.length - 1]);
                s = ((BufferedReader)br).readLine().split(sep);
                int height = Integer.parseInt(s[s.length - 1]);
                s = ((BufferedReader)br).readLine().split(sep);
                minx = Double.parseDouble(s[s.length - 1]) + cellsize / 2.0;
                s = ((BufferedReader)br).readLine().split(sep);
                double miny = Double.parseDouble(s[s.length - 1]) - cellsize / 2.0;
                s = ((BufferedReader)br).readLine().split(sep);
                cellsize = Double.parseDouble(s[s.length - 1]);
                double maxx = minx + (double)width * cellsize;
                maxy = miny + (double)height * cellsize;
                s = ((BufferedReader)br).readLine().split(sep);
                noDataValue = Integer.parseInt(s[s.length - 1]);
            }
            CsvWriter cw = new CsvWriter(csv);
            cw.setDelimiter(';');
            cw.write("X");
            cw.write("Y");
            for (String n : readers.keySet()) {
                cw.write(n);
            }
            cw.endRecord();
            double y = maxy;
            TreeMap<String, String[]> lines = new TreeMap<String, String[]>();
            while (((BufferedReader)readers.values().iterator().next()).ready()) {
                double x = minx;
                lines.clear();
                for (Map.Entry e : readers.entrySet()) {
                    lines.put((String)e.getKey(), ((BufferedReader)e.getValue()).readLine().split(" "));
                }
                for (int i = 0; i < width; ++i) {
                    boolean ok = true;
                    for (String[] line : lines.values()) {
                        if (Double.parseDouble(line[i]) != (double)noDataValue) continue;
                        ok = false;
                        break;
                    }
                    if (ok) {
                        cw.write(x + "");
                        cw.write(y + "");
                        for (String[] line : lines.values()) {
                            cw.write(line[i]);
                        }
                        cw.endRecord();
                    }
                    x += cellsize;
                }
                y -= cellsize;
            }
            cw.close();
            for (BufferedReader br : readers.values()) {
                br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

