/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.util;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.raster.PixelManager;
import fr.inrae.act.bagap.apiland.raster.RefPoint;
import fr.inrae.act.bagap.apiland.raster.RefPointWithID;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.jumpmind.symmetric.csv.CsvReader;

public class CoordinateManager {
    public static double getProjectedX(EnteteRaster entete, int x) {
        return (double)((float)x * entete.cellsize()) + entete.minx() + (double)entete.cellsize() / 2.0;
    }

    public static double getProjectedX(double minX, double cellSize, int x) {
        return (double)x * cellSize + minX + cellSize / 2.0;
    }

    public static double getProjectedY(EnteteRaster entete, int y) {
        return (double)(entete.cellsize() * (float)(entete.height() - y)) + entete.miny() - (double)entete.cellsize() / 2.0;
    }

    public static double getProjectedY(double minY, double cellSize, int height, int y) {
        return cellSize * (double)(height - y) + minY - cellSize / 2.0;
    }

    public static int getLocalX(EnteteRaster entete, double x) {
        return (int)((x - entete.minx()) / (double)entete.cellsize());
    }

    public static int getLocalY(EnteteRaster entete, double y) {
        int ly = (int)((entete.maxy() - y) / (double)entete.cellsize());
        return ly;
    }

    public static Set<Pixel> initWithPoints(String f, EnteteRaster entete) {
        TreeSet<Pixel> pixels = new TreeSet<Pixel>();
        try {
            String header;
            int i;
            CsvReader cr = new CsvReader(f);
            cr.setDelimiter(';');
            cr.readHeaders();
            int xIndex = -1;
            int yIndex = -1;
            int idIndex = -1;
            boolean hasId = false;
            for (i = 0; i < cr.getHeaderCount(); ++i) {
                header = cr.getHeader(i);
                if (header.equalsIgnoreCase("x")) {
                    xIndex = i;
                }
                if (header.equalsIgnoreCase("y")) {
                    yIndex = i;
                }
                if (!header.equalsIgnoreCase("id")) continue;
                idIndex = i;
                hasId = true;
            }
            if (!hasId) {
                for (i = 0; i < cr.getHeaderCount(); ++i) {
                    header = cr.getHeader(i);
                    if (!header.toLowerCase().contains("id")) continue;
                    idIndex = i;
                    hasId = true;
                    break;
                }
            }
            if (xIndex == -1 || yIndex == -1) {
                System.err.println("'X' or 'Y' column missing from " + f);
            }
            int ind = 1;
            while (cr.readRecord()) {
                double X = Double.parseDouble(cr.get(xIndex));
                int x = CoordinateManager.getLocalX(entete, X);
                double Y = Double.parseDouble(cr.get(yIndex));
                int y = CoordinateManager.getLocalY(entete, Y);
                if (hasId) {
                    String id = cr.get(idIndex);
                    pixels.add(PixelManager.get(x, y, id, X, Y));
                    continue;
                }
                pixels.add(PixelManager.get(x, y, ind++ + "", X, Y));
            }
            cr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return pixels;
    }

    public static Set<RefPoint> initWithPoints(String f) {
        TreeSet<RefPoint> points = new TreeSet<RefPoint>();
        try {
            CsvReader cr = new CsvReader(f);
            cr.setDelimiter(';');
            cr.readHeaders();
            while (cr.readRecord()) {
                double X = cr.get("X") != "" ? Double.parseDouble(cr.get("X")) : Double.parseDouble(cr.get("x"));
                double Y = cr.get("Y") != "" ? Double.parseDouble(cr.get("Y")) : Double.parseDouble(cr.get("y"));
                String id = cr.get("id");
                if (!id.equals("")) {
                    points.add(new RefPointWithID(id, X, Y));
                    continue;
                }
                id = cr.get("ID");
                if (!id.equals("")) {
                    points.add(new RefPointWithID(id, X, Y));
                    continue;
                }
                id = cr.get("Id");
                if (!id.equals("")) {
                    points.add(new RefPointWithID(id, X, Y));
                    continue;
                }
                id = cr.get("iD");
                if (!id.equals("")) {
                    points.add(new RefPointWithID(id, X, Y));
                    continue;
                }
                points.add(new RefPoint(X, Y));
            }
            cr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return points;
    }

    public static Set<Pixel> initWithPixels(String f) {
        TreeSet<Pixel> pixels = new TreeSet<Pixel>();
        try {
            CsvReader cr = new CsvReader(f);
            cr.setDelimiter(';');
            cr.readHeaders();
            while (cr.readRecord()) {
                int x = Integer.parseInt(cr.get("X"));
                int y = Integer.parseInt(cr.get("Y"));
                pixels.add(PixelManager.get(x, y));
            }
            cr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return pixels;
    }
}

