/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.simul.model;

import fr.inrae.act.bagap.apiland.core.element.DynamicElement;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.delay.Delay;
import fr.inrae.act.bagap.apiland.simul.model.AtomicModel;
import fr.inrae.act.bagap.apiland.simul.operation.Operation;
import java.util.ArrayList;
import java.util.List;

public class Robot
extends AtomicModel {
    private static final long serialVersionUID = 1L;
    private List<Operation> operations = new ArrayList<Operation>();

    public Robot(String name, Instant start, Delay delay, Operation operation, DynamicElement element) {
        super(name, start, delay, element);
        this.addOperation(operation);
    }

    public Robot(String name, Instant start, Delay delay, DynamicElement element) {
        super(name, start, delay, element);
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public void resetOperation() {
        this.operations = new ArrayList<Operation>();
    }

    protected List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean make(Instant t) {
        for (Operation op : this.operations) {
            if (op.make(t, this.getElement())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void delete() {
        super.delete();
        for (Operation o : this.operations) {
            o.delete();
        }
        this.operations.clear();
        this.operations = null;
    }
}

