/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.simul.model;

import fr.inrae.act.bagap.apiland.core.element.DynamicElement;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.simul.Simulation;
import fr.inrae.act.bagap.apiland.simul.SimulationManager;
import fr.inrae.act.bagap.apiland.simul.Simulator;
import java.io.Serializable;

public abstract class Model
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Instant current;
    private DynamicElement element;
    private Model parent;

    public Model(String name, Instant start) {
        this.name = name;
        this.setCurrent(start);
    }

    public Model(String name, Instant start, DynamicElement element) {
        this.name = name;
        this.setCurrent(start);
        this.element = element;
    }

    public void setParent(Model parent) {
        this.parent = parent;
    }

    public Simulator simulator() {
        return this.simulation().simulator();
    }

    public Simulation simulation() {
        return this.parent.simulation();
    }

    public SimulationManager manager() {
        return this.simulator().manager();
    }

    protected Instant current() {
        return this.current;
    }

    public void setCurrent(Instant t) {
        this.current = t;
    }

    public void initCurrent(Instant t) {
        this.setCurrent(t);
    }

    public String getName() {
        return this.name;
    }

    public DynamicElement getElement() {
        return this.element;
    }

    public void setDynamicElement(DynamicElement element) {
        this.element = element;
    }

    public boolean deepContains(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public Model deepGet(String name) {
        if (this.deepContains(name)) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    public abstract boolean run(Instant var1);

    public void delete() {
        this.name = null;
        this.current = null;
    }
}

