/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.simul.model;

import fr.inrae.act.bagap.apiland.core.element.map.DynamicMap;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.simul.Simulator;
import fr.inrae.act.bagap.apiland.simul.model.LandscapeAction;
import fr.inrae.act.bagap.apiland.simul.model.Model;
import fr.inrae.act.bagap.apiland.simul.operation.Operation;
import java.util.ArrayList;
import java.util.List;

public class LandscapeModel
extends Model {
    private static final long serialVersionUID = 1L;
    private DynamicMap map;
    private List<Operation> operations;
    private List<LandscapeAction> actions;

    public LandscapeModel(Simulator simulator, DynamicMap map) {
        super("landscape", simulator.manager().start());
        this.map = map;
        this.operations = new ArrayList<Operation>();
        this.actions = new ArrayList<LandscapeAction>();
    }

    public String toString() {
        return "landscape model";
    }

    public DynamicMap map() {
        return this.map;
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public void removeOperation(Operation operation) {
        this.operations.remove(operation);
    }

    public void removeAllOperations() {
        this.operations.clear();
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void addAction(LandscapeAction action) {
        this.actions.add(action);
    }

    @Override
    public boolean run(Instant t) {
        for (Operation op : this.operations) {
            if (op.make(t, this.getElement())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void delete() {
        super.delete();
        for (Operation o : this.operations) {
            o.delete();
        }
        this.operations.clear();
        this.operations = null;
        for (LandscapeAction la : this.actions) {
            la.delete();
        }
        this.actions.clear();
        this.actions = null;
        this.map.delete();
        this.map = null;
    }
}

