/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.simul.model;

import fr.inrae.act.bagap.apiland.core.element.DynamicElement;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.delay.Delay;
import fr.inrae.act.bagap.apiland.simul.Simulator;
import fr.inrae.act.bagap.apiland.simul.model.Model;

public abstract class AtomicModel
extends Model {
    private static final long serialVersionUID = 1L;
    private Delay delay;

    public AtomicModel(String name, Simulator simulator, DynamicElement element) {
        super(name, simulator.manager().start(), element);
        this.delay = simulator.manager().delay();
    }

    public AtomicModel(String name, Instant start, Delay delay, DynamicElement element) {
        super(name, start, element);
        this.delay = delay;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean run(Instant t) {
        while (this.current().isBefore(t) || this.current().equals(t)) {
            if (this.make(this.current())) {
                this.setCurrent(this.delay.next(this.current()));
                continue;
            }
            return false;
        }
        return true;
    }

    public Delay getDelay() {
        return this.delay;
    }

    public abstract boolean make(Instant var1);

    @Override
    public void delete() {
        super.delete();
        this.delay = null;
    }
}

