/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.raster.converter;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.RasterLineString;
import fr.inrae.act.bagap.apiland.raster.RasterPolygon;
import fr.inrae.act.bagap.apiland.raster.TabCoverage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.store.ContentFeatureSource;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapeFile2CoverageConverter {
    public static CoordinateReferenceSystem getCoordinateReferenceSystem(String shape) {
        try {
            ShapefileDataStore SHPdataStore = new ShapefileDataStore(Paths.get(shape, new String[0]).toUri().toURL());
            ContentFeatureSource featureSource = SHPdataStore.getFeatureSource();
            SimpleFeatureType schema = featureSource.getSchema();
            CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
            SHPdataStore.dispose();
            return crs;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (ShapefileException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static ShapeType getShapeType(String shape) {
        try {
            ShpFiles sf = shape.endsWith(".shp") ? new ShpFiles(shape) : new ShpFiles(shape + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            ShapeType st = sfr.getHeader().getShapeType();
            sfr.close();
            return st;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (ShapefileException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void rasterize(String output, String input, String attribute, float fillValue, EnteteRaster entete) {
        float[] data = null;
        ShapeType sType = ShapeFile2CoverageConverter.getShapeType(input);
        if (sType.isPolygonType()) {
            data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, fillValue);
        } else if (sType.isLineType()) {
            data = ShapeFile2CoverageConverter.getLinearData(input, entete, attribute, fillValue, 0.0);
        } else {
            throw new IllegalArgumentException("shape type " + sType + " not supported yet");
        }
        CoverageManager.write(output, data, entete);
    }

    public static void rasterize(String output, String input, String attribute, Map<String, Integer> codes, float fillValue, EnteteRaster entete) {
        float[] data = null;
        ShapeType sType = ShapeFile2CoverageConverter.getShapeType(input);
        if (sType.isPolygonType()) {
            data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, codes, fillValue);
        } else if (!sType.isLineType()) {
            throw new IllegalArgumentException("shape type " + sType + " not supported yet");
        }
        CoverageManager.write(output, data, entete);
    }

    public static void rasterize(String output, String input, String attribute, float cellSize, int noDataValue, CoordinateReferenceSystem crs) {
        EnteteRaster entete = ShapeFile2CoverageConverter.getEntete(input, cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, (float)noDataValue);
        CoverageManager.write(output, data, entete);
    }

    public static void rasterize(String output, String input, String attribute, float cellSize, int noDataValue, CoordinateReferenceSystem crs, double minx, double maxx, double miny, double maxy, float fillValue) {
        EnteteRaster entete = EnteteRaster.getEntete(new Envelope(minx, maxx, miny, maxy), cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, fillValue);
        CoverageManager.write(output, data, entete);
    }

    public static void rasterize(String output, String input, String attribute, Map<String, Integer> codes, float cellSize, int noDataValue, int fillValue, CoordinateReferenceSystem crs) {
        EnteteRaster entete = ShapeFile2CoverageConverter.getEntete(input, cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, codes, fillValue);
        CoverageManager.write(output, data, entete);
    }

    public static void rasterize(String output, String input, String attribute, Map<String, Integer> codes, float cellSize, int noDataValue, CoordinateReferenceSystem crs, double minx, double maxx, double miny, double maxy, float fillValue) {
        EnteteRaster entete = EnteteRaster.getEntete(new Envelope(minx, maxx, miny, maxy), cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, codes, fillValue);
        CoverageManager.write(output, data, entete);
    }

    public static void rasterize(String output, String input, float cellSize, float value, int noDataValue) {
        EnteteRaster entete = ShapeFile2CoverageConverter.getEntete(input, cellSize, noDataValue, null);
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, value, (float)noDataValue);
        CoverageManager.write(output, data, entete);
    }

    public static EnteteRaster getEntete(String zone, float cellSize, int noDataValue, CoordinateReferenceSystem crs) {
        try {
            ShpFiles sf = new ShpFiles(zone);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            double minx = Double.MAX_VALUE;
            double maxx = Double.MIN_VALUE;
            double miny = Double.MAX_VALUE;
            double maxy = Double.MIN_VALUE;
            while (sfr.hasNext()) {
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                if (the_geom == null) continue;
                minx = Math.min(minx, the_geom.getEnvelopeInternal().getMinX());
                maxx = Math.max(maxx, the_geom.getEnvelopeInternal().getMaxX());
                miny = Math.min(miny, the_geom.getEnvelopeInternal().getMinY());
                maxy = Math.max(maxy, the_geom.getEnvelopeInternal().getMaxY());
            }
            sfr.close();
            sf.dispose();
            return EnteteRaster.getEntete(new Envelope(minx, maxx, miny, maxy), cellSize, noDataValue, crs);
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Coverage getSurfaceCoverage(float[] data, EnteteRaster entete, String input, float fillValue) {
        ShapeFile2CoverageConverter.getSurfaceData(data, entete, input, fillValue);
        return new TabCoverage(data, entete);
    }

    public static Coverage getSurfaceCoverage(float[] data, EnteteRaster entete, String input, String attribute) {
        ShapeFile2CoverageConverter.getSurfaceData(data, entete, input, attribute);
        return new TabCoverage(data, entete);
    }

    public static Coverage getSurfaceCoverage(float[] data, EnteteRaster entete, String input, String attribute, Map<String, Integer> codes) {
        ShapeFile2CoverageConverter.getSurfaceData(data, entete, input, attribute, codes);
        return new TabCoverage(data, entete);
    }

    public static Coverage getSurfaceCoverage(String input, String attribute, EnteteRaster entete, int fillValue) {
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, (float)fillValue);
        return new TabCoverage(data, entete);
    }

    public static Coverage getSurfaceCoverage(String input, String attribute, float cellSize, int noDataValue, CoordinateReferenceSystem crs) {
        EnteteRaster entete = ShapeFile2CoverageConverter.getEntete(input, cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, (float)noDataValue);
        return new TabCoverage(data, entete);
    }

    public static Coverage getSurfaceCoverage(String input, String attribute, float cellSize, int noDataValue, CoordinateReferenceSystem crs, double minx, double maxx, double miny, double maxy, float fillValue) {
        EnteteRaster entete = EnteteRaster.getEntete(new Envelope(minx, maxx, miny, maxy), cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, fillValue);
        return new TabCoverage(data, entete);
    }

    public static Coverage getSurfaceCoverage(String input, EnteteRaster entete, float value, float fillValue) {
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, value, fillValue);
        return new TabCoverage(data, entete);
    }

    public static Coverage getSurfaceCoverage(String input, String attribute, Map<String, Integer> codes, EnteteRaster entete, float fillValue) {
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, codes, fillValue);
        return new TabCoverage(data, entete);
    }

    public static Coverage getSurfaceCoverage(String input, String attribute, Map<String, Integer> codes, float cellSize, int noDataValue, CoordinateReferenceSystem crs) {
        EnteteRaster entete = ShapeFile2CoverageConverter.getEntete(input, cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, codes, noDataValue);
        return new TabCoverage(data, entete);
    }

    public static Coverage getSurfaceCoverage(String input, String attribute, Map<String, Integer> codes, float cellSize, int noDataValue, CoordinateReferenceSystem crs, double minx, double maxx, double miny, double maxy, float fillValue) {
        EnteteRaster entete = EnteteRaster.getEntete(new Envelope(minx, maxx, miny, maxy), cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getSurfaceData(input, entete, attribute, codes, fillValue);
        return new TabCoverage(data, entete);
    }

    private static void getSurfaceData(float[] data, EnteteRaster entete, String inputShape, float fillValue) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            Envelope envelopeRef = entete.getEnvelope();
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterPolygon rp;
                Polygon the_poly;
                Envelope envelopeGeom;
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                if (the_geom == null || !(envelopeGeom = the_geom.getEnvelopeInternal()).intersects(envelopeRef)) continue;
                if (the_geom instanceof Polygon) {
                    the_poly = (Polygon)the_geom;
                    rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                    indrp = 0;
                    xdelta = rp.getDeltaI();
                    ydelta = rp.getDeltaJ();
                    float[] fArray = rp.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rp.getWidth();
                            yrp = indrp / rp.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height() && data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] != (float)entete.noDataValue()) {
                                data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = fillValue;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiPolygon) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_poly = (Polygon)((MultiPolygon)the_geom).getGeometryN(i);
                        rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                        indrp = 0;
                        xdelta = rp.getDeltaI();
                        ydelta = rp.getDeltaJ();
                        float[] fArray = rp.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rp.getWidth();
                                yrp = indrp / rp.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height() && data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] != (float)entete.noDataValue()) {
                                    data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = fillValue;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("probleme geometrique");
            }
            sfr.close();
            sf.dispose();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void getSurfaceData(float[] data, EnteteRaster entete, String inputShape, String attribute) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            int pos = -1;
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                pos = f;
            }
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterPolygon rp;
                Polygon the_poly;
                dfr.read();
                String value = dfr.readField(pos).toString();
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                if (the_geom == null) continue;
                if (the_geom instanceof Polygon) {
                    the_poly = (Polygon)the_geom;
                    rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                    indrp = 0;
                    xdelta = rp.getDeltaI();
                    ydelta = rp.getDeltaJ();
                    float[] fArray = rp.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rp.getWidth();
                            yrp = indrp / rp.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = Float.parseFloat(value);
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiPolygon) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_poly = (Polygon)((MultiPolygon)the_geom).getGeometryN(i);
                        rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                        indrp = 0;
                        xdelta = rp.getDeltaI();
                        ydelta = rp.getDeltaJ();
                        float[] fArray = rp.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rp.getWidth();
                                yrp = indrp / rp.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = Float.parseFloat(value);
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                System.out.println(the_geom);
            }
            sfr.close();
            dfr.close();
            sf.dispose();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void getSurfaceData(float[] data, EnteteRaster entete, String inputShape, String attribute, Map<String, Integer> codes) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            int pos = -1;
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                pos = f;
            }
            Envelope envelopeRef = entete.getEnvelope();
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterPolygon rp;
                Polygon the_poly;
                Envelope envelopeGeom;
                Geometry the_geom;
                dfr.read();
                String value = (String)dfr.readField(pos);
                boolean ok = true;
                float code = -1.0f;
                if (codes.containsKey(value)) {
                    code = codes.get(value).intValue();
                } else {
                    ok = false;
                }
                if ((the_geom = (Geometry)sfr.nextRecord().shape()) == null || !ok || !(envelopeGeom = the_geom.getEnvelopeInternal()).intersects(envelopeRef)) continue;
                if (the_geom instanceof Polygon) {
                    the_poly = (Polygon)the_geom;
                    rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                    indrp = 0;
                    xdelta = rp.getDeltaI();
                    ydelta = rp.getDeltaJ();
                    float[] fArray = rp.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rp.getWidth();
                            yrp = indrp / rp.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height() && data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] != (float)entete.noDataValue()) {
                                data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = code;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiPolygon) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_poly = (Polygon)((MultiPolygon)the_geom).getGeometryN(i);
                        rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                        indrp = 0;
                        xdelta = rp.getDeltaI();
                        ydelta = rp.getDeltaJ();
                        float[] fArray = rp.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rp.getWidth();
                                yrp = indrp / rp.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height() && data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] != (float)entete.noDataValue()) {
                                    data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = code;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("probleme geometrique");
            }
            sfr.close();
            dfr.close();
            sf.dispose();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static float[] getSurfaceData(String inputShape, EnteteRaster entete, String attribute, float fillValue) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            int pos = -1;
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                pos = f;
            }
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            Coordinate[] coords = new Coordinate[]{new Coordinate(entete.minx(), entete.maxy()), new Coordinate(entete.maxx(), entete.maxy()), new Coordinate(entete.maxx(), entete.miny()), new Coordinate(entete.minx(), entete.miny()), new Coordinate(entete.minx(), entete.maxy())};
            PreparedPolygon pgE = new PreparedPolygon((Polygonal)new GeometryFactory().createPolygon(coords));
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterPolygon rp;
                Polygon the_poly;
                dfr.read();
                String value = dfr.readField(pos).toString();
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                if (the_geom == null) continue;
                if (pgE.within(the_geom)) {
                    Arrays.fill(datas, Float.parseFloat(value));
                    break;
                }
                if (!pgE.intersects(the_geom)) continue;
                if (the_geom instanceof Polygon) {
                    the_poly = (Polygon)the_geom;
                    rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                    indrp = 0;
                    xdelta = rp.getDeltaI();
                    ydelta = rp.getDeltaJ();
                    float[] fArray = rp.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rp.getWidth();
                            yrp = indrp / rp.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = Float.parseFloat(value);
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiPolygon) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_poly = (Polygon)((MultiPolygon)the_geom).getGeometryN(i);
                        rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                        indrp = 0;
                        xdelta = rp.getDeltaI();
                        ydelta = rp.getDeltaJ();
                        float[] fArray = rp.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rp.getWidth();
                                yrp = indrp / rp.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = Float.parseFloat(value);
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                System.out.println(the_geom);
            }
            sfr.close();
            dfr.close();
            sf.dispose();
            return datas;
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static float[] getSurfaceData(String inputShape, EnteteRaster entete, float value, float fillValue) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterPolygon rp;
                Polygon the_poly;
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                if (the_geom == null || !entete.getEnvelope().intersects(the_geom.getEnvelopeInternal())) continue;
                if (the_geom instanceof Polygon) {
                    the_poly = (Polygon)the_geom;
                    rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                    indrp = 0;
                    xdelta = rp.getDeltaI();
                    ydelta = rp.getDeltaJ();
                    float[] fArray = rp.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rp.getWidth();
                            yrp = indrp / rp.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = value;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiPolygon) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_poly = (Polygon)((MultiPolygon)the_geom).getGeometryN(i);
                        rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                        indrp = 0;
                        xdelta = rp.getDeltaI();
                        ydelta = rp.getDeltaJ();
                        float[] fArray = rp.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rp.getWidth();
                                yrp = indrp / rp.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = value;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                System.out.println(the_geom);
            }
            sfr.close();
            sf.dispose();
            return datas;
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static float[] getSurfaceData(String inputShape, EnteteRaster entete, String attribute, Map<String, Integer> codes, float fillValue) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            int pos = -1;
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                pos = f;
            }
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            Envelope envelopeRef = entete.getEnvelope();
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterPolygon rp;
                Polygon the_poly;
                Envelope envelopeGeom;
                dfr.read();
                String value = dfr.readField(pos).toString();
                float code = codes.containsKey(value) ? (float)codes.get(value).intValue() : fillValue;
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                if (the_geom == null || !(envelopeGeom = the_geom.getEnvelopeInternal()).intersects(envelopeRef)) continue;
                if (the_geom instanceof Polygon) {
                    the_poly = (Polygon)the_geom;
                    rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                    indrp = 0;
                    xdelta = rp.getDeltaI();
                    ydelta = rp.getDeltaJ();
                    float[] fArray = rp.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rp.getWidth();
                            yrp = indrp / rp.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = code;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiPolygon) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_poly = (Polygon)((MultiPolygon)the_geom).getGeometryN(i);
                        rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                        indrp = 0;
                        xdelta = rp.getDeltaI();
                        ydelta = rp.getDeltaJ();
                        float[] fArray = rp.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rp.getWidth();
                                yrp = indrp / rp.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = code;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("probleme geometrique");
            }
            sfr.close();
            dfr.close();
            sf.dispose();
            return datas;
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Coverage getLinearCoverage(float[] data, EnteteRaster entete, String input, float value) {
        ShapeFile2CoverageConverter.getLinearData(data, entete, input, value, 0.0);
        return new TabCoverage(data, entete);
    }

    public static Coverage getLinearCoverage(float[] data, EnteteRaster entete, String input, float value, double buffer) {
        ShapeFile2CoverageConverter.getLinearData(data, entete, input, value, buffer);
        return new TabCoverage(data, entete);
    }

    public static Coverage getLinearCoverage(float[] data, EnteteRaster entete, String input, String attribute, Map<String, Integer> codes, double buffer) {
        ShapeFile2CoverageConverter.getLinearData(data, entete, input, attribute, codes, buffer);
        return new TabCoverage(data, entete);
    }

    public static Coverage getLinearCoverage(String input, EnteteRaster entete, float value, float fillValue) {
        float[] data = ShapeFile2CoverageConverter.getLinearData(input, entete, value, fillValue, 0.0);
        return new TabCoverage(data, entete);
    }

    public static Coverage getLinearCoverage(String input, EnteteRaster entete, float value, float fillValue, double buffer) {
        float[] data = ShapeFile2CoverageConverter.getLinearData(input, entete, value, fillValue, buffer);
        return new TabCoverage(data, entete);
    }

    private static float[] getLinearData(String inputShape, EnteteRaster entete, float value, float fillValue, double buffer) {
        float[] data = new float[entete.width() * entete.height()];
        Arrays.fill(data, fillValue);
        ShapeFile2CoverageConverter.getLinearData(data, entete, inputShape, value, buffer);
        return data;
    }

    private static void getLinearData(float[] data, EnteteRaster entete, String inputShape, float value, double buffer) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            Envelope envelopeRef = entete.getEnvelope();
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterLineString rls;
                LineString the_line;
                Envelope envelopeGeom;
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                if (the_geom == null || !(envelopeGeom = the_geom.getEnvelopeInternal()).intersects(envelopeRef)) continue;
                if (the_geom instanceof LineString) {
                    the_line = (LineString)the_geom;
                    rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                    indrp = 0;
                    xdelta = rls.getDeltaI();
                    ydelta = rls.getDeltaJ();
                    float[] fArray = rls.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rls.getWidth();
                            yrp = indrp / rls.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height() && data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] != (float)entete.noDataValue()) {
                                data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = value;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiLineString) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_line = (LineString)((MultiLineString)the_geom).getGeometryN(i);
                        rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                        if (rls == null) continue;
                        indrp = 0;
                        xdelta = rls.getDeltaI();
                        ydelta = rls.getDeltaJ();
                        float[] fArray = rls.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rls.getWidth();
                                yrp = indrp / rls.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height() && data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] != (float)entete.noDataValue()) {
                                    data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = value;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                System.out.println(the_geom);
            }
            sfr.close();
            sf.dispose();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void getLinearData(float[] data, EnteteRaster entete, String inputShape, String attribute, Map<String, Integer> codes, double buffer) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            int pos = -1;
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                pos = f;
            }
            Envelope envelopeRef = entete.getEnvelope();
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterLineString rls;
                LineString the_line;
                Envelope envelopeGeom;
                Geometry the_geom;
                dfr.read();
                String value = (String)dfr.readField(pos);
                boolean ok = true;
                int code = -1;
                if (codes.containsKey(value)) {
                    code = codes.get(value);
                } else {
                    ok = false;
                }
                if ((the_geom = (Geometry)sfr.nextRecord().shape()) == null || !ok || !(envelopeGeom = the_geom.getEnvelopeInternal()).intersects(envelopeRef)) continue;
                if (the_geom instanceof LineString) {
                    the_line = (LineString)the_geom;
                    rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                    indrp = 0;
                    xdelta = rls.getDeltaI();
                    ydelta = rls.getDeltaJ();
                    float[] fArray = rls.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rls.getWidth();
                            yrp = indrp / rls.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height() && data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] != (float)entete.noDataValue()) {
                                data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = code;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiLineString) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_line = (LineString)((MultiLineString)the_geom).getGeometryN(i);
                        rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                        if (rls == null) continue;
                        indrp = 0;
                        xdelta = rls.getDeltaI();
                        ydelta = rls.getDeltaJ();
                        float[] fArray = rls.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rls.getWidth();
                                yrp = indrp / rls.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height() && data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] != (float)entete.noDataValue()) {
                                    data[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = code;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                System.out.println(the_geom);
            }
            sfr.close();
            dfr.close();
            sf.dispose();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Coverage getLinearCoverage(String input, String attribute, EnteteRaster entete, float fillValue, double buffer) {
        float[] data = ShapeFile2CoverageConverter.getLinearData(input, entete, attribute, fillValue, buffer);
        return new TabCoverage(data, entete);
    }

    public static Coverage getLinearCoverage(String input, String attribute, float cellSize, int noDataValue, CoordinateReferenceSystem crs, double minx, double maxx, double miny, double maxy, float fillValue, double buffer) {
        EnteteRaster entete = EnteteRaster.getEntete(new Envelope(minx, maxx, miny, maxy), cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getLinearData(input, entete, attribute, fillValue, buffer);
        return new TabCoverage(data, entete);
    }

    private static float[] getLinearData(String inputShape, EnteteRaster entete, String attribute, float fillValue, double buffer) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            int pos = -1;
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                pos = f;
            }
            Envelope globalEnvelope = new Envelope(entete.minx(), entete.maxx(), entete.miny(), entete.maxy());
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterLineString rls;
                LineString the_line;
                dfr.read();
                String value = dfr.readField(pos).toString();
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                if (the_geom == null || !the_geom.getEnvelopeInternal().intersects(globalEnvelope)) continue;
                if (the_geom instanceof LineString) {
                    the_line = (LineString)the_geom;
                    rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                    indrp = 0;
                    xdelta = rls.getDeltaI();
                    ydelta = rls.getDeltaJ();
                    float[] fArray = rls.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rls.getWidth();
                            yrp = indrp / rls.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = Float.parseFloat(value);
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiLineString) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_line = (LineString)((MultiLineString)the_geom).getGeometryN(i);
                        rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                        indrp = 0;
                        xdelta = rls.getDeltaI();
                        ydelta = rls.getDeltaJ();
                        float[] fArray = rls.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rls.getWidth();
                                yrp = indrp / rls.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = Float.parseFloat(value);
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("probleme geometrique");
            }
            sfr.close();
            dfr.close();
            sf.dispose();
            return datas;
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Coverage getLinearCoverage(String input, Map<String, String> conditionsAttributeAndValue, String attribute, float cellSize, int noDataValue, CoordinateReferenceSystem crs, double minx, double maxx, double miny, double maxy, float fillValue, double buffer) {
        EnteteRaster entete = EnteteRaster.getEntete(new Envelope(minx, maxx, miny, maxy), cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getLinearData(input, entete, conditionsAttributeAndValue, attribute, fillValue, buffer);
        return new TabCoverage(data, entete);
    }

    private static float[] getLinearData(String inputShape, EnteteRaster entete, Map<String, String> conditionsAttributeAndValue, String attribute, float fillValue, double buffer) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            TreeMap<String, Integer> conditionsPosition = new TreeMap<String, Integer>();
            for (String cond : conditionsAttributeAndValue.keySet()) {
                conditionsPosition.put(cond, -1);
            }
            int posAttribute = -1;
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (dfh.getFieldName(f).equalsIgnoreCase(attribute)) {
                    posAttribute = f;
                }
                for (String cond : conditionsAttributeAndValue.keySet()) {
                    if (!dfh.getFieldName(f).equalsIgnoreCase(cond)) continue;
                    conditionsPosition.put(cond, f);
                }
            }
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            TreeMap<String, String> conditions = new TreeMap<String, String>();
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterLineString rls;
                LineString the_line;
                dfr.read();
                String value = dfr.readField(posAttribute).toString();
                conditions.clear();
                for (String cond : conditionsAttributeAndValue.keySet()) {
                    conditions.put(cond, dfr.readField(((Integer)conditionsPosition.get(cond)).intValue()).toString());
                }
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                boolean ok = true;
                for (String cond : conditionsAttributeAndValue.keySet()) {
                    if (conditionsAttributeAndValue.get(cond).equalsIgnoreCase((String)conditions.get(cond))) continue;
                    ok = false;
                }
                if (the_geom == null || !ok) continue;
                if (the_geom instanceof LineString) {
                    the_line = (LineString)the_geom;
                    rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                    indrp = 0;
                    xdelta = rls.getDeltaI();
                    ydelta = rls.getDeltaJ();
                    Object object = rls.getDatas();
                    int n2 = ((Object)object).length;
                    for (n = 0; n < n2; ++n) {
                        double v = (double)object[n];
                        if (v == 1.0) {
                            xrp = indrp % rls.getWidth();
                            yrp = indrp / rls.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = Float.parseFloat(value);
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiLineString) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_line = (LineString)((MultiLineString)the_geom).getGeometryN(i);
                        rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                        indrp = 0;
                        xdelta = rls.getDeltaI();
                        ydelta = rls.getDeltaJ();
                        float[] fArray = rls.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rls.getWidth();
                                yrp = indrp / rls.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = Float.parseFloat(value);
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("probleme geometrique");
            }
            sfr.close();
            dfr.close();
            sf.dispose();
            return datas;
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Coverage getLinearCoverage(String input, Map<String, String> conditionsAttributeAndValue, float value, float cellSize, int noDataValue, CoordinateReferenceSystem crs, double minx, double maxx, double miny, double maxy, float fillValue, double buffer) {
        EnteteRaster entete = EnteteRaster.getEntete(new Envelope(minx, maxx, miny, maxy), cellSize, noDataValue, crs);
        float[] data = ShapeFile2CoverageConverter.getLinearData(input, entete, conditionsAttributeAndValue, value, fillValue, buffer);
        return new TabCoverage(data, entete);
    }

    private static float[] getLinearData(String inputShape, EnteteRaster entete, Map<String, String> conditionsAttributeAndValue, float value, float fillValue, double buffer) {
        try {
            ShpFiles sf = new ShpFiles(inputShape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            TreeMap<String, Integer> conditionsPosition = new TreeMap<String, Integer>();
            for (String string : conditionsAttributeAndValue.keySet()) {
                conditionsPosition.put(string, -1);
            }
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                for (String cond : conditionsAttributeAndValue.keySet()) {
                    if (!dfh.getFieldName(f).equalsIgnoreCase(cond)) continue;
                    conditionsPosition.put(cond, f);
                }
            }
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            TreeMap<String, String> conditions = new TreeMap<String, String>();
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterLineString rls;
                LineString the_line;
                dfr.read();
                conditions.clear();
                for (String cond : conditionsAttributeAndValue.keySet()) {
                    conditions.put(cond, dfr.readField(((Integer)conditionsPosition.get(cond)).intValue()).toString());
                }
                Geometry geometry = (Geometry)sfr.nextRecord().shape();
                boolean ok = true;
                for (String cond : conditionsAttributeAndValue.keySet()) {
                    if (conditionsAttributeAndValue.get(cond).equalsIgnoreCase((String)conditions.get(cond))) continue;
                    ok = false;
                }
                if (geometry == null || !ok) continue;
                if (geometry instanceof LineString) {
                    the_line = (LineString)geometry;
                    rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                    indrp = 0;
                    xdelta = rls.getDeltaI();
                    ydelta = rls.getDeltaJ();
                    Object object = rls.getDatas();
                    int n2 = ((Object)object).length;
                    for (n = 0; n < n2; ++n) {
                        double v = (double)object[n];
                        if (v == 1.0) {
                            xrp = indrp % rls.getWidth();
                            yrp = indrp / rls.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = value;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (geometry instanceof MultiLineString) {
                    for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                        the_line = (LineString)((MultiLineString)geometry).getGeometryN(i);
                        rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                        indrp = 0;
                        xdelta = rls.getDeltaI();
                        ydelta = rls.getDeltaJ();
                        float[] fArray = rls.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rls.getWidth();
                                yrp = indrp / rls.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = value;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("probleme geometrique");
            }
            sfr.close();
            dfr.close();
            sf.dispose();
            return datas;
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Envelope getEnvelope(String zone) {
        return ShapeFile2CoverageConverter.getEnvelope(zone, 0.0);
    }

    public static Envelope getEnvelope(String zone, double buffer) {
        double minx = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double miny = Double.MAX_VALUE;
        double maxy = Double.MIN_VALUE;
        try {
            ShpFiles sf = new ShpFiles(zone);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            while (sfr.hasNext()) {
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                if (the_geom == null) continue;
                minx = Math.min(minx, the_geom.getEnvelopeInternal().getMinX());
                maxx = Math.max(maxx, the_geom.getEnvelopeInternal().getMaxX());
                miny = Math.min(miny, the_geom.getEnvelopeInternal().getMinY());
                maxy = Math.max(maxy, the_geom.getEnvelopeInternal().getMaxY());
            }
            sfr.close();
            return new Envelope(minx - buffer, maxx + buffer, miny - buffer, maxy + buffer);
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Envelope getEnvelope(String zone, double buffer, String attribute, String ... values) {
        double minx = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double miny = Double.MAX_VALUE;
        double maxy = Double.MIN_VALUE;
        try {
            ShpFiles sf = new ShpFiles(zone);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            int position = -1;
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                position = f;
                break;
            }
            block4: while (sfr.hasNext()) {
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                String value = dfr.readEntry()[position].toString();
                if (the_geom == null) continue;
                for (String v : values) {
                    if (!value.equalsIgnoreCase(v)) continue;
                    minx = Math.min(minx, the_geom.getEnvelopeInternal().getMinX());
                    maxx = Math.max(maxx, the_geom.getEnvelopeInternal().getMaxX());
                    miny = Math.min(miny, the_geom.getEnvelopeInternal().getMinY());
                    maxy = Math.max(maxy, the_geom.getEnvelopeInternal().getMaxY());
                    continue block4;
                }
            }
            sfr.close();
            dfr.close();
            return new Envelope(minx - buffer, maxx + buffer, miny - buffer, maxy + buffer);
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

