/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.raster.converter;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.RasterLineString;
import fr.inrae.act.bagap.apiland.raster.RasterPolygon;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geopkg.FeatureEntry;
import org.geotools.geopkg.GeoPackage;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoPackage2CoverageConverter {
    public static String getGeoPackageType(String geoPackage) {
        String type = "";
        try {
            GeoPackage gp = new GeoPackage(new File(geoPackage));
            FeatureEntry fe = (FeatureEntry)gp.features().get(0);
            Geometries g = fe.getGeometryType();
            type = g.toString();
            gp.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return type;
    }

    public static void rasterize(String output, String input, float value, float fillValue, EnteteRaster entete) {
        float[] data;
        System.out.println("rasterize " + input);
        String type = GeoPackage2CoverageConverter.getGeoPackageType(input);
        if (type.equalsIgnoreCase("LineString")) {
            data = GeoPackage2CoverageConverter.getLinearData(input, entete, value, fillValue, 0.0);
        } else if (type.equalsIgnoreCase("MultiPolygon")) {
            data = GeoPackage2CoverageConverter.getSurfaceData(input, entete, value, fillValue);
        } else {
            throw new IllegalArgumentException("gpkg type " + type + " not supported yet");
        }
        CoverageManager.write(output, data, entete);
    }

    public static void rasterize(String output, String input, float value, float fillValue, EnteteRaster entete, double buffer) {
        float[] data;
        System.out.println("rasterize " + input);
        String type = GeoPackage2CoverageConverter.getGeoPackageType(input);
        if (type.equalsIgnoreCase("LineString")) {
            data = GeoPackage2CoverageConverter.getLinearData(input, entete, value, fillValue, buffer);
        } else if (type.equalsIgnoreCase("MultiPolygon")) {
            data = GeoPackage2CoverageConverter.getSurfaceData(input, entete, value, fillValue);
        } else {
            throw new IllegalArgumentException("gpkg type " + type + " not supported yet");
        }
        CoverageManager.write(output, data, entete);
    }

    public static void rasterize(String output, String input, String attribute, float fillValue, EnteteRaster entete) {
        System.out.println("rasterize " + input);
        float[] data = null;
        data = GeoPackage2CoverageConverter.getSurfaceData(input, entete, attribute, fillValue);
        CoverageManager.write(output, data, entete);
    }

    public static void rasterize(String output, String input, String attribute, float fillValue, float cellSize, int noDataValue, CoordinateReferenceSystem crs) {
        EnteteRaster entete = GeoPackage2CoverageConverter.getEntete(input, cellSize, noDataValue, crs);
        GeoPackage2CoverageConverter.rasterize(output, input, attribute, fillValue, entete);
    }

    public static void rasterize(String output, String input, String attribute, Map<String, Integer> codes, float fillValue, EnteteRaster entete) {
        float[] data;
        System.out.println("rasterize " + input);
        String type = GeoPackage2CoverageConverter.getGeoPackageType(input);
        if (type.equalsIgnoreCase("LineString")) {
            data = GeoPackage2CoverageConverter.getLinearData(input, entete, attribute, codes, fillValue, 0.0);
        } else if (type.equalsIgnoreCase("MultiPolygon")) {
            data = GeoPackage2CoverageConverter.getSurfaceData(input, entete, attribute, codes, fillValue);
        } else {
            throw new IllegalArgumentException("gpkg type " + type + " not supported yet");
        }
        CoverageManager.write(output, data, entete);
    }

    public static void rasterize(String output, String input, String attribute, Map<String, Integer> codes, float fillValue, EnteteRaster entete, double buffer) {
        float[] data;
        System.out.println("rasterize " + input);
        String type = GeoPackage2CoverageConverter.getGeoPackageType(input);
        if (type.equalsIgnoreCase("LineString")) {
            data = GeoPackage2CoverageConverter.getLinearData(input, entete, attribute, codes, fillValue, buffer);
        } else if (type.equalsIgnoreCase("MultiPolygon")) {
            data = GeoPackage2CoverageConverter.getSurfaceData(input, entete, attribute, codes, fillValue);
        } else {
            throw new IllegalArgumentException("gpkg type " + type + " not supported yet");
        }
        CoverageManager.write(output, data, entete);
    }

    private static EnteteRaster getEntete(String zone, float cellSize, int noDataValue, CoordinateReferenceSystem crs) {
        try {
            GeoPackage gp = new GeoPackage(new File(zone));
            FeatureEntry fe = (FeatureEntry)gp.features().get(0);
            SimpleFeatureReader sfr = gp.reader(fe, null, null);
            double minx = Double.MAX_VALUE;
            double maxx = Double.MIN_VALUE;
            double miny = Double.MAX_VALUE;
            double maxy = Double.MIN_VALUE;
            while (sfr.hasNext()) {
                Geometry the_geom = (Geometry)((SimpleFeature)sfr.next()).getDefaultGeometry();
                if (the_geom == null) continue;
                minx = Math.min(minx, the_geom.getEnvelopeInternal().getMinX());
                maxx = Math.max(maxx, the_geom.getEnvelopeInternal().getMaxX());
                miny = Math.min(miny, the_geom.getEnvelopeInternal().getMinY());
                maxy = Math.max(maxy, the_geom.getEnvelopeInternal().getMaxY());
            }
            sfr.close();
            gp.close();
            return EnteteRaster.getEntete(new Envelope(minx, maxx, miny, maxy), cellSize, noDataValue, crs);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static float[] getSurfaceData(String input, EnteteRaster entete, float value, float fillValue) {
        try {
            GeoPackage gp = new GeoPackage(new File(input));
            FeatureEntry fe = (FeatureEntry)gp.features().get(0);
            SimpleFeatureReader sfr = gp.reader(fe, null, null);
            Envelope globalEnvelope = new Envelope(entete.minx(), entete.maxx(), entete.miny(), entete.maxy());
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterPolygon rp;
                Polygon the_poly;
                SimpleFeature sf = (SimpleFeature)sfr.next();
                Geometry the_geom = (Geometry)sf.getDefaultGeometry();
                if (the_geom == null || !the_geom.getEnvelopeInternal().intersects(globalEnvelope)) continue;
                if (the_geom instanceof Polygon) {
                    the_poly = (Polygon)the_geom;
                    rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                    indrp = 0;
                    xdelta = rp.getDeltaI();
                    ydelta = rp.getDeltaJ();
                    float[] fArray = rp.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rp.getWidth();
                            yrp = indrp / rp.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = value;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiPolygon) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_poly = (Polygon)((MultiPolygon)the_geom).getGeometryN(i);
                        rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                        indrp = 0;
                        xdelta = rp.getDeltaI();
                        ydelta = rp.getDeltaJ();
                        float[] fArray = rp.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rp.getWidth();
                                yrp = indrp / rp.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = value;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                System.out.println(the_geom);
            }
            sfr.close();
            gp.close();
            return datas;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static float[] getSurfaceData(String input, EnteteRaster entete, String attribute, float fillValue) {
        try {
            GeoPackage gp = new GeoPackage(new File(input));
            FeatureEntry fe = (FeatureEntry)gp.features().get(0);
            SimpleFeatureReader sfr = gp.reader(fe, null, null);
            Envelope globalEnvelope = new Envelope(entete.minx(), entete.maxx(), entete.miny(), entete.maxy());
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterPolygon rp;
                Polygon the_poly;
                SimpleFeature sf = (SimpleFeature)sfr.next();
                Geometry the_geom = (Geometry)sf.getDefaultGeometry();
                String value = sf.getAttribute(attribute).toString();
                if (the_geom == null || !the_geom.getEnvelopeInternal().intersects(globalEnvelope)) continue;
                if (the_geom instanceof Polygon) {
                    the_poly = (Polygon)the_geom;
                    rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                    indrp = 0;
                    xdelta = rp.getDeltaI();
                    ydelta = rp.getDeltaJ();
                    float[] fArray = rp.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rp.getWidth();
                            yrp = indrp / rp.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = Float.parseFloat(value);
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiPolygon) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_poly = (Polygon)((MultiPolygon)the_geom).getGeometryN(i);
                        rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                        indrp = 0;
                        xdelta = rp.getDeltaI();
                        ydelta = rp.getDeltaJ();
                        float[] fArray = rp.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rp.getWidth();
                                yrp = indrp / rp.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = Float.parseFloat(value);
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                System.out.println(the_geom);
            }
            sfr.close();
            gp.close();
            return datas;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static float[] getSurfaceData(String input, EnteteRaster entete, String attribute, Map<String, Integer> codes, float fillValue) {
        try {
            GeoPackage gp = new GeoPackage(new File(input));
            FeatureEntry fe = (FeatureEntry)gp.features().get(0);
            SimpleFeatureReader sfr = gp.reader(fe, null, null);
            Envelope globalEnvelope = new Envelope(entete.minx(), entete.maxx(), entete.miny(), entete.maxy());
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterPolygon rp;
                Polygon the_poly;
                SimpleFeature sf = (SimpleFeature)sfr.next();
                Geometry the_geom = (Geometry)sf.getDefaultGeometry();
                String value = sf.getAttribute(attribute).toString();
                float code = codes.containsKey(value) ? (float)codes.get(value).intValue() : fillValue;
                if (the_geom == null || !the_geom.getEnvelopeInternal().intersects(globalEnvelope)) continue;
                if (the_geom instanceof Polygon) {
                    the_poly = (Polygon)the_geom;
                    rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                    indrp = 0;
                    xdelta = rp.getDeltaI();
                    ydelta = rp.getDeltaJ();
                    float[] fArray = rp.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rp.getWidth();
                            yrp = indrp / rp.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = code;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiPolygon) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_poly = (Polygon)((MultiPolygon)the_geom).getGeometryN(i);
                        rp = RasterPolygon.getRasterPolygon((Polygonal)the_poly, entete.minx(), entete.maxy(), entete.cellsize());
                        indrp = 0;
                        xdelta = rp.getDeltaI();
                        ydelta = rp.getDeltaJ();
                        float[] fArray = rp.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rp.getWidth();
                                yrp = indrp / rp.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = code;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                System.out.println(the_geom);
            }
            sfr.close();
            gp.close();
            return datas;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static float[] getLinearData(String input, EnteteRaster entete, float value, float fillValue, double buffer) {
        try {
            GeoPackage gp = new GeoPackage(new File(input));
            FeatureEntry fe = (FeatureEntry)gp.features().get(0);
            SimpleFeatureReader sfr = gp.reader(fe, null, null);
            Envelope globalEnvelope = new Envelope(entete.minx(), entete.maxx(), entete.miny(), entete.maxy());
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterLineString rls;
                LineString the_line;
                SimpleFeature sf = (SimpleFeature)sfr.next();
                Geometry the_geom = (Geometry)sf.getDefaultGeometry();
                if (the_geom == null || !the_geom.getEnvelopeInternal().intersects(globalEnvelope)) continue;
                if (the_geom instanceof LineString) {
                    the_line = (LineString)the_geom;
                    rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                    if (rls == null) continue;
                    indrp = 0;
                    xdelta = rls.getDeltaI();
                    ydelta = rls.getDeltaJ();
                    float[] fArray = rls.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rls.getWidth();
                            yrp = indrp / rls.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = value;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiLineString) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_line = (LineString)((MultiLineString)the_geom).getGeometryN(i);
                        rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                        if (rls == null) continue;
                        indrp = 0;
                        xdelta = rls.getDeltaI();
                        ydelta = rls.getDeltaJ();
                        float[] fArray = rls.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rls.getWidth();
                                yrp = indrp / rls.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = value;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                System.out.println(the_geom);
            }
            sfr.close();
            gp.close();
            return datas;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static float[] getLinearData(String input, EnteteRaster entete, String attribute, Map<String, Integer> codes, float fillValue, double buffer) {
        try {
            GeoPackage gp = new GeoPackage(new File(input));
            FeatureEntry fe = (FeatureEntry)gp.features().get(0);
            SimpleFeatureReader sfr = gp.reader(fe, null, null);
            Envelope globalEnvelope = new Envelope(entete.minx(), entete.maxx(), entete.miny(), entete.maxy());
            float[] datas = new float[entete.width() * entete.height()];
            Arrays.fill(datas, fillValue);
            while (sfr.hasNext()) {
                int yrp;
                int xrp;
                int n;
                int ydelta;
                int xdelta;
                int indrp;
                RasterLineString rls;
                LineString the_line;
                SimpleFeature sf = (SimpleFeature)sfr.next();
                Geometry the_geom = (Geometry)sf.getDefaultGeometry();
                String value = sf.getAttribute(attribute).toString();
                float code = codes.containsKey(value) ? (float)codes.get(value).intValue() : fillValue;
                if (the_geom == null || !the_geom.getEnvelopeInternal().intersects(globalEnvelope)) continue;
                if (the_geom instanceof LineString) {
                    the_line = (LineString)the_geom;
                    rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                    if (rls == null) continue;
                    indrp = 0;
                    xdelta = rls.getDeltaI();
                    ydelta = rls.getDeltaJ();
                    float[] fArray = rls.getDatas();
                    int n2 = fArray.length;
                    for (n = 0; n < n2; ++n) {
                        double v = fArray[n];
                        if (v == 1.0) {
                            xrp = indrp % rls.getWidth();
                            yrp = indrp / rls.getWidth();
                            if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = code;
                            }
                        }
                        ++indrp;
                    }
                    continue;
                }
                if (the_geom instanceof MultiLineString) {
                    for (int i = 0; i < the_geom.getNumGeometries(); ++i) {
                        the_line = (LineString)((MultiLineString)the_geom).getGeometryN(i);
                        rls = RasterLineString.getRasterLineString((Lineal)the_line, entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.cellsize(), buffer);
                        if (rls == null) continue;
                        indrp = 0;
                        xdelta = rls.getDeltaI();
                        ydelta = rls.getDeltaJ();
                        float[] fArray = rls.getDatas();
                        n = fArray.length;
                        for (int j = 0; j < n; ++j) {
                            double v = fArray[j];
                            if (v == 1.0) {
                                xrp = indrp % rls.getWidth();
                                yrp = indrp / rls.getWidth();
                                if (xdelta + xrp >= 0 && xdelta + xrp < entete.width() && ydelta + yrp >= 0 && ydelta + yrp < entete.height()) {
                                    datas[(ydelta + yrp) * entete.width() + (xdelta + xrp)] = code;
                                }
                            }
                            ++indrp;
                        }
                    }
                    continue;
                }
                System.out.println(the_geom);
            }
            sfr.close();
            gp.close();
            return datas;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

