/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.raster.analysis;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.TileCoverage;
import java.io.File;

public abstract class Pixel2PixelTileCoverageCalculation {
    private String outputFolder;
    private Coverage[] inCoverage;

    public Pixel2PixelTileCoverageCalculation(String outputFolder, Coverage ... inCoverage) {
        this.outputFolder = outputFolder;
        this.inCoverage = inCoverage;
    }

    public void run() {
        String name = new File(this.outputFolder).getName();
        float[] v = new float[this.inCoverage.length];
        int ncols = ((TileCoverage)this.inCoverage[0]).ncols();
        int nrows = ((TileCoverage)this.inCoverage[0]).nrows();
        int size = (int)Math.pow(((TileCoverage)this.inCoverage[0]).tileWidth(), 2.0);
        Coverage[] localCoverage = new Coverage[this.inCoverage.length];
        float[][] localDatas = new float[this.inCoverage.length][size];
        for (int y = 0; y < nrows; ++y) {
            for (int x = 0; x < ncols; ++x) {
                int j;
                boolean pass = true;
                for (j = 0; j < v.length; ++j) {
                    localCoverage[j] = ((TileCoverage)this.inCoverage[j]).getCoverage(x, y);
                    if (localCoverage[j] != null) continue;
                    pass = false;
                    if (j != 1) break;
                    System.out.println("bug en " + localCoverage[0].getEntete());
                    break;
                }
                if (!pass) continue;
                float[] outData = new float[size];
                EnteteRaster localEntete = localCoverage[0].getEntete();
                for (j = 0; j < v.length; ++j) {
                    localDatas[j] = localCoverage[j].getData();
                    localCoverage[j].dispose();
                }
                for (int i = 0; i < size; ++i) {
                    for (int j2 = 0; j2 < v.length; ++j2) {
                        v[j2] = localDatas[j2][i];
                    }
                    outData[i] = this.doTreat(v);
                }
                CoverageManager.writeGeotiff(this.outputFolder + name + "_" + (int)localEntete.minx() / 1000 + "_" + (int)localEntete.maxy() / 1000 + ".tif", outData, localEntete);
            }
        }
    }

    protected abstract float doTreat(float[] var1);
}

