/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.raster;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;

public class TileCoverage
extends Coverage {
    private int ncols;
    private int nrows;
    private int tileWidth;
    private int tileHeight;
    private Coverage[] grid;
    private int noDataValue;

    public TileCoverage(Set<Coverage> tiles, EnteteRaster entete) {
        super(entete);
        this.noDataValue = entete.noDataValue();
        this.initGrid(tiles);
    }

    public Coverage getCoverage(int i, int j) {
        if (i < 0 || i >= this.tileWidth || j < 0 || j >= this.tileHeight) {
            return null;
        }
        return this.grid[j * this.ncols + i];
    }

    public int ncols() {
        return this.ncols;
    }

    public int nrows() {
        return this.nrows;
    }

    public double tileSize() {
        return (float)this.tileWidth * this.getEntete().cellsize();
    }

    public int tileWidth() {
        return this.tileWidth;
    }

    private void initGrid(Set<Coverage> tiles) {
        Coverage cov = tiles.iterator().next();
        this.tileWidth = cov.width();
        this.tileHeight = cov.height();
        this.ncols = new Double(Math.round(this.getEntete().maxx() - this.getEntete().minx()) / (long)(this.tileWidth * (int)this.getEntete().cellsize())).intValue();
        if (Math.round(this.getEntete().maxx() - this.getEntete().minx()) % (long)(this.tileWidth * (int)this.getEntete().cellsize()) != 0L) {
            ++this.ncols;
        }
        this.nrows = new Double(Math.round(this.getEntete().maxy() - this.getEntete().miny()) / (long)(this.tileHeight * (int)this.getEntete().cellsize())).intValue();
        if (Math.round(this.getEntete().maxy() - this.getEntete().miny()) % (long)(this.tileHeight * (int)this.getEntete().cellsize()) != 0L) {
            ++this.nrows;
        }
        this.grid = new Coverage[this.ncols * this.nrows];
        for (Coverage tile : tiles) {
            int posX = new Double(Math.round(tile.getEntete().minx() - this.getEntete().minx()) / (long)(this.tileWidth * (int)this.getEntete().cellsize())).intValue();
            int posY = new Double(Math.round(this.getEntete().maxy() - tile.getEntete().maxy()) / (long)(this.tileHeight * (int)this.getEntete().cellsize())).intValue();
            this.grid[posY * this.ncols + posX] = tile;
        }
    }

    @Override
    public float[] getData() {
        float[] datas = new float[this.width() * this.height()];
        for (int j = 0; j < this.nrows; ++j) {
            for (int i = 0; i < this.ncols; ++i) {
                int x;
                int y;
                Coverage tile = this.grid[j * this.ncols + i];
                if (tile != null) {
                    float[] d = tile.getData();
                    for (y = 0; y < this.tileHeight; ++y) {
                        for (x = 0; x < this.tileWidth; ++x) {
                            datas[(j * this.tileHeight + y) * this.width() + (i * this.tileWidth + x)] = d[y * this.tileWidth + x];
                        }
                    }
                    continue;
                }
                for (y = 0; y < this.tileHeight; ++y) {
                    for (x = 0; x < this.tileWidth; ++x) {
                        datas[(j * this.tileHeight + y) * this.width() + (i * this.tileWidth + x)] = this.noDataValue;
                    }
                }
            }
        }
        return datas;
    }

    @Override
    public float[] getData(Rectangle roi) {
        EnteteRaster roiEntete = EnteteRaster.getEntete(this.getEntete(), roi);
        Envelope roiEnv = roiEntete.getEnvelope();
        float[] data = new float[roiEntete.width() * roiEntete.height()];
        Arrays.fill(data, (float)this.noDataValue);
        for (int j = 0; j < this.nrows; ++j) {
            for (int i = 0; i < this.ncols; ++i) {
                Envelope localEnv;
                Envelope tileEnv;
                Coverage tile = this.grid[j * this.ncols + i];
                if (tile == null || !roiEnv.intersects(tileEnv = tile.getEntete().getEnvelope()) || (localEnv = roiEnv.intersection(tileEnv)).getMinX() == localEnv.getMaxX() || localEnv.getMinY() == localEnv.getMaxY()) continue;
                Rectangle localRoi = EnteteRaster.getROI(tile.getEntete(), localEnv);
                if (localRoi.width == 0 || localRoi.height == 0) continue;
                float[] localData = tile.getData(localRoi);
                Rectangle tileRoi = EnteteRaster.getROI(roiEntete, localEnv);
                for (int y = 0; y < localRoi.height; ++y) {
                    for (int x = 0; x < localRoi.width; ++x) {
                        data[(y + tileRoi.y) * roiEntete.width() + x + tileRoi.x] = localData[y * localRoi.width + x];
                    }
                }
            }
        }
        return data;
    }

    @Override
    public void dispose() {
        if (this.grid != null) {
            for (Coverage tile : this.grid) {
                if (tile == null) continue;
                tile.dispose();
            }
        }
        this.grid = null;
    }
}

