/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.raster;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.TileCoverage;
import org.locationtech.jts.geom.Envelope;

public class Tile {
    private Envelope envelope;
    private int ncols;
    private int nrows;
    private double tileLength;
    private boolean[] grid;

    public Tile(Envelope envelope, int ncols, int nrows, double tileLength) {
        this.envelope = envelope;
        this.ncols = ncols;
        this.nrows = nrows;
        this.tileLength = tileLength;
    }

    public Tile(Envelope envelope, int ncols, int nrows, double tileLength, boolean[] grid) {
        this(envelope, ncols, nrows, tileLength);
        this.grid = grid;
    }

    public boolean hasTile(int i, int j) {
        if (this.grid != null) {
            return this.grid[j * this.ncols + i];
        }
        return true;
    }

    public boolean[] grid() {
        return this.grid;
    }

    public String toString() {
        return this.envelope + " " + this.ncols + " " + this.nrows + " " + this.tileLength;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public Envelope getEnvelope(int i, int j) {
        return new Envelope(this.envelope.getMinX() + (double)i * this.tileLength, this.envelope.getMinX() + (double)(i + 1) * this.tileLength, this.envelope.getMaxY() - (double)(j + 1) * this.tileLength, this.envelope.getMaxY() - (double)j * this.tileLength);
    }

    public double getMinX() {
        return this.envelope.getMinX();
    }

    public double getMaxX() {
        return this.envelope.getMaxX();
    }

    public double getMinY() {
        return this.envelope.getMinY();
    }

    public double getMaxY() {
        return this.envelope.getMaxY();
    }

    public int getNcols() {
        return this.ncols;
    }

    public int getNrows() {
        return this.nrows;
    }

    public double getTileLength() {
        return this.tileLength;
    }

    public static Tile getTile(String tileFolder) {
        return Tile.getTile((TileCoverage)CoverageManager.getCoverage(tileFolder));
    }

    public static Tile getTile(TileCoverage tileCoverage) {
        Envelope envelope = new Envelope(tileCoverage.getEntete().minx(), tileCoverage.getEntete().maxx(), tileCoverage.getEntete().miny(), tileCoverage.getEntete().maxy());
        int ncols = tileCoverage.ncols();
        int nrows = tileCoverage.nrows();
        double tileSize = tileCoverage.tileSize();
        boolean[] grid = new boolean[ncols * nrows];
        for (int j = 0; j < nrows; ++j) {
            for (int i = 0; i < ncols; ++i) {
                if (tileCoverage.getCoverage(i, j) == null) continue;
                grid[j * ncols + i] = true;
            }
        }
        return new Tile(envelope, ncols, nrows, tileSize, grid);
    }

    public static Tile getTile(Tile refTile, Envelope envelope) {
        int deltaMinX = new Double((envelope.getMinX() - refTile.getMinX()) / refTile.tileLength).intValue();
        int deltaMaxX = new Double((refTile.getMaxX() - envelope.getMaxX()) / refTile.tileLength).intValue();
        int deltaMinY = new Double((envelope.getMinY() - refTile.getMinY()) / refTile.tileLength).intValue();
        int deltaMaxY = new Double((refTile.getMaxY() - envelope.getMaxY()) / refTile.tileLength).intValue();
        if (deltaMinX < 0) {
            --deltaMinX;
        }
        double minX = refTile.getMinX() + (double)deltaMinX * refTile.tileLength;
        if (deltaMaxX < 0) {
            --deltaMaxX;
        }
        double maxX = refTile.getMaxX() - (double)deltaMaxX * refTile.tileLength;
        if (deltaMinY < 0) {
            --deltaMinY;
        }
        double minY = refTile.getMinY() + (double)deltaMinY * refTile.tileLength;
        if (deltaMaxY < 0) {
            --deltaMaxY;
        }
        double maxY = refTile.getMaxY() - (double)deltaMaxY * refTile.tileLength;
        Envelope env = new Envelope(minX, maxX, minY, maxY);
        int ncols = refTile.ncols - deltaMinX - deltaMaxX;
        int nrows = refTile.nrows - deltaMinY - deltaMaxY;
        return new Tile(env, ncols, nrows, refTile.tileLength);
    }
}

