/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.raster;

import fr.inrae.act.bagap.apiland.core.space.ComplexGeometry;
import fr.inrae.act.bagap.apiland.core.space.Curve;
import fr.inrae.act.bagap.apiland.core.space.Surface;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedPolygon;

public class RasterPolygon
extends fr.inrae.act.bagap.apiland.core.space.Geometry {
    private static final long serialVersionUID = 1L;
    private int deltaI;
    private int deltaJ;
    private float[] datas;
    private int width;
    private int height;

    public RasterPolygon(int deltaI, int deltaJ, int width, int height, float[] datas) {
        this.deltaI = deltaI;
        this.deltaJ = deltaJ;
        this.width = width;
        this.height = height;
        this.datas = datas;
    }

    public static RasterPolygon getRasterPolygon(Polygonal poly, double minx, double maxy, double cellsize) {
        Envelope internal = null;
        if (poly instanceof Polygon) {
            internal = ((Polygon)poly).getEnvelopeInternal();
        } else if (poly instanceof MultiPolygon) {
            internal = ((MultiPolygon)poly).getEnvelopeInternal();
        }
        double iminx = internal.getMinX();
        double imaxx = internal.getMaxX();
        double iminy = internal.getMinY();
        double imaxy = internal.getMaxY();
        int deltaI = new Double((iminx - minx) / cellsize).intValue();
        int deltaJ = new Double((maxy - imaxy) / cellsize).intValue();
        double eminx = minx + cellsize * (double)deltaI;
        double emaxy = maxy - cellsize * (double)deltaJ;
        int width = new Double((imaxx - eminx) / cellsize).intValue() + 1;
        int height = new Double((emaxy - iminy) / cellsize).intValue() + 1;
        float[] datas = new float[width * height];
        PreparedPolygon pp = new PreparedPolygon(poly);
        GeometryFactory gf = new GeometryFactory();
        Coordinate coord = new Coordinate(0.0, 0.0);
        Point p = gf.createPoint(coord);
        for (int j = 0; j < height; ++j) {
            double y = emaxy - cellsize / 2.0 - (double)j * cellsize;
            for (int i = 0; i < width; ++i) {
                double x = eminx + cellsize / 2.0 + (double)i * cellsize;
                coord.setX(x);
                coord.setY(y);
                p.geometryChanged();
                if (!pp.intersects((Geometry)p)) continue;
                datas[j * width + i] = 1.0f;
            }
        }
        return new RasterPolygon(deltaI, deltaJ, width, height, datas);
    }

    public int getDeltaI() {
        return this.deltaI;
    }

    public int getDeltaJ() {
        return this.deltaJ;
    }

    public float[] getDatas() {
        return this.datas;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public fr.inrae.act.bagap.apiland.core.space.Geometry smooth() {
        return this;
    }

    @Override
    public fr.inrae.act.bagap.apiland.core.space.Geometry addGeometry(fr.inrae.act.bagap.apiland.core.space.Geometry g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public fr.inrae.act.bagap.apiland.core.space.Geometry addCurve(Curve g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public fr.inrae.act.bagap.apiland.core.space.Geometry addSurface(Surface g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <G extends fr.inrae.act.bagap.apiland.core.space.Geometry> fr.inrae.act.bagap.apiland.core.space.Geometry addComplexGeometry(ComplexGeometry<G> g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public fr.inrae.act.bagap.apiland.core.space.Geometry addPoint(fr.inrae.act.bagap.apiland.core.space.Point g) {
        throw new UnsupportedOperationException();
    }
}

