/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.raster;

import fr.inrae.act.bagap.apiland.core.space.ComplexGeometry;
import fr.inrae.act.bagap.apiland.core.space.Curve;
import fr.inrae.act.bagap.apiland.core.space.Surface;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;

public class RasterLineString
extends fr.inrae.act.bagap.apiland.core.space.Geometry {
    private static final long serialVersionUID = 1L;
    private int deltaI;
    private int deltaJ;
    private float[] datas;
    private int width;
    private int height;

    public RasterLineString(int deltaI, int deltaJ, int width, int height, float[] datas) {
        this.deltaI = deltaI;
        this.deltaJ = deltaJ;
        this.width = width;
        this.height = height;
        this.datas = datas;
    }

    public static RasterLineString getRasterLineString(LineString line, double minx, double maxx, double miny, double maxy, double cellsize) {
        return RasterLineString.getRasterLineString((Lineal)line, minx, maxx, miny, maxy, cellsize, 0.0);
    }

    public static RasterLineString getRasterLineString(Lineal line, double minx, double maxx, double miny, double maxy, double cellsize, double buffer) {
        Envelope internal = null;
        if (line instanceof LineString) {
            internal = ((LineString)line).getEnvelopeInternal();
        } else if (line instanceof MultiLineString) {
            internal = ((MultiLineString)line).getEnvelopeInternal();
        }
        double iminx = Math.max(minx, internal.getMinX());
        double imaxx = Math.min(maxx, internal.getMaxX());
        double iminy = Math.max(miny, internal.getMinY());
        double imaxy = Math.min(maxy, internal.getMaxY());
        int deltaI = new Double((iminx - minx) / cellsize).intValue();
        int deltaJ = new Double((maxy - imaxy) / cellsize).intValue();
        double eminx = minx + cellsize * (double)deltaI;
        double emaxy = maxy - cellsize * (double)deltaJ;
        int width = new Double((imaxx - eminx) / cellsize).intValue() + 1;
        int height = new Double((emaxy - iminy) / cellsize).intValue() + 1;
        float[] datas = new float[width * height];
        GeometryFactory gf = new GeometryFactory();
        boolean ok = false;
        for (int j = 0; j < height; ++j) {
            double y = emaxy - cellsize / 2.0 - (double)j * cellsize;
            for (int i = 0; i < width; ++i) {
                double x = eminx + cellsize / 2.0 + (double)i * cellsize;
                Point p = gf.createPoint(new Coordinate(x, y));
                if (!(((LineString)line).distance((Geometry)p) <= (cellsize + buffer) / 2.0 * Math.sqrt(2.0))) continue;
                datas[j * width + i] = 1.0f;
                ok = true;
            }
        }
        if (ok) {
            return new RasterLineString(deltaI, deltaJ, width, height, datas);
        }
        return null;
    }

    public int getDeltaI() {
        return this.deltaI;
    }

    public int getDeltaJ() {
        return this.deltaJ;
    }

    public float[] getDatas() {
        return this.datas;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public fr.inrae.act.bagap.apiland.core.space.Geometry smooth() {
        return this;
    }

    @Override
    public fr.inrae.act.bagap.apiland.core.space.Geometry addGeometry(fr.inrae.act.bagap.apiland.core.space.Geometry g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public fr.inrae.act.bagap.apiland.core.space.Geometry addCurve(Curve g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public fr.inrae.act.bagap.apiland.core.space.Geometry addSurface(Surface g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <G extends fr.inrae.act.bagap.apiland.core.space.Geometry> fr.inrae.act.bagap.apiland.core.space.Geometry addComplexGeometry(ComplexGeometry<G> g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public fr.inrae.act.bagap.apiland.core.space.Geometry addPoint(fr.inrae.act.bagap.apiland.core.space.Point g) {
        throw new UnsupportedOperationException();
    }
}

