/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.raster;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.util.ImageUtilities;

public class FileCoverage
extends Coverage {
    private GridCoverage2D coverage;

    public FileCoverage(GridCoverage2D coverage, EnteteRaster entete) {
        super(entete);
        this.coverage = coverage;
    }

    public void setCoverage2D(GridCoverage2D gc2d) {
        this.coverage = gc2d;
    }

    @Override
    public float[] getData() {
        return this.getData(new Rectangle(0, 0, this.getEntete().width(), this.getEntete().height()));
    }

    @Override
    public float[] getData(Rectangle roi) {
        float[] datas = new float[roi.width * roi.height];
        datas = this.coverage.getRenderedImage().getData(roi).getSamples(roi.x, roi.y, roi.width, roi.height, 0, datas);
        return datas;
    }

    @Override
    public void dispose() {
        if (this.coverage != null) {
            PlanarImage planarImage = (PlanarImage)this.coverage.getRenderedImage();
            ImageUtilities.disposeImage((RenderedImage)planarImage);
            planarImage = null;
            this.coverage.dispose(true);
            this.coverage = null;
        }
    }
}

