/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.raster;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EnteteRaster {
    private static final float tolerance = 0.001f;
    private int width;
    private int height;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private float cellsize;
    private int noDataValue;
    private CoordinateReferenceSystem crs;

    public EnteteRaster(int width, int height, double minx, double maxx, double miny, double maxy, float cellsize, int noDataValue) {
        this.width = width;
        this.height = height;
        this.minx = minx;
        this.maxx = maxx;
        this.miny = miny;
        this.maxy = maxy;
        this.cellsize = cellsize;
        this.noDataValue = noDataValue;
        try {
            this.crs = CRS.decode((String)"EPSG:2154");
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    public EnteteRaster(int width, int height, double minx, double maxx, double miny, double maxy, float cellsize, int noDataValue, CoordinateReferenceSystem crs) {
        this.width = width;
        this.height = height;
        this.minx = minx;
        this.maxx = maxx;
        this.miny = miny;
        this.maxy = maxy;
        this.cellsize = cellsize;
        this.noDataValue = noDataValue;
        if (crs == null) {
            try {
                this.crs = CRS.decode((String)"EPSG:2154");
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
        } else {
            this.crs = crs;
        }
    }

    public String toString() {
        return this.width + " " + this.height + " " + this.minx + " " + this.maxx + " " + this.miny + " " + this.maxy + " " + this.cellsize + " " + this.noDataValue + " " + CRS.toSRS((CoordinateReferenceSystem)this.crs);
    }

    public CoordinateReferenceSystem crs() {
        return this.crs;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public double minx() {
        return this.minx;
    }

    public double maxx() {
        return this.maxx;
    }

    public double miny() {
        return this.miny;
    }

    public double maxy() {
        return this.maxy;
    }

    public float cellsize() {
        return this.cellsize;
    }

    public int noDataValue() {
        return this.noDataValue;
    }

    public void setNoDataValue(int noDataValue) {
        this.noDataValue = noDataValue;
    }

    public Envelope getEnvelope() {
        return new Envelope(this.minx, this.maxx, this.miny, this.maxy);
    }

    public static EnteteRaster getEntete(EnteteRaster refEntete, Rectangle roi) {
        double minX = refEntete.minx + (double)((float)roi.x * refEntete.cellsize);
        double maxX = minX + (double)((float)roi.width * refEntete.cellsize);
        double maxY = refEntete.maxy - (double)((float)roi.y * refEntete.cellsize);
        double minY = maxY - (double)((float)roi.height * refEntete.cellsize);
        return new EnteteRaster(roi.width, roi.height, minX, maxX, minY, maxY, refEntete.cellsize, refEntete.noDataValue);
    }

    public static Rectangle getROI(EnteteRaster refEntete, Envelope env) {
        double distX = env.getMinX() - refEntete.minx;
        int xx = (int)(distX / (double)refEntete.cellsize);
        double diffX = env.getMinX() - (refEntete.minx + (double)((float)xx * refEntete.cellsize));
        int nc = (int)((diffX + env.getMaxX() - env.getMinX()) / (double)refEntete.cellsize);
        if ((diffX + env.getMaxX() - env.getMinX()) % (double)refEntete.cellsize > (double)0.001f) {
            ++nc;
        }
        double distY = refEntete.maxy - env.getMaxY();
        int yy = (int)(distY / (double)refEntete.cellsize);
        double diffY = refEntete.maxy - (double)((float)yy * refEntete.cellsize) - env.getMaxY();
        int nr = (int)((diffY + env.getMaxY() - env.getMinY()) / (double)refEntete.cellsize);
        if ((diffY + env.getMaxY() - env.getMinY()) % (double)refEntete.cellsize > (double)0.001f) {
            ++nr;
        }
        return new Rectangle(xx, yy, nc, nr);
    }

    public static Rectangle getROI2(EnteteRaster refEntete, Envelope env) {
        double distX = env.getMinX() - refEntete.minx;
        int xx = (int)(distX / (double)refEntete.cellsize);
        double diffX = env.getMinX() - (refEntete.minx + (double)((float)xx * refEntete.cellsize));
        int nc = (int)((diffX + env.getMaxX() - env.getMinX()) / (double)refEntete.cellsize);
        double distY = refEntete.maxy - env.getMaxY();
        int yy = (int)(distY / (double)refEntete.cellsize);
        double diffY = refEntete.maxy - (double)((float)yy * refEntete.cellsize) - env.getMaxY();
        int nr = (int)((diffY + env.getMaxY() - env.getMinY()) / (double)refEntete.cellsize);
        return new Rectangle(xx, yy, nc, nr);
    }

    public static EnteteRaster getEntete(EnteteRaster refEntete, Envelope env) {
        double distX = env.getMinX() - refEntete.minx;
        int xx = (int)(distX / (double)refEntete.cellsize);
        double diffX = env.getMinX() - (refEntete.minx + (double)((float)xx * refEntete.cellsize));
        int nc = (int)((diffX + env.getMaxX() - env.getMinX()) / (double)refEntete.cellsize);
        if ((diffX + env.getMaxX() - env.getMinX()) % (double)refEntete.cellsize > (double)0.001f) {
            ++nc;
        }
        double distY = refEntete.maxy - env.getMaxY();
        int yy = (int)(distY / (double)refEntete.cellsize);
        double diffY = refEntete.maxy - (double)((float)yy * refEntete.cellsize) - env.getMaxY();
        int nr = (int)((diffY + env.getMaxY() - env.getMinY()) / (double)refEntete.cellsize);
        if ((diffY + env.getMaxY() - env.getMinY()) % (double)refEntete.cellsize > (double)0.001f) {
            ++nr;
        }
        double minX = refEntete.minx + (double)((float)xx * refEntete.cellsize);
        double maxX = minX + (double)((float)nc * refEntete.cellsize);
        double maxY = refEntete.maxy - (double)((float)yy * refEntete.cellsize);
        double minY = maxY - (double)((float)nr * refEntete.cellsize);
        return new EnteteRaster(nc, nr, minX, maxX, minY, maxY, refEntete.cellsize, refEntete.noDataValue);
    }

    public static EnteteRaster getEntete(Envelope envelope, float cellsize, int noDataValue, CoordinateReferenceSystem crs) {
        int ncols = new Double((float)Math.round(envelope.getMaxX() - envelope.getMinX()) / cellsize).intValue();
        if ((float)Math.round(envelope.getMaxX() - envelope.getMinX()) % cellsize != 0.0f) {
            ++ncols;
        }
        int nrows = new Double((float)Math.round(envelope.getMaxY() - envelope.getMinY()) / cellsize).intValue();
        if ((float)Math.round(envelope.getMaxY() - envelope.getMinY()) % cellsize != 0.0f) {
            ++nrows;
        }
        return new EnteteRaster(ncols, nrows, envelope.getMinX(), envelope.getMinX() + (double)((float)ncols * cellsize), envelope.getMinY(), envelope.getMinY() + (double)((float)nrows * cellsize), cellsize, noDataValue, crs);
    }

    public static EnteteRaster getEntete(Envelope envelope, float cellsize, int noDataValue) {
        int ncols = new Double((float)Math.round(envelope.getMaxX() - envelope.getMinX()) / cellsize).intValue();
        if ((float)Math.round(envelope.getMaxX() - envelope.getMinX()) % cellsize != 0.0f) {
            ++ncols;
        }
        int nrows = new Double((float)Math.round(envelope.getMaxY() - envelope.getMinY()) / cellsize).intValue();
        if ((float)Math.round(envelope.getMaxY() - envelope.getMinY()) % cellsize != 0.0f) {
            ++nrows;
        }
        return new EnteteRaster(ncols, nrows, envelope.getMinX(), envelope.getMinX() + (double)((float)ncols * cellsize), envelope.getMinY(), envelope.getMinY() + (double)((float)nrows * cellsize), cellsize, noDataValue);
    }

    public static EnteteRaster sum(EnteteRaster entete1, EnteteRaster entete2) {
        if (entete1.cellsize != entete2.cellsize || entete1.noDataValue != entete2.noDataValue) {
            throw new IllegalArgumentException();
        }
        double minx = Math.min(entete1.minx, entete2.minx);
        double maxx = Math.max(entete1.maxx, entete2.maxx);
        double miny = Math.min(entete1.miny, entete2.miny);
        double maxy = Math.max(entete1.maxy, entete2.maxy);
        return EnteteRaster.getEntete(new Envelope(minx, maxx, miny, maxy), entete1.cellsize, entete1.noDataValue, entete1.crs);
    }

    public static EnteteRaster getEntete(Set<EnteteRaster> entetes) {
        EnteteRaster entete = entetes.iterator().next();
        for (EnteteRaster e : entetes) {
            entete = EnteteRaster.sum(entete, e);
        }
        return entete;
    }

    public static EnteteRaster read(String enteteFile) {
        try {
            Properties properties = new Properties();
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(enteteFile), "UTF8");
            properties.load(in);
            ((Reader)in).close();
            int width = Integer.parseInt(properties.getProperty("width"));
            int height = Integer.parseInt(properties.getProperty("height"));
            double minx = Double.parseDouble(properties.getProperty("minx"));
            double maxx = Double.parseDouble(properties.getProperty("maxx"));
            double miny = Double.parseDouble(properties.getProperty("miny"));
            double maxy = Double.parseDouble(properties.getProperty("maxy"));
            float cellsize = Float.parseFloat(properties.getProperty("cellsize"));
            int noDataValue = Integer.parseInt(properties.getProperty("nodata_value"));
            CoordinateReferenceSystem crs = null;
            try {
                crs = properties.containsKey("crs") ? CRS.decode((String)properties.getProperty("crs")) : CRS.decode((String)"EPSG:2154");
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
            return new EnteteRaster(width, height, minx, maxx, miny, maxy, cellsize, noDataValue, crs);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static EnteteRaster readFromAsciiGridHeader(String asciiHeader) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(asciiHeader));
            String line = br.readLine();
            StringTokenizer st = new StringTokenizer(line, " ");
            st.nextToken();
            int width = Integer.parseInt(st.nextToken());
            line = br.readLine();
            st = new StringTokenizer(line, " ");
            st.nextToken();
            int height = Integer.parseInt(st.nextToken());
            line = br.readLine();
            st = new StringTokenizer(line, " ");
            st.nextToken();
            double minx = Double.parseDouble(st.nextToken());
            line = br.readLine();
            st = new StringTokenizer(line, " ");
            st.nextToken();
            double miny = Double.parseDouble(st.nextToken());
            line = br.readLine();
            st = new StringTokenizer(line, " ");
            st.nextToken();
            float cellSize = Float.parseFloat(st.nextToken());
            line = br.readLine();
            st = new StringTokenizer(line, " ");
            st.nextToken();
            int noDataValue = Integer.parseInt(st.nextToken());
            br.close();
            double maxx = minx + (double)((float)width * cellSize);
            double maxy = miny + (double)((float)height * cellSize);
            return new EnteteRaster(width, height, minx, maxx, miny, maxy, cellSize, noDataValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void export(EnteteRaster entete, String paramFile) {
        try {
            Properties properties = new Properties();
            properties.setProperty("width", entete.width + "");
            properties.setProperty("height", entete.height + "");
            properties.setProperty("minx", entete.minx + "");
            properties.setProperty("maxx", entete.maxx + "");
            properties.setProperty("miny", entete.miny + "");
            properties.setProperty("maxy", entete.maxy + "");
            properties.setProperty("cellsize", entete.cellsize + "");
            properties.setProperty("nodata_value", entete.noDataValue + "");
            properties.setProperty("crs", CRS.toSRS((CoordinateReferenceSystem)entete.crs));
            FileOutputStream out = new FileOutputStream(paramFile);
            properties.store(out, "parameter file generated with APILand");
            out.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

