/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.raster;

import com.sun.media.jai.codecimpl.util.RasterFactory;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.FileCoverage;
import fr.inrae.act.bagap.apiland.raster.TileCoverage;
import fr.inrae.act.bagap.apiland.util.Tool;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataSourceException;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.CRS;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CoverageManager {
    private static String epsg = "lambert93.prj";

    public static String epsg() {
        return epsg;
    }

    public static Coverage getCoverage(String raster) {
        if (new File(raster).isDirectory()) {
            return CoverageManager.getTileCoverage(raster);
        }
        ArcGridReader reader = null;
        try {
            File file;
            if (raster.endsWith(".asc")) {
                file = new File(raster);
                reader = new ArcGridReader((Object)file);
            } else if (raster.endsWith(".tif")) {
                file = new File(raster);
                reader = new GeoTiffReader((Object)file);
            } else {
                throw new IllegalArgumentException(raster + " is not a recognize raster");
            }
            GridCoverage2D coverage2D = reader.read(null);
            reader.dispose();
            int inWidth = (Integer)coverage2D.getProperty("image_width");
            int inHeight = (Integer)coverage2D.getProperty("image_height");
            double inMinX = coverage2D.getEnvelope().getMinimum(0);
            double inMinY = coverage2D.getEnvelope().getMinimum(1);
            double inMaxX = coverage2D.getEnvelope().getMaximum(0);
            double inMaxY = coverage2D.getEnvelope().getMaximum(1);
            float inCellSize = (float)((AffineTransform)coverage2D.getGridGeometry().getGridToCRS2D()).getScaleX();
            CoordinateReferenceSystem crs = coverage2D.getEnvelope().getCoordinateReferenceSystem();
            int noDataValue = -1;
            GridSampleDimension dim = coverage2D.getSampleDimension(0);
            if (dim.getNoDataValues() != null) {
                noDataValue = (int)dim.getNoDataValues()[0];
            }
            EnteteRaster entete = new EnteteRaster(inWidth, inHeight, inMinX, inMaxX, inMinY, inMaxY, inCellSize, noDataValue, crs);
            FileCoverage coverage = new FileCoverage(coverage2D, entete);
            return coverage;
        }
        catch (DataSourceException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Coverage getTileCoverage(String raster) {
        File folder = new File(raster);
        HashSet<Coverage> tiles = new HashSet<Coverage>();
        HashSet<EnteteRaster> entetes = new HashSet<EnteteRaster>();
        for (String file : folder.list()) {
            if (!file.endsWith(".asc") && !file.endsWith(".tif")) continue;
            Coverage tile = CoverageManager.getCoverage(folder + "/" + file);
            tiles.add(tile);
            entetes.add(tile.getEntete());
        }
        EnteteRaster entete = EnteteRaster.getEntete(entetes);
        return new TileCoverage(tiles, entete);
    }

    public static void write(String raster, float[] data, EnteteRaster entete) {
        if (raster.endsWith(".asc")) {
            CoverageManager.writeAsciiGrid(raster, data, entete);
        } else if (raster.endsWith(".tif")) {
            CoverageManager.writeGeotiff(raster, data, entete);
        } else {
            throw new IllegalArgumentException("format for " + raster + " not recognized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAsciiGrid(String ascii, float[] datas, EnteteRaster entete) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(ascii));
            writer.write("ncols " + entete.width());
            writer.newLine();
            writer.write("nrows " + entete.height());
            writer.newLine();
            writer.write("xllcorner " + entete.minx());
            writer.newLine();
            writer.write("yllcorner " + entete.miny());
            writer.newLine();
            writer.write("cellsize " + entete.cellsize());
            writer.newLine();
            writer.write("NODATA_value " + entete.noDataValue());
            writer.newLine();
            for (int j = 0; j < entete.height(); ++j) {
                for (int i = 0; i < entete.width(); ++i) {
                    writer.write(datas[j * entete.width() + i] + " ");
                }
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(CoverageManager.class.getResourceAsStream(CoverageManager.epsg()), ascii.replace(".asc", "") + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeGeotiff(String out, float[] datas, EnteteRaster entete) {
        CoverageManager.writeGeotiff(out, datas, entete, null);
    }

    public static void writeGeotiff(String out, float[] datas, EnteteRaster entete, String compressionType) {
        try {
            WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)entete.width(), (int)entete.height(), (int)1, null);
            raster.setSamples(0, 0, entete.width(), entete.height(), 0, datas);
            Category noDataCategory = new Category((CharSequence)Category.NODATA.getName(), new Color(0, 0, 0, 0), entete.noDataValue());
            Category[] categories = new Category[]{noDataCategory};
            GridSampleDimension[] bands = new GridSampleDimension[]{new GridSampleDimension(null, categories, null)};
            ReferencedEnvelope env = new ReferencedEnvelope(entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.crs());
            GridCoverageFactory gcf = new GridCoverageFactory();
            GridCoverage2D coverage = gcf.create((CharSequence)"TIMEGRID", raster, (Envelope)env, bands);
            GeoTiffWriteParams wp = new GeoTiffWriteParams();
            wp.setCompressionMode(2);
            if (compressionType != null) {
                wp.setCompressionType(compressionType);
            }
            ParameterValueGroup params = new GeoTiffFormat().getWriteParameters();
            params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
            GeoTiffWriter writer = new GeoTiffWriter((Object)new File(out));
            writer.write((GridCoverage)coverage, params.values().toArray(new GeneralParameterValue[1]));
            coverage.dispose(true);
            PlanarImage planarImage = (PlanarImage)coverage.getRenderedImage();
            ImageUtilities.disposePlanarImageChain((PlanarImage)planarImage);
            coverage = null;
            writer.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeGeotiffHuge(GridCoverage2D coverage, File out, float[] datas, int width, int height, int roiWidth, int roiHeight, int posX, int posY, double minX, double maxX, double minY, double maxY) {
        try {
            WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)1, null);
            raster.setSamples(posX, posY, roiWidth, roiHeight, 0, datas);
            ReferencedEnvelope env = new ReferencedEnvelope(minX, maxX, minY, maxY, CRS.decode((String)"EPSG:2154"));
            GridCoverageFactory gcf = new GridCoverageFactory();
            ((WritableRenderedImage)coverage.getRenderedImage()).setData(raster);
            GeoTiffWriteParams wp = new GeoTiffWriteParams();
            wp.setCompressionMode(2);
            wp.setCompressionType("LZW");
            ParameterValueGroup params = new GeoTiffFormat().getWriteParameters();
            params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
            GeoTiffWriter writer = new GeoTiffWriter((Object)out);
            writer.write((GridCoverage)coverage, params.values().toArray(new GeneralParameterValue[1]));
            writer.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeGeotiff(String out, float[] datas, int width, int height, double minX, double maxX, double minY, double maxY, int noDataValue) {
        CoverageManager.writeGeotiff(new File(out), datas, width, height, minX, maxX, minY, maxY, noDataValue);
    }

    public static void writeGeotiff(File out, float[] datas, int width, int height, double minX, double maxX, double minY, double maxY, int noDataValue) {
        try {
            WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)1, null);
            raster.setSamples(0, 0, width, height, 0, datas);
            Category noDataCategory = new Category((CharSequence)Category.NODATA.getName(), new Color(0, 0, 0, 0), noDataValue);
            Category[] categories = new Category[]{noDataCategory};
            GridSampleDimension[] bands = new GridSampleDimension[]{new GridSampleDimension(null, categories, null)};
            ReferencedEnvelope env = new ReferencedEnvelope(minX, maxX, minY, maxY, CRS.decode((String)"EPSG:2154"));
            GridCoverageFactory gcf = new GridCoverageFactory();
            GridCoverage2D coverage = gcf.create((CharSequence)"TIMEGRID", raster, (Envelope)env, bands);
            GeoTiffWriteParams wp = new GeoTiffWriteParams();
            wp.setCompressionMode(2);
            ParameterValueGroup params = new GeoTiffFormat().getWriteParameters();
            params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
            GeoTiffWriter writer = new GeoTiffWriter((Object)out);
            writer.write((GridCoverage)coverage, params.values().toArray(new GeneralParameterValue[1]));
            coverage.dispose(true);
            PlanarImage planarImage = (PlanarImage)coverage.getRenderedImage();
            ImageUtilities.disposePlanarImageChain((PlanarImage)planarImage);
            coverage = null;
            writer.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridCoverage2D get(String raster) {
        ArcGridReader reader = null;
        try {
            File file = new File(raster);
            if (raster.endsWith(".asc")) {
                reader = new ArcGridReader((Object)file);
            } else if (raster.endsWith(".tif") || raster.endsWith(".tiff")) {
                reader = new GeoTiffReader((Object)file);
            } else {
                throw new IllegalArgumentException("format not supported for " + raster);
            }
            GridCoverage2D gridCoverage2D = reader.read(null);
            return gridCoverage2D;
        }
        catch (DataSourceException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            reader.dispose();
        }
        return null;
    }

    public static float[] getData(GridCoverage2D coverage, int roiX, int roiY, int roiWidth, int roiHeight) {
        Rectangle roi = new Rectangle(roiX, roiY, roiWidth, roiHeight);
        float[] inDatas = new float[roiWidth * roiHeight];
        inDatas = coverage.getRenderedImage().getData(roi).getSamples(roi.x, roi.y, roi.width, roi.height, 0, inDatas);
        return inDatas;
    }

    private static float[] readData(String file, int roiX, int roiY, int roiWidth, int roiHeight) {
        try {
            ParameterBlockJAI pbj = new ParameterBlockJAI("imageread");
            pbj.setParameter("Input", (Object)ImageIO.createImageInputStream(new File(file)));
            ImageLayout layout = new ImageLayout();
            layout.setMinX(roiX);
            layout.setMinY(roiY);
            layout.setTileWidth(roiWidth);
            layout.setTileHeight(roiHeight);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            RenderedOp ro = JAI.create((String)"imageread", (ParameterBlock)pbj, (RenderingHints)hints);
            float[] inDatas = new float[roiWidth * roiHeight];
            return ro.getData().getSamples(roiX, roiY, roiWidth, roiHeight, 0, inDatas);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static float[][] getData2D(GridCoverage2D coverage, int roiX, int roiY, int roiWidth, int roiHeight) {
        Rectangle roi = new Rectangle(roiX, roiY, roiWidth, roiHeight);
        float[] inDatas = new float[roiWidth * roiHeight];
        inDatas = coverage.getRenderedImage().getData(roi).getSamples(roi.x, roi.y, roi.width, roi.height, 0, inDatas);
        float[][] inDatas2D = new float[roiHeight][roiWidth];
        for (int j = 0; j < roiHeight; ++j) {
            for (int i = 0; i < roiWidth; ++i) {
                inDatas2D[j][i] = inDatas[j * roiWidth + i];
            }
        }
        return inDatas2D;
    }

    private static void setData(GridCoverage2D coverage, int roiX, int roiY, int roiWidth, int roiHeight, float[] datas) {
        Rectangle roi = new Rectangle(roiX, roiY, roiWidth, roiHeight);
        ((WritableRaster)coverage.getRenderedImage().getData()).setPixels(roiX, roiY, roiWidth, roiHeight, datas);
    }

    private static GridCoverage2D getEmptyCoverage(int width, int height, double minX, double maxX, double minY, double maxY, double cellSize) {
        try {
            WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)1, null);
            ReferencedEnvelope env = new ReferencedEnvelope(minX, maxX, minY, maxY, CRS.decode((String)"EPSG:2154"));
            GridCoverageFactory gcf = new GridCoverageFactory();
            GridCoverage2D coverage = gcf.create((CharSequence)"TIMEGRID", raster, (Envelope)env);
            return coverage;
        }
        catch (MismatchedDimensionException | FactoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static GridCoverage2D getCoverageUsingRaster(WritableRaster raster, int width, int height, double minX, double maxX, double minY, double maxY, double cellSize) {
        try {
            ReferencedEnvelope env = new ReferencedEnvelope(minX, maxX, minY, maxY, CRS.decode((String)"EPSG:2154"));
            GridCoverageFactory gcf = new GridCoverageFactory();
            GridCoverage2D coverage = gcf.create((CharSequence)"TIMEGRID", raster, (Envelope)env);
            return coverage;
        }
        catch (MismatchedDimensionException | FactoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static GridCoverage2D getCoverageFromData(float[] datas, int width, int height, double posX, double posY, double cellSize) {
        GridCoverage2D cov = null;
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:2154");
            GridCoverageFactory gcf = new GridCoverageFactory();
            Envelope2D e = new Envelope2D(crs, posX, posY, (double)width * cellSize, (double)height * cellSize);
            float[][] d = new float[height][width];
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    d[j][i] = datas[j * width + i];
                }
            }
            cov = gcf.create((CharSequence)"output", d, (Envelope)e);
        }
        catch (FactoryException e1) {
            e1.printStackTrace();
        }
        return cov;
    }

    private static GridCoverage2D getCoverageFromData2D(float[][] datas, int width, int height, double posX, double posY, double cellSize) {
        GridCoverage2D cov = null;
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:2154");
            GridCoverageFactory gcf = new GridCoverageFactory();
            Envelope2D e = new Envelope2D(crs, posX, posY, (double)width * cellSize, (double)height * cellSize);
            cov = gcf.create((CharSequence)"output", datas, (Envelope)e);
        }
        catch (FactoryException e1) {
            e1.printStackTrace();
        }
        return cov;
    }

    private static void exportAsciiGrid(GridCoverage2D coverage, String output) {
        try {
            ArcGridWriter writer = new ArcGridWriter((Object)new File(output));
            GeneralParameterValue[] gpv = null;
            writer.write((GridCoverage)coverage, gpv);
            writer.dispose();
        }
        catch (IOException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static void write(WritableRaster raster, int width, int height, double imageMinX, double imageMaxX, double imageMinY, double imageMaxY, float cellSize, String output) {
        GridCoverage2D outC = CoverageManager.getCoverageUsingRaster(raster, width, height, imageMinX, imageMaxX, imageMinY, imageMaxY, cellSize);
        if (output.endsWith(".tif")) {
            CoverageManager.writeTiff(outC, output);
        } else if (output.endsWith(".asc")) {
            CoverageManager.writeAsciiGrid(outC, output);
        } else {
            throw new IllegalArgumentException("extension of " + output + " unknown");
        }
        outC.dispose(true);
        PlanarImage planarImage = (PlanarImage)outC.getRenderedImage();
        ImageUtilities.disposePlanarImageChain((PlanarImage)planarImage);
        outC = null;
    }

    private static void writeAsciiGrid(String ascii, float[] datas, int width, int height, double minx, double miny, double cellsize, int noDataValue) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(ascii));
            writer.write("ncols " + width);
            writer.newLine();
            writer.write("nrows " + height);
            writer.newLine();
            writer.write("xllcorner " + minx);
            writer.newLine();
            writer.write("yllcorner " + miny);
            writer.newLine();
            writer.write("cellsize " + cellsize);
            writer.newLine();
            writer.write("NODATA_value " + noDataValue);
            writer.newLine();
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    writer.write(datas[j * width + i] + " ");
                }
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeAsciiGrid(GridCoverage2D outC, String output) {
        try {
            ArcGridWriter writer = new ArcGridWriter((Object)new File(output));
            writer.write((GridCoverage)outC, null);
            writer.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeTiff(GridCoverage2D outC, String output) {
        try {
            GeoTiffWriteParams wp = new GeoTiffWriteParams();
            wp.setCompressionMode(2);
            ParameterValueGroup params = new GeoTiffFormat().getWriteParameters();
            params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
            GeoTiffWriter writer = new GeoTiffWriter((Object)new File(output));
            writer.write((GridCoverage)outC, params.values().toArray(new GeneralParameterValue[1]));
            writer.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void retile(String inputRaster, String outputRaster, double minx, double maxx, double miny, double maxy, int noDataValue) {
        block9: {
            try {
                ArcGridReader reader;
                if (inputRaster.endsWith(".asc")) {
                    reader = new ArcGridReader((Object)new File(inputRaster));
                } else if (inputRaster.endsWith(".tif")) {
                    reader = new GeoTiffReader((Object)new File(inputRaster));
                } else {
                    throw new IllegalArgumentException(inputRaster + " is not a recognize raster");
                }
                GridCoverage2D coverage2D = reader.read(null);
                reader.dispose();
                int inWidth = (Integer)coverage2D.getProperty("image_width");
                int inHeight = (Integer)coverage2D.getProperty("image_height");
                double inMinX = coverage2D.getEnvelope().getMinimum(0);
                double inMinY = coverage2D.getEnvelope().getMinimum(1);
                double inMaxX = coverage2D.getEnvelope().getMaximum(0);
                double inMaxY = coverage2D.getEnvelope().getMaximum(1);
                float inCellSize = (float)((AffineTransform)coverage2D.getGridGeometry().getGridToCRS2D()).getScaleX();
                int roiX = (int)((minx - inMinX) / (double)inCellSize);
                double outMinX = inMinX + (double)((float)roiX * inCellSize);
                int roiY = (int)((inMaxY - maxy) / (double)inCellSize);
                double outMaxY = inMaxY - (double)((float)roiY * inCellSize);
                int roiWidth = (int)((maxx - outMinX) / (double)inCellSize);
                int roiHeight = (int)((outMaxY - miny) / (double)inCellSize);
                System.out.println(roiX + " " + roiY + " " + roiWidth + " " + roiHeight);
                Rectangle roi = new Rectangle(roiX, roiY, roiWidth, roiHeight);
                float[] datas = new float[roiWidth * roiHeight];
                datas = coverage2D.getRenderedImage().getData(roi).getSamples(roi.x, roi.y, roi.width, roi.height, 0, datas);
                if (outputRaster.endsWith("tif")) {
                    CoverageManager.writeGeotiff(outputRaster, datas, roiWidth, roiHeight, outMinX, maxx, miny, outMaxY, noDataValue);
                    break block9;
                }
                if (outputRaster.endsWith(".asc")) {
                    CoverageManager.writeAsciiGrid(outputRaster, datas, roiWidth, roiHeight, outMinX, miny, inCellSize, noDataValue);
                    break block9;
                }
                throw new IllegalArgumentException(outputRaster + " is not a recognize raster");
            }
            catch (DataSourceException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

