/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.time.delay;

import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Interval;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.delay.Delay;

public class YearDelay
extends Delay {
    private static final long serialVersionUID = 1L;
    private int delay;

    public YearDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public Instant next(Instant i) {
        return new Instant(Time.getDayOfMonth(i), Time.getMonth(i), Time.getYear(i) + this.delay);
    }

    @Override
    public Instant previous(Instant i) {
        return new Instant(Time.getDayOfMonth(i), Time.getMonth(i), Time.getYear(i) - this.delay);
    }

    @Override
    public Interval next(Interval i) {
        return new Interval(new Instant(Time.getDayOfMonth(i.start()), Time.getMonth(i.start()), Time.getYear(i.start()) + this.delay), new Instant(Time.getDayOfMonth(i.end()), Time.getMonth(i.end()), Time.getYear(i.end()) + this.delay));
    }

    @Override
    public Interval previous(Interval i) {
        return new Interval(new Instant(Time.getDayOfMonth(i.start()), Time.getMonth(i.start()), Time.getYear(i.start()) - this.delay), new Instant(Time.getDayOfMonth(i.end()), Time.getMonth(i.end()), Time.getYear(i.end()) - this.delay));
    }

    @Override
    public long get() {
        return this.delay;
    }
}

