/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.time;

import fr.inrae.act.bagap.apiland.core.time.ComplexTime;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Interval;
import fr.inrae.act.bagap.apiland.core.time.MultiInstant;
import fr.inrae.act.bagap.apiland.core.time.Time;
import java.util.List;

public class MultiInterval
extends ComplexTime<Interval> {
    private static final long serialVersionUID = 1L;

    public MultiInterval() {
    }

    public MultiInterval(List<Interval> l) {
        super(l);
    }

    @Override
    public MultiInterval clone() {
        return (MultiInterval)super.clone();
    }

    @Override
    public Time addTime(Time t) {
        return t.addMultiInterval(this);
    }

    @Override
    protected Time addInstant(Instant t) {
        if (this.isActive(t)) {
            return this.clone();
        }
        ComplexTime<Time> time = new ComplexTime<Time>();
        for (Interval tt : this) {
            time.add(tt);
        }
        time.add(t);
        return time.smooth();
    }

    @Override
    protected Time addInterval(Interval t) {
        if (this.containsInterval(t)) {
            return this.clone();
        }
        MultiInterval mi = this.clone();
        mi.add(t);
        return mi.smooth();
    }

    @Override
    protected <TT extends Time> Time addComplexTime(ComplexTime<TT> t) {
        Time ct = t.clone();
        for (Interval time : this) {
            ((ComplexTime)ct).add(time);
        }
        return ((ComplexTime)ct).smooth();
    }

    @Override
    protected Time addMultiInstant(MultiInstant t) {
        ComplexTime<Interval> time = new ComplexTime<Interval>();
        for (Time tt : this) {
            time.add((Interval)tt);
        }
        for (Time tt : t) {
            time.add((Interval)tt);
        }
        return time.smooth();
    }

    @Override
    protected Time addMultiInterval(MultiInterval t) {
        MultiInterval mi = this.clone();
        for (Interval i : t) {
            mi.add(i);
        }
        return mi.smooth();
    }

    public int minimumYearDelay() {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.times.size() - 1; ++i) {
            min = Math.min(min, ((Interval)this.times.get(i + 1)).start().year() - ((Interval)this.times.get(i)).end().year());
        }
        if (min != Integer.MAX_VALUE) {
            return min;
        }
        throw new IllegalArgumentException();
    }
}

