/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.time;

import fr.inrae.act.bagap.apiland.core.time.ComplexTime;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.MultiInstant;
import fr.inrae.act.bagap.apiland.core.time.MultiInterval;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import fr.inrae.act.bagap.apiland.core.time.TimeNulle;
import fr.inrae.act.bagap.apiland.core.time.Timer;
import fr.inrae.act.bagap.apiland.core.time.delay.Delay;

public class Interval
extends Time {
    private static final long serialVersionUID = 1L;
    private Instant start;
    private Instant end;
    private long length = -1L;

    public Interval(Instant start) {
        if (start instanceof TimeNulle) {
            this.start = start;
            this.end = start;
            this.length = 0L;
        } else {
            this.start = start;
            this.end = Timer.future();
            this.length = this.end.date.getTime() - this.start.date.getTime();
        }
    }

    public Interval(int d, int m, int y) {
        this(Instant.get(d, m, y));
    }

    public Interval(Instant start, Instant end) {
        if (start.isAfter(end)) {
            this.start = end;
            this.end = end;
        } else {
            this.start = start;
            this.end = end;
        }
        this.length = this.end.date.getTime() - this.start.date.getTime();
    }

    public Interval(int sd, int sm, int sy, int ed, int em, int ey) {
        this(Instant.get(sd, sm, sy), Instant.get(ed, em, ey));
    }

    public Interval(int year) {
        this.start = new Instant(1, 1, year);
        this.end = Timer.future();
        this.length = this.end.date.getTime() - this.start.date.getTime();
    }

    public Interval(int year1, int year2) {
        if (year1 <= year2) {
            this.start = new Instant(1, 1, year1);
            this.end = new Instant(31, 12, year2);
        } else {
            this.start = new Instant(1, 1, year2);
            this.end = new Instant(31, 12, year1);
        }
        this.length = this.end.date.getTime() - this.start.date.getTime();
    }

    public Interval(Instant start, Delay delay) {
        this.start = start;
        this.end = delay.next(start);
        this.length = this.end.date.getTime() - this.start.date.getTime();
    }

    public String toString() {
        return "[" + this.start + "-" + this.end + "[";
    }

    @Override
    public Interval clone() {
        Interval clone = (Interval)super.clone();
        clone.start = this.start.clone();
        clone.end = this.end.clone();
        return clone;
    }

    @Override
    protected Time killTime(Instant t) {
        if (!this.end.isBefore(t) && this.start.isBefore(t)) {
            return new Interval(this.start, t);
        }
        if (this.start.equals(t)) {
            return new TimeNulle();
        }
        return this;
    }

    @Override
    public boolean isActive(Instant t) {
        return this.start.equals(t) || this.start.isBefore(t) && this.end.isAfter(t);
    }

    @Override
    public boolean isAfter(Time other) {
        return this.end.isAfter(other.end());
    }

    @Override
    public boolean isBefore(Time other) {
        return this.start.isBefore(other.start());
    }

    @Override
    public Instant start() {
        return this.start;
    }

    @Override
    public Instant end() {
        return this.end;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public int getDayCount() {
        return Time.getDayCount(this.start, this.end);
    }

    @Override
    public void setStart(Instant t) throws TimeException {
        if (this.end.isBefore(t)) {
            throw new TimeException("start must be before the end");
        }
        this.start = t;
        this.length = this.end.date.getTime() - this.start.date.getTime();
    }

    @Override
    public void setEnd(Instant t) throws TimeException {
        if (this.start.isAfter(t)) {
            throw new TimeException("start must be before the end");
        }
        this.end = t;
        this.length = this.end.date.getTime() - this.start.date.getTime();
    }

    @Override
    public boolean equals(Time other) {
        return other.equalsInterval(this);
    }

    @Override
    public boolean equalsInstant(Instant t) {
        return t.date.equals(this.start.date) && t.date.equals(this.end.date);
    }

    @Override
    protected boolean equalsInterval(Interval t) {
        return this.length == t.length && this.start.equals(t.start) && this.end.equals(t.end);
    }

    @Override
    protected <T extends Time> boolean equalsComplexTime(ComplexTime<T> t) {
        return this.equals(t);
    }

    @Override
    public boolean contains(Time other) {
        return this.isActive(other.start()) && (this.isActive(other.end()) || this.end.equals(other.end()));
    }

    @Override
    protected boolean containsInterval(Interval t) {
        return this.contains(t);
    }

    @Override
    public <T extends Time> boolean containsComplexTime(ComplexTime<T> t) {
        return this.contains(t);
    }

    @Override
    public boolean within(Time other) {
        return other.containsInterval(this);
    }

    @Override
    protected boolean withinInstant(Instant t) {
        return false;
    }

    @Override
    protected <T extends Time> boolean withinComplexTime(ComplexTime<T> t) {
        return this.within(t);
    }

    @Override
    public boolean intersects(Time other) {
        return other.intersectInterval(this);
    }

    @Override
    protected boolean intersectInterval(Interval t) {
        return this.isActive(t.start) || t.isActive(this.start);
    }

    @Override
    public boolean touches(Time other) {
        return other.touchesInterval(this);
    }

    @Override
    protected boolean touchesInstant(Instant t) {
        return this.start.isActive(t) || this.end.isActive(t);
    }

    @Override
    protected boolean touchesInterval(Interval t) {
        return this.start.isActive(t.end) || this.end.isActive(t.start);
    }

    @Override
    protected <T extends Time> boolean touchesComplexTime(ComplexTime<T> t) {
        return this.touches(t);
    }

    @Override
    public boolean crosses(Time other) {
        return other.crossesInterval(this);
    }

    @Override
    protected boolean crossesInstant(Instant t) {
        return this.isActive(t) && this.getLength() != 0L;
    }

    @Override
    protected boolean crossesInterval(Interval t) {
        return !(!this.isActive(t.start) && !t.isActive(this.start) || this.start.equals(t.start) && this.end.equals(t.end));
    }

    @Override
    protected <T extends Time> boolean crossesComplexTime(ComplexTime<T> t) {
        return this.crosses(t);
    }

    @Override
    public boolean disjoint(Time other) {
        return other.disjointInterval(this);
    }

    @Override
    protected boolean disjointInterval(Interval t) {
        return this.start.isAfter(t.end) || this.end.isBefore(t.start) || this.start.isActive(t.end) && !this.start.isActive(t.start) || this.end.isActive(t.start) && !this.end.isActive(t.end);
    }

    @Override
    public boolean overlaps(Time other) {
        return other.overlapsInterval(this);
    }

    @Override
    public boolean overlapsInstant(Instant t) {
        return false;
    }

    @Override
    public boolean overlapsInterval(Interval t) {
        return this.intersectInterval(t) && !this.touchesInterval(t);
    }

    @Override
    public <T extends Time> boolean overlapsComplexTime(ComplexTime<T> t) {
        return false;
    }

    @Override
    public Time addTime(Time t) {
        return t.addInterval(this);
    }

    @Override
    protected Time addInstant(Instant t) {
        if (this.contains(t)) {
            return this.clone();
        }
        if (this.isTimeNull()) {
            return t.clone();
        }
        ComplexTime<Time> ct = new ComplexTime<Time>();
        ct.add(this);
        ct.add(t);
        return ct.smooth();
    }

    @Override
    protected boolean isTimeNull() {
        return this.start().isTimeNull();
    }

    @Override
    protected Time addInterval(Interval t) {
        if (this.isTimeNull()) {
            return t.clone();
        }
        if (t.isTimeNull()) {
            return this.clone();
        }
        if (this.disjointInterval(t)) {
            MultiInterval mi = new MultiInterval();
            mi.add(this);
            mi.add(t);
            return mi.smooth();
        }
        if (this.isBefore(t)) {
            if (this.isAfter(t)) {
                return this.clone();
            }
            return new Interval(this.start, t.end);
        }
        if (this.isAfter(t)) {
            return new Interval(t.start, this.end);
        }
        return t.clone();
    }

    @Override
    protected <T extends Time> Time addComplexTime(ComplexTime<T> t) {
        return t.addInterval(this);
    }

    @Override
    protected Time addMultiInstant(MultiInstant t) {
        return t.addInterval(this);
    }

    @Override
    protected Time addMultiInterval(MultiInterval t) {
        return t.addInterval(this);
    }

    public static Interval concat(Interval inter1, Interval inter2) {
        Instant b = inter1.isBefore(inter2) ? inter1.start() : inter2.start();
        Instant e = inter1.isAfter(inter2) ? inter1.end() : inter2.end();
        return new Interval(b, e);
    }

    @Override
    protected boolean isSmooth() {
        return true;
    }

    @Override
    public Time smooth() {
        return this;
    }

    @Override
    protected Time deleteInstant(Instant t) {
        return this.clone();
    }

    @Override
    protected Time deleteInterval(Interval t) {
        if (this.equals(t)) {
            return new TimeNulle();
        }
        if (this.intersectInterval(t)) {
            if (this.containsInterval(t)) {
                MultiInterval mi = new MultiInterval();
                mi.add(this);
                mi.add(t);
                return mi.smooth();
            }
            if (t.containsInterval(this)) {
                return new TimeNulle();
            }
            if (this.start.isBefore(t.start())) {
                return new Interval(t.end(), this.end);
            }
            return new Interval(this.start, t.start());
        }
        return this.clone();
    }

    @Override
    protected <T extends Time> Time deleteComplexTime(ComplexTime<T> t) {
        return null;
    }

    @Override
    protected Time deleteMultiInstant(MultiInstant t) {
        return null;
    }

    @Override
    protected Time deleteMultiInterval(MultiInterval t) {
        return null;
    }

    @Override
    public Time deleteTime(Time t) {
        return t.deleteInterval(this);
    }

    public int yearInterval() {
        return this.end.year() - this.start.year();
    }
}

