/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.time;

import fr.inrae.act.bagap.apiland.core.time.ComplexTime;
import fr.inrae.act.bagap.apiland.core.time.Future;
import fr.inrae.act.bagap.apiland.core.time.Interval;
import fr.inrae.act.bagap.apiland.core.time.MultiInstant;
import fr.inrae.act.bagap.apiland.core.time.MultiInterval;
import fr.inrae.act.bagap.apiland.core.time.Past;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import fr.inrae.act.bagap.apiland.core.time.TimeNulle;
import fr.inrae.act.bagap.apiland.core.time.Timer;
import fr.inrae.act.bagap.apiland.core.time.period.Month;
import java.util.Date;

public class Instant
extends Time {
    private static final long serialVersionUID = 1L;
    public Date date;
    public static final Instant FUTUR = new Future();
    public static final Instant PAST = new Past();

    public Instant() {
    }

    public Instant(long n) {
        this.date = new Date(n);
    }

    public Instant(Date d) {
        this.date = d;
    }

    public Instant(int month, int year) {
        if (month <= 0 || month > 12) {
            throw new IllegalArgumentException();
        }
        Timer.getCalendar().set(year, month - 1, 1);
        this.date = Timer.getCalendar().getTime();
    }

    public Instant(int day, int month, int year) {
        int d = day;
        if (month <= 0 || month > 12) {
            throw new IllegalArgumentException("error : month = " + month);
        }
        if (day <= 0 || day > Month.getMonth(month).getDayCount()) {
            d = Month.getMonth(month).getDayCount();
        }
        Timer.getCalendar().set(year, month - 1, d);
        this.date = Timer.getCalendar().getTime();
    }

    public String toString() {
        Timer.getCalendar().setTime(this.date);
        return Timer.getCalendar().get(5) + "/" + (Timer.getCalendar().get(2) + 1) + "/" + new Integer(Timer.getCalendar().get(1)).toString();
    }

    @Override
    public Instant clone() {
        Instant clone = (Instant)super.clone();
        if (this.date != null) {
            clone.date = (Date)this.date.clone();
        }
        return clone;
    }

    public long get() {
        return this.date.getTime();
    }

    public int dayOfMonth() {
        return Time.getDayOfMonth(this);
    }

    public int dayOfYear() {
        return Time.getDayOfYear(this);
    }

    public int month() {
        return Time.getMonth(this);
    }

    public int year() {
        return Time.getYear(this);
    }

    @Override
    public boolean isActive(Instant t) {
        return Math.abs(this.date.getTime() - t.date.getTime()) < 100000000L;
    }

    public static int getDayCount(Instant start, Instant end) {
        return Time.getDayCount(start, end);
    }

    @Override
    protected Instant killTime(Instant t) {
        if (this.equals(t)) {
            return new TimeNulle();
        }
        return this;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public Instant start() {
        return this;
    }

    @Override
    public Instant end() {
        return this;
    }

    @Override
    public void setStart(Instant t) throws TimeException {
        this.date = t.date;
    }

    @Override
    public void setEnd(Instant t) throws TimeException {
        this.date = t.date;
    }

    @Override
    public boolean isAfter(Time other) {
        return this.date.after(other.end().date);
    }

    @Override
    public boolean isBefore(Time other) {
        return this.date.before(other.start().date);
    }

    @Override
    public boolean equals(Time other) {
        return other.equalsInstant(this);
    }

    @Override
    protected boolean equalsInstant(Instant t) {
        return this.date.equals(t.date);
    }

    @Override
    protected boolean equalsInterval(Interval t) {
        return this.date.equals(t.start().date) && this.date.equals(t.end().date);
    }

    @Override
    public int hashCode() {
        return this.date.hashCode();
    }

    @Override
    protected <T extends Time> boolean equalsComplexTime(ComplexTime<T> t) {
        return this.equals(t);
    }

    @Override
    public boolean contains(Time other) {
        return other.withinInstant(this);
    }

    @Override
    protected boolean containsInterval(Interval t) {
        return this.contains(t);
    }

    @Override
    protected <T extends Time> boolean containsComplexTime(ComplexTime<T> t) {
        return this.contains(t);
    }

    @Override
    public boolean within(Time other) {
        return other.isActive(this);
    }

    @Override
    protected boolean withinInstant(Instant t) {
        return this.isActive(t);
    }

    @Override
    protected <T extends Time> boolean withinComplexTime(ComplexTime<T> t) {
        return this.within(t);
    }

    @Override
    public boolean intersects(Time other) {
        return other.isActive(this);
    }

    @Override
    protected boolean intersectInterval(Interval t) {
        return this.intersects(t);
    }

    @Override
    public boolean touches(Time other) {
        return other.touchesInstant(this);
    }

    @Override
    protected boolean touchesInstant(Instant t) {
        return this.isActive(t);
    }

    @Override
    protected boolean touchesInterval(Interval t) {
        return this.touches(t);
    }

    @Override
    protected <T extends Time> boolean touchesComplexTime(ComplexTime<T> t) {
        return this.touches(t);
    }

    @Override
    public boolean crosses(Time other) {
        return other.crossesInstant(this);
    }

    @Override
    protected boolean crossesInstant(Instant t) {
        return false;
    }

    @Override
    protected boolean crossesInterval(Interval t) {
        return this.crosses(t);
    }

    @Override
    protected <T extends Time> boolean crossesComplexTime(ComplexTime<T> t) {
        return this.crosses(t);
    }

    @Override
    public boolean disjoint(Time other) {
        return !other.isActive(this);
    }

    @Override
    protected boolean disjointInterval(Interval t) {
        return this.disjoint(t);
    }

    @Override
    public boolean overlaps(Time other) {
        return other.overlapsInstant(this);
    }

    @Override
    public boolean overlapsInstant(Instant t) {
        return this.isActive(t);
    }

    @Override
    public boolean overlapsInterval(Interval t) {
        return false;
    }

    @Override
    public <T extends Time> boolean overlapsComplexTime(ComplexTime<T> t) {
        return false;
    }

    @Override
    public Time deleteTime(Time t) {
        return t.deleteInstant(this);
    }

    @Override
    protected Time deleteInstant(Instant t) {
        if (this.equals(t)) {
            return new TimeNulle();
        }
        return this.clone();
    }

    @Override
    protected Time deleteInterval(Interval t) {
        return t.deleteInstant(this);
    }

    @Override
    protected <T extends Time> Time deleteComplexTime(ComplexTime<T> t) {
        return t.deleteInstant(this);
    }

    @Override
    protected Time deleteMultiInstant(MultiInstant t) {
        return t.deleteInstant(this);
    }

    @Override
    protected Time deleteMultiInterval(MultiInterval t) {
        return t.deleteInstant(this);
    }

    @Override
    public Time addTime(Time t) {
        return t.addInstant(this);
    }

    @Override
    protected Time addInstant(Instant t) {
        if (this.equals(t)) {
            return this.clone();
        }
        MultiInstant mi = new MultiInstant();
        mi.add(this);
        mi.add(t);
        return mi.smooth();
    }

    @Override
    protected Time addInterval(Interval t) {
        return t.addInstant(this);
    }

    @Override
    protected <T extends Time> Time addComplexTime(ComplexTime<T> t) {
        return t.addInstant(this);
    }

    @Override
    protected Time addMultiInstant(MultiInstant t) {
        return t.addInstant(this);
    }

    @Override
    protected Time addMultiInterval(MultiInterval t) {
        return t.addInstant(this);
    }

    @Override
    protected boolean isSmooth() {
        return true;
    }

    @Override
    public Time smooth() {
        return this;
    }

    @Override
    protected boolean isTimeNull() {
        return false;
    }
}

