/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.time;

import fr.inrae.act.bagap.apiland.core.time.ComparatorTime;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Interval;
import fr.inrae.act.bagap.apiland.core.time.MultiInstant;
import fr.inrae.act.bagap.apiland.core.time.MultiInterval;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ComplexTime<T extends Time>
extends Time
implements Iterable<T> {
    private static final long serialVersionUID = 1L;
    protected List<T> times;
    private boolean smooth;

    public ComplexTime() {
        this.times = new ArrayList<T>();
        this.smooth = false;
    }

    public ComplexTime(List<T> times) {
        this.times = times;
        this.smooth = false;
    }

    @Override
    public ComplexTime<T> clone() {
        ComplexTime clone = (ComplexTime)super.clone();
        clone.times = new ArrayList<T>();
        for (Time t : this) {
            clone.times.add(t.clone());
        }
        return clone;
    }

    protected void add(T t) {
        this.times.add(t);
        Collections.sort(this.times, new ComparatorTime());
        this.smooth = false;
    }

    public T getAt(int index) {
        return (T)((Time)this.times.get(index));
    }

    protected void set(List<T> times) {
        this.times = times;
        this.smooth = false;
    }

    @Override
    public Time smooth() {
        if (!this.smooth) {
            if (this.times.size() > 0) {
                Collections.sort(this.times, new ComparatorTime());
                Time t = (Time)this.times.get(0);
                ArrayList<T> l = new ArrayList<T>();
                for (int i = 1; i < this.times.size(); ++i) {
                    if (((Time)this.times.get(i)).isTimeNull()) continue;
                    if (t.intersects((Time)this.times.get(i))) {
                        t = t.addTime((Time)this.times.get(i));
                        continue;
                    }
                    l.add(t);
                    t = (Time)this.times.get(i);
                }
                l.add(t);
                if (l.size() == 1) {
                    return (Time)l.get(0);
                }
                this.times = l;
            }
            this.smooth = true;
        }
        return this;
    }

    @Override
    protected boolean isSmooth() {
        return this.smooth;
    }

    public String toString() {
        StringBuffer sb = null;
        for (Time t : this.times) {
            if (sb == null) {
                sb = new StringBuffer();
                sb.append('{');
            } else {
                sb.append(";");
            }
            sb.append(t);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.times.iterator();
    }

    @Override
    public boolean isActive(Instant t) {
        for (Time time : this) {
            if (!time.isActive(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Time killTime(Instant t) {
        ComplexTime<Time> ct = new ComplexTime<Time>();
        for (Time time : this) {
            if (time.contains(t)) {
                ct.add(time.killTime(t));
                continue;
            }
            ct.add(time);
        }
        return ct.smooth();
    }

    @Override
    public long getLength() {
        long l = 0L;
        for (Time t : this) {
            l += t.getLength();
        }
        return l;
    }

    @Override
    public Instant start() {
        if (this.smooth) {
            return ((Time)this.times.get(0)).start();
        }
        Time tBegin = (Time)this.times.get(0);
        for (Time t : this) {
            if (!t.isBefore(tBegin)) continue;
            tBegin = t;
        }
        return tBegin.start();
    }

    @Override
    public Instant end() {
        Time tEnd = (Time)this.times.get(0);
        for (Time t : this) {
            if (!t.isAfter(tEnd)) continue;
            tEnd = t;
        }
        return tEnd.end();
    }

    @Override
    public void setStart(Instant t) throws TimeException {
        for (Time time : this) {
            if (!time.isBefore(t)) continue;
            time.setStart(t);
        }
    }

    @Override
    public void setEnd(Instant t) throws TimeException {
        for (Time time : this) {
            if (!time.isAfter(t)) continue;
            time.setEnd(t);
        }
    }

    @Override
    public boolean isBefore(Time other) {
        return this.start().isBefore(other.start());
    }

    @Override
    public boolean isAfter(Time other) {
        return this.end().isAfter(other.end());
    }

    @Override
    public boolean equals(Time other) {
        return other.equalsComplexTime(this);
    }

    @Override
    public boolean equalsInstant(Instant t) {
        return t.date.equals(this.start().date) && t.date.equals(this.end().date);
    }

    @Override
    protected boolean equalsInterval(Interval t) {
        return this.getLength() == t.getLength() && this.start().equals(t.start()) && this.end().equals(t.end());
    }

    protected <TT extends Time> boolean equalsComplexTime(ComplexTime<TT> t) {
        for (int i = 0; i < this.times.size(); ++i) {
            try {
                if (((Time)this.times.get(i)).equals(ComplexTime.get(i))) continue;
                return false;
            }
            catch (IndexOutOfBoundsException ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(Time other) {
        return other.withinComplexTime(this);
    }

    @Override
    protected boolean containsInterval(Interval t) {
        for (Time time : this) {
            if (!time.containsInterval(t)) continue;
            return true;
        }
        return false;
    }

    protected <TT extends Time> boolean containsComplexTime(ComplexTime<TT> t) {
        return t.withinComplexTime((ComplexTime<TT>)this);
    }

    @Override
    public boolean within(Time other) {
        return other.containsComplexTime(this);
    }

    @Override
    protected boolean withinInstant(Instant t) {
        return false;
    }

    protected <TT extends Time> boolean withinComplexTime(ComplexTime<TT> t) {
        for (Time time : this) {
            if (time.withinComplexTime(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(Time other) {
        for (Time t : this) {
            if (!t.intersects(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean intersectInterval(Interval t) {
        return this.intersects(t);
    }

    @Override
    public boolean touches(Time other) {
        return other.touchesComplexTime(this);
    }

    @Override
    protected boolean touchesInstant(Instant t) {
        for (Time time : this) {
            if (!time.touchesInstant(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean touchesInterval(Interval t) {
        boolean isTouche = false;
        for (Time time : this) {
            if (!time.intersects(t)) continue;
            if (time.touchesInterval(t)) {
                isTouche = true;
            }
            return false;
        }
        return isTouche;
    }

    protected <TT extends Time> boolean touchesComplexTime(ComplexTime<TT> t) {
        boolean isTouche = false;
        for (Time time : this) {
            if (!time.intersects(t)) continue;
            if (time.touches(t)) {
                isTouche = true;
            }
            return false;
        }
        return isTouche;
    }

    @Override
    public boolean crosses(Time other) {
        return other.crossesComplexTime(this);
    }

    @Override
    protected boolean crossesInstant(Instant t) {
        return this.isActive(t) && this.getLength() != 0L;
    }

    @Override
    protected boolean crossesInterval(Interval t) {
        for (Time time : this) {
            if (time.crossesInterval(t)) {
                return true;
            }
            if (!time.equals(t) || this.times.size() <= 1) continue;
            return true;
        }
        return false;
    }

    protected <TT extends Time> boolean crossesComplexTime(ComplexTime<TT> t) {
        boolean equals = false;
        boolean disjoint = false;
        for (Time time : this) {
            boolean notouches = true;
            for (Time tt : t) {
                if (time.crosses(tt)) {
                    return true;
                }
                if (!time.equals(tt)) continue;
                if (this.times.size() != t.times.size()) {
                    return true;
                }
                equals = true;
                notouches = false;
            }
            if (!notouches) continue;
            disjoint = true;
        }
        return equals && disjoint;
    }

    @Override
    public boolean disjoint(Time other) {
        for (Time t : this) {
            if (t.disjoint(other)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean disjointInterval(Interval t) {
        return this.disjoint(t);
    }

    @Override
    public boolean overlaps(Time other) {
        return other.overlapsComplexTime(this);
    }

    @Override
    protected boolean overlapsInstant(Instant t) {
        return false;
    }

    @Override
    protected boolean overlapsInterval(Interval t) {
        return false;
    }

    public <TT extends Time> boolean overlapsComplexTime(ComplexTime<TT> t) {
        int n = 0;
        for (Time time : this) {
            if (!time.intersects(t)) continue;
            ++n;
        }
        if (n >= 2) {
            return true;
        }
        n = 0;
        for (Time time : t) {
            if (!time.intersects(this)) continue;
            ++n;
        }
        return n >= 2;
    }

    @Override
    public Time addTime(Time t) {
        return t.addComplexTime(this);
    }

    @Override
    protected Time addInstant(Instant t) {
        if (this.isActive(t)) {
            return this.clone();
        }
        Time ct = this.clone();
        ((ComplexTime)ct).add(t);
        return ((ComplexTime)ct).smooth();
    }

    @Override
    protected Time addInterval(Interval t) {
        if (this.contains(t)) {
            return this.clone();
        }
        Time ct = this.clone();
        ((ComplexTime)ct).add(t);
        return ((ComplexTime)ct).smooth();
    }

    protected <TT extends Time> Time addComplexTime(ComplexTime<TT> t) {
        Time ct = this.clone();
        for (Time time : t) {
            ((ComplexTime)ct).add(time);
        }
        return ((ComplexTime)ct).smooth();
    }

    @Override
    protected Time addMultiInstant(MultiInstant t) {
        return t.addComplexTime(this);
    }

    @Override
    protected Time addMultiInterval(MultiInterval t) {
        return t.addComplexTime(this);
    }

    @Override
    protected <T extends Time> Time deleteComplexTime(ComplexTime<T> t) {
        return null;
    }

    @Override
    protected Time deleteInstant(Instant t) {
        return null;
    }

    @Override
    protected Time deleteInterval(Interval t) {
        return null;
    }

    @Override
    protected Time deleteMultiInstant(MultiInstant t) {
        return null;
    }

    @Override
    protected Time deleteMultiInterval(MultiInterval t) {
        return null;
    }

    @Override
    public Time deleteTime(Time t) {
        return null;
    }

    @Override
    protected boolean isTimeNull() {
        for (Time t : this.times) {
            if (t.isTimeNull()) continue;
            return false;
        }
        return true;
    }
}

