/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.structure;

import fr.inrae.act.bagap.apiland.core.change.Changeable;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObserver;
import fr.inrae.act.bagap.apiland.core.space.Geometry;
import fr.inrae.act.bagap.apiland.core.space.Point;
import fr.inrae.act.bagap.apiland.core.structure.Representation;
import fr.inrae.act.bagap.apiland.core.structure.RepresentationType;
import fr.inrae.act.bagap.apiland.core.structure.TemporalEntity;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.TimeException;

public class StaticRepresentation<G extends Geometry>
extends Representation<G> {
    private static final long serialVersionUID = 1L;
    private TemporalEntity<G> te;

    public StaticRepresentation(RepresentationType type) {
        super(type);
    }

    @Override
    public void display() {
    }

    @Override
    public G getGeometry(Instant t) {
        return this.getGeometry(t);
    }

    @Override
    public Time getTime() {
        return this.te.getTime();
    }

    @Override
    public boolean isActive(Instant t) {
        return this.te.isActive(t);
    }

    @Override
    public void kill(Instant t) throws TimeException {
        this.te.kill(t);
    }

    @Override
    public void setTime(Time t) {
        this.te.setTime(t);
    }

    @Override
    public void addObserver(ChangeableObserver o) {
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
    }

    @Override
    public boolean isActive(Instant t, Point g) {
        return this.te.isActive(t, g);
    }

    @Override
    public double getArea(Instant t) {
        return this.te.getArea();
    }

    @Override
    public double getLength(Instant t) {
        return this.te.getLength();
    }

    @Override
    public int size() {
        if (this.te != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setGeometry(Time t, G g) {
        if (this.te == null) {
            this.te = new TemporalEntity<G>(t, g);
        } else {
            this.te.setGeometry((Geometry)g);
        }
    }

    @Override
    public void addTemporal(TemporalEntity<G> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TemporalEntity<G> get(int index) {
        if (index == 0) {
            return this.te;
        }
        return null;
    }

    @Override
    public TemporalEntity<G> getActive(Instant t) {
        if (this.te.isActive(t)) {
            return this.te;
        }
        return null;
    }

    @Override
    public int getIndex(Instant t) {
        return 0;
    }

    @Override
    public TemporalEntity<G> getLast() {
        return this.te;
    }

    @Override
    public Instant getLastChange() {
        return this.te.getTime().start();
    }

    @Override
    public double minX() {
        return ((Geometry)this.te.getGeometry()).minX();
    }

    @Override
    public double maxX() {
        return ((Geometry)this.te.getGeometry()).maxX();
    }

    @Override
    public double minY() {
        return ((Geometry)this.te.getGeometry()).minY();
    }

    @Override
    public double maxY() {
        return ((Geometry)this.te.getGeometry()).maxY();
    }

    @Override
    public void delete() {
        super.delete();
        this.te.delete();
        this.te = null;
    }

    @Override
    public void removeTemporal(TemporalEntity<G> t) {
    }

    @Override
    public TemporalEntity<G> getFirst() {
        return null;
    }
}

