/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.structure;

import fr.inrae.act.bagap.apiland.core.change.Changeable;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObject;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObserver;
import fr.inrae.act.bagap.apiland.core.structure.Representation;
import fr.inrae.act.bagap.apiland.core.structure.Structure;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import java.util.ArrayList;
import java.util.Iterator;

public class SimpleStructure
extends Structure {
    private static final long serialVersionUID = 1L;
    private Representation<?> representation;
    private ChangeableObject changeable = new ChangeableObject();
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;

    @Override
    public SimpleStructure clone() {
        SimpleStructure clone = (SimpleStructure)super.clone();
        clone.changeable = new ChangeableObject();
        if (this.representation != null) {
            clone.representation = this.representation;
        }
        return clone;
    }

    @Override
    public Representation<?> getDefaultRepresentation() {
        return this.representation;
    }

    @Override
    public Representation<?> getRepresentation(String name) {
        if (this.representation.getType().getName().equalsIgnoreCase(name)) {
            return this.representation;
        }
        return null;
    }

    @Override
    public boolean hasRepresentation(String name) {
        return this.representation.getType().getName().equalsIgnoreCase(name);
    }

    @Override
    public void kill(Instant t) throws TimeException {
        this.representation.kill(t);
    }

    @Override
    public void addObserver(ChangeableObserver o) {
        this.changeable.addObserver(o);
        this.representation.addObserver(o);
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
        this.changeable.notifyObservers(t, c, o);
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
        this.changeable.removeObserver(o);
        this.representation.removeObserver(o);
    }

    @Override
    public void addRepresentation(Representation<?> r) {
        this.representation = r;
        this.representation.addObserver(this);
    }

    @Override
    public void removeRepresentation(String r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Representation<?>> iterator() {
        ArrayList l = new ArrayList();
        l.add(this.representation);
        return l.iterator();
    }

    @Override
    public Instant getLastChange() {
        return this.representation.getLastChange();
    }

    @Override
    public double minX() {
        return this.representation.minX();
    }

    @Override
    public double maxX() {
        return this.representation.maxX();
    }

    @Override
    public double minY() {
        return this.representation.minY();
    }

    @Override
    public double maxY() {
        return this.representation.maxY();
    }

    @Override
    public void delete() {
        super.delete();
        this.representation.delete();
        this.representation = null;
        this.changeable.delete();
        this.changeable = null;
    }

    @Override
    public void setMinX(double minX) {
        this.minX = minX;
    }

    @Override
    public void setMinY(double minY) {
        this.minY = minY;
    }

    @Override
    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    @Override
    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }
}

