/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.structure;

import fr.inrae.act.bagap.apiland.core.change.Changeable;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObject;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObserver;
import fr.inrae.act.bagap.apiland.core.structure.Representation;
import fr.inrae.act.bagap.apiland.core.structure.Structure;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MultipleStructure
extends Structure
implements Iterable<Representation<?>> {
    private static final long serialVersionUID = 1L;
    private Map<String, Representation<?>> representations = new HashMap();
    private ChangeableObject changeable = new ChangeableObject();

    @Override
    public MultipleStructure clone() {
        MultipleStructure clone = (MultipleStructure)super.clone();
        clone.changeable = new ChangeableObject();
        if (this.representations != null) {
            clone.representations = new HashMap();
            for (Map.Entry<String, Representation<?>> s : this.representations.entrySet()) {
                clone.representations.put(s.getKey(), (Representation<?>)s.getValue().clone());
            }
        }
        return clone;
    }

    @Override
    public Iterator<Representation<?>> iterator() {
        return this.representations.values().iterator();
    }

    @Override
    public void addRepresentation(Representation<?> r) {
        if (this.representations.size() == 0) {
            this.representations.put("the_geom", r);
        }
        this.representations.put(r.getName(), r);
        r.addObserver(this);
    }

    @Override
    public void removeRepresentation(String name) {
        this.representations.remove(this.representations.get(name));
    }

    @Override
    public Representation<?> getDefaultRepresentation() {
        return this.representations.get("the_geom");
    }

    @Override
    public Representation getRepresentation(String name) {
        if (this.representations.containsKey(name)) {
            return this.representations.get(name);
        }
        throw new IllegalArgumentException("representation '" + name + "' does not exist");
    }

    @Override
    public void kill(Instant t) throws TimeException {
        for (Representation<?> r : this) {
            r.kill(t);
        }
    }

    public void displayTuples() {
        for (Representation<?> r : this) {
            r.display();
        }
    }

    @Override
    public void addObserver(ChangeableObserver o) {
        this.changeable.addObserver(o);
        for (Representation<?> r : this) {
            r.addObserver(o);
        }
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
        this.changeable.removeObserver(o);
        for (Representation<?> r : this) {
            r.removeObserver(o);
        }
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
        this.changeable.notifyObservers(t, c, o);
    }

    @Override
    public boolean hasRepresentation(String name) {
        return this.representations.containsKey(name);
    }

    @Override
    public Instant getLastChange() {
        Instant t = null;
        for (Representation<?> r : this) {
            Instant n = r.getLastChange();
            if (t != null && (n == null || !n.isAfter(t))) continue;
            t = n;
        }
        return t;
    }

    @Override
    public double minX() {
        return this.getDefaultRepresentation().minX();
    }

    @Override
    public double maxX() {
        return this.getDefaultRepresentation().maxX();
    }

    @Override
    public double minY() {
        return this.getDefaultRepresentation().minY();
    }

    @Override
    public double maxY() {
        return this.getDefaultRepresentation().maxY();
    }

    @Override
    public void delete() {
        super.delete();
        for (Representation<?> r : this.representations.values()) {
            r.delete();
        }
        this.representations.clear();
        this.representations = null;
        this.changeable.delete();
        this.changeable = null;
    }
}

