/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.space.impl.raster;

import fr.inrae.act.bagap.apiland.core.space.impl.GeometryImpl;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.BoundaryIterator;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.MarginIterator;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.PixelIterator;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.Raster;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class RasterComposite
extends Raster {
    private static final long serialVersionUID = 1L;
    private Set<Raster> rasters = new HashSet<Raster>();

    public RasterComposite() {
        this.smooth = true;
    }

    public RasterComposite(Set<Raster> rasters) {
        this.rasters.addAll(rasters);
    }

    public void addSimplePixelComposite(PixelComposite pc) {
        this.rasters.add(pc);
    }

    public void removeSimplePixelComposite(PixelComposite pc) {
        this.rasters.remove(pc);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append('\n');
        int index = 0;
        for (Raster p : this.rasters) {
            sb.append(++index);
            sb.append(" : ");
            sb.append(p.size());
            sb.append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    public Set<Raster> getRasters() {
        return this.rasters;
    }

    @Override
    public boolean isSmooth() {
        return this.smooth;
    }

    private Set<Raster> lissage(Set<Raster> rs) {
        for (Raster r1 : rs) {
            for (Raster r2 : rs) {
                if (!r1.touches(r2)) continue;
                rs.remove(r1);
                rs.remove(r2);
                rs.add(r1.addGeometryImpl(r2));
                return this.lissage(rs);
            }
        }
        return rs;
    }

    @Override
    public Raster smooth() {
        if (!this.smooth) {
            if (this.rasters.size() > 0) {
                this.rasters = this.lissage(this.rasters);
                if (this.rasters.size() == 1) {
                    return this.rasters.iterator().next();
                }
            }
            this.smooth = true;
        }
        return this;
    }

    @Override
    public RasterComposite clone() {
        RasterComposite clone = (RasterComposite)super.clone();
        clone.rasters = new HashSet<Raster>();
        for (Raster r : this.rasters) {
            clone.rasters.add(r.clone());
        }
        return clone;
    }

    protected void add(Raster r) {
        this.rasters.add(r);
        this.smooth = false;
    }

    public void remove(Raster r) {
        this.rasters.remove(r);
        this.smooth = false;
    }

    protected void addAll(Collection<Raster> c) {
        this.rasters.addAll(c);
        this.smooth = false;
    }

    protected void removeAll(Collection<Raster> c) {
        this.rasters.removeAll(c);
        this.smooth = false;
    }

    @Override
    public Raster addGeometryImpl(GeometryImpl impl) {
        try {
            return ((Raster)impl).addRasterComposite(this);
        }
        catch (Exception ex) {
            return this;
        }
    }

    @Override
    protected Raster addPixel(Pixel impl) {
        if (this.rasters.size() == 0) {
            return impl;
        }
        if (this.containsPixel(impl)) {
            return this;
        }
        Iterator<Raster> ite = this.rasters.iterator();
        while (ite.hasNext()) {
            Raster r = ite.next();
            if (!r.touchesPixelWithoutContainsTest(impl)) continue;
            ite.remove();
            this.rasters.add(r.addGeometryImpl(impl));
            this.smooth = false;
            return this;
        }
        this.add(impl);
        return this;
    }

    @Override
    protected Raster addPixelComposite(PixelComposite impl) {
        if (this.rasters.size() == 0) {
            return impl;
        }
        if (impl.count() == 0) {
            return this.clone().smooth();
        }
        RasterComposite rc = new RasterComposite();
        rc.add(this);
        rc.add(impl);
        return rc;
    }

    @Override
    protected Raster addRasterComposite(RasterComposite impl) {
        if (this.rasters.size() == 0) {
            return impl.clone().smooth();
        }
        if (impl.count() == 0) {
            return this.clone().smooth();
        }
        if (this.intersects(impl)) {
            if (this.contains(impl)) {
                return this.clone().smooth();
            }
            if (this.within(impl)) {
                return impl.clone().smooth();
            }
            RasterComposite rc = this.clone();
            rc.add(impl);
            return rc.smooth();
        }
        if (this.touches(impl)) {
            RasterComposite rc = this.clone();
            rc.add(impl);
            return rc.smooth();
        }
        RasterComposite rc = new RasterComposite();
        rc.add(this);
        rc.add(impl);
        return rc.smooth();
    }

    @Override
    public Iterator<Pixel> iterator() {
        return new PixelIterator(this.rasters.iterator());
    }

    @Override
    public Iterator<Pixel> getBoundaries() {
        return new BoundaryIterator(this);
    }

    @Override
    public Iterator<Pixel> getMargins() {
        return new MarginIterator(this);
    }

    @Override
    public int count() {
        if (!this.smooth) {
            Raster r = this.smooth();
            return r.count();
        }
        int count = 0;
        for (Raster r : this.rasters) {
            count += r.count();
        }
        return count;
    }

    @Override
    public int size() {
        return this.rasters.size();
    }

    @Override
    public double getArea() {
        return (double)this.count() * Math.pow(size, 2.0);
    }

    @Override
    public double getLength() {
        Iterator<Pixel> ite = this.getBoundaries();
        double length = 0.0;
        while (ite.hasNext()) {
            ite.next();
            length += size;
        }
        return length;
    }

    @Override
    public boolean equals(GeometryImpl impl) {
        try {
            return ((Raster)impl).equalsRasterComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean equalsPixel(Pixel impl) {
        for (Pixel p : this) {
            if (p.equalsPixel(impl)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean equalsPixelComposite(PixelComposite impl) {
        if (this.getArea() == impl.getArea()) {
            for (Pixel p : this) {
                if (impl.containsPixel(p)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean equalsRasterComposite(RasterComposite impl) {
        if (this.getArea() == impl.getArea()) {
            for (Pixel p : this) {
                if (impl.containsPixel(p)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(GeometryImpl impl) {
        try {
            return ((Raster)impl).withinRasterComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean containsPixel(Pixel impl) {
        for (Pixel p : this) {
            if (!p.equalsPixel(impl)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean containsPixelComposite(PixelComposite impl) {
        for (Pixel p : impl) {
            if (this.containsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean containsRasterComposite(RasterComposite impl) {
        for (Pixel p : impl) {
            if (this.containsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean crosses(GeometryImpl impl) {
        try {
            return ((Raster)impl).crossesRasterComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean crossesPixel(Pixel impl) {
        return false;
    }

    @Override
    protected boolean crossesPixelComposite(PixelComposite impl) {
        Iterator<Pixel> ite = this.iterator();
        if (ite.hasNext()) {
            Pixel p = ite.next();
            if (impl.containsPixel(p)) {
                while (ite.hasNext()) {
                    p = ite.next();
                    if (impl.containsPixel(p)) continue;
                    return true;
                }
                return false;
            }
            while (ite.hasNext()) {
                p = ite.next();
                if (!impl.containsPixel(p)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected boolean crossesRasterComposite(RasterComposite impl) {
        Iterator<Pixel> ite = this.iterator();
        if (ite.hasNext()) {
            Pixel p = ite.next();
            if (impl.containsPixel(p)) {
                while (ite.hasNext()) {
                    p = ite.next();
                    if (impl.containsPixel(p)) continue;
                    return true;
                }
                return false;
            }
            while (ite.hasNext()) {
                p = ite.next();
                if (!impl.containsPixel(p)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean touches(GeometryImpl impl) {
        try {
            return ((Raster)impl).touchesRasterComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean touchesPixel(Pixel impl) {
        boolean touche = false;
        for (Raster r : this.rasters) {
            if (r.containsPixel(impl)) {
                return false;
            }
            if (!r.touchesPixel(impl)) continue;
            touche = true;
        }
        return touche;
    }

    @Override
    protected boolean touchesPixelWithoutContainsTest(Pixel impl) {
        for (Pixel p : this) {
            if (!p.touchesPixel(impl)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean touchesPixelComposite(PixelComposite impl) {
        boolean response = false;
        for (Pixel p1 : this) {
            for (Pixel p2 : impl) {
                if (p1.equalsPixel(p2)) {
                    return false;
                }
                if (!p1.touchesPixel(p2)) continue;
                response = true;
            }
        }
        return response;
    }

    @Override
    protected boolean touchesRasterComposite(RasterComposite impl) {
        if (this.disjointRasterComposite(impl)) {
            for (Pixel p : this) {
                if (!impl.touchesPixel(p)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean within(GeometryImpl impl) {
        try {
            return ((Raster)impl).containsRasterComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean withinPixel(Pixel impl) {
        for (Pixel p : this) {
            if (impl.equalsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean withinPixelComposite(PixelComposite impl) {
        for (Pixel p : this) {
            if (impl.containsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean withinRasterComposite(RasterComposite impl) {
        for (Pixel p : this) {
            if (impl.containsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(GeometryImpl impl) {
        try {
            return ((Raster)impl).intersectsRasterComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean intersectsPixel(Pixel impl) {
        return this.containsPixel(impl);
    }

    @Override
    protected boolean intersectsPixelComposite(PixelComposite impl) {
        for (Pixel p : this) {
            if (!impl.containsPixel(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean intersectsRasterComposite(RasterComposite impl) {
        for (Pixel p : this) {
            if (!impl.containsPixel(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean disjoint(GeometryImpl impl) {
        try {
            return ((Raster)impl).disjointRasterComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean disjointPixel(Pixel impl) {
        return !this.containsPixel(impl);
    }

    @Override
    protected boolean disjointPixelComposite(PixelComposite impl) {
        for (Pixel p : this) {
            if (!impl.containsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean disjointRasterComposite(RasterComposite impl) {
        for (Pixel p : this) {
            if (!impl.containsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean overlaps(GeometryImpl impl) {
        try {
            return ((Raster)impl).overlapsRasterComposite(this);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected boolean overlapsPixel(Pixel impl) {
        for (Pixel p : this) {
            if (impl.equalsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean overlapsPixelComposite(PixelComposite impl) {
        return false;
    }

    @Override
    protected boolean overlapsRasterComposite(RasterComposite impl) {
        return false;
    }

    @Override
    public double minX() {
        double min = 9.99999999E8;
        for (Pixel p : this) {
            min = Math.min(min, p.minX());
        }
        return min;
    }

    @Override
    public double maxX() {
        double max = -9.99999999E8;
        for (Pixel p : this) {
            max = Math.max(max, p.maxX());
        }
        return max;
    }

    @Override
    public double minY() {
        double min = 9.99999999E8;
        for (Pixel p : this) {
            min = Math.min(min, p.minY());
        }
        return min;
    }

    @Override
    public double maxY() {
        double max = -9.99999999E8;
        for (Pixel p : this) {
            max = Math.max(max, p.maxY());
        }
        return max;
    }

    @Override
    public Pixel getOne() {
        return this.rasters.iterator().next().getOne();
    }
}

