/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.space.impl.raster;

import fr.inrae.act.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.Raster;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.RasterComposite;
import java.util.Iterator;
import java.util.Stack;

public class PixelIterator
implements Iterator<Pixel> {
    private Stack<Iterator> pile = new Stack();

    public PixelIterator(Iterator<? extends Raster> iterator) {
        this.pile.push(iterator);
    }

    @Override
    public boolean hasNext() {
        if (!this.pile.isEmpty()) {
            Iterator iterator = this.pile.peek();
            if (!iterator.hasNext()) {
                this.pile.pop();
                return this.hasNext();
            }
            return true;
        }
        return false;
    }

    @Override
    public Pixel next() {
        if (this.hasNext()) {
            Iterator iterator = this.pile.peek();
            Raster r = (Raster)iterator.next();
            if (r instanceof PixelComposite) {
                this.pile.push(((PixelComposite)r).iterator());
                return this.next();
            }
            if (r instanceof RasterComposite) {
                this.pile.push(((RasterComposite)r).iterator());
                return this.next();
            }
            return (Pixel)r;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

