/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.space;

import fr.inrae.act.bagap.apiland.core.space.ComplexGeometry;
import fr.inrae.act.bagap.apiland.core.space.Curve;
import fr.inrae.act.bagap.apiland.core.space.GeometryType;
import fr.inrae.act.bagap.apiland.core.space.Point;
import fr.inrae.act.bagap.apiland.core.space.Spatial;
import fr.inrae.act.bagap.apiland.core.space.Surface;
import fr.inrae.act.bagap.apiland.core.space.impl.GeometryImpl;

public abstract class Geometry
implements Spatial,
GeometryType {
    private static final long serialVersionUID = 1L;
    protected GeometryImpl impl;

    protected Geometry(GeometryImpl impl) {
        impl.init(this);
        this.impl = impl;
    }

    protected Geometry() {
    }

    public Geometry clone() {
        try {
            Geometry clone = (Geometry)super.clone();
            clone.impl = this.impl.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public GeometryImpl get() {
        return this.impl;
    }

    public double minX() {
        return this.get().minX();
    }

    public double maxX() {
        return this.get().maxX();
    }

    public double minY() {
        return this.get().minY();
    }

    public double maxY() {
        return this.get().maxY();
    }

    public abstract Geometry smooth();

    @Override
    public Geometry getGeometry() {
        return this;
    }

    @Override
    public void setGeometry(Geometry geom) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getArea() {
        return this.get().getArea();
    }

    @Override
    public double getLength() {
        return this.get().getLength();
    }

    @Override
    public boolean isActive(Point g) {
        return this.get().contains(g.get());
    }

    public boolean equals(Geometry other) {
        return this.get().equals(other.get());
    }

    public boolean contains(Geometry other) {
        return this.get().contains(other.get());
    }

    public boolean touches(Geometry other) {
        return this.get().touches(other.get());
    }

    public boolean within(Geometry other) {
        return this.get().within(other.get());
    }

    public boolean crosses(Geometry other) {
        return this.get().crosses(other.get());
    }

    public boolean intersects(Geometry other) {
        return this.get().intersects(other.get());
    }

    public boolean disjoint(Geometry other) {
        return this.get().disjoint(other.get());
    }

    public boolean overlaps(Geometry other) {
        return this.get().overlaps(other.get());
    }

    public abstract Geometry addGeometry(Geometry var1);

    public abstract Geometry addPoint(Point var1);

    public abstract Geometry addCurve(Curve var1);

    public abstract Geometry addSurface(Surface var1);

    public abstract <G extends Geometry> Geometry addComplexGeometry(ComplexGeometry<G> var1);

    public static Geometry add(Geometry g1, Geometry g2) {
        if (g1 == null) {
            return g2;
        }
        return g1.addGeometry(g2);
    }
}

