/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.element.type;

import fr.inrae.act.bagap.apiland.core.change.Changeable;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObject;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObserver;
import fr.inrae.act.bagap.apiland.core.composition.AttributeType;
import fr.inrae.act.bagap.apiland.core.element.DynamicElement;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicFeatureType;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicLayerType;
import fr.inrae.act.bagap.apiland.core.structure.RepresentationType;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class DynamicElementType
implements Cloneable,
Changeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Class<? extends DynamicElement> binding;
    protected List<AttributeType> attributeTypes;
    protected List<RepresentationType> representationTypes;
    protected DynamicLayerType layerType;
    protected String idName;
    protected Set<Object> conditions;
    private ChangeableObject changeable = new ChangeableObject();

    public DynamicElementType(String idName, Class<? extends DynamicElement> binding) {
        this.idName = idName;
        this.binding = binding;
        this.attributeTypes = new ArrayList<AttributeType>();
        this.representationTypes = new ArrayList<RepresentationType>();
        this.conditions = new HashSet<Object>();
    }

    public DynamicElementType(String idName, List<AttributeType> attributeTypes, List<RepresentationType> representationTypes) {
        this.idName = idName;
        this.attributeTypes = attributeTypes;
        this.representationTypes = representationTypes;
        this.conditions = new HashSet<Object>();
    }

    public DynamicElementType(String idName, Class<? extends DynamicElement> binding, List<AttributeType> attributeTypes, List<RepresentationType> representationTypes) {
        this.idName = idName;
        this.binding = binding;
        this.attributeTypes = attributeTypes;
        this.representationTypes = representationTypes;
        this.conditions = new HashSet<Object>();
    }

    public DynamicElementType clone() {
        try {
            DynamicElementType clone = (DynamicElementType)super.clone();
            clone.attributeTypes = new ArrayList<AttributeType>();
            for (AttributeType attributeType : this.attributeTypes) {
                clone.attributeTypes.add(attributeType);
            }
            clone.representationTypes = new ArrayList<RepresentationType>();
            for (RepresentationType representationType : this.representationTypes) {
                clone.representationTypes.add(representationType);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        int l;
        int level = this.getLevelTopDown();
        StringBuffer sb = new StringBuffer();
        for (int l2 = 0; l2 < level; ++l2) {
            sb.append("\t");
        }
        sb.append(this.binding + "\n");
        for (int l2 = 0; l2 < level; ++l2) {
            sb.append("\t");
        }
        sb.append("id : " + this.idName + " \n");
        for (AttributeType attributeType : this.getAttributeTypes()) {
            for (l = 0; l < level; ++l) {
                sb.append("\t");
            }
            sb.append(attributeType.toString());
        }
        for (RepresentationType representationType : this.getRepresentationTypes()) {
            for (l = 0; l < level; ++l) {
                sb.append("\t");
            }
            sb.append(representationType.toString());
        }
        return sb.toString();
    }

    public void display() {
        System.out.println(this);
    }

    public List<AttributeType> getAttributeTypes() {
        return this.attributeTypes;
    }

    public Set<AttributeType> getInheritedAttributeTypes(DynamicElementType type, Set<AttributeType> set) {
        set.addAll(this.getAttributeTypes());
        if (type.equals(this)) {
            return set;
        }
        if (this.layerType != null) {
            return this.layerType.getInheritedAttributeTypes(type, set);
        }
        return set;
    }

    public List<RepresentationType> getRepresentationTypes() {
        return this.representationTypes;
    }

    public boolean hasRepresentationType(String name) {
        for (RepresentationType type : this.getRepresentationTypes()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeType(String name) {
        for (AttributeType type : this.getAttributeTypes()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public RepresentationType getRepresentationType(String name) {
        for (RepresentationType type : this.getRepresentationTypes()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public AttributeType getAttributeType(String name) {
        for (AttributeType type : this.getAttributeTypes()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public int attributesCount() {
        return this.getAttributeTypes().size();
    }

    public int representationsCount() {
        return this.getRepresentationTypes().size();
    }

    public void addAttributeType(AttributeType type) {
        if (!this.hasAttributeType(type.getName())) {
            this.attributeTypes.add(type);
        }
    }

    public void setAttributeTypes(List<AttributeType> attributeTypes) {
        this.attributeTypes = attributeTypes;
    }

    public void addRepresentationType(RepresentationType type) {
        if (!this.hasRepresentationType(type.getName())) {
            this.representationTypes.add(type);
        }
    }

    public void setRepresentationTypes(List<RepresentationType> representationTypes) {
        this.representationTypes = representationTypes;
    }

    public void removeAttributeType(String name) {
        for (AttributeType type : this.attributeTypes) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            this.attributeTypes.remove(type);
            this.notifyObservers(null, this, type);
            return;
        }
    }

    public void removeRepresentationType(String name) {
        for (RepresentationType type : this.representationTypes) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            this.representationTypes.remove(type);
            this.notifyObservers(null, this, type);
            return;
        }
        throw new IllegalArgumentException("representation " + name + " does not exist : can not remove it");
    }

    public Class<? extends DynamicElement> getBinding() {
        return this.binding;
    }

    public DynamicElementType getLayerType() {
        return this.layerType;
    }

    public void setLayerType(DynamicLayerType layerType) {
        this.layerType = layerType;
    }

    public String getIdName() {
        return this.idName;
    }

    public Set<String> getInheritedIdNames(DynamicElementType type, Set<String> set) {
        set.add(this.idName);
        if (type.equals(this)) {
            return set;
        }
        if (this.layerType != null) {
            return this.layerType.getInheritedIdNames(type, set);
        }
        return set;
    }

    private void setIdName(String idName) {
        this.idName = idName;
    }

    public boolean hasIdName(String name) {
        return this.idName.equalsIgnoreCase(name);
    }

    public boolean containsIdName(String name) {
        return this.hasIdName(name);
    }

    public boolean containsAttributeByName(String name) {
        return this.hasAttributeType(name);
    }

    public abstract List<DynamicFeatureType> getFeatureTypes();

    public abstract int getLevelBottomUp();

    public int getLevelTopDown() {
        if (this.layerType == null) {
            return 0;
        }
        return this.layerType.getLevelTopDown() + 1;
    }

    public abstract boolean hasElementType(Class<? extends DynamicElement> var1);

    public abstract DynamicElementType getDeepElementType();

    public abstract DynamicElementType getElementType(Class<? extends DynamicElement> var1);

    public boolean isElementType(Class<? extends DynamicElement> binding) {
        return this.getBinding().equals(binding);
    }

    public boolean hasDeepCondition(Object o) {
        return this.hasCondition(o);
    }

    public boolean hasCondition(Object o) {
        return this.conditions.contains(o);
    }

    public void addCondition(Object o) {
        this.conditions.add(o);
    }

    @Override
    public void addObserver(ChangeableObserver o) {
        this.changeable.addObserver(o);
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
        this.changeable.removeObserver(o);
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
        this.changeable.notifyObservers(t, c, o);
    }
}

