/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.element.manager;

import fr.inrae.act.bagap.apiland.core.composition.AttributeType;
import fr.inrae.act.bagap.apiland.core.element.DefaultDynamicLayer;
import fr.inrae.act.bagap.apiland.core.element.DynamicElement;
import fr.inrae.act.bagap.apiland.core.element.DynamicFeature;
import fr.inrae.act.bagap.apiland.core.element.DynamicLayer;
import fr.inrae.act.bagap.apiland.core.element.IdManager;
import fr.inrae.act.bagap.apiland.core.element.manager.DynamicElementBuilder;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicElementType;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicElementTypeFactory;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicFeatureType;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicLayerType;
import fr.inrae.act.bagap.apiland.core.space.Geometry;
import fr.inrae.act.bagap.apiland.core.space.GeometryFactory;
import fr.inrae.act.bagap.apiland.core.space.GeometryType;
import fr.inrae.act.bagap.apiland.core.space.Linear;
import fr.inrae.act.bagap.apiland.core.space.Local;
import fr.inrae.act.bagap.apiland.core.space.Surfacic;
import fr.inrae.act.bagap.apiland.core.space.impl.GeometryImplType;
import fr.inrae.act.bagap.apiland.core.structure.RepresentationType;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Interval;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.delay.Delay;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.util.Tool;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class DynamicLayerFactory {
    public static <E extends DynamicElement, D extends DynamicLayer<E>> D initWithShape(String shape, Instant t) {
        return DynamicLayerFactory.initWithShape(shape, new Interval(t));
    }

    public static <E extends DynamicElement, D extends DynamicLayer<E>> D initWithShape(String shape, Time time) {
        DynamicLayerType layerType = new DynamicLayerType(DefaultDynamicLayer.class);
        DynamicFeatureType featureType = new DynamicFeatureType();
        layerType.addElementType(featureType);
        return DynamicLayerFactory.initWithShape(shape, time, layerType, null, featureType);
    }

    public static <E extends DynamicElement, D extends DynamicLayer<E>> D initWithShape(String shape, Instant t, String id) {
        return DynamicLayerFactory.initWithShape(shape, (Time)new Interval(t), id);
    }

    public static <E extends DynamicElement, D extends DynamicLayer<E>> D initWithShape(String shape, Time time, String id) {
        DynamicLayerType layerType = new DynamicLayerType(DefaultDynamicLayer.class);
        DynamicFeatureType featureType = new DynamicFeatureType(id);
        layerType.addElementType(featureType);
        return DynamicLayerFactory.initWithShape(shape, time, layerType, null, featureType);
    }

    public static <E extends DynamicElement, D extends DynamicLayer<E>> D initWithShape(String shape, Instant t, DynamicLayerType layerType) {
        return DynamicLayerFactory.initWithShape(shape, (Time)new Interval(t), layerType);
    }

    public static <E extends DynamicElement, D extends DynamicLayer<E>> D initWithShape(String shape, Time time, DynamicLayerType layerType) {
        return DynamicLayerFactory.initWithShape(shape, time, layerType, null, layerType.getDeepElementType());
    }

    public static <E extends DynamicElement, D extends DynamicLayer<E>> D initWithShape(String shape, Instant t, DynamicLayerType layerType, DynamicElementType type) {
        return DynamicLayerFactory.initWithShape(shape, new Interval(t), layerType, type);
    }

    public static <E extends DynamicElement, D extends DynamicLayer<E>> D initWithShape(String shape, Time time, DynamicLayerType layerType, DynamicElementType type) {
        return DynamicLayerFactory.initWithShape(shape, time, layerType, null, type);
    }

    public static <E extends DynamicElement, D extends DynamicLayer<E>> D initWithShape(String shape, Instant t, DynamicLayerType layerType, String condition, DynamicElementType ... types) {
        return DynamicLayerFactory.initWithShape(shape, new Interval(t), layerType, condition, types);
    }

    public static <E extends DynamicElement, D extends DynamicLayer<E>> D initWithShape(String shape, Time time, DynamicLayerType layerType, String condition, DynamicElementType ... types) {
        DynamicLayer layer = null;
        try {
            DynamicElementBuilder builder = new DynamicElementBuilder(layerType);
            layer = (DynamicLayer)builder.build();
            ShpFiles sf = shape.endsWith(".shp") ? new ShpFiles(shape) : new ShpFiles(shape + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new org.locationtech.jts.geom.GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            HashMap<String, Integer> posIds = new HashMap<String, Integer>();
            HashMap<String, Integer> positions = new HashMap<String, Integer>();
            for (int i = 0; i < dfh.getNumFields(); ++i) {
                String field = dfh.getFieldName(i).toLowerCase();
                if (layerType.containsIdName(field)) {
                    posIds.put(field, i);
                    continue;
                }
                positions.put(field, i);
                if (layerType.containsAttributeByName(field)) continue;
                AttributeType aType = DynamicElementTypeFactory.createAttributeType(field, time.getClass(), dfh.getFieldClass(i));
                for (DynamicElementType type : types) {
                    type.addAttributeType(aType);
                }
            }
            if (sfr.getHeader().getShapeType().isPolygonType()) {
                DynamicLayerFactory.initWithGeometries(layer, time, sfr, dfr, posIds, positions, Surfacic.class, condition, types);
            } else if (sfr.getHeader().getShapeType().isLineType()) {
                DynamicLayerFactory.initWithGeometries(layer, time, sfr, dfr, posIds, positions, Linear.class, condition, types);
            } else if (sfr.getHeader().getShapeType().isPointType()) {
                DynamicLayerFactory.initWithGeometries(layer, time, sfr, dfr, posIds, positions, Local.class, condition, types);
            } else {
                throw new IllegalArgumentException(sfr.getHeader().getShapeType().name);
            }
            sfr.close();
            dfr.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (ShapefileException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        layer.setName(shape);
        return (D)layer;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <E extends DynamicElement> void initWithGeometries(DynamicLayer<E> layer, Time time, ShapefileReader sfr, DbaseFileReader dfr, Map<String, Integer> posIds, Map<String, Integer> positions, Class<? extends GeometryType> geometryClass, String condition, DynamicElementType ... types) {
        try {
            RepresentationType rType = DynamicElementTypeFactory.createRepresentationType("the_geom", time.getClass(), geometryClass, GeometryImplType.VECTOR);
            for (DynamicElementType t : types) {
                t.addRepresentationType(rType);
            }
            while (sfr.hasNext()) {
                void var9_17;
                Object shape = sfr.nextRecord().shape();
                if (geometryClass.equals(Surfacic.class)) {
                    if (((MultiPolygon)shape).getNumGeometries() > 1) {
                        MultiPolygon multiPolygon = (MultiPolygon)shape;
                    } else {
                        if (((MultiPolygon)shape).getNumGeometries() != 1) throw new IllegalArgumentException();
                        Polygon polygon = (Polygon)((MultiPolygon)shape).getGeometryN(0);
                    }
                } else if (geometryClass.equals(Linear.class)) {
                    if (((MultiLineString)shape).getNumGeometries() > 1) {
                        MultiLineString multiLineString = (MultiLineString)shape;
                    } else {
                        LineString lineString = (LineString)((MultiLineString)shape).getGeometryN(0);
                    }
                } else {
                    if (!geometryClass.equals(Local.class)) throw new IllegalArgumentException();
                    if (((MultiPoint)shape).getNumGeometries() > 1) {
                        MultiPoint multiPoint = (MultiPoint)shape;
                    } else {
                        Point point = (Point)((MultiPoint)shape).getGeometryN(0);
                    }
                }
                DynamicLayerFactory.importEntry(layer, time, GeometryFactory.create((org.locationtech.jts.geom.Geometry)var9_17), dfr, dfr.readEntry(), posIds, positions, condition, types);
            }
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            Iterator ite = layer.deepIterator();
            boolean i = false;
            while (ite.hasNext()) {
                DynamicFeature e = (DynamicFeature)ite.next();
                minX = Math.min(minX, e.minX());
                maxX = Math.max(maxX, e.maxX());
                minY = Math.min(minY, e.minY());
                maxY = Math.max(maxY, e.maxY());
            }
            layer.getStructure().setMinX(minX);
            layer.getStructure().setMaxX(maxX);
            layer.getStructure().setMinY(minY);
            layer.getStructure().setMaxY(maxY);
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static <E extends DynamicElement> void importEntry(DynamicLayer<E> layer, Time time, Geometry geometry, DbaseFileReader dfr, Object[] entry, Map<String, Integer> posIds, Map<String, Integer> positions, String condition, DynamicElementType ... types) {
        Iterator<AttributeType> o;
        boolean childType = false;
        for (DynamicElementType t1 : types) {
            for (DynamicElementType t2 : layer.getType().getElementTypes()) {
                if (!t1.equals(t2)) continue;
                childType = true;
            }
        }
        Object type = null;
        DynamicElement element = null;
        DynamicElementBuilder builder = null;
        if (childType) {
            if (condition != null) {
                o = entry[positions.get(condition)];
                for (DynamicElementType t : types) {
                    if (!t.hasCondition(o)) continue;
                    type = t;
                }
                if (type == null) {
                    throw new IllegalArgumentException();
                }
            } else {
                type = types[0];
            }
            builder = new DynamicElementBuilder((DynamicElementType)type);
            builder.setTime(time);
            for (AttributeType a : ((DynamicElementType)type).getAttributeTypes()) {
                if (!positions.containsKey(a.getName())) continue;
                if (a.getBinding().equals(Boolean.class) && dfr.getHeader().getFieldClass(positions.get(a.getName()).intValue()).equals(Integer.class)) {
                    builder.setAttribute(a.getName(), time, new Boolean((Integer)entry[positions.get(a.getName())] != 0));
                    continue;
                }
                builder.setAttribute(a.getName(), time, (Serializable)entry[positions.get(a.getName())]);
            }
            builder.setRepresentation("the_geom", time, geometry);
            element = (DynamicElement)builder.build();
            if (posIds.size() == 0) {
                element.setId(IdManager.get().getId());
            } else if (entry[posIds.get(element.getType().getIdName().toLowerCase())] instanceof String) {
                element.setId((String)entry[posIds.get(element.getType().getIdName().toLowerCase())]);
            } else if (dfr.getHeader().getFieldClass(posIds.get(element.getType().getIdName().toLowerCase()).intValue()).equals(Integer.class)) {
                element.setId(entry[posIds.get(element.getType().getIdName().toLowerCase())].toString());
            } else if (dfr.getHeader().getFieldClass(posIds.get(element.getType().getIdName().toLowerCase()).intValue()).equals(Long.class)) {
                element.setId(entry[posIds.get(element.getType().getIdName().toLowerCase())].toString());
            } else {
                element.setId(entry[posIds.get(element.getType().getIdName().toLowerCase())].toString());
            }
        } else {
            String id;
            if (layer.getType().getElementTypes().size() > 1) {
                o = entry[positions.get(condition)];
                for (DynamicElementType t : layer.getType().getElementTypes()) {
                    if (!t.hasDeepCondition(o)) continue;
                    type = t;
                    break;
                }
                if (type == null) {
                    throw new IllegalArgumentException("'" + o + "' is not recognized as a type");
                }
            } else {
                type = layer.getType().getElementType();
            }
            if ((element = (DynamicElement)layer.get(id = posIds.size() == 0 ? IdManager.get().getId() : (!posIds.containsKey(((DynamicElementType)type).getIdName()) ? IdManager.get().getId() : (entry[posIds.get(((DynamicElementType)type).getIdName())] instanceof String ? (String)entry[posIds.get(((DynamicElementType)type).getIdName())] : (dfr.getHeader().getFieldClass(posIds.get(((DynamicElementType)type).getIdName()).intValue()).equals(Integer.class) ? entry[posIds.get(((DynamicElementType)type).getIdName())].toString() : (dfr.getHeader().getFieldClass(posIds.get(((DynamicElementType)type).getIdName()).intValue()).equals(Long.class) ? entry[posIds.get(((DynamicElementType)type).getIdName())].toString() : entry[posIds.get(((DynamicElementType)type).getIdName())].toString())))))) == null) {
                builder = new DynamicElementBuilder((DynamicElementType)type);
                for (AttributeType a : ((DynamicElementType)type).getAttributeTypes()) {
                    if (!positions.containsKey(a.getName())) continue;
                    if (dfr.getHeader().getFieldClass(positions.get(a.getName()).intValue()).equals(Integer.class)) {
                        builder.setAttribute(a.getName(), time, (Serializable)entry[positions.get(a.getName())]);
                        continue;
                    }
                    if (dfr.getHeader().getFieldClass(positions.get(a.getName()).intValue()).equals(Long.class)) {
                        builder.setAttribute(a.getName(), time, (Serializable)entry[positions.get(a.getName())]);
                        continue;
                    }
                    builder.setAttribute(a.getName(), time, (Serializable)entry[positions.get(a.getName())]);
                }
                element = builder.build();
                element.setId(id);
            }
            DynamicLayerFactory.importEntry((DynamicLayer)element, time, geometry, dfr, entry, posIds, positions, condition, types);
        }
        layer.add(element);
    }

    public static boolean exportShape(DynamicElement element, Instant time, String shape) {
        return DynamicLayerFactory.exportShape(element, time, shape, ((DynamicLayerType)element.getType()).getFeatureTypes());
    }

    public static boolean exportShape(DynamicElement element, Instant time, String shape, double minx, double maxx, double miny, double maxy) {
        return DynamicLayerFactory.exportShape(element, time, shape, minx, maxx, miny, maxy, ((DynamicLayerType)element.getType()).getFeatureTypes());
    }

    private static boolean exportShape(DynamicElement element, Instant time, String shape, List<DynamicFeatureType> types) {
        DynamicElementType[] d = new DynamicElementType[types.size()];
        int i = 0;
        Iterator<DynamicFeatureType> iterator = types.iterator();
        while (iterator.hasNext()) {
            DynamicElementType t;
            d[i] = t = (DynamicElementType)iterator.next();
            ++i;
        }
        return DynamicLayerFactory.exportShape(element, time, shape, d);
    }

    private static boolean exportShape(DynamicElement element, Instant time, String shape, double minx, double maxx, double miny, double maxy, List<DynamicFeatureType> types) {
        DynamicElementType[] d = new DynamicElementType[types.size()];
        int i = 0;
        Iterator<DynamicFeatureType> iterator = types.iterator();
        while (iterator.hasNext()) {
            DynamicElementType t;
            d[i] = t = (DynamicElementType)iterator.next();
            ++i;
        }
        return DynamicLayerFactory.exportShape(element, time, shape, minx, maxx, miny, maxy, d);
    }

    public static boolean exportShape(DynamicElement element, Instant time, String shape, Class<? extends DynamicElement> ... classes) {
        DynamicElementType[] d = new DynamicElementType[classes.length];
        int i = 0;
        for (Class<? extends DynamicElement> c : classes) {
            if (!element.getType().hasElementType(c)) continue;
            d[i] = element.getType().getElementType(c);
            ++i;
        }
        return DynamicLayerFactory.exportShape(element, time, shape, d);
    }

    public static boolean exportShape(DynamicElement element, Instant time, String shape, Set<DynamicElementType> types) {
        DynamicElementType[] d = new DynamicElementType[types.size()];
        int i = 0;
        Iterator<DynamicElementType> iterator = types.iterator();
        while (iterator.hasNext()) {
            DynamicElementType t;
            d[i] = t = iterator.next();
            ++i;
        }
        return DynamicLayerFactory.exportShape(element, time, shape, d);
    }

    public static boolean exportShape(DynamicElement element, Instant time, String shape, DynamicElementType ... types) {
        return DynamicLayerFactory.exportShape(element, time, shape, -1.0, -1.0, -1.0, -1.0, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportShape(DynamicElement element, Instant time, String shape, double minx, double maxx, double miny, double maxy, DynamicElementType ... types) {
        try {
            int count = element.count(time, types);
            DbaseFileHeader header = new DbaseFileHeader();
            header.setNumRecords(count);
            Set<String> setId = new TreeSet<String>();
            for (DynamicElementType t : types) {
                setId = t.getInheritedIdNames(element.getType(), setId);
            }
            setId.remove(element.getType().getIdName());
            for (String id : setId) {
                header.addColumn(id, 'C', 8, 0);
            }
            Set<AttributeType> setAtt = new TreeSet<AttributeType>();
            for (DynamicElementType t : types) {
                setAtt = t.getInheritedAttributeTypes(element.getType(), setAtt);
            }
            for (AttributeType t : setAtt) {
                if (t.getBinding().equals(String.class)) {
                    header.addColumn(t.getName(), 'C', 80, 0);
                    continue;
                }
                if (t.getBinding().equals(Long.class)) {
                    header.addColumn(t.getName(), 'N', 12, 0);
                    continue;
                }
                if (t.getBinding().equals(Integer.class)) {
                    header.addColumn(t.getName(), 'N', 8, 0);
                    continue;
                }
                if (t.getBinding().equals(Double.class)) {
                    header.addColumn(t.getName(), 'N', 8, 3);
                    continue;
                }
                if (t.getBinding().equals(Boolean.class)) {
                    header.addColumn(t.getName(), 'L', 1, 0);
                    continue;
                }
                header.addColumn(t.getName(), 'C', 20, 0);
            }
            FileChannel out = new FileOutputStream(shape + ".dbf").getChannel();
            DbaseFileWriter dbfW = new DbaseFileWriter(header, (WritableByteChannel)out);
            FileOutputStream shp = new FileOutputStream(shape + ".shp");
            FileOutputStream shx = new FileOutputStream(shape + ".shx");
            ShapefileWriter shapeW = new ShapefileWriter(shp.getChannel(), shx.getChannel());
            if (minx == -1.0 && maxx == -1.0 && miny == -1.0 && maxy == -1.0) {
                minx = Double.MAX_VALUE;
                maxx = Double.MIN_VALUE;
                miny = Double.MAX_VALUE;
                maxy = Double.MIN_VALUE;
                Iterator ite = ((DynamicLayer)element).deepIterator();
                while (ite.hasNext()) {
                    DynamicFeature f = (DynamicFeature)ite.next();
                    minx = Math.min(minx, f.minX());
                    maxx = Math.max(maxx, f.maxX());
                    miny = Math.min(miny, f.minY());
                    maxy = Math.max(maxy, f.maxY());
                }
            }
            if (types[0].getRepresentationType("the_geom").getSpatialBinding().equals(Surfacic.class)) {
                shapeW.writeHeaders(new Envelope(minx, maxx, miny, maxy), ShapeType.POLYGON, count, 1000000);
            } else if (types[0].getRepresentationType("the_geom").getSpatialBinding().equals(Linear.class)) {
                shapeW.writeHeaders(new Envelope(minx, maxx, miny, maxy), ShapeType.ARC, count, 1000000);
            } else if (types[0].getRepresentationType("the_geom").getSpatialBinding().equals(Local.class)) {
                shapeW.writeHeaders(new Envelope(minx, maxx, miny, maxy), ShapeType.POINT, count, 1000000);
            } else {
                throw new IllegalArgumentException();
            }
            DynamicLayerFactory.exportElement(element, time, dbfW, shapeW, setId, setAtt, types);
            dbfW.close();
            shapeW.close();
            out.close();
            shp.close();
            shx.close();
        }
        catch (DbaseFileException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                Tool.copy(CoverageManager.class.getResourceAsStream(CoverageManager.epsg()), shape + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static void exportElement(DynamicElement element, Instant time, DbaseFileWriter dbfW, ShapefileWriter shapeW, Set<String> setId, Set<AttributeType> setAtt, DynamicElementType ... types) {
        block10: {
            block9: {
                boolean export = false;
                for (DynamicElementType t : types) {
                    if (!element.getType().equals(t)) continue;
                    export = true;
                }
                if (export) break block9;
                if (!(element instanceof DynamicLayer)) break block10;
                for (DynamicElement e : (DynamicLayer)element) {
                    DynamicLayerFactory.exportElement(e, time, dbfW, shapeW, setId, setAtt, types);
                }
                break block10;
            }
            if (!element.isActive(time)) break block10;
            try {
                Object[] record = new Object[setId.size() + setAtt.size()];
                int index = 0;
                for (String id : setId) {
                    record[index++] = element.getInheritedId(id);
                }
                for (AttributeType att : setAtt) {
                    if (element.getType().hasAttributeType(att.getName())) {
                        record[index++] = element.getInheritedAttribute(att.getName()).getValue(time);
                        continue;
                    }
                    record[index++] = null;
                }
                dbfW.write(record);
                if (element.getGeometry(time) == null) {
                    shapeW.writeGeometry(null);
                }
                if (element.getGeometry(time).get().getJTS() instanceof LineString) {
                    shapeW.writeGeometry((org.locationtech.jts.geom.Geometry)element.getGeometry(time).get().getJTS().getFactory().createMultiLineString(new LineString[]{(LineString)element.getGeometry(time).get().getJTS()}));
                }
                shapeW.writeGeometry(element.getGeometry(time).get().getJTS());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static boolean exportTimeShape(DynamicElement element, Instant start, Instant end, Delay delay, String shape) {
        return DynamicLayerFactory.exportTimeShape(element, start, end, delay, shape, ((DynamicLayerType)element.getType()).getFeatureTypes());
    }

    private static boolean exportTimeShape(DynamicElement element, Instant start, Instant end, Delay delay, String shape, List<DynamicFeatureType> types) {
        DynamicElementType[] d = new DynamicElementType[types.size()];
        int i = 0;
        Iterator<DynamicFeatureType> iterator = types.iterator();
        while (iterator.hasNext()) {
            DynamicElementType t;
            d[i] = t = (DynamicElementType)iterator.next();
            ++i;
        }
        return DynamicLayerFactory.exportTimeShape(element, start, end, delay, shape, d);
    }

    public static boolean exportTimeShape(DynamicElement element, Instant start, Instant end, Delay delay, String shape, DynamicElementType ... types) {
        return DynamicLayerFactory.exportTimeShape(element, start, end, delay, shape, -1.0, -1.0, -1.0, -1.0, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportTimeShape(DynamicElement element, Instant start, Instant end, Delay delay, String shape, double minx, double maxx, double miny, double maxy, DynamicElementType ... types) {
        try {
            int count = 0;
            Instant time = start;
            while (time.isBefore(end) || time.equals(end)) {
                count += element.count(time, types);
                time = delay.next(time);
            }
            System.out.println("nombre d'\ufffdl\ufffdment = " + count);
            DbaseFileHeader header = new DbaseFileHeader();
            header.setNumRecords(count);
            Set<String> setId = new TreeSet<String>();
            for (DynamicElementType t : types) {
                setId = t.getInheritedIdNames(element.getType(), setId);
            }
            setId.remove(element.getType().getIdName());
            for (String id : setId) {
                header.addColumn(id, 'C', 8, 0);
            }
            header.addColumn("start", 'D', 10, 0);
            header.addColumn("end", 'D', 10, 0);
            Set<AttributeType> setAtt = new TreeSet<AttributeType>();
            for (DynamicElementType t : types) {
                setAtt = t.getInheritedAttributeTypes(element.getType(), setAtt);
            }
            for (AttributeType t : setAtt) {
                if (t.getBinding().equals(String.class)) {
                    header.addColumn(t.getName(), 'C', 80, 0);
                    continue;
                }
                if (t.getBinding().equals(Long.class)) {
                    header.addColumn(t.getName(), 'N', 12, 0);
                    continue;
                }
                if (t.getBinding().equals(Integer.class)) {
                    header.addColumn(t.getName(), 'N', 8, 0);
                    continue;
                }
                if (t.getBinding().equals(Double.class)) {
                    header.addColumn(t.getName(), 'N', 8, 3);
                    continue;
                }
                if (t.getBinding().equals(Boolean.class)) {
                    header.addColumn(t.getName(), 'L', 1, 0);
                    continue;
                }
                header.addColumn(t.getName(), 'C', 20, 0);
            }
            FileChannel out = new FileOutputStream(shape + ".dbf").getChannel();
            DbaseFileWriter dbfW = new DbaseFileWriter(header, (WritableByteChannel)out);
            FileOutputStream shp = new FileOutputStream(shape + ".shp");
            FileOutputStream shx = new FileOutputStream(shape + ".shx");
            ShapefileWriter shapeW = new ShapefileWriter(shp.getChannel(), shx.getChannel());
            if (minx == -1.0 && maxx == -1.0 && miny == -1.0 && maxy == -1.0) {
                minx = Double.MAX_VALUE;
                maxx = Double.MIN_VALUE;
                miny = Double.MAX_VALUE;
                maxy = Double.MIN_VALUE;
                Iterator ite = ((DynamicLayer)element).deepIterator();
                while (ite.hasNext()) {
                    DynamicFeature f = (DynamicFeature)ite.next();
                    minx = Math.min(minx, f.minX());
                    maxx = Math.max(maxx, f.maxX());
                    miny = Math.min(miny, f.minY());
                    maxy = Math.max(maxy, f.maxY());
                }
            }
            if (types[0].getRepresentationType("the_geom").getSpatialBinding().equals(Surfacic.class)) {
                shapeW.writeHeaders(new Envelope(minx, maxx, miny, maxy), ShapeType.POLYGON, count, 1000000);
            } else if (types[0].getRepresentationType("the_geom").getSpatialBinding().equals(Linear.class)) {
                shapeW.writeHeaders(new Envelope(minx, maxx, miny, maxy), ShapeType.ARC, count, 1000000);
            } else if (types[0].getRepresentationType("the_geom").getSpatialBinding().equals(Local.class)) {
                shapeW.writeHeaders(new Envelope(minx, maxx, miny, maxy), ShapeType.POINT, count, 1000000);
            } else {
                throw new IllegalArgumentException();
            }
            time = start;
            while (time.isBefore(end) || time.equals(end)) {
                DynamicLayerFactory.exportTimeElement(element, time, delay, dbfW, shapeW, setId, setAtt, types);
                time = delay.next(time);
            }
            dbfW.close();
            shapeW.close();
            out.close();
            shp.close();
            shx.close();
        }
        catch (DbaseFileException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                Tool.copy(CoverageManager.class.getResourceAsStream("lambert93.prj"), shape + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static void exportTimeElement(DynamicElement element, Instant time, Delay delay, DbaseFileWriter dbfW, ShapefileWriter shapeW, Set<String> setId, Set<AttributeType> setAtt, DynamicElementType ... types) {
        block10: {
            Instant next;
            block9: {
                next = delay.next(time);
                boolean export = false;
                for (DynamicElementType t : types) {
                    if (!element.getType().equals(t)) continue;
                    export = true;
                }
                if (export) break block9;
                if (!(element instanceof DynamicLayer)) break block10;
                for (DynamicElement e : (DynamicLayer)element) {
                    DynamicLayerFactory.exportTimeElement(e, time, delay, dbfW, shapeW, setId, setAtt, types);
                }
                break block10;
            }
            if (!element.isActive(time)) break block10;
            try {
                Object[] record = new Object[setId.size() + setAtt.size() + 2];
                int index = 0;
                for (String id : setId) {
                    record[index++] = element.getInheritedId(id);
                }
                GregorianCalendar c = new GregorianCalendar();
                c.set(time.year(), time.month() - 1, time.dayOfMonth());
                record[index++] = c.getTime();
                c.set(next.year(), next.month() - 2, next.dayOfMonth());
                record[index++] = c.getTime();
                for (AttributeType att : setAtt) {
                    if (element.getType().hasAttributeType(att.getName())) {
                        record[index++] = element.getInheritedAttribute(att.getName()).getValue(time);
                        continue;
                    }
                    record[index++] = null;
                }
                dbfW.write(record);
                if (element.getGeometry(time) == null) {
                    shapeW.writeGeometry(null);
                }
                if (element.getGeometry(time).get().getJTS() instanceof LineString) {
                    shapeW.writeGeometry((org.locationtech.jts.geom.Geometry)element.getGeometry(time).get().getJTS().getFactory().createMultiLineString(new LineString[]{(LineString)element.getGeometry(time).get().getJTS()}));
                }
                shapeW.writeGeometry(element.getGeometry(time).get().getJTS());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

