/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.element.manager;

import fr.inrae.act.bagap.apiland.core.composition.AttributeType;
import fr.inrae.act.bagap.apiland.core.element.DynamicElement;
import fr.inrae.act.bagap.apiland.core.element.DynamicLayer;
import fr.inrae.act.bagap.apiland.core.element.manager.DynamicElementFactory;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicElementType;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicElementTypeFactory;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicLayerType;
import fr.inrae.act.bagap.apiland.core.space.GeometryType;
import fr.inrae.act.bagap.apiland.core.space.impl.GeometryImplType;
import fr.inrae.act.bagap.apiland.core.structure.MultipleStructure;
import fr.inrae.act.bagap.apiland.core.structure.NullStructure;
import fr.inrae.act.bagap.apiland.core.structure.RepresentationType;
import fr.inrae.act.bagap.apiland.core.structure.SimpleStructure;
import fr.inrae.act.bagap.apiland.core.time.Time;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DynamicElementManager {
    public static void save(DynamicElement element, String file) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        try {
            out.writeObject(element);
        }
        finally {
            out.flush();
            out.close();
        }
    }

    public static DynamicElement load(String file) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
        DynamicElement element = (DynamicElement)in.readObject();
        in.close();
        return element;
    }

    public static void addAttributeToFeatures(DynamicElement element, String name, Class<? extends Time> temporal, Class<?> binding) {
        DynamicElementManager.addAttributeToFeatures(element, DynamicElementTypeFactory.createAttributeType(name, temporal, binding));
    }

    public static void addAttributeToFeatures(DynamicElement element, String name, Class<?> binding) {
        DynamicElementManager.addAttributeToFeatures(element, DynamicElementTypeFactory.createAttributeType(name, null, binding));
    }

    public static void addAttributeToFeatures(DynamicElement element, AttributeType type) {
        if (element instanceof DynamicLayer) {
            for (DynamicElement e : (DynamicLayer)element) {
                DynamicElementManager.addAttributeToFeatures(e, type);
            }
        } else {
            if (!element.getType().hasAttributeType(type.getName())) {
                element.getType().addAttributeType(type);
            }
            element.getComposition().addAttribute(DynamicElementFactory.createAttribute(type));
        }
    }

    public static boolean hasAttributeToFeatures(DynamicElement element, String name) {
        if (element instanceof DynamicLayer) {
            for (DynamicElementType dynamicElementType : ((DynamicLayerType)element.getType()).getFeatureTypes()) {
            }
            for (DynamicElement dynamicElement : (DynamicLayer)element) {
                if (!DynamicElementManager.hasAttributeToFeatures(dynamicElement, name)) continue;
                return true;
            }
        } else if (element.getType().hasAttributeType(name)) {
            return true;
        }
        return false;
    }

    public static void removeAttribute(DynamicElement element, String name) {
        if (element.getType().hasAttributeType(name)) {
            element.getComposition().removeAttribute(name);
            element.getType().removeAttributeType(name);
        } else if (element instanceof DynamicLayer) {
            for (DynamicElement e : (DynamicLayer)element) {
                DynamicElementManager.removeAttribute(e, name);
            }
        }
    }

    public static void removeAttributeToFeatures(DynamicElement element, String name) {
        if (element instanceof DynamicLayer) {
            for (DynamicElementType dynamicElementType : ((DynamicLayerType)element.getType()).getFeatureTypes()) {
                dynamicElementType.removeAttributeType(name);
            }
            for (DynamicElement dynamicElement : (DynamicLayer)element) {
                DynamicElementManager.removeAttributeToFeatures(dynamicElement, name);
            }
        } else {
            element.getComposition().removeAttribute(name);
        }
    }

    public static void addRepresentationToFeatures(DynamicElement element, String name, Class<? extends Time> temporal, Class<? extends GeometryType> spatial, GeometryImplType geometryType) {
        DynamicElementManager.addRepresentationToFeatures(element, DynamicElementTypeFactory.createRepresentationType(name, temporal, spatial, geometryType));
    }

    public static void addRepresentationToFeatures(DynamicElement element, RepresentationType type) {
        if (element instanceof DynamicLayer) {
            for (DynamicElement e : (DynamicLayer)element) {
                DynamicElementManager.addRepresentationToFeatures(e, type);
            }
        } else {
            if (!element.getType().hasRepresentationType(type.getName())) {
                element.getType().addRepresentationType(type);
            }
            if (element.getStructure() instanceof NullStructure) {
                SimpleStructure structure = new SimpleStructure();
                element.setStructure(structure);
            } else if (element.getStructure() instanceof SimpleStructure) {
                MultipleStructure structure = new MultipleStructure();
                structure.addRepresentation(element.getDefaultRepresentation());
                element.setStructure(structure);
            }
            element.getStructure().addRepresentation(DynamicElementFactory.createRepresentation(type));
        }
    }

    public static void removeRepresentationToFeatures(DynamicElement element, String name) {
        if (element instanceof DynamicLayer) {
            for (DynamicElement e : (DynamicLayer)element) {
                DynamicElementManager.removeRepresentationToFeatures(e, name);
            }
        } else {
            if (element.hasRepresentation(name)) {
                element.getType().removeRepresentationType(name);
            }
            element.getStructure().removeRepresentation(name);
        }
    }
}

