/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.element;

import fr.inrae.act.bagap.apiland.core.element.AbstractDynamicLayer;
import fr.inrae.act.bagap.apiland.core.element.DynamicElement;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicLayerType;
import fr.inrae.act.bagap.apiland.core.space.Geometry;
import fr.inrae.act.bagap.apiland.core.space.Point;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import java.util.Set;
import java.util.TreeSet;

public class DefaultDynamicLayer<E extends DynamicElement>
extends AbstractDynamicLayer<E> {
    private static final long serialVersionUID = 1L;

    public DefaultDynamicLayer(DynamicLayerType type) {
        super(type);
    }

    @Override
    public DefaultDynamicLayer<E> clone() {
        DefaultDynamicLayer clone = (DefaultDynamicLayer)super.clone();
        return clone;
    }

    @Override
    public Time getTime() {
        Time t = null;
        for (DynamicElement e : this) {
            t = Time.add(t, e.getTime());
        }
        return t;
    }

    @Override
    public void setTime(Time t) {
    }

    @Override
    public boolean isActive(Instant t) {
        for (DynamicElement e : this) {
            if (!e.isActive(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void kill(Instant t) throws TimeException {
        for (DynamicElement e : this) {
            e.kill(t);
        }
        super.kill(t);
    }

    @Override
    public double getArea(Instant t) {
        double area = 0.0;
        for (DynamicElement e : this) {
            if (!e.isActive(t)) continue;
            area += e.getArea(t);
        }
        return area;
    }

    @Override
    public double getLength(Instant t) {
        double length = 0.0;
        for (DynamicElement e : this) {
            if (!e.isActive(t)) continue;
            length += e.getLength(t);
        }
        return length;
    }

    @Override
    public Geometry getGeometry(Instant t) {
        Geometry g = null;
        for (DynamicElement e : this) {
            g = Geometry.add(g, e.getGeometry(t));
        }
        return g;
    }

    @Override
    public boolean isActive(Instant t, Point g) {
        for (DynamicElement e : this) {
            if (!e.isActive(t, g)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <F extends DynamicElement> Set<F> set(Class<F> theClass) {
        TreeSet<DynamicElement> set = new TreeSet<DynamicElement>();
        for (DynamicElement e : this) {
            if (!theClass.isAssignableFrom(e.getClass())) continue;
            set.add(e);
        }
        return set;
    }
}

