/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.element;

import fr.inrae.act.bagap.apiland.core.change.Changeable;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObserver;
import fr.inrae.act.bagap.apiland.core.element.AbstractDynamicElement;
import fr.inrae.act.bagap.apiland.core.element.DynamicElement;
import fr.inrae.act.bagap.apiland.core.element.DynamicFeature;
import fr.inrae.act.bagap.apiland.core.element.DynamicLayer;
import fr.inrae.act.bagap.apiland.core.element.iterator.ActiveElementsIterator;
import fr.inrae.act.bagap.apiland.core.element.iterator.ActiveFeaturesIterator;
import fr.inrae.act.bagap.apiland.core.element.iterator.ElementsIterator;
import fr.inrae.act.bagap.apiland.core.element.iterator.FeaturesIterator;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicElementType;
import fr.inrae.act.bagap.apiland.core.element.type.DynamicLayerType;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.TimeNulle;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractDynamicLayer<E extends DynamicElement>
extends AbstractDynamicElement
implements DynamicLayer<E>,
Set<E> {
    private static final long serialVersionUID = 1L;
    private Set<E> elements = new TreeSet();
    private String name;

    public AbstractDynamicLayer(DynamicLayerType type) {
        super(type);
        this.setId("");
        this.setName("layer");
    }

    @Override
    public AbstractDynamicLayer<E> clone() {
        AbstractDynamicLayer clone = (AbstractDynamicLayer)super.clone();
        clone.elements = new TreeSet();
        for (DynamicElement e : this.elements) {
            clone.elements.add(e.clone());
        }
        return clone;
    }

    @Override
    public DynamicLayerType getType() {
        return (DynamicLayerType)super.getType();
    }

    @Override
    public void addObserver(ChangeableObserver o) {
        for (DynamicElement e : this) {
            e.addObserver(o);
        }
        super.addObserver(o);
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
        for (DynamicElement e : this) {
            e.addObserver(o);
        }
        super.removeObserver(o);
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
        super.notifyObservers(t, c, o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Iterator<E> activeIterator(Instant t) {
        return new ActiveElementsIterator(this, t);
    }

    @Override
    public Iterator<E> completeIterator() {
        return new ElementsIterator<E>(this.iterator());
    }

    @Override
    public <D extends DynamicFeature> Iterator<D> deepIterator() {
        return new FeaturesIterator(this.iterator());
    }

    @Override
    public <D extends DynamicFeature> Iterator<D> activeDeepIterator(Instant t) {
        return new ActiveFeaturesIterator<D>(this.deepIterator(), t);
    }

    @Override
    public int count(Instant t) {
        int count = 0;
        for (DynamicElement de : this) {
            count += de.count(t);
        }
        return count;
    }

    @Override
    public int count(Instant t, DynamicElementType ... types) {
        for (DynamicElementType type : types) {
            if (!this.getType().equals(type)) continue;
            if (this.isActive(t)) {
                return 1;
            }
            return 0;
        }
        int count = 0;
        for (DynamicElement e : this) {
            count += e.count(t, types);
        }
        return count;
    }

    @Override
    public boolean add(E e) {
        e.setLayer(this);
        return this.elements.add(e);
    }

    @Override
    public E get(String id) {
        for (DynamicElement e : this) {
            if (!e.getId().equalsIgnoreCase(id)) continue;
            return (E)e;
        }
        return null;
    }

    @Override
    public DynamicFeature getDeep(String id) {
        Iterator ite = this.deepIterator();
        while (ite.hasNext()) {
            DynamicFeature f = (DynamicFeature)ite.next();
            if (!f.getId().equalsIgnoreCase(id)) continue;
            return f;
        }
        return null;
    }

    @Override
    public boolean contains(String id) {
        for (DynamicElement e : this) {
            if (!e.getId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void display() {
        System.out.println("dynamiclayer id " + this.getId() + " and type : " + this.getClass().getSimpleName());
        System.out.println(this.getType());
        for (DynamicElement e : this) {
            e.display();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (DynamicElement e : c) {
            e.setLayer(this);
        }
        return this.elements.addAll(c);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        ((DynamicElement)o).setLayer(null);
        return this.elements.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object e : c) {
            ((DynamicElement)e).setLayer(null);
        }
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public Instant getLastChange() {
        Instant t = super.getLastChange();
        for (DynamicElement e : this) {
            Instant n = e.getLastChange();
            if (t != null && !(t instanceof TimeNulle) && (n == null || !n.isAfter(t))) continue;
            t = n;
        }
        return t;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void delete() {
        super.delete();
        this.name = null;
        for (DynamicElement e : this.elements) {
            e.delete();
        }
        this.elements.clear();
        this.elements = null;
    }
}

