/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.dynamic;

import fr.inrae.act.bagap.apiland.core.change.Changeable;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObject;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObserver;
import fr.inrae.act.bagap.apiland.core.dynamic.Dynamical;
import fr.inrae.act.bagap.apiland.core.dynamic.IteratorInverse;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Interval;
import fr.inrae.act.bagap.apiland.core.time.Temporal;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import fr.inrae.act.bagap.apiland.core.time.TimeNulle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Dynamic<T extends Temporal>
implements Dynamical<T>,
Iterable<T> {
    private static final long serialVersionUID = 1L;
    protected List<T> temporals = new ArrayList<T>();
    private ChangeableObject changeable = new ChangeableObject();

    public Dynamic<T> cut(Instant start, Instant end) {
        Dynamic<Temporal> cut = new Dynamic<Temporal>();
        for (Temporal t : this) {
            Temporal temp;
            if (t.getTime().start().isBefore(start) && t.getTime().end().isAfter(start)) {
                temp = t.clone();
                temp.setTime(new Interval(start, t.getTime().end()));
                cut.addTemporal(temp);
                continue;
            }
            if (!t.getTime().start().isBefore(start) && !t.getTime().end().isAfter(end)) {
                cut.addTemporal(t);
                continue;
            }
            if (t.getTime().start().isBefore(end) && t.getTime().end().isAfter(end)) {
                cut.addTemporal(t);
                continue;
            }
            if (!t.getTime().start().equals(end)) continue;
            temp = t.clone();
            temp.setTime(new Interval(end, t.getTime().end()));
            cut.addTemporal(temp);
        }
        return cut;
    }

    @Override
    public Dynamic<T> clone() {
        try {
            Dynamic clone = (Dynamic)super.clone();
            clone.changeable = new ChangeableObject();
            if (this.temporals != null) {
                clone.temporals = new ArrayList<T>();
                for (Temporal t : this) {
                    clone.temporals.add(t.clone());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.temporals.toString();
    }

    @Override
    public Time getTime() {
        Time time = new TimeNulle();
        for (Temporal tt : this) {
            time = ((Time)time).addTime(tt.getTime());
        }
        return time;
    }

    @Override
    public boolean isActive(Instant t) {
        Iterator<T> ii = this.iteratorInverse();
        while (ii.hasNext()) {
            if (!((Temporal)ii.next()).isActive(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void kill(Instant t) throws TimeException {
        for (Temporal tt : this) {
            if (!tt.isActive(t)) continue;
            tt.kill(t);
        }
    }

    @Override
    public void setTime(Time t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this.temporals.iterator();
    }

    public Iterator<T> iteratorInverse() {
        return new IteratorInverse<T>(this.temporals);
    }

    @Override
    public void addTemporal(T t) {
        this.temporals.add(t);
    }

    @Override
    public void removeTemporal(T t) {
        this.temporals.remove(t);
    }

    @Override
    public T getActive(Instant t) {
        Iterator<T> ii = this.iteratorInverse();
        while (ii.hasNext()) {
            Temporal time = (Temporal)ii.next();
            if (!time.isActive(t)) continue;
            return (T)time;
        }
        return null;
    }

    @Override
    public T get(int index) {
        return (T)((Temporal)this.temporals.get(index));
    }

    @Override
    public int getIndex(Instant t) {
        Iterator<T> ii = this.iteratorInverse();
        int i = this.size() - 1;
        while (ii.hasNext()) {
            Temporal time = (Temporal)ii.next();
            if (time.isActive(t)) {
                return i;
            }
            --i;
        }
        return i;
    }

    @Override
    public void addObserver(ChangeableObserver o) {
        this.changeable.addObserver(o);
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
        this.changeable.removeObserver(o);
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
        this.changeable.notifyObservers(t, c, o);
    }

    @Override
    public T getFirst() {
        if (this.temporals.size() != 0) {
            return (T)((Temporal)this.temporals.get(0));
        }
        return null;
    }

    @Override
    public T getLast() {
        if (this.temporals.size() != 0) {
            return (T)((Temporal)this.temporals.get(this.temporals.size() - 1));
        }
        return null;
    }

    public void removeLast() {
        this.temporals.remove(this.temporals.size() - 1);
    }

    @Override
    public int size() {
        return this.temporals.size();
    }

    @Override
    public Instant getLastChange() {
        if (this.temporals.size() != 0) {
            return ((Temporal)this.temporals.get(this.temporals.size() - 1)).getTime().start();
        }
        return null;
    }

    public void delete() {
        this.changeable.delete();
        this.changeable = null;
        this.temporals.clear();
        this.temporals = null;
    }

    public void clear() {
        this.temporals.clear();
    }
}

